/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLinkageSpecification;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTProblemDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUsingDirective;

public class DeclarationHandler
extends Handler<Declaration, IASTDeclaration, CXXLanguageFrontend> {
    public DeclarationHandler(CXXLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(CPPASTSimpleDeclaration.class, ctx -> this.handleSimpleDeclaration((CPPASTSimpleDeclaration)ctx));
        this.map.put(CPPASTFunctionDefinition.class, ctx -> this.handleFunctionDefinition((CPPASTFunctionDefinition)ctx));
        this.map.put(CPPASTProblemDeclaration.class, ctx -> this.handleProblem((CPPASTProblemDeclaration)ctx));
        this.map.put(CPPASTNamespaceDefinition.class, ctx -> this.handleNamespace((CPPASTNamespaceDefinition)ctx));
        this.map.put(CPPASTUsingDirective.class, ctx -> this.handleUsingDirective((CPPASTUsingDirective)ctx));
    }

    private Declaration handleUsingDirective(CPPASTUsingDirective using) {
        return NodeBuilder.newUsingDirective(using.getRawSignature(), using.getQualifiedName().toString());
    }

    private Declaration handleNamespace(CPPASTNamespaceDefinition ctx) {
        NamespaceDeclaration declaration = NodeBuilder.newNamespaceDeclaration(ctx.getName().toString());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        for (IASTNode child : ctx.getChildren()) {
            if (child instanceof IASTDeclaration) {
                declaration.add((Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle((IASTDeclaration)child));
                continue;
            }
            if (child instanceof CPPASTName) continue;
            log.error("Unknown child in namespace: {}", child.getClass());
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        return declaration;
    }

    private Declaration handleProblem(CPPASTProblemDeclaration ctx) {
        return NodeBuilder.newProblemDeclaration(ctx.getContainingFilename(), ctx.getProblem().getMessage(), ctx.getProblem().getFileLocation().toString());
    }

    private FunctionDeclaration handleFunctionDefinition(CPPASTFunctionDefinition ctx) {
        Statement bodyStatement;
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)((CXXLanguageFrontend)this.lang).getDeclaratorHandler().handle(ctx.getDeclarator());
        String typeString = ctx.getDeclSpecifier().toString();
        if (functionDeclaration instanceof MethodDeclaration && typeString.isEmpty()) {
            functionDeclaration = ConstructorDeclaration.from((MethodDeclaration)functionDeclaration);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(functionDeclaration);
        String typeAdjustment = functionDeclaration.getType().getTypeAdjustment();
        functionDeclaration.setType(Type.createFrom(typeString));
        functionDeclaration.getType().setTypeAdjustment(typeAdjustment);
        if (ctx.getBody() != null && (bodyStatement = (Statement)((CXXLanguageFrontend)this.lang).getStatementHandler().handle(ctx.getBody())) instanceof CompoundStatement) {
            CompoundStatement body = (CompoundStatement)bodyStatement;
            List<Statement> statements = body.getStatements();
            Statement lastStatement = null;
            if (!statements.isEmpty()) {
                lastStatement = statements.get(statements.size() - 1);
            }
            if (!(lastStatement instanceof ReturnStatement)) {
                ReturnStatement returnStatement = NodeBuilder.newReturnStatement("return;");
                returnStatement.setImplicit(true);
                statements.add(returnStatement);
            }
            functionDeclaration.setBody(body);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(functionDeclaration);
        return functionDeclaration;
    }

    private Declaration handleSimpleDeclaration(CPPASTSimpleDeclaration ctx) {
        if (ctx.getDeclarators().length == 0) {
            if (ctx.getDeclSpecifier() != null) {
                if (ctx.getDeclSpecifier() instanceof CPPASTCompositeTypeSpecifier) {
                    Declaration declaration = (Declaration)((CXXLanguageFrontend)this.lang).getDeclaratorHandler().handle((CPPASTCompositeTypeSpecifier)ctx.getDeclSpecifier());
                    return declaration;
                }
                log.error("Unknown Declspecifier in SimpleDeclaration: {}", ctx.getDeclSpecifier().getClass());
            } else {
                log.error("Declspecifier is null");
            }
        } else {
            if (ctx.getDeclarators().length == 1) {
                List handle = (List)((CXXLanguageFrontend)this.lang).getDeclarationListHandler().handle(ctx);
                if (handle.size() != 1) {
                    log.error("Invalid declaration generation");
                    return NodeBuilder.newDeclaration("");
                }
                return (Declaration)handle.get(0);
            }
            log.error("More than one declaration, this should not happen here.");
        }
        return null;
    }

    private void parseInclusions(IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] includes, HashMap<String, HashSet<String>> allIncludes) {
        if (includes != null) {
            for (IASTTranslationUnit.IDependencyTree.IASTInclusionNode n : includes) {
                HashSet strings = allIncludes.computeIfAbsent(n.getIncludeDirective().getContainingFilename(), k -> new HashSet());
                strings.add(n.getIncludeDirective().getPath());
                this.parseInclusions(n.getNestedInclusions(), allIncludes);
            }
        }
    }

    TranslationUnitDeclaration handleTranslationUnit(CPPASTTranslationUnit translationUnit) {
        TranslationUnitDeclaration node = NodeBuilder.newTranslationUnitDeclaration(translationUnit.getFilePath(), translationUnit.getRawSignature());
        HashMap<String, HashSet> problematicIncludes = new HashMap<String, HashSet>();
        for (IASTDeclaration declaration : translationUnit.getDeclarations()) {
            if (declaration instanceof CPPASTLinkageSpecification) continue;
            Declaration decl = (Declaration)this.handle(declaration);
            if (decl instanceof ProblemDeclaration) {
                HashSet problems = problematicIncludes.computeIfAbsent(((ProblemDeclaration)decl).getFilename(), k -> new HashSet());
                problems.add((ProblemDeclaration)decl);
                continue;
            }
            if (decl instanceof NamespaceDeclaration) {
                node.add(decl);
                continue;
            }
            node.add(decl);
        }
        boolean addIncludesToGraph = true;
        if (addIncludesToGraph) {
            IASTTranslationUnit.IDependencyTree dependencyTree = translationUnit.getDependencyTree();
            HashMap<String, HashSet<String>> allIncludes = new HashMap<String, HashSet<String>>();
            this.parseInclusions(dependencyTree.getInclusions(), allIncludes);
            if (allIncludes.size() > 0) {
                HashSet includesStrings = new HashSet();
                HashMap<String, IncludeDeclaration> includeMap = new HashMap<String, IncludeDeclaration>();
                allIncludes.values().forEach(includesStrings::addAll);
                for (String string : includesStrings) {
                    HashSet problems = (HashSet)problematicIncludes.get(string);
                    IncludeDeclaration includeDeclaration = NodeBuilder.newIncludeDeclaration(string);
                    if (problems != null) {
                        includeDeclaration.getProblems().addAll(problems);
                    }
                    includeMap.put(string, includeDeclaration);
                }
                for (String string : allIncludes.get(translationUnit.getFilePath())) {
                    node.add((Declaration)includeMap.get(string));
                }
                allIncludes.remove(translationUnit.getFilePath());
                for (Map.Entry entry : allIncludes.entrySet()) {
                    IncludeDeclaration includeDeclaration = (IncludeDeclaration)includeMap.get(entry.getKey());
                    for (String s : (HashSet)entry.getValue()) {
                        includeDeclaration.getIncludes().add((IncludeDeclaration)includeMap.get(s));
                    }
                }
            }
        }
        return node;
    }
}

