/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.cpp.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.DeclarationListHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.DeclaratorHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.InitializerHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.ParameterDeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Region;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXXLanguageFrontend
extends LanguageFrontend {
    public static final Type LONG_TYPE = Type.createFrom("long");
    public static final Type TYPE_UNSIGNED_LONG_LONG = Type.createFrom("unsigned long long");
    public static final Type INT_TYPE = Type.createFrom("int");
    public static final Type LONG_LONG_TYPE = Type.createFrom("long long");
    public static final Type TYPE_UNSIGNED_LONG = Type.createFrom("unsigned long");
    private static final Logger LOGGER = LoggerFactory.getLogger(CXXLanguageFrontend.class);
    private static final IncludeFileContentProvider INCLUDE_FILE_PROVIDER = new InternalFileContentProvider(){

        private @Nullable InternalFileContent getContentUncached(String path) {
            if (!this.getInclusionExists(path)) {
                LOGGER.debug("Include file not found: {}", (Object)path);
                return null;
            }
            LOGGER.debug("Loading include file {}", (Object)path);
            FileContent content = FileContent.createForExternalFileLocation((String)path);
            return (InternalFileContent)content;
        }

        public @Nullable InternalFileContent getContentForInclusion(String path, IMacroDictionary macroDictionary) {
            return this.getContentUncached(path);
        }

        public @Nullable InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
            return this.getContentUncached(astPath);
        }
    };
    private DeclarationHandler declarationHandler = new DeclarationHandler(this);
    private DeclarationListHandler declarationListHandler = new DeclarationListHandler(this);
    private DeclaratorHandler declaratorHandler = new DeclaratorHandler(this);
    private ExpressionHandler expressionHandler = new ExpressionHandler(this);
    private InitializerHandler initializerHandler = new InitializerHandler(this);
    private ParameterDeclarationHandler parameterDeclarationHandler = new ParameterDeclarationHandler(this);
    private StatementHandler statementHandler = new StatementHandler(this);
    private HashMap<IBinding, Declaration> cachedDeclarations = new HashMap();
    private HashMap<Integer, String> comments = new HashMap();

    public CXXLanguageFrontend(@NonNull TranslationConfiguration config, ScopeManager scopeManager) {
        super(config, scopeManager, "::");
    }

    private static int getEndColumnIndex(AbstractCharArray posPrefix, int end) {
        int column = 1;
        try {
            if (end - 1 >= posPrefix.getLength() || posPrefix.get(end - 1) == '\n') {
                end = Math.min(end - 1, posPrefix.getLength() - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("could not update end ", (Throwable)e);
        }
        for (int i = end - 1; i > 1 && posPrefix.get(i) != '\n'; --i) {
            ++column;
        }
        return column;
    }

    private static void explore(IASTNode node, int indent) {
        IASTNode[] children = node.getChildren();
        StringBuilder s = new StringBuilder();
        s.append(" ".repeat(indent));
        log.debug("{}{} -> {}", new Object[]{s, node.getClass().getSimpleName(), node.getRawSignature().replaceAll("\n", " \\ ").replaceAll("\\s+", "  ")});
        for (IASTNode iastNode : children) {
            CXXLanguageFrontend.explore(iastNode, indent + 2);
        }
    }

    @Override
    public TranslationUnitDeclaration parse(File file) throws TranslationException {
        TypeManager.getInstance().setLanguageFrontend(this);
        FileContent content = FileContent.createForExternalFileLocation((String)file.getAbsolutePath());
        String[] includePaths = this.config.includePaths;
        ScannerInfo scannerInfo = new ScannerInfo(this.config.symbols, includePaths);
        DefaultLogService log = new DefaultLogService();
        IncludeFileContentProvider includeProvider = this.config.loadIncludes ? INCLUDE_FILE_PROVIDER : IncludeFileContentProvider.getEmptyFilesProvider();
        int opts = 32;
        try {
            Benchmark bench = new Benchmark(this.getClass(), "Parsing sourcefile");
            IASTTranslationUnit translationUnit = GPPLanguage.getDefault().getASTTranslationUnit(content, (IScannerInfo)scannerInfo, includeProvider, null, opts, (IParserLogService)log);
            bench.stop();
            bench = new Benchmark(this.getClass(), "Transform to CPG");
            if (this.config.debugParser) {
                CXXLanguageFrontend.explore((IASTNode)translationUnit, 0);
            }
            for (IASTComment c : translationUnit.getComments()) {
                this.comments.put(c.getFileLocation().getStartingLineNumber(), c.getRawSignature());
            }
            TranslationUnitDeclaration translationUnitDeclaration = this.declarationHandler.handleTranslationUnit((CPPASTTranslationUnit)translationUnit);
            bench.stop();
            return translationUnitDeclaration;
        }
        catch (CoreException ex) {
            throw new TranslationException((Exception)((Object)ex));
        }
    }

    @Override
    public <T> @Nullable String getCodeFromRawNode(T astNode) {
        if (astNode instanceof ASTNode) {
            ASTNode node = (ASTNode)astNode;
            return node.getRawSignature();
        }
        return null;
    }

    @Override
    public <T> @NonNull Region getRegionFromRawNode(T astNode) {
        if (astNode instanceof ASTNode) {
            ASTNode node = (ASTNode)astNode;
            IASTFileLocation fLocation = node.getFileLocation();
            ASTNode parent = (ASTNode)node.getParent();
            if (fLocation != null) {
                CharArray parentRawSig = new CharArray("");
                try {
                    Field fLoc = this.getField(fLocation.getClass(), "fLocationCtx");
                    fLoc.setAccessible(true);
                    Object locCtx = fLoc.get(fLocation);
                    Field fSource = this.getField(locCtx.getClass(), "fSource");
                    fSource.setAccessible(true);
                    parentRawSig = (AbstractCharArray)fSource.get(locCtx);
                }
                catch (ClassCastException | NullPointerException | ReflectiveOperationException e) {
                    LOGGER.warn("Reflective retrieval of AST node source failed. Must go the official but costly route via getRawSignature(). Watch your heap!");
                    while (parent.getParent() != null) {
                        parent = (ASTNode)parent.getParent();
                    }
                    parentRawSig = new CharArray(parent.getRawSignature());
                }
                int startColumn = 1;
                for (int i = node.getFileLocation().getNodeOffset() - 1; i > 1 && parentRawSig.get(i) != '\n'; --i) {
                    ++startColumn;
                }
                int endColumn = CXXLanguageFrontend.getEndColumnIndex((AbstractCharArray)parentRawSig, node.getFileLocation().getNodeOffset() + node.getLength());
                return new Region(fLocation.getStartingLineNumber(), startColumn, fLocation.getEndingLineNumber(), endColumn);
            }
        }
        return new Region();
    }

    private Field getField(Class<?> type, String fieldName) throws NoSuchFieldException {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (type.getSuperclass() != null) {
                return this.getField(type.getSuperclass(), fieldName);
            }
            throw e;
        }
    }

    public void expressionRefersToDeclaration(Expression expression, IASTExpression iastExpression) {
        if (expression instanceof DeclaredReferenceExpression && iastExpression instanceof CPPASTIdExpression) {
            IBinding binding = ((CPPASTIdExpression)iastExpression).getName().resolveBinding();
            Declaration declaration = this.cachedDeclarations.get(binding);
            if (declaration != null) {
                LOGGER.debug("Connecting {} to {}", (Object)expression, (Object)declaration);
                ((DeclaredReferenceExpression)expression).setRefersTo(Set.of((ValueDeclaration)declaration));
            }
        } else if (expression == null) {
            LOGGER.warn("Cannot connect, from is NULL, to is {}", (Object)iastExpression.getClass().toGenericString());
        } else if (iastExpression == null) {
            LOGGER.warn("Cannot connect, to is NULL, from is {}", (Object)expression.getClass().toGenericString());
        } else {
            LOGGER.debug("Cannot connect {} to {}", expression.getClass(), iastExpression.getClass());
        }
    }

    public @Nullable Declaration cacheDeclaration(IBinding binding, Declaration declaration) {
        return this.cachedDeclarations.put(binding, declaration);
    }

    public Declaration getCachedDeclaration(IBinding binding) {
        return this.cachedDeclarations.get(binding);
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public <S, T> void setComment(S s, T ctx) {
        Node cpgNode;
        if (ctx instanceof ASTNode && s instanceof Node && this.comments.containsKey((cpgNode = (Node)s).getRegion().getEndLine())) {
            cpgNode.setComment(this.comments.get(cpgNode.getRegion().getEndLine()));
        }
    }

    public DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    public DeclarationListHandler getDeclarationListHandler() {
        return this.declarationListHandler;
    }

    public DeclaratorHandler getDeclaratorHandler() {
        return this.declaratorHandler;
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    public InitializerHandler getInitializerHandler() {
        return this.initializerHandler;
    }

    public ParameterDeclarationHandler getParameterDeclarationHandler() {
        return this.parameterDeclarationHandler;
    }

    public StatementHandler getStatementHandler() {
        return this.statementHandler;
    }
}

