/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.Region;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageFrontend {
    protected static final Logger log = LoggerFactory.getLogger(LanguageFrontend.class);
    protected final TranslationConfiguration config;
    protected ScopeManager scopeManager;
    protected Map<Object, BiConsumer<Object, Object>> objectListeners = new HashMap<Object, BiConsumer<Object, Object>>();
    protected Map<BiPredicate<Object, Object>, BiConsumer<Object, Object>> predicateListeners = new HashMap<BiPredicate<Object, Object>, BiConsumer<Object, Object>>();
    protected Map<Object, Object> processedMapping = new HashMap<Object, Object>();
    private String namespaceDelimiter;
    private Map<String, RecordDeclaration> records = new HashMap<String, RecordDeclaration>();

    public LanguageFrontend(@NonNull TranslationConfiguration config, ScopeManager scopeManager, String namespaceDelimiter) {
        this.config = config;
        this.namespaceDelimiter = namespaceDelimiter;
        this.scopeManager = scopeManager;
        this.scopeManager.setLang(this);
    }

    public void process(Object from, Object to) {
        this.processedMapping.put(from, to);
        BiConsumer<Object, Object> listener = this.objectListeners.get(from);
        if (listener != null) {
            listener.accept(from, to);
            this.objectListeners.remove(from);
        }
        for (Map.Entry<BiPredicate<Object, Object>, BiConsumer<Object, Object>> pListener : this.predicateListeners.entrySet()) {
            if (!pListener.getKey().test(from, to)) continue;
            pListener.getValue().accept(from, to);
            this.predicateListeners.remove(pListener.getKey());
        }
    }

    public void registerObjectListener(Object from, BiConsumer<Object, Object> biConsumer) {
        if (this.processedMapping.containsKey(from)) {
            biConsumer.accept(from, this.processedMapping.get(from));
        }
        this.objectListeners.put(from, biConsumer);
    }

    public void registerPredicateListener(BiPredicate<Object, Object> predicate, BiConsumer<Object, Object> biConsumer) {
        ArrayList<Map.Entry<Object, Object>> matchingEntries = new ArrayList<Map.Entry<Object, Object>>();
        for (Map.Entry<Object, Object> mapping : this.processedMapping.entrySet()) {
            if (!predicate.test(mapping.getKey(), mapping.getValue())) continue;
            matchingEntries.add(mapping);
        }
        if (!matchingEntries.isEmpty()) {
            for (Map.Entry<Object, Object> match : matchingEntries) {
                biConsumer.accept(match.getKey(), match.getValue());
            }
        }
        this.predicateListeners.put(predicate, biConsumer);
    }

    public void clearProcessed() {
        this.objectListeners.clear();
        this.predicateListeners.clear();
        this.processedMapping.clear();
    }

    public List<TranslationUnitDeclaration> parseAll() throws TranslationException {
        ArrayList<TranslationUnitDeclaration> units = new ArrayList<TranslationUnitDeclaration>();
        for (File sourceFile : this.config.getSourceLocations()) {
            units.add(this.parse(sourceFile));
        }
        return units;
    }

    public @NonNull ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    public void setScopeManager(@NonNull ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
        this.scopeManager.setLang(this);
    }

    public abstract TranslationUnitDeclaration parse(File var1) throws TranslationException;

    public abstract <T> @Nullable String getCodeFromRawNode(T var1);

    public abstract <T> @NonNull Region getRegionFromRawNode(T var1);

    public <N, S> void setCodeAndRegion(@NonNull N cpgNode, @NonNull S astNode) {
        if (cpgNode instanceof Node) {
            if (this.config.codeInNodes) {
                String code = this.getCodeFromRawNode(astNode);
                if (code != null) {
                    ((Node)cpgNode).setCode(code);
                } else {
                    log.warn("Unexpected: No code for node {}", (Object)astNode.toString());
                }
            }
            ((Node)cpgNode).setRegion(this.getRegionFromRawNode(astNode));
        }
    }

    public String getNewLineType(Node node) {
        List<String> nls = Arrays.asList("\n\r", "\r\n", "\n");
        for (String nl : nls) {
            if (!node.toString().endsWith(nl)) continue;
            return nl;
        }
        log.debug("Could not determine newline type. Assuming \\n. {}", (Object)node.toString());
        return "\n";
    }

    public String getCodeOfSubregion(Node node, Region nodeRegion, Region subRegion) {
        String code = node.getCode();
        if (code == null) {
            return "";
        }
        String nlType = this.getNewLineType(node);
        int start = subRegion.getStartLine() == nodeRegion.getStartLine() ? subRegion.getStartColumn() - nodeRegion.getStartColumn() : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getStartLine() - nodeRegion.getStartLine())) + subRegion.getStartColumn();
        int end = subRegion.getEndLine() == nodeRegion.getStartLine() ? subRegion.getStartColumn() - nodeRegion.getStartColumn() : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getEndLine() - nodeRegion.getStartLine())) + subRegion.getEndColumn();
        return code.substring(start, end);
    }

    public Region mergeRegions(Region regionOne, Region regionTwo) {
        Region ret = new Region();
        if (regionOne.getStartLine() < regionTwo.getStartLine() || regionOne.getStartLine() == regionTwo.getStartLine() && regionOne.getStartColumn() < regionTwo.getStartColumn()) {
            ret.setStartLine(regionOne.getStartLine());
            ret.setStartColumn(regionOne.getStartColumn());
        } else {
            ret.setStartLine(regionTwo.getStartLine());
            ret.setStartColumn(regionTwo.getStartColumn());
        }
        if (regionOne.getEndLine() > regionTwo.getEndLine() || regionOne.getEndLine() == regionTwo.getEndLine() && regionOne.getEndColumn() > regionTwo.getEndColumn()) {
            ret.setEndLine(regionOne.getEndLine());
            ret.setEndColumn(regionOne.getStartColumn());
        } else {
            ret.setEndLine(regionTwo.getEndLine());
            ret.setEndColumn(regionTwo.getEndColumn());
        }
        return ret;
    }

    public void addRecord(RecordDeclaration record) {
        this.records.put(record.getName(), record);
    }

    public Map<String, RecordDeclaration> getRecords() {
        return this.records;
    }

    public void cleanup() {
        this.records.clear();
        this.clearProcessed();
    }

    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    public abstract <S, T> void setComment(S var1, T var2);

    public Optional<RecordDeclaration> getRecordForName(String name) {
        return Optional.ofNullable(this.records.get(name));
    }
}

