/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontendFactory;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationManager {
    private static final Logger log = LoggerFactory.getLogger(TranslationManager.class);
    private @NonNull TranslationConfiguration config;
    private AtomicBoolean isCancelled = new AtomicBoolean(false);

    private TranslationManager(@NonNull TranslationConfiguration config) {
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletableFuture<TranslationResult> analyze() {
        TranslationResult result = new TranslationResult(this);
        return CompletableFuture.supplyAsync(() -> {
            ScopeManager scopesBuildForAnalysis = new ScopeManager();
            Benchmark outerBench = new Benchmark(TranslationManager.class, "Translation into full graph");
            HashSet<Pass> passesNeedCleanup = new HashSet<Pass>();
            HashSet<LanguageFrontend> frontendsNeedCleanup = null;
            try {
                Benchmark bench = new Benchmark(this.getClass(), "Frontend");
                frontendsNeedCleanup = this.runFrontends(result, this.config, scopesBuildForAnalysis);
                bench.stop();
                for (Pass pass : this.config.getRegisteredPasses()) {
                    passesNeedCleanup.add(pass);
                    bench = new Benchmark(pass.getClass(), "Executing Pass");
                    pass.accept(result);
                    bench.stop();
                    if (!result.isCancelled()) continue;
                    log.warn("Analysis interrupted, stopping Pass evaluation");
                }
            }
            catch (TranslationException ex) {
                throw new CompletionException(ex);
            }
            finally {
                outerBench.stop();
                log.debug("Cleaning up {} Passes", (Object)passesNeedCleanup.size());
                passesNeedCleanup.forEach(Pass::cleanup);
                if (frontendsNeedCleanup != null) {
                    log.debug("Cleaning up {} Frontends", (Object)frontendsNeedCleanup.size());
                    frontendsNeedCleanup.forEach(LanguageFrontend::cleanup);
                }
                TypeManager.getInstance().cleanup();
            }
            return result;
        });
    }

    public List<Pass> getPasses() {
        return this.config.getRegisteredPasses();
    }

    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    private HashSet<LanguageFrontend> runFrontends(@NonNull TranslationResult result, @NonNull TranslationConfiguration config, @NonNull ScopeManager scopeManager) throws TranslationException {
        ArrayList<File> sourceLocations = new ArrayList<File>(this.config.getSourceLocations());
        HashSet<LanguageFrontend> usedFrontends = new HashSet<LanguageFrontend>();
        for (int i = 0; i < sourceLocations.size(); ++i) {
            LanguageFrontend frontend;
            block15: {
                File sourceLocation = (File)sourceLocations.get(i);
                if (sourceLocation.isDirectory()) {
                    try (Stream<Path> stream = Files.find(sourceLocation.toPath(), 999, (p, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
                        sourceLocations.addAll(stream.map(Path::toFile).collect(Collectors.toSet()));
                        continue;
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                log.info("Parsing {}", (Object)sourceLocation.getAbsolutePath());
                frontend = null;
                try {
                    frontend = LanguageFrontendFactory.getFrontend(Util.getExtension(sourceLocation), config, scopeManager);
                    if (frontend == null) {
                        log.error("Found no parser frontend for {}", (Object)sourceLocation.getName());
                        if (!config.failOnError) continue;
                        throw new TranslationException("Found no parser frontend for " + sourceLocation.getName());
                    }
                    for (LanguageFrontend previous : usedFrontends) {
                        if (previous.getClass().equals(frontend.getClass())) continue;
                        log.error("Different frontends are used for multiple files. This will very likely break the following passes.");
                    }
                    usedFrontends.add(frontend);
                    Map sfToFe = (Map)result.getScratch().computeIfAbsent("sourceLocationsToFrontend", x -> new HashMap());
                    sfToFe.put(sourceLocation.getName(), frontend.getClass().getSimpleName());
                    result.getTranslationUnits().add(frontend.parse(sourceLocation));
                }
                catch (TranslationException ex) {
                    log.error("An error occurred during parsing of {}: {}", (Object)sourceLocation.getName(), (Object)ex.getMessage());
                    if (!config.failOnError) break block15;
                    throw ex;
                }
            }
            for (Pass pass : config.getRegisteredPasses()) {
                pass.setLang(frontend);
            }
        }
        return usedFrontends;
    }

    public @NonNull TranslationConfiguration getConfig() {
        return this.config;
    }

    public static class Builder {
        private TranslationConfiguration config;

        private Builder() {
        }

        public Builder config(TranslationConfiguration config) {
            this.config = config;
            return this;
        }

        public TranslationManager build() {
            return new TranslationManager(this.config);
        }
    }
}

