/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg_vis_neo4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.aisec.cpg.ConfigurationException;
import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.BenchmarkResults;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import de.fraunhofer.aisec.cpg.passes.ControlDependenceGraphPass;
import de.fraunhofer.aisec.cpg.passes.ControlFlowSensitiveDFGPass;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.ImportResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.PrepareSerialization;
import de.fraunhofer.aisec.cpg.passes.ProgramDependenceGraphPass;
import de.fraunhofer.aisec.cpg.passes.SymbolResolver;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg_vis_neo4j.Application;
import de.fraunhofer.aisec.cpg_vis_neo4j.JsonEdge;
import de.fraunhofer.aisec.cpg_vis_neo4j.JsonGraph;
import de.fraunhofer.aisec.cpg_vis_neo4j.JsonNode;
import de.fraunhofer.aisec.cpg_vis_neo4j.Schema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.cypher.compiler.MultiStatementCypherCompiler;
import org.neo4j.ogm.cypher.compiler.builders.node.DefaultNodeBuilder;
import org.neo4j.ogm.cypher.compiler.builders.node.DefaultRelationshipBuilder;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001RB\u0005\u00a2\u0006\u0002\u0010\u0003J&\u00107\u001a\u0002082\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020:\u0018\u00010(2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010(J\r\u0010=\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B0@J\u0016\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0005J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050(2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070JH\u0002J\u001c\u0010K\u001a\u00020D2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070J2\u0006\u0010L\u001a\u00020MJ\u000e\u0010N\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u0006\u0010O\u001a\u00020PJ*\u0010Q\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020:\u0018\u00010(\u0012\f\u0012\n\u0012\u0004\u0012\u00020<\u0018\u00010(0@2\u0006\u0010E\u001a\u00020FR\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u0012\u0010!\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R$\u0010'\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*0)0(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010,\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*0)0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00102\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00103\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00104\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00106\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application;", "Ljava/util/concurrent/Callable;", "", "()V", "benchmarkJson", "Ljava/io/File;", "customPasses", "", "depth", "exportJsonFile", "host", "includesFile", "inferNodes", "", "loadIncludes", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mutuallyExclusiveParameters", "Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "getMutuallyExclusiveParameters", "()Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "setMutuallyExclusiveParameters", "(Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;)V", "neo4jPassword", "getNeo4jPassword", "()Ljava/lang/String;", "setNeo4jPassword", "(Ljava/lang/String;)V", "neo4jUsername", "getNeo4jUsername", "setNeo4jUsername", "noDefaultPasses", "noNeo4j", "noPurgeDb", "packages", "", "[Ljava/lang/String;", "passClassList", "", "Lkotlin/reflect/KClass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "passClassMap", "", "passList", "getPassList", "()Ljava/util/List;", "port", "printBenchmark", "schemaJson", "schemaMarkdown", "topLevel", "useUnityBuild", "buildJsonGraph", "Lde/fraunhofer/aisec/cpg_vis_neo4j/JsonGraph;", "newNodeBuilders", "Lorg/neo4j/ogm/cypher/compiler/builders/node/DefaultNodeBuilder;", "newRelationshipBuilders", "Lorg/neo4j/ogm/cypher/compiler/builders/node/DefaultRelationshipBuilder;", "call", "()Ljava/lang/Integer;", "connect", "Lkotlin/Pair;", "Lorg/neo4j/ogm/session/Session;", "Lorg/neo4j/ogm/session/SessionFactory;", "exportToJson", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "path", "getFilesOfList", "filenames", "", "printSchema", "format", "Lde/fraunhofer/aisec/cpg_vis_neo4j/Schema$Format;", "pushToNeo4j", "setupTranslationConfiguration", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "translateCPGToOGMBuilders", "Exclusive", "cpg-neo4j"})
@SourceDebugExtension(value={"SMAP\nApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Application.kt\nde/fraunhofer/aisec/cpg_vis_neo4j/Application\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,635:1\n1194#2,2:636\n1222#2,4:638\n1603#2,9:642\n1855#2:651\n1856#2:653\n1612#2:654\n1549#2:655\n1620#2,3:656\n1549#2:659\n1620#2,3:660\n800#2,11:663\n800#2,11:674\n1549#2:685\n1620#2,2:686\n1179#2,2:688\n1253#2,4:690\n1622#2:694\n766#2:695\n857#2,2:696\n1549#2:698\n1620#2,2:699\n1179#2,2:701\n1253#2,4:703\n1622#2:707\n1549#2:708\n1620#2,3:709\n1855#2,2:712\n1855#2,2:715\n1#3:652\n1#3:714\n32#4,2:717\n*S KotlinDebug\n*F\n+ 1 Application.kt\nde/fraunhofer/aisec/cpg_vis_neo4j/Application\n*L\n264#1:636,2\n264#1:638,4\n268#1:642,9\n268#1:651\n268#1:653\n268#1:654\n286#1:655\n286#1:656,3\n287#1:659\n287#1:660,3\n302#1:663,11\n304#1:674,11\n322#1:685\n322#1:686,2\n327#1:688,2\n327#1:690,4\n322#1:694\n333#1:695\n333#1:696,2\n334#1:698\n334#1:699,2\n341#1:701,2\n341#1:703,4\n334#1:707\n457#1:708\n457#1:709,3\n458#1:712,2\n552#1:715,2\n268#1:652\n580#1:717,2\n*E\n"})
public final class Application
implements Callable<Integer> {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    public Exclusive mutuallyExclusiveParameters;
    @CommandLine.Option(names={"--user"}, description={"Neo4j user name (default: neo4j)"})
    @NotNull
    private String neo4jUsername = "neo4j";
    @CommandLine.Option(names={"--password"}, description={"Neo4j password (default: password"})
    @NotNull
    private String neo4jPassword = "password";
    @CommandLine.Option(names={"--host"}, description={"Set the host of the neo4j Database (default: localhost)."})
    @NotNull
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, description={"Set the port of the neo4j Database (default: 7687)."})
    private int port = 7687;
    @CommandLine.Option(names={"--save-depth"}, description={"Performance optimisation: Limit recursion depth form neo4j OGM when leaving the AST. -1 (default) means no limit is used."})
    private int depth = -1;
    @CommandLine.Option(names={"--load-includes"}, description={"Enable TranslationConfiguration option loadIncludes"})
    private boolean loadIncludes;
    @CommandLine.Option(names={"--use-unity-build"}, description={"Enable unity build mode for C++ (requires --load-includes)"})
    private boolean useUnityBuild;
    @CommandLine.Option(names={"--includes-file"}, description={"Load includes from file"})
    @Nullable
    private File includesFile;
    @CommandLine.Option(names={"--print-benchmark"}, description={"Print benchmark result as markdown table"})
    private boolean printBenchmark;
    @CommandLine.Option(names={"--no-default-passes"}, description={"Do not register default passes [used for debugging]"})
    private boolean noDefaultPasses;
    @CommandLine.Option(names={"--custom-pass-list"}, description={"Add custom list of passes (might be used additional to --no-default-passes) which is passed as a comma-separated list; give either pass name if pass is in list, or its FQDN (e.g. --custom-pass-list=DFGPass,CallResolver)"})
    @NotNull
    private String customPasses = "DEFAULT";
    @CommandLine.Option(names={"--no-neo4j"}, description={"Do not push cpg into neo4j [used for debugging]"})
    private boolean noNeo4j;
    @CommandLine.Option(names={"--no-purge-db"}, description={"Do no purge neo4j database before pushing the cpg"})
    private boolean noPurgeDb;
    @CommandLine.Option(names={"--infer-nodes"}, description={"Create inferred nodes for missing declarations"})
    private boolean inferNodes;
    @CommandLine.Option(names={"--schema-markdown"}, description={"Print the CPGs nodes and edges that they can have."})
    private boolean schemaMarkdown;
    @CommandLine.Option(names={"--schema-json"}, description={"Print the CPGs nodes and edges that they can have."})
    private boolean schemaJson;
    @CommandLine.Option(names={"--top-level"}, description={"Set top level directory of project structure. Default: Largest common path of all source files"})
    @Nullable
    private File topLevel;
    @CommandLine.Option(names={"--benchmark-json"}, description={"Save benchmark results to json file"})
    @Nullable
    private File benchmarkJson;
    @CommandLine.Option(names={"--export-json"}, description={"Export cpg as json"})
    @Nullable
    private File exportJsonFile;
    @NotNull
    private List<? extends KClass<? extends Pass<? extends Node>>> passClassList;
    @NotNull
    private Map<String, ? extends KClass<? extends Pass<? extends Node>>> passClassMap;
    @NotNull
    private final String[] packages;

    /*
     * WARNING - void declaration
     */
    public Application() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object = new KClass[]{Reflection.getOrCreateKotlinClass(TypeHierarchyResolver.class), Reflection.getOrCreateKotlinClass(ImportResolver.class), Reflection.getOrCreateKotlinClass(SymbolResolver.class), Reflection.getOrCreateKotlinClass(DFGPass.class), Reflection.getOrCreateKotlinClass(EvaluationOrderGraphPass.class), Reflection.getOrCreateKotlinClass(TypeResolver.class), Reflection.getOrCreateKotlinClass(ControlFlowSensitiveDFGPass.class), Reflection.getOrCreateKotlinClass(FilenameMapper.class), Reflection.getOrCreateKotlinClass(ControlDependenceGraphPass.class), Reflection.getOrCreateKotlinClass(ProgramDependenceGraphPass.class)};
        this.passClassList = CollectionsKt.listOf((Object[])object);
        object = this.passClassList;
        Application application = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KClass kClass = (KClass)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSimpleName(), element$iv$iv);
        }
        application.passClassMap = destination$iv$iv;
        object = new String[]{"de.fraunhofer.aisec.cpg.graph", "de.fraunhofer.aisec.cpg.frontends"};
        this.packages = object;
    }

    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(Application.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @NotNull
    public final Exclusive getMutuallyExclusiveParameters() {
        Exclusive exclusive = this.mutuallyExclusiveParameters;
        if (exclusive != null) {
            return exclusive;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mutuallyExclusiveParameters");
        return null;
    }

    public final void setMutuallyExclusiveParameters(@NotNull Exclusive exclusive) {
        Intrinsics.checkNotNullParameter((Object)exclusive, (String)"<set-?>");
        this.mutuallyExclusiveParameters = exclusive;
    }

    @NotNull
    public final String getNeo4jUsername() {
        return this.neo4jUsername;
    }

    public final void setNeo4jUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.neo4jUsername = string;
    }

    @NotNull
    public final String getNeo4jPassword() {
        return this.neo4jPassword;
    }

    public final void setNeo4jPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.neo4jPassword = string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPassList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.passClassList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KClass it = (KClass)element$iv$iv;
            boolean bl2 = false;
            if (it.getSimpleName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<DefaultNodeBuilder>, List<DefaultRelationshipBuilder>> translateCPGToOGMBuilders(@NotNull TranslationResult translationResult) {
        List list;
        List list2;
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        String[] stringArray = this.packages;
        MetaData meta = new MetaData(Arrays.copyOf(stringArray, stringArray.length));
        MappingContext con = new MappingContext(meta);
        EntityGraphMapper entityGraphMapper = new EntityGraphMapper(meta, con);
        Iterable $this$map$iv = translationResult.getComponents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Component component = (Component)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(entityGraphMapper.map(it, this.depth));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        $this$map$iv = translationResult.getAdditionalNodes();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Node)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(entityGraphMapper.map(it, this.depth));
        }
        List cfr_ignored_1 = (List)destination$iv$iv;
        Compiler compiler = entityGraphMapper.compileContext().getCompiler();
        Field getNewNodeBuilders = MultiStatementCypherCompiler.class.getDeclaredField("newNodeBuilders");
        Field getNewRelationshipBuilders = MultiStatementCypherCompiler.class.getDeclaredField("newRelationshipBuilders");
        getNewNodeBuilders.setAccessible(true);
        getNewRelationshipBuilders.setAccessible(true);
        Object object = getNewNodeBuilders.get(compiler);
        ArrayList arrayList = object instanceof ArrayList ? (ArrayList)object : null;
        if (arrayList != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = arrayList;
            boolean $i$f$filterIsInstance = false;
            it = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DefaultNodeBuilder)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = null;
        }
        List newNodeBuilders = list2;
        Object $i$f$filterIsInstance = getNewRelationshipBuilders.get(compiler);
        ArrayList arrayList2 = $i$f$filterIsInstance instanceof ArrayList ? (ArrayList)$i$f$filterIsInstance : null;
        if (arrayList2 != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = arrayList2;
            boolean $i$f$filterIsInstance2 = false;
            Iterable destination$iv$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DefaultRelationshipBuilder)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            list = null;
        }
        List newRelationshipBuilders = list;
        return TuplesKt.to(newNodeBuilders, newRelationshipBuilders);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonGraph buildJsonGraph(@Nullable List<? extends DefaultNodeBuilder> newNodeBuilders, @Nullable List<? extends DefaultRelationshipBuilder> newRelationshipBuilders) {
        List list;
        List nodes;
        Property prop;
        Collection collection;
        Collection destination$iv$iv;
        List<? extends DefaultNodeBuilder> list2 = newNodeBuilders;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
                Map map;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                void it;
                DefaultNodeBuilder defaultNodeBuilder = (DefaultNodeBuilder)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                org.neo4j.ogm.model.Node node = it.node();
                Long l = node.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                long l2 = ((Number)l).longValue();
                String[] stringArray = node.getLabels();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getLabels(...)");
                Set set = ArraysKt.toSet((Object[])stringArray);
                List list3 = node.getPropertyList();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getPropertyList(...)");
                Iterable iterable2 = list3;
                Set set2 = set;
                long l3 = l2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var23_31 = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv2;
                    prop = (Property)element$iv$iv;
                    boolean bl2 = false;
                    prop = TuplesKt.to((Object)prop.getKey(), (Object)prop.getValue());
                    map2.put(prop.getFirst(), prop.getSecond());
                }
                Map map3 = map = destination$iv$iv2;
                Set set3 = set2;
                long l4 = l3;
                collection.add(new JsonNode(l4, set3, map3));
            }
            v6 = (List)destination$iv$iv;
        } else {
            v6 = nodes = CollectionsKt.emptyList();
        }
        if (newRelationshipBuilders != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable $i$f$map = newRelationshipBuilders;
            boolean $i$f$filter22 = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DefaultRelationshipBuilder it = (DefaultRelationshipBuilder)element$iv$iv;
                boolean bl = false;
                if (!(it.edge().getStartNode() != null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                Map map;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                void it;
                DefaultRelationshipBuilder bl = (DefaultRelationshipBuilder)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl3 = false;
                Edge edge = it.edge();
                Long l = edge.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                long l5 = ((Number)l).longValue();
                Intrinsics.checkNotNullExpressionValue((Object)edge.getType(), (String)"getType(...)");
                Long l6 = edge.getStartNode();
                Intrinsics.checkNotNullExpressionValue((Object)l6, (String)"getStartNode(...)");
                long l7 = ((Number)l6).longValue();
                Long l8 = edge.getEndNode();
                Intrinsics.checkNotNullExpressionValue((Object)l8, (String)"getEndNode(...)");
                long l9 = ((Number)l8).longValue();
                List list4 = edge.getPropertyList();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getPropertyList(...)");
                Iterable iterable = list4;
                long l10 = l9;
                long l11 = l7;
                long l12 = l5;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                prop = $this$associate$iv;
                Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map4 = destination$iv$iv5;
                    Property prop2 = (Property)element$iv$iv;
                    boolean bl4 = false;
                    Pair pair = TuplesKt.to((Object)prop2.getKey(), (Object)prop2.getValue());
                    map4.put(pair.getFirst(), pair.getSecond());
                }
                Map map5 = map = destination$iv$iv5;
                long l13 = l10;
                long l14 = l11;
                String string2 = string;
                long l15 = l12;
                collection.add(new JsonEdge(l15, string2, l14, l13, map5));
            }
            list = (List)destination$iv$iv4;
        } else {
            list = CollectionsKt.emptyList();
        }
        List edges = list;
        return new JsonGraph(nodes, edges);
    }

    public final void exportToJson(@NotNull TranslationResult translationResult, @NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Benchmark bench = new Benchmark(this.getClass(), "Export cpg to json", false, (StatisticsHolder)translationResult);
        this.getLog().info("Export graph to json using import depth: " + this.depth);
        Pair<List<DefaultNodeBuilder>, List<DefaultRelationshipBuilder>> pair = this.translateCPGToOGMBuilders(translationResult);
        List nodes = (List)pair.component1();
        List edges = (List)pair.component2();
        JsonGraph graph = this.buildJsonGraph(nodes, edges);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writeValue(path, (Object)graph);
        this.getLog().info("Exported " + graph.getNodes().size() + " Nodes and " + graph.getEdges().size() + " Edges to json file " + path.getAbsoluteFile());
        MeasurementHolder.addMeasurement$default((MeasurementHolder)((MeasurementHolder)bench), null, null, (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToNeo4j(@NotNull TranslationResult translationResult) throws InterruptedException, ConnectException {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        Benchmark bench = new Benchmark(this.getClass(), "Push cpg to neo4j", false, (StatisticsHolder)translationResult);
        this.getLog().info("Using import depth: " + this.depth);
        this.getLog().info("Count base nodes to save: " + translationResult.getComponents().size() + translationResult.getAdditionalNodes().size());
        Pair<Session, SessionFactory> sessionAndSessionFactoryPair = this.connect();
        Session session = (Session)sessionAndSessionFactoryPair.getFirst();
        AutoCloseable autoCloseable = (AutoCloseable)session.beginTransaction();
        Throwable throwable = null;
        try {
            Transaction transaction = (Transaction)autoCloseable;
            boolean bl = false;
            if (!this.noPurgeDb) {
                session.purgeDatabase();
            }
            session.save((Object)translationResult.getComponents(), this.depth);
            session.save((Object)translationResult.getAdditionalNodes(), this.depth);
            transaction.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        session.clear();
        ((SessionFactory)sessionAndSessionFactoryPair.getSecond()).close();
        MeasurementHolder.addMeasurement$default((MeasurementHolder)((MeasurementHolder)bench), null, null, (int)3, null);
    }

    @NotNull
    public final Pair<Session, SessionFactory> connect() throws InterruptedException, ConnectException {
        boolean bl;
        String[] stringArray;
        int fails = 0;
        SessionFactory sessionFactory = null;
        Session session = null;
        while (session == null && fails < 10) {
            try {
                Configuration configuration = new Configuration.Builder().uri("bolt://" + this.host + ":" + this.port).autoIndex("none").credentials(this.neo4jUsername, this.neo4jPassword).verifyConnection(Boolean.valueOf(true)).build();
                stringArray = this.packages;
                sessionFactory = new SessionFactory(configuration, Arrays.copyOf(stringArray, stringArray.length));
                session = sessionFactory.openSession();
            }
            catch (ConnectionException ex) {
                sessionFactory = null;
                ++fails;
                this.getLog().error("Unable to connect to localhost:7687, ensure the database is running and that there is a working network connection to it.");
                Thread.sleep(2000L);
            }
            catch (AuthenticationException ex) {
                this.getLog().error("Unable to connect to localhost:7687, wrong username/password!");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        if (session == null || sessionFactory == null) {
            this.getLog().error("Unable to connect to localhost:7687");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        boolean bl2 = bl = fails <= 10;
        if (_Assertions.ENABLED && !bl) {
            stringArray = "Assertion failed";
            throw new AssertionError(stringArray);
        }
        return new Pair(session, sessionFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getFilesOfList(Collection<String> filenames) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = filenames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get((String)it, new String[0]).toAbsolutePath().normalize().toFile());
        }
        List filePaths = (List)destination$iv$iv;
        Iterable $this$forEach$iv = filePaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.exists() && !it.isHidden()) continue;
            boolean bl2 = false;
            String string = "Please use a correct path. It was: " + it.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        return filePaths;
    }

    @NotNull
    public final TranslationConfiguration setupTranslationConfiguration() {
        Object object;
        TranslationConfiguration.Builder translationConfiguration = TranslationConfiguration.Companion.builder().topLevel(this.topLevel).optionalLanguage("de.fraunhofer.aisec.cpg.frontends.cxx.CLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.cxx.CPPLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.java.JavaLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.golang.GoLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.python.PythonLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.ruby.RubyLanguage").loadIncludes(this.loadIncludes).addIncludesToGraph(this.loadIncludes).debugParser(true).useUnityBuild(this.useUnityBuild);
        if (!this.getMutuallyExclusiveParameters().getSoftwareComponents().isEmpty()) {
            Map components = new LinkedHashMap();
            for (Map.Entry<String, String> sc : this.getMutuallyExclusiveParameters().getSoftwareComponents().entrySet()) {
                Map map = components;
                object = sc.getKey();
                Object object2 = new String[]{","};
                object2 = this.getFilesOfList(StringsKt.split$default((CharSequence)sc.getValue(), (String[])object2, (boolean)false, (int)0, (int)6, null));
                map.put(object, object2);
            }
            translationConfiguration.softwareComponents(components);
        } else {
            List<File> filePaths = this.getFilesOfList((Collection<String>)this.getMutuallyExclusiveParameters().getFiles());
            translationConfiguration.sourceLocations(filePaths);
        }
        if (!this.noDefaultPasses) {
            translationConfiguration.defaultPasses();
        }
        if (!Intrinsics.areEqual((Object)this.customPasses, (Object)"DEFAULT")) {
            String[] stringArray = new String[]{","};
            List pieces = StringsKt.split$default((CharSequence)this.customPasses, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String pass : pieces) {
                if (StringsKt.contains$default((CharSequence)pass, (CharSequence)".", (boolean)false, (int)2, null)) {
                    Class<?> clazz = Class.forName(pass);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
                    Intrinsics.checkNotNull((Object)kClass, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<out de.fraunhofer.aisec.cpg.passes.Pass<*>>");
                    translationConfiguration.registerPass(kClass);
                    continue;
                }
                if (!this.passClassMap.containsKey(pass)) {
                    throw new ConfigurationException("Asked to produce unknown pass: " + pass);
                }
                if (this.passClassMap.get(pass) != null) {
                    KClass<? extends Pass<? extends Node>> it;
                    boolean bl = false;
                    translationConfiguration.registerPass(it);
                }
            }
        }
        translationConfiguration.registerPass(Reflection.getOrCreateKotlinClass(PrepareSerialization.class));
        File file = this.getMutuallyExclusiveParameters().getJsonCompilationDatabase();
        if (file != null) {
            File it = file;
            boolean bl = false;
            CompilationDatabase db = CompilationDatabase.Companion.fromFile(it);
            if (!((Collection)db).isEmpty()) {
                translationConfiguration.useCompilationDatabase(db);
                translationConfiguration.sourceLocations(db.getSourceFiles());
            }
        }
        File file2 = this.includesFile;
        if (file2 != null) {
            File theFile = file2;
            boolean bl = false;
            this.getLog().info("Load includes form file: " + theFile);
            Object object3 = new File(theFile.toString()).getParentFile();
            if (object3 == null || (object3 = ((File)object3).toString()) == null) {
                object3 = "";
            }
            object = object3;
            Intrinsics.checkNotNull((Object)object);
            Object baseDir = object;
            object = new FileInputStream(theFile);
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).lines().map(arg_0 -> Application.setupTranslationConfiguration$lambda$18$lambda$15(setupTranslationConfiguration.3.1.INSTANCE, arg_0)).map(arg_0 -> Application.setupTranslationConfiguration$lambda$18$lambda$16((Function1)new Function1<String, String>((String)baseDir){
                final /* synthetic */ String $baseDir;
                {
                    this.$baseDir = $baseDir;
                    super(1);
                }

                public final String invoke(String it) {
                    String string;
                    if (Paths.get(it, new String[0]).isAbsolute()) {
                        string = it;
                    } else {
                        String[] stringArray = new String[]{it};
                        string = ((Object)Paths.get(this.$baseDir, stringArray)).toString();
                    }
                    return string;
                }
            }, arg_0)).forEach(arg_0 -> Application.setupTranslationConfiguration$lambda$18$lambda$17((Function1)new Function1<String, Unit>(translationConfiguration){
                final /* synthetic */ TranslationConfiguration.Builder $translationConfiguration;
                {
                    this.$translationConfiguration = $translationConfiguration;
                    super(1);
                }

                public final void invoke(String it) {
                    Intrinsics.checkNotNull((Object)it);
                    this.$translationConfiguration.includePath(it);
                }
            }, arg_0));
        }
        if (this.inferNodes) {
            translationConfiguration.inferenceConfiguration(InferenceConfiguration.Companion.builder().inferRecords(true).build());
        }
        return translationConfiguration.build();
    }

    public final void printSchema(@NotNull Collection<String> filenames, @NotNull Schema.Format format) {
        Intrinsics.checkNotNullParameter(filenames, (String)"filenames");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Schema schema = new Schema();
        schema.extractSchema();
        Iterable $this$forEach$iv = filenames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            schema.printToFile(it, format);
        }
    }

    @Override
    @NotNull
    public Integer call() throws Exception, ConnectException, IllegalArgumentException {
        block8: {
            if (this.schemaMarkdown || this.schemaJson) {
                if (this.schemaMarkdown) {
                    this.printSchema((Collection<String>)this.getMutuallyExclusiveParameters().getFiles(), Schema.Format.MARKDOWN);
                }
                if (this.schemaJson) {
                    this.printSchema((Collection<String>)this.getMutuallyExclusiveParameters().getFiles(), Schema.Format.JSON);
                }
                return 0;
            }
            if (this.getMutuallyExclusiveParameters().getListPasses()) {
                this.getLog().info("List of passes:");
                Iterator<String> $this$forEach$iv = this.getPassList().iterator();
                boolean $i$f$forEach = false;
                Iterator<String> iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    String element$iv;
                    String it = element$iv = iterator.next();
                    boolean bl = false;
                    this.getLog().info("- " + it);
                }
                this.getLog().info("--");
                this.getLog().info("End of list. Stopping.");
                return 0;
            }
            TranslationConfiguration translationConfiguration = this.setupTranslationConfiguration();
            long startTime = System.currentTimeMillis();
            TranslationResult translationResult = (TranslationResult)TranslationManager.Companion.builder().config(translationConfiguration).build().analyze().get();
            long analyzingTime = System.currentTimeMillis();
            this.getLog().info("Benchmark: analyzing code in " + (analyzingTime - startTime) / (long)1000 + " s.");
            File file = this.exportJsonFile;
            if (file != null) {
                File it = file;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)translationResult);
                this.exportToJson(translationResult, it);
            }
            if (!this.noNeo4j) {
                Intrinsics.checkNotNull((Object)translationResult);
                this.pushToNeo4j(translationResult);
            }
            long pushTime = System.currentTimeMillis();
            this.getLog().info("Benchmark: push code in " + (pushTime - analyzingTime) / (long)1000 + " s.");
            BenchmarkResults benchmarkResult = translationResult.getBenchmarkResults();
            if (this.printBenchmark) {
                benchmarkResult.print();
            }
            File file2 = this.benchmarkJson;
            if (file2 == null) break block8;
            File theFile = file2;
            boolean bl = false;
            this.getLog().info("Save benchmark results to file: " + theFile);
            FilesKt.writeText$default((File)theFile, (String)benchmarkResult.getJson(), null, (int)2, null);
        }
        return 0;
    }

    private static final String setupTranslationConfiguration$lambda$18$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String setupTranslationConfiguration$lambda$18$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void setupTranslationConfiguration$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "", "()V", "files", "", "", "getFiles", "()Ljava/util/List;", "setFiles", "(Ljava/util/List;)V", "jsonCompilationDatabase", "Ljava/io/File;", "getJsonCompilationDatabase", "()Ljava/io/File;", "setJsonCompilationDatabase", "(Ljava/io/File;)V", "listPasses", "", "getListPasses", "()Z", "setListPasses", "(Z)V", "softwareComponents", "", "getSoftwareComponents", "()Ljava/util/Map;", "setSoftwareComponents", "(Ljava/util/Map;)V", "cpg-neo4j"})
    public static final class Exclusive {
        @CommandLine.Parameters(description={"The paths to analyze. If module support is enabled, the paths will be looked at if they contain modules"}, arity="0..*")
        @NotNull
        private List<String> files = new ArrayList();
        @CommandLine.Option(names={"--softwareComponents", "-S"}, description={"Maps the names of software components to their respective files. The files are separated by commas (No whitespace!).", "Example: -S App1=./file1.c,./file2.c -S App2=./Main.java,./Class.java"})
        @NotNull
        private Map<String, String> softwareComponents = new LinkedHashMap();
        @CommandLine.Option(names={"--json-compilation-database"}, description={"The path to an optional a JSON compilation database"})
        @Nullable
        private File jsonCompilationDatabase;
        @CommandLine.Option(names={"--list-passes"}, description={"Prints the list available passes"})
        private boolean listPasses;

        @NotNull
        public final List<String> getFiles() {
            return this.files;
        }

        public final void setFiles(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.files = list;
        }

        @NotNull
        public final Map<String, String> getSoftwareComponents() {
            return this.softwareComponents;
        }

        public final void setSoftwareComponents(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.softwareComponents = map;
        }

        @Nullable
        public final File getJsonCompilationDatabase() {
            return this.jsonCompilationDatabase;
        }

        public final void setJsonCompilationDatabase(@Nullable File file) {
            this.jsonCompilationDatabase = file;
        }

        public final boolean getListPasses() {
            return this.listPasses;
        }

        public final void setListPasses(boolean bl) {
            this.listPasses = bl;
        }
    }
}

