/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg_vis_neo4j;

import de.fraunhofer.aisec.cpg.ConfigurationException;
import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.BenchmarkResults;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.ControlFlowSensitiveDFGPass;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.ImportResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import de.fraunhofer.aisec.cpg_vis_neo4j.Application;
import de.fraunhofer.aisec.cpg_vis_neo4j.AstChildrenEventListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u00100\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020503J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050$2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000708H\u0002J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u00020>H\u0002R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0012\u0010 \u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030&0%0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010'\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030&0%0(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0012\u0010,\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application;", "Ljava/util/concurrent/Callable;", "", "()V", "benchmarkJson", "Ljava/io/File;", "customPasses", "", "depth", "host", "includesFile", "inferNodes", "", "loadIncludes", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mutuallyExclusiveParameters", "Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "getMutuallyExclusiveParameters", "()Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "setMutuallyExclusiveParameters", "(Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;)V", "neo4jPassword", "getNeo4jPassword", "()Ljava/lang/String;", "setNeo4jPassword", "(Ljava/lang/String;)V", "neo4jUsername", "getNeo4jUsername", "setNeo4jUsername", "noDefaultPasses", "noNeo4j", "noPurgeDb", "passClassList", "", "Lkotlin/reflect/KClass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "passClassMap", "", "passList", "getPassList", "()Ljava/util/List;", "port", "printBenchmark", "topLevel", "useUnityBuild", "call", "()Ljava/lang/Integer;", "connect", "Lkotlin/Pair;", "Lorg/neo4j/ogm/session/Session;", "Lorg/neo4j/ogm/session/SessionFactory;", "getFilesOfList", "filenames", "", "pushToNeo4j", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "setupTranslationConfiguration", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "Exclusive", "cpg-neo4j"})
@SourceDebugExtension(value={"SMAP\nApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Application.kt\nde/fraunhofer/aisec/cpg_vis_neo4j/Application\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,515:1\n1194#2,2:516\n1222#2,4:518\n1603#2,9:522\n1855#2:531\n1856#2:533\n1612#2:534\n1549#2:535\n1620#2,3:536\n1855#2,2:539\n1#3:532\n1#3:541\n32#4,2:542\n*S KotlinDebug\n*F\n+ 1 Application.kt\nde/fraunhofer/aisec/cpg_vis_neo4j/Application\n*L\n238#1:516,2\n238#1:518,4\n242#1:522,9\n242#1:531\n242#1:533\n242#1:534\n338#1:535\n338#1:536,3\n339#1:539,2\n242#1:532\n440#1:542,2\n*E\n"})
public final class Application
implements Callable<Integer> {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    public Exclusive mutuallyExclusiveParameters;
    @CommandLine.Option(names={"--user"}, description={"Neo4j user name (default: neo4j)"})
    @NotNull
    private String neo4jUsername = "neo4j";
    @CommandLine.Option(names={"--password"}, description={"Neo4j password (default: password"})
    @NotNull
    private String neo4jPassword = "password";
    @CommandLine.Option(names={"--host"}, description={"Set the host of the neo4j Database (default: localhost)."})
    @NotNull
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, description={"Set the port of the neo4j Database (default: 7687)."})
    private int port = 7687;
    @CommandLine.Option(names={"--save-depth"}, description={"Performance optimisation: Limit recursion depth form neo4j OGM when leaving the AST. -1 (default) means no limit is used."})
    private int depth = -1;
    @CommandLine.Option(names={"--load-includes"}, description={"Enable TranslationConfiguration option loadIncludes"})
    private boolean loadIncludes;
    @CommandLine.Option(names={"--use-unity-build"}, description={"Enable unity build mode for C++ (requires --load-includes)"})
    private boolean useUnityBuild;
    @CommandLine.Option(names={"--includes-file"}, description={"Load includes from file"})
    @Nullable
    private File includesFile;
    @CommandLine.Option(names={"--print-benchmark"}, description={"Print benchmark result as markdown table"})
    private boolean printBenchmark;
    @CommandLine.Option(names={"--no-default-passes"}, description={"Do not register default passes [used for debugging]"})
    private boolean noDefaultPasses;
    @CommandLine.Option(names={"--custom-pass-list"}, description={"Add custom list of passes (includes --no-default-passes) which is passed as a comma-separated list; give either pass name if pass is in list, or its FQDN (e.g. --custom-pass-list=DFGPass,CallResolver)"})
    @NotNull
    private String customPasses = "DEFAULT";
    @CommandLine.Option(names={"--no-neo4j"}, description={"Do not push cpg into neo4j [used for debugging]"})
    private boolean noNeo4j;
    @CommandLine.Option(names={"--no-purge-db"}, description={"Do no purge neo4j database before pushing the cpg"})
    private boolean noPurgeDb;
    @CommandLine.Option(names={"--infer-nodes"}, description={"Create inferred nodes for missing declarations"})
    private boolean inferNodes;
    @CommandLine.Option(names={"--top-level"}, description={"Set top level directory of project structure. Default: Largest common path of all source files"})
    @Nullable
    private File topLevel;
    @CommandLine.Option(names={"--benchmark-json"}, description={"Save benchmark results to json file"})
    @Nullable
    private File benchmarkJson;
    @NotNull
    private List<? extends KClass<? extends Pass<?>>> passClassList;
    @NotNull
    private Map<String, ? extends KClass<? extends Pass<?>>> passClassMap;

    /*
     * WARNING - void declaration
     */
    public Application() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object = new KClass[]{Reflection.getOrCreateKotlinClass(TypeHierarchyResolver.class), Reflection.getOrCreateKotlinClass(ImportResolver.class), Reflection.getOrCreateKotlinClass(VariableUsageResolver.class), Reflection.getOrCreateKotlinClass(CallResolver.class), Reflection.getOrCreateKotlinClass(DFGPass.class), Reflection.getOrCreateKotlinClass(EvaluationOrderGraphPass.class), Reflection.getOrCreateKotlinClass(TypeResolver.class), Reflection.getOrCreateKotlinClass(ControlFlowSensitiveDFGPass.class), Reflection.getOrCreateKotlinClass(FilenameMapper.class)};
        this.passClassList = CollectionsKt.listOf((Object[])object);
        object = this.passClassList;
        Application application = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KClass kClass = (KClass)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSimpleName(), element$iv$iv);
        }
        application.passClassMap = destination$iv$iv;
    }

    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(Application.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @NotNull
    public final Exclusive getMutuallyExclusiveParameters() {
        Exclusive exclusive = this.mutuallyExclusiveParameters;
        if (exclusive != null) {
            return exclusive;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mutuallyExclusiveParameters");
        return null;
    }

    public final void setMutuallyExclusiveParameters(@NotNull Exclusive exclusive) {
        Intrinsics.checkNotNullParameter((Object)exclusive, (String)"<set-?>");
        this.mutuallyExclusiveParameters = exclusive;
    }

    @NotNull
    public final String getNeo4jUsername() {
        return this.neo4jUsername;
    }

    public final void setNeo4jUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.neo4jUsername = string;
    }

    @NotNull
    public final String getNeo4jPassword() {
        return this.neo4jPassword;
    }

    public final void setNeo4jPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.neo4jPassword = string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPassList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.passClassList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KClass it = (KClass)element$iv$iv;
            boolean bl2 = false;
            if (it.getSimpleName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToNeo4j(@NotNull TranslationResult translationResult) throws InterruptedException, ConnectException {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        Benchmark bench = new Benchmark(this.getClass(), "Push cpg to neo4j", false, (StatisticsHolder)translationResult);
        this.getLog().info("Using import depth: " + this.depth);
        this.getLog().info("Count base nodes to save: " + translationResult.getComponents().size() + translationResult.getAdditionalNodes().size());
        Pair<Session, SessionFactory> sessionAndSessionFactoryPair = this.connect();
        Session session = (Session)sessionAndSessionFactoryPair.getFirst();
        AutoCloseable autoCloseable = (AutoCloseable)session.beginTransaction();
        Throwable throwable = null;
        try {
            Transaction transaction = (Transaction)autoCloseable;
            boolean bl = false;
            if (!this.noPurgeDb) {
                session.purgeDatabase();
            }
            session.save((Object)translationResult.getComponents(), this.depth);
            session.save((Object)translationResult.getAdditionalNodes(), this.depth);
            transaction.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        session.clear();
        ((SessionFactory)sessionAndSessionFactoryPair.getSecond()).close();
        MeasurementHolder.addMeasurement$default((MeasurementHolder)((MeasurementHolder)bench), null, null, (int)3, null);
    }

    @NotNull
    public final Pair<Session, SessionFactory> connect() throws InterruptedException, ConnectException {
        boolean bl;
        String[] stringArray;
        int fails = 0;
        SessionFactory sessionFactory = null;
        Session session = null;
        while (session == null && fails < 10) {
            try {
                Configuration configuration = new Configuration.Builder().uri("bolt://" + this.host + ":" + this.port).autoIndex("none").credentials(this.neo4jUsername, this.neo4jPassword).verifyConnection(Boolean.valueOf(true)).build();
                stringArray = new String[]{"de.fraunhofer.aisec.cpg.graph", "de.fraunhofer.aisec.cpg.frontends"};
                sessionFactory = new SessionFactory(configuration, stringArray);
                sessionFactory.register((EventListener)new AstChildrenEventListener());
                session = sessionFactory.openSession();
            }
            catch (ConnectionException ex) {
                sessionFactory = null;
                ++fails;
                this.getLog().error("Unable to connect to localhost:7687, ensure the database is running and that there is a working network connection to it.");
                Thread.sleep(2000L);
            }
            catch (AuthenticationException ex) {
                this.getLog().error("Unable to connect to localhost:7687, wrong username/password!");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        if (session == null || sessionFactory == null) {
            this.getLog().error("Unable to connect to localhost:7687");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        boolean bl2 = bl = fails <= 10;
        if (_Assertions.ENABLED && !bl) {
            stringArray = "Assertion failed";
            throw new AssertionError(stringArray);
        }
        return new Pair(session, sessionFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getFilesOfList(Collection<String> filenames) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = filenames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get((String)it, new String[0]).toAbsolutePath().normalize().toFile());
        }
        List filePaths = (List)destination$iv$iv;
        Iterable $this$forEach$iv = filePaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.exists() && !it.isHidden()) continue;
            boolean bl2 = false;
            String string = "Please use a correct path. It was: " + it.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        return filePaths;
    }

    private final TranslationConfiguration setupTranslationConfiguration() {
        Object object;
        TranslationConfiguration.Builder translationConfiguration = TranslationConfiguration.Companion.builder().topLevel(this.topLevel).defaultLanguages().optionalLanguage("de.fraunhofer.aisec.cpg.frontends.java.JavaLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.golang.GoLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.python.PythonLanguage").optionalLanguage("de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguage").loadIncludes(this.loadIncludes).addIncludesToGraph(this.loadIncludes).debugParser(true).useUnityBuild(this.useUnityBuild);
        if (!this.getMutuallyExclusiveParameters().getSoftwareComponents().isEmpty()) {
            Map components = new LinkedHashMap();
            for (Map.Entry<String, String> sc : this.getMutuallyExclusiveParameters().getSoftwareComponents().entrySet()) {
                Map map = components;
                object = sc.getKey();
                Object object2 = new String[]{","};
                object2 = this.getFilesOfList(StringsKt.split$default((CharSequence)sc.getValue(), (String[])object2, (boolean)false, (int)0, (int)6, null));
                map.put(object, object2);
            }
            translationConfiguration.softwareComponents(components);
        } else {
            List<File> filePaths = this.getFilesOfList((Collection<String>)this.getMutuallyExclusiveParameters().getFiles());
            translationConfiguration.sourceLocations(filePaths);
        }
        if (!this.noDefaultPasses && Intrinsics.areEqual((Object)this.customPasses, (Object)"DEFAULT")) {
            translationConfiguration.defaultPasses();
        } else if (!this.noDefaultPasses && !Intrinsics.areEqual((Object)this.customPasses, (Object)"DEFAULT")) {
            String[] stringArray = new String[]{","};
            List pieces = StringsKt.split$default((CharSequence)this.customPasses, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String pass : pieces) {
                if (StringsKt.contains$default((CharSequence)pass, (CharSequence)".", (boolean)false, (int)2, null)) {
                    Class<?> clazz = Class.forName(pass);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
                    Intrinsics.checkNotNull((Object)kClass, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<out de.fraunhofer.aisec.cpg.passes.Pass<*>>");
                    translationConfiguration.registerPass(kClass);
                    continue;
                }
                if (!this.passClassMap.containsKey(pass)) {
                    throw new ConfigurationException("Asked to produce unknown pass");
                }
                if (this.passClassMap.get(pass) != null) {
                    KClass<? extends Pass<?>> it;
                    boolean bl = false;
                    translationConfiguration.registerPass(it);
                }
            }
        }
        File file = this.getMutuallyExclusiveParameters().getJsonCompilationDatabase();
        if (file != null) {
            File it = file;
            boolean bl = false;
            CompilationDatabase db = CompilationDatabase.Companion.fromFile(it);
            if (!((Collection)db).isEmpty()) {
                translationConfiguration.useCompilationDatabase(db);
                translationConfiguration.sourceLocations(db.getSourceFiles());
            }
        }
        File file2 = this.includesFile;
        if (file2 != null) {
            File theFile = file2;
            boolean bl = false;
            this.getLog().info("Load includes form file: " + theFile);
            Object object3 = new File(theFile.toString()).getParentFile();
            if (object3 == null || (object3 = ((File)object3).toString()) == null) {
                object3 = "";
            }
            object = object3;
            Intrinsics.checkNotNull((Object)object);
            Object baseDir = object;
            object = new FileInputStream(theFile);
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).lines().map(arg_0 -> Application.setupTranslationConfiguration$lambda$11$lambda$8(setupTranslationConfiguration.3.1.INSTANCE, arg_0)).map(arg_0 -> Application.setupTranslationConfiguration$lambda$11$lambda$9((Function1)new Function1<String, String>((String)baseDir){
                final /* synthetic */ String $baseDir;
                {
                    this.$baseDir = $baseDir;
                    super(1);
                }

                public final String invoke(String it) {
                    String string;
                    if (Paths.get(it, new String[0]).isAbsolute()) {
                        string = it;
                    } else {
                        String[] stringArray = new String[]{it};
                        string = ((Object)Paths.get(this.$baseDir, stringArray)).toString();
                    }
                    return string;
                }
            }, arg_0)).forEach(arg_0 -> Application.setupTranslationConfiguration$lambda$11$lambda$10((Function1)new Function1<String, Unit>(translationConfiguration){
                final /* synthetic */ TranslationConfiguration.Builder $translationConfiguration;
                {
                    this.$translationConfiguration = $translationConfiguration;
                    super(1);
                }

                public final void invoke(String it) {
                    Intrinsics.checkNotNull((Object)it);
                    this.$translationConfiguration.includePath(it);
                }
            }, arg_0));
        }
        if (this.inferNodes) {
            translationConfiguration.inferenceConfiguration(InferenceConfiguration.Companion.builder().inferRecords(true).build());
        }
        return translationConfiguration.build();
    }

    @Override
    @NotNull
    public Integer call() throws Exception, ConnectException, IllegalArgumentException {
        block4: {
            if (this.getMutuallyExclusiveParameters().getListPasses()) {
                this.getLog().info("List of passes:");
                Iterator<String> $this$forEach$iv = this.getPassList().iterator();
                boolean $i$f$forEach = false;
                Iterator<String> iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    String element$iv;
                    String it = element$iv = iterator.next();
                    boolean bl = false;
                    this.getLog().info("- " + it);
                }
                this.getLog().info("--");
                this.getLog().info("End of list. Stopping.");
                return 0;
            }
            TranslationConfiguration translationConfiguration = this.setupTranslationConfiguration();
            long startTime = System.currentTimeMillis();
            TranslationResult translationResult = (TranslationResult)TranslationManager.Companion.builder().config(translationConfiguration).build().analyze().get();
            long analyzingTime = System.currentTimeMillis();
            this.getLog().info("Benchmark: analyzing code in " + (analyzingTime - startTime) / (long)1000 + " s.");
            if (!this.noNeo4j) {
                Intrinsics.checkNotNull((Object)translationResult);
                this.pushToNeo4j(translationResult);
            }
            long pushTime = System.currentTimeMillis();
            this.getLog().info("Benchmark: push code in " + (pushTime - analyzingTime) / (long)1000 + " s.");
            BenchmarkResults benchmarkResult = translationResult.getBenchmarkResults();
            if (this.printBenchmark) {
                benchmarkResult.print();
            }
            File file = this.benchmarkJson;
            if (file == null) break block4;
            File theFile = file;
            boolean bl = false;
            this.getLog().info("Save benchmark results to file: " + theFile);
            FilesKt.writeText$default((File)theFile, (String)benchmarkResult.getJson(), null, (int)2, null);
        }
        return 0;
    }

    private static final String setupTranslationConfiguration$lambda$11$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String setupTranslationConfiguration$lambda$11$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void setupTranslationConfiguration$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "", "()V", "files", "", "", "getFiles", "()Ljava/util/List;", "setFiles", "(Ljava/util/List;)V", "jsonCompilationDatabase", "Ljava/io/File;", "getJsonCompilationDatabase", "()Ljava/io/File;", "setJsonCompilationDatabase", "(Ljava/io/File;)V", "listPasses", "", "getListPasses", "()Z", "setListPasses", "(Z)V", "softwareComponents", "", "getSoftwareComponents", "()Ljava/util/Map;", "setSoftwareComponents", "(Ljava/util/Map;)V", "cpg-neo4j"})
    public static final class Exclusive {
        @CommandLine.Parameters(description={"The paths to analyze. If module support is enabled, the paths will be looked at if they contain modules"}, arity="0..*")
        @NotNull
        private List<String> files = new ArrayList();
        @CommandLine.Option(names={"--softwareComponents", "-S"}, description={"Maps the names of software components to their respective files. The files are separated by commas (No whitespace!).", "Example: -S App1=./file1.c,./file2.c -S App2=./Main.java,./Class.java"})
        @NotNull
        private Map<String, String> softwareComponents = new LinkedHashMap();
        @CommandLine.Option(names={"--json-compilation-database"}, description={"The path to an optional a JSON compilation database"})
        @Nullable
        private File jsonCompilationDatabase;
        @CommandLine.Option(names={"--list-passes"}, description={"Prints the list available passes"})
        private boolean listPasses;

        @NotNull
        public final List<String> getFiles() {
            return this.files;
        }

        public final void setFiles(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.files = list;
        }

        @NotNull
        public final Map<String, String> getSoftwareComponents() {
            return this.softwareComponents;
        }

        public final void setSoftwareComponents(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.softwareComponents = map;
        }

        @Nullable
        public final File getJsonCompilationDatabase() {
            return this.jsonCompilationDatabase;
        }

        public final void setJsonCompilationDatabase(@Nullable File file) {
            this.jsonCompilationDatabase = file;
        }

        public final boolean getListPasses() {
            return this.listPasses;
        }

        public final void setListPasses(boolean bl) {
            this.listPasses = bl;
        }
    }
}

