/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg_vis_neo4j;

import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.python.PythonLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.BenchmarkResults;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010(\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\f01H\u0002J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\b\u00106\u001a\u000207H\u0002R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0012\u0010\"\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application;", "Ljava/util/concurrent/Callable;", "", "()V", "benchmarkJson", "Ljava/io/File;", "depth", "enableExperimentalGo", "", "enableExperimentalPython", "enableExperimentalTypeScript", "host", "", "includesFile", "inferNodes", "loadIncludes", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mutuallyExclusiveParameters", "Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "getMutuallyExclusiveParameters", "()Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "setMutuallyExclusiveParameters", "(Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;)V", "neo4jPassword", "getNeo4jPassword", "()Ljava/lang/String;", "setNeo4jPassword", "(Ljava/lang/String;)V", "neo4jUsername", "getNeo4jUsername", "setNeo4jUsername", "noDefaultPasses", "noNeo4j", "noPurgeDb", "port", "printBenchmark", "topLevel", "call", "()Ljava/lang/Integer;", "connect", "Lkotlin/Pair;", "Lorg/neo4j/ogm/session/Session;", "Lorg/neo4j/ogm/session/SessionFactory;", "getFilesOfList", "", "filenames", "", "pushToNeo4j", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "setupTranslationConfiguration", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "Exclusive", "cpg-neo4j"})
public final class Application
implements Callable<Integer> {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    public Exclusive mutuallyExclusiveParameters;
    @CommandLine.Option(names={"--user"}, description={"Neo4j user name (default: neo4j)"})
    @NotNull
    private String neo4jUsername = "neo4j";
    @CommandLine.Option(names={"--password"}, description={"Neo4j password (default: password"})
    @NotNull
    private String neo4jPassword = "password";
    @CommandLine.Option(names={"--host"}, description={"Set the host of the neo4j Database (default: localhost)."})
    @NotNull
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, description={"Set the port of the neo4j Database (default: 7687)."})
    private int port = 7687;
    @CommandLine.Option(names={"--save-depth"}, description={"Performance optimisation: Limit recursion depth form neo4j OGM when leaving the AST. -1 (default) means no limit is used."})
    private int depth = -1;
    @CommandLine.Option(names={"--load-includes"}, description={"Enable TranslationConfiguration option loadIncludes"})
    private boolean loadIncludes;
    @CommandLine.Option(names={"--includes-file"}, description={"Load includes from file"})
    @Nullable
    private File includesFile;
    @CommandLine.Option(names={"--enable-experimental-python"}, description={"Enables the experimental language frontend for Python. Be aware, that further steps might be necessary to install native libraries such as jep"})
    private boolean enableExperimentalPython;
    @CommandLine.Option(names={"--enable-experimental-go"}, description={"Enables the experimental language frontend for Go. Be aware, that further steps might be necessary to install native libraries such as cpgo"})
    private boolean enableExperimentalGo;
    @CommandLine.Option(names={"--enable-experimental-typescript"}, description={"Enables the experimental language frontend for TypeScript."})
    private boolean enableExperimentalTypeScript;
    @CommandLine.Option(names={"--print-benchmark"}, description={"Print benchmark result as markdown table"})
    private boolean printBenchmark;
    @CommandLine.Option(names={"--no-default-passes"}, description={"Do not register default passes [used for debugging]"})
    private boolean noDefaultPasses;
    @CommandLine.Option(names={"--no-neo4j"}, description={"Do not push cpg into neo4j [used for debugging]"})
    private boolean noNeo4j;
    @CommandLine.Option(names={"--no-purge-db"}, description={"Do no purge neo4j database before pushing the cpg"})
    private boolean noPurgeDb;
    @CommandLine.Option(names={"--infer-nodes"}, description={"Create inferred nodes for missing declarations"})
    private boolean inferNodes;
    @CommandLine.Option(names={"--top-level"}, description={"Set top level directory of project structure. Default: Largest common path of all source files"})
    @Nullable
    private File topLevel;
    @CommandLine.Option(names={"--benchmark-json"}, description={"Save benchmark results to json file"})
    @Nullable
    private File benchmarkJson;

    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(Application.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Application::class.java)");
        return logger;
    }

    @NotNull
    public final Exclusive getMutuallyExclusiveParameters() {
        Exclusive exclusive = this.mutuallyExclusiveParameters;
        if (exclusive != null) {
            return exclusive;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mutuallyExclusiveParameters");
        return null;
    }

    public final void setMutuallyExclusiveParameters(@NotNull Exclusive exclusive) {
        Intrinsics.checkNotNullParameter((Object)exclusive, (String)"<set-?>");
        this.mutuallyExclusiveParameters = exclusive;
    }

    @NotNull
    public final String getNeo4jUsername() {
        return this.neo4jUsername;
    }

    public final void setNeo4jUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.neo4jUsername = string;
    }

    @NotNull
    public final String getNeo4jPassword() {
        return this.neo4jPassword;
    }

    public final void setNeo4jPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.neo4jPassword = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToNeo4j(@NotNull TranslationResult translationResult) throws InterruptedException, ConnectException {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        Benchmark bench = new Benchmark(this.getClass(), "Push cpg to neo4j", false, (StatisticsHolder)translationResult);
        this.getLog().info("Using import depth: " + this.depth);
        this.getLog().info("Count base nodes to save: " + translationResult.getComponents().size() + translationResult.getAdditionalNodes().size());
        Pair<Session, SessionFactory> sessionAndSessionFactoryPair = this.connect();
        Session session = (Session)sessionAndSessionFactoryPair.getFirst();
        AutoCloseable autoCloseable = (AutoCloseable)session.beginTransaction();
        Throwable throwable = null;
        try {
            Transaction transaction = (Transaction)autoCloseable;
            boolean bl = false;
            if (!this.noPurgeDb) {
                session.purgeDatabase();
            }
            session.save((Object)translationResult.getComponents(), this.depth);
            session.save((Object)translationResult.getAdditionalNodes(), this.depth);
            transaction.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        session.clear();
        ((SessionFactory)sessionAndSessionFactoryPair.getSecond()).close();
        MeasurementHolder.addMeasurement$default((MeasurementHolder)((MeasurementHolder)bench), null, null, (int)3, null);
    }

    @NotNull
    public final Pair<Session, SessionFactory> connect() throws InterruptedException, ConnectException {
        boolean bl;
        String[] stringArray;
        int fails = 0;
        SessionFactory sessionFactory = null;
        Session session = null;
        while (session == null && fails < 10) {
            try {
                Configuration configuration = new Configuration.Builder().uri("bolt://" + this.host + ":" + this.port).autoIndex("none").credentials(this.neo4jUsername, this.neo4jPassword).verifyConnection(Boolean.valueOf(true)).build();
                stringArray = new String[]{"de.fraunhofer.aisec.cpg.graph"};
                sessionFactory = new SessionFactory(configuration, stringArray);
                session = sessionFactory.openSession();
            }
            catch (ConnectionException ex) {
                sessionFactory = null;
                ++fails;
                this.getLog().error("Unable to connect to localhost:7687, ensure the database is running and that there is a working network connection to it.");
                Thread.sleep(2000L);
            }
            catch (AuthenticationException ex) {
                this.getLog().error("Unable to connect to localhost:7687, wrong username/password!");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        if (session == null || sessionFactory == null) {
            this.getLog().error("Unable to connect to localhost:7687");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        boolean bl2 = bl = fails <= 10;
        if (_Assertions.ENABLED && !bl) {
            stringArray = "Assertion failed";
            throw new AssertionError(stringArray);
        }
        return new Pair(session, sessionFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getFilesOfList(Collection<String> filenames) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = filenames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Paths.get((String)it, new String[0]).toAbsolutePath().normalize().toFile());
        }
        List filePaths = (List)destination$iv$iv;
        Iterable $this$forEach$iv = filePaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.exists() && !it.isHidden()) continue;
            boolean bl2 = false;
            String string = "Please use a correct path. It was: " + it.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        return filePaths;
    }

    private final TranslationConfiguration setupTranslationConfiguration() {
        Object object;
        TranslationConfiguration.Builder translationConfiguration = TranslationConfiguration.builder().topLevel(this.topLevel).defaultLanguages().loadIncludes(this.loadIncludes).debugParser(true);
        if (!this.getMutuallyExclusiveParameters().getSoftwareComponents().isEmpty()) {
            Map components = new LinkedHashMap();
            for (Map.Entry<String, String> sc : this.getMutuallyExclusiveParameters().getSoftwareComponents().entrySet()) {
                Map map = components;
                String string = sc.getKey();
                object = new String[]{","};
                object = this.getFilesOfList(StringsKt.split$default((CharSequence)sc.getValue(), (String[])object, (boolean)false, (int)0, (int)6, null));
                map.put(string, object);
            }
            translationConfiguration.softwareComponents(components);
        } else {
            List<File> filePaths = this.getFilesOfList((Collection<String>)this.getMutuallyExclusiveParameters().getFiles());
            translationConfiguration.sourceLocations(filePaths);
        }
        if (!this.noDefaultPasses) {
            translationConfiguration.defaultPasses();
        }
        if (this.getMutuallyExclusiveParameters().getJsonCompilationDatabase() != null) {
            File file = this.getMutuallyExclusiveParameters().getJsonCompilationDatabase();
            Intrinsics.checkNotNull((Object)file);
            CompilationDatabase db = CompilationDatabase.Companion.fromFile(file);
            if (!((Collection)db).isEmpty()) {
                translationConfiguration.useCompilationDatabase(db);
                translationConfiguration.sourceLocations(db.getSourceFiles());
            }
        }
        translationConfiguration.registerLanguage(LLVMIRLanguageFrontend.class, LLVMIRLanguageFrontend.LLVM_EXTENSIONS);
        if (this.enableExperimentalPython) {
            translationConfiguration.registerLanguage(PythonLanguageFrontend.class, PythonLanguageFrontend.PY_EXTENSIONS);
        }
        if (this.enableExperimentalGo) {
            translationConfiguration.registerLanguage(GoLanguageFrontend.class, GoLanguageFrontend.GOLANG_EXTENSIONS);
        }
        if (this.enableExperimentalTypeScript) {
            translationConfiguration.registerLanguage(TypeScriptLanguageFrontend.class, CollectionsKt.plus((Collection)TypeScriptLanguageFrontend.TYPESCRIPT_EXTENSIONS, (Iterable)TypeScriptLanguageFrontend.JAVASCRIPT_EXTENSIONS));
        }
        File file = this.includesFile;
        if (file != null) {
            File theFile = file;
            boolean bl = false;
            this.getLog().info("Load includes form file: " + theFile);
            Object object2 = new File(theFile.toString()).getParentFile();
            if (object2 == null || (object2 = ((File)object2).toString()) == null) {
                object2 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"File(theFile.toString())\u2026entFile?.toString() ?: \"\"");
            Object baseDir = object2;
            object = new FileInputStream(theFile);
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).lines().map(Application::setupTranslationConfiguration$lambda-6$trim__proxy).map(arg_0 -> Application.setupTranslationConfiguration$lambda-6$lambda-4((String)baseDir, arg_0)).forEach(arg_0 -> Application.setupTranslationConfiguration$lambda-6$lambda-5(translationConfiguration, arg_0));
        }
        if (this.inferNodes) {
            translationConfiguration.inferenceConfiguration(InferenceConfiguration.Companion.builder().inferRecords(true).build());
        }
        TranslationConfiguration translationConfiguration2 = translationConfiguration.build();
        Intrinsics.checkNotNullExpressionValue((Object)translationConfiguration2, (String)"translationConfiguration.build()");
        return translationConfiguration2;
    }

    @Override
    @NotNull
    public Integer call() throws Exception, ConnectException, IllegalArgumentException {
        block2: {
            TranslationConfiguration translationConfiguration = this.setupTranslationConfiguration();
            long startTime = System.currentTimeMillis();
            TranslationResult translationResult = (TranslationResult)TranslationManager.Companion.builder().config(translationConfiguration).build().analyze().get();
            long analyzingTime = System.currentTimeMillis();
            this.getLog().info("Benchmark: analyzing code in " + (analyzingTime - startTime) / (long)1000 + " s.");
            if (!this.noNeo4j) {
                Intrinsics.checkNotNullExpressionValue((Object)translationResult, (String)"translationResult");
                this.pushToNeo4j(translationResult);
            }
            long pushTime = System.currentTimeMillis();
            this.getLog().info("Benchmark: push code in " + (pushTime - analyzingTime) / (long)1000 + " s.");
            BenchmarkResults benchmarkResults = translationResult.getBenchmarkResults();
            Intrinsics.checkNotNullExpressionValue((Object)benchmarkResults, (String)"translationResult.benchmarkResults");
            BenchmarkResults benchmarkResult = benchmarkResults;
            if (this.printBenchmark) {
                benchmarkResult.print();
            }
            File file = this.benchmarkJson;
            if (file == null) break block2;
            File theFile = file;
            boolean bl = false;
            this.getLog().info("Save benchmark results to file: " + theFile);
            FilesKt.writeText$default((File)theFile, (String)benchmarkResult.getJson(), null, (int)2, null);
        }
        return 0;
    }

    private static final String setupTranslationConfiguration$lambda-6$trim__proxy(String string) {
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final String setupTranslationConfiguration$lambda-6$lambda-4(String $baseDir, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        if (Paths.get(it, new String[0]).isAbsolute()) {
            string = it;
        } else {
            String[] stringArray = new String[]{it};
            string = ((Object)Paths.get($baseDir, stringArray)).toString();
        }
        return string;
    }

    private static final void setupTranslationConfiguration$lambda-6$lambda-5(TranslationConfiguration.Builder $translationConfiguration, String it) {
        $translationConfiguration.includePath(it);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "", "()V", "files", "", "", "getFiles", "()Ljava/util/List;", "setFiles", "(Ljava/util/List;)V", "jsonCompilationDatabase", "Ljava/io/File;", "getJsonCompilationDatabase", "()Ljava/io/File;", "setJsonCompilationDatabase", "(Ljava/io/File;)V", "softwareComponents", "", "getSoftwareComponents", "()Ljava/util/Map;", "setSoftwareComponents", "(Ljava/util/Map;)V", "cpg-neo4j"})
    public static final class Exclusive {
        @CommandLine.Parameters(description={"The paths to analyze. If module support is enabled, the paths will be looked at if they contain modules"}, arity="0..*")
        @NotNull
        private List<String> files = new ArrayList();
        @CommandLine.Option(names={"--softwareComponents", "-S"}, description={"Maps the names of software components to their respective files. The files are separated by commas (No whitespace!).", "Example: -S App1=./file1.c,./file2.c -S App2=./Main.java,./Class.java"})
        @NotNull
        private Map<String, String> softwareComponents = new LinkedHashMap();
        @CommandLine.Option(names={"--json-compilation-database"}, description={"The path to an optional a JSON compilation database"})
        @Nullable
        private File jsonCompilationDatabase;

        @NotNull
        public final List<String> getFiles() {
            return this.files;
        }

        public final void setFiles(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.files = list;
        }

        @NotNull
        public final Map<String, String> getSoftwareComponents() {
            return this.softwareComponents;
        }

        public final void setSoftwareComponents(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.softwareComponents = map;
        }

        @Nullable
        public final File getJsonCompilationDatabase() {
            return this.jsonCompilationDatabase;
        }

        public final void setJsonCompilationDatabase(@Nullable File file) {
            this.jsonCompilationDatabase = file;
        }
    }
}

