/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg_vis_neo4j;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.python.PythonLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg_vis_neo4j.Application;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002'(B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020&H\u0002R\u0012\u0010\u0004\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application;", "Ljava/util/concurrent/Callable;", "", "()V", "depth", "enableExperimentalGo", "", "enableExperimentalPython", "enableExperimentalTypeScript", "host", "", "includesFile", "Ljava/io/File;", "loadIncludes", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mutuallyExclusiveParameters", "Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "getMutuallyExclusiveParameters", "()Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "setMutuallyExclusiveParameters", "(Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;)V", "neo4jPassword", "neo4jUsername", "port", "call", "()Ljava/lang/Integer;", "connect", "Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Pair;", "Lorg/neo4j/ogm/session/Session;", "Lorg/neo4j/ogm/session/SessionFactory;", "pushToNeo4j", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "setupTranslationConfiguration", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "Exclusive", "Pair", "cpg-neo4j"})
public final class Application
implements Callable<Integer> {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    public Exclusive mutuallyExclusiveParameters;
    @CommandLine.Option(names={"--user"}, description={"Neo4j user name (default: neo4j)"})
    @NotNull
    private String neo4jUsername = "neo4j";
    @CommandLine.Option(names={"--password"}, description={"Neo4j password (default: password"})
    @NotNull
    private String neo4jPassword = "password";
    @CommandLine.Option(names={"--host"}, description={"Set the host of the neo4j Database (default: localhost)."})
    @NotNull
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, description={"Set the port of the neo4j Database (default: 7687)."})
    private int port = 7687;
    @CommandLine.Option(names={"--save-depth"}, description={"Performance optimisation: Limit recursion depth form neo4j OGM when leaving the AST. -1 (default) means no limit is used."})
    private int depth = -1;
    @CommandLine.Option(names={"--load-includes"}, description={"Enable TranslationConfiguration option loadIncludes"})
    private boolean loadIncludes;
    @CommandLine.Option(names={"--includes-file"}, description={"Load includes from file"})
    @Nullable
    private File includesFile;
    @CommandLine.Option(names={"--enable-experimental-python"}, description={"Enables the experimental language frontend for Python. Be aware, that further steps might be necessary to install native libraries such as jep"})
    private boolean enableExperimentalPython;
    @CommandLine.Option(names={"--enable-experimental-go"}, description={"Enables the experimental language frontend for Go. Be aware, that further steps might be necessary to install native libraries such as cpgo"})
    private boolean enableExperimentalGo;
    @CommandLine.Option(names={"--enable-experimental-typescript"}, description={"Enables the experimental language frontend for TypeScript."})
    private boolean enableExperimentalTypeScript;

    private final Logger getLog() {
        Logger logger = LoggerFactory.getLogger(Application.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Application::class.java)");
        return logger;
    }

    @NotNull
    public final Exclusive getMutuallyExclusiveParameters() {
        Exclusive exclusive = this.mutuallyExclusiveParameters;
        if (exclusive != null) {
            return exclusive;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mutuallyExclusiveParameters");
        return null;
    }

    public final void setMutuallyExclusiveParameters(@NotNull Exclusive exclusive) {
        Intrinsics.checkNotNullParameter((Object)exclusive, (String)"<set-?>");
        this.mutuallyExclusiveParameters = exclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToNeo4j(@NotNull TranslationResult translationResult) throws InterruptedException, ConnectException {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        this.getLog().info(Intrinsics.stringPlus((String)"Using import depth: ", (Object)this.depth));
        this.getLog().info("Count base nodes to save: " + translationResult.getTranslationUnits().size() + translationResult.getAdditionalNodes().size());
        Pair<Session, SessionFactory> sessionAndSessionFactoryPair = this.connect();
        Session session = sessionAndSessionFactoryPair.getFirst();
        AutoCloseable autoCloseable = (AutoCloseable)session.beginTransaction();
        Throwable throwable = null;
        try {
            Transaction transaction = (Transaction)autoCloseable;
            boolean bl = false;
            session.purgeDatabase();
            session.save((Object)translationResult.getTranslationUnits(), this.depth);
            session.save((Object)translationResult.getAdditionalNodes(), this.depth);
            transaction.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        session.clear();
        sessionAndSessionFactoryPair.getSecond().close();
    }

    @NotNull
    public final Pair<Session, SessionFactory> connect() throws InterruptedException, ConnectException {
        boolean bl;
        String[] stringArray;
        int fails = 0;
        SessionFactory sessionFactory = null;
        Session session = null;
        while (session == null && fails < 10) {
            try {
                Configuration configuration = new Configuration.Builder().uri("bolt://" + this.host + ':' + this.port).autoIndex("none").credentials(this.neo4jUsername, this.neo4jPassword).verifyConnection(Boolean.valueOf(true)).build();
                stringArray = new String[]{"de.fraunhofer.aisec.cpg.graph"};
                sessionFactory = new SessionFactory(configuration, stringArray);
                session = sessionFactory.openSession();
            }
            catch (ConnectionException ex) {
                sessionFactory = null;
                int n = fails;
                fails = n + 1;
                this.getLog().error("Unable to connect to localhost:7687, ensure the database is running and that there is a working network connection to it.");
                Thread.sleep(2000L);
            }
            catch (AuthenticationException ex) {
                this.getLog().error("Unable to connect to localhost:7687, wrong username/password!");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        if (session == null || sessionFactory == null) {
            this.getLog().error("Unable to connect to localhost:7687");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        boolean bl2 = bl = fails <= 10;
        if (_Assertions.ENABLED && !bl) {
            stringArray = "Assertion failed";
            throw new AssertionError(stringArray);
        }
        return new Pair<Object, Object>(session, sessionFactory);
    }

    private final TranslationConfiguration setupTranslationConfiguration() {
        boolean bl;
        boolean bl2 = bl = !(this.getMutuallyExclusiveParameters().getFiles().length == 0);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        File[] filePaths = new File[this.getMutuallyExclusiveParameters().getFiles().length];
        File topLevel = null;
        int n = 0;
        int n2 = this.getMutuallyExclusiveParameters().getFiles().length;
        while (n < n2) {
            File currentTopLevel;
            int index = n++;
            Path path = Paths.get(this.getMutuallyExclusiveParameters().getFiles()[index], new String[0]).toAbsolutePath().normalize();
            File file = new File(((Object)path).toString());
            if (!(file.exists() && !file.isHidden())) {
                boolean bl3 = false;
                String string = Intrinsics.stringPlus((String)"Please use a correct path. It was: ", (Object)path);
                throw new IllegalArgumentException(string.toString());
            }
            File file2 = currentTopLevel = file.isDirectory() ? file : file.getParentFile();
            if (topLevel == null) {
                topLevel = currentTopLevel;
            }
            if (!Intrinsics.areEqual((Object)String.valueOf(topLevel), (Object)currentTopLevel.toString())) {
                boolean bl4 = false;
                String string = "All files should have the same top level path.";
                throw new IllegalArgumentException(string.toString());
            }
            filePaths[index] = file;
        }
        TranslationConfiguration.Builder translationConfiguration = TranslationConfiguration.builder().sourceLocations(Arrays.copyOf(filePaths, filePaths.length)).topLevel(topLevel).defaultPasses().defaultLanguages().loadIncludes(this.loadIncludes).debugParser(true);
        if (this.getMutuallyExclusiveParameters().getJsonCompilationDatabase() != null) {
            File file = this.getMutuallyExclusiveParameters().getJsonCompilationDatabase();
            Intrinsics.checkNotNull((Object)file);
            CompilationDatabase db = CompilationDatabase.Companion.fromFile(file);
            if (!((Collection)db).isEmpty()) {
                translationConfiguration.useCompilationDatabase(db);
                translationConfiguration.sourceLocations(db.getSourceFiles());
            }
        }
        translationConfiguration.registerLanguage(LLVMIRLanguageFrontend.class, LLVMIRLanguageFrontend.LLVM_EXTENSIONS);
        if (this.enableExperimentalPython) {
            translationConfiguration.registerLanguage(PythonLanguageFrontend.class, PythonLanguageFrontend.PY_EXTENSIONS);
        }
        if (this.enableExperimentalGo) {
            translationConfiguration.registerLanguage(GoLanguageFrontend.class, GoLanguageFrontend.GOLANG_EXTENSIONS);
        }
        if (this.enableExperimentalTypeScript) {
            translationConfiguration.registerLanguage(TypeScriptLanguageFrontend.class, CollectionsKt.plus((Collection)TypeScriptLanguageFrontend.TYPESCRIPT_EXTENSIONS, (Iterable)TypeScriptLanguageFrontend.JAVASCRIPT_EXTENSIONS));
        }
        File file = this.includesFile;
        if (file != null) {
            String string;
            File theFile = file;
            boolean bl5 = false;
            this.getLog().info(Intrinsics.stringPlus((String)"Load includes form file: ", (Object)theFile));
            File file3 = new File(theFile.toString()).getParentFile();
            if (file3 == null) {
                string = "";
            } else {
                string = file3.toString();
                if (string == null) {
                    string = "";
                }
            }
            String baseDir = string;
            InputStream inputStream = new FileInputStream(theFile);
            Charset charset = Charsets.UTF_8;
            Closeable closeable = inputStream;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            int n3 = 8192;
            (closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n3)).lines().map(setupTranslationConfiguration.3.1.INSTANCE).map(arg_0 -> Application.setupTranslationConfiguration$lambda-5$lambda-3(baseDir, arg_0)).forEach(arg_0 -> Application.setupTranslationConfiguration$lambda-5$lambda-4(translationConfiguration, arg_0));
        }
        TranslationConfiguration translationConfiguration2 = translationConfiguration.build();
        Intrinsics.checkNotNullExpressionValue((Object)translationConfiguration2, (String)"translationConfiguration.build()");
        return translationConfiguration2;
    }

    @Override
    @NotNull
    public Integer call() throws Exception, ConnectException, IllegalArgumentException {
        TranslationConfiguration translationConfiguration = this.setupTranslationConfiguration();
        long startTime = System.currentTimeMillis();
        TranslationResult translationResult = (TranslationResult)TranslationManager.Companion.builder().config(translationConfiguration).build().analyze().get();
        long analyzingTime = System.currentTimeMillis();
        this.getLog().info("Benchmark: analyzing code in " + (analyzingTime - startTime) / (long)1000 + " s.");
        Intrinsics.checkNotNullExpressionValue((Object)translationResult, (String)"translationResult");
        this.pushToNeo4j(translationResult);
        long pushTime = System.currentTimeMillis();
        this.getLog().info("Benchmark: push code in " + (pushTime - analyzingTime) / (long)1000 + " s.");
        return 0;
    }

    private static final String setupTranslationConfiguration$lambda-5$lambda-3(String $baseDir, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        if (Paths.get(it, new String[0]).isAbsolute()) {
            string = it;
        } else {
            String[] stringArray = new String[]{it};
            string = ((Object)Paths.get($baseDir, stringArray)).toString();
        }
        return string;
    }

    private static final void setupTranslationConfiguration$lambda-5$lambda-4(TranslationConfiguration.Builder $translationConfiguration, String it) {
        $translationConfiguration.includePath(it);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Exclusive;", "", "()V", "files", "", "", "getFiles", "()[Ljava/lang/String;", "setFiles", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "jsonCompilationDatabase", "Ljava/io/File;", "getJsonCompilationDatabase", "()Ljava/io/File;", "setJsonCompilationDatabase", "(Ljava/io/File;)V", "cpg-neo4j"})
    public static final class Exclusive {
        @CommandLine.Parameters(description={"The paths to analyze. If module support is enabled, the paths will be looked at if they contain modules"}, arity="1..*")
        @NotNull
        private String[] files;
        @CommandLine.Option(names={"--json-compilation-database"}, description={"The path to an optional a JSON compilation database"})
        @Nullable
        private File jsonCompilationDatabase;

        public Exclusive() {
            boolean $i$f$emptyArray = false;
            this.files = new String[0];
        }

        @NotNull
        public final String[] getFiles() {
            return this.files;
        }

        public final void setFiles(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
            this.files = stringArray;
        }

        @Nullable
        public final File getJsonCompilationDatabase() {
            return this.jsonCompilationDatabase;
        }

        public final void setJsonCompilationDatabase(@Nullable File file) {
            this.jsonCompilationDatabase = file;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/fraunhofer/aisec/cpg_vis_neo4j/Application$Pair;", "T", "U", "", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFirst", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSecond", "cpg-neo4j"})
    public static final class Pair<T, U> {
        private final T first;
        private final U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public final T getFirst() {
            return this.first;
        }

        public final U getSecond() {
            return this.second;
        }
    }
}

