/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.ruby;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.ruby.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.ruby.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.ruby.RubyLanguage;
import de.fraunhofer.aisec.cpg.frontends.ruby.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jruby.Ruby;
import org.jruby.ast.BlockNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/ruby/RubyLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lorg/jruby/ast/Node;", "language", "Lde/fraunhofer/aisec/cpg/frontends/ruby/RubyLanguage;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "<init>", "(Lde/fraunhofer/aisec/cpg/frontends/ruby/RubyLanguage;Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "declarationHandler", "Lde/fraunhofer/aisec/cpg/frontends/ruby/DeclarationHandler;", "getDeclarationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/ruby/DeclarationHandler;", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/ruby/ExpressionHandler;", "getExpressionHandler", "()Lde/fraunhofer/aisec/cpg/frontends/ruby/ExpressionHandler;", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/ruby/StatementHandler;", "getStatementHandler", "()Lde/fraunhofer/aisec/cpg/frontends/ruby/StatementHandler;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "handleRootNode", "node", "Lorg/jruby/ast/RootNode;", "codeOf", "", "astNode", "locationOf", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "typeOf", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "type", "setComment", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "cpg-language-ruby"})
public final class RubyLanguageFrontend
extends LanguageFrontend<Node, Node> {
    @NotNull
    private final DeclarationHandler declarationHandler;
    @NotNull
    private final ExpressionHandler expressionHandler;
    @NotNull
    private final StatementHandler statementHandler;

    public RubyLanguageFrontend(@NotNull RubyLanguage language, @NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super((Language)language, ctx);
        this.declarationHandler = new DeclarationHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
        this.statementHandler = new StatementHandler(this);
    }

    @NotNull
    public final DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    @NotNull
    public final StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Ruby ruby = Ruby.getGlobalRuntime();
        Parser parser = new Parser(ruby);
        Node node = parser.parse(file.getPath(), (InputStream)new FileInputStream(file), null, new ParserConfiguration(ruby, 0, false, true, false));
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.jruby.ast.RootNode");
        RootNode node2 = (RootNode)node;
        return this.handleRootNode(node2);
    }

    private final TranslationUnitDeclaration handleRootNode(RootNode node) {
        TranslationUnitDeclaration tu = DeclarationBuilderKt.newTranslationUnitDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)node.getFile(), (Object)node);
        this.getScopeManager().resetToGlobal(tu);
        if (node.getBodyNode() instanceof MethodDefNode) {
            Node node2 = node.getBodyNode();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getBodyNode(...)");
            Declaration decl = (Declaration)this.declarationHandler.handle(node2);
            ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)decl, (boolean)false, (int)2, null);
        } else if (node.getBodyNode() instanceof BlockNode) {
            Node node3 = node.getBodyNode();
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type org.jruby.ast.BlockNode");
            BlockNode block = (BlockNode)node3;
            for (Node innerNode : CollectionsKt.filterNotNull((Iterable)((Iterable)block))) {
                if (innerNode instanceof MethodDefNode) {
                    Declaration decl = (Declaration)this.declarationHandler.handle(innerNode);
                    ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)decl, (boolean)false, (int)2, null);
                    continue;
                }
                Statement stmt = (Statement)this.statementHandler.handle(innerNode);
                tu.plusAssign(stmt);
            }
        }
        return tu;
    }

    @Nullable
    public String codeOf(@NotNull Node astNode) {
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        return "";
    }

    @Nullable
    public PhysicalLocation locationOf(@NotNull Node astNode) {
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        return null;
    }

    @NotNull
    public Type typeOf(@NotNull Node type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return TypeBuilderKt.autoType((LanguageProvider)((LanguageProvider)this));
    }

    public void setComment(@NotNull de.fraunhofer.aisec.cpg.graph.Node node, @NotNull Node astNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
    }
}

