/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.ruby;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.ruby.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.ruby.RubyHandler;
import de.fraunhofer.aisec.cpg.frontends.ruby.RubyLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.ruby.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.RawNodeTypeProvider;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.AssignExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.LambdaExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.OperatorCallNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\t\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001d2\u0006\u0010\t\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001d2\u0006\u0010\t\u001a\u00020%H\u0002\u00a8\u0006&"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/ruby/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/ruby/RubyHandler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lorg/jruby/ast/Node;", "lang", "Lde/fraunhofer/aisec/cpg/frontends/ruby/RubyLanguageFrontend;", "<init>", "(Lde/fraunhofer/aisec/cpg/frontends/ruby/RubyLanguageFrontend;)V", "handleNode", "node", "handleOperatorCallNode", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "Lorg/jruby/ast/visitor/OperatorCallNode;", "handleINameNode", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Reference;", "Lorg/jruby/ast/types/INameNode;", "handleIterNode", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/LambdaExpression;", "Lorg/jruby/ast/IterNode;", "handleDAsgnNode", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/AssignExpression;", "Lorg/jruby/ast/DAsgnNode;", "handleLocalAsgnNode", "Lorg/jruby/ast/LocalAsgnNode;", "handleCallNode", "Lorg/jruby/ast/CallNode;", "handleFCallNode", "Lorg/jruby/ast/FCallNode;", "handleStrNode", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "", "Lorg/jruby/ast/StrNode;", "handleFixnumNode", "", "Lorg/jruby/ast/FixnumNode;", "handleFloatNode", "", "Lorg/jruby/ast/FloatNode;", "cpg-language-ruby"})
@SourceDebugExtension(value={"SMAP\nExpressionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionHandler.kt\nde/fraunhofer/aisec/cpg/frontends/ruby/ExpressionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class ExpressionHandler
extends RubyHandler<Expression, Node> {
    public ExpressionHandler(@NotNull RubyLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(ExpressionHandler::_init_$lambda$0, lang);
    }

    @Override
    @NotNull
    public Expression handleNode(@NotNull Node node) {
        Expression expression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node node2 = node;
        if (node2 instanceof OperatorCallNode) {
            expression = (Expression)this.handleOperatorCallNode((OperatorCallNode)node);
        } else if (node2 instanceof CallNode) {
            expression = this.handleCallNode((CallNode)node);
        } else if (node2 instanceof FCallNode) {
            expression = this.handleFCallNode((FCallNode)node);
        } else if (node2 instanceof IterNode) {
            expression = (Expression)this.handleIterNode((IterNode)node);
        } else if (node2 instanceof StrNode) {
            expression = (Expression)this.handleStrNode((StrNode)node);
        } else if (node2 instanceof FixnumNode) {
            expression = (Expression)this.handleFixnumNode((FixnumNode)node);
        } else if (node2 instanceof FloatNode) {
            expression = (Expression)this.handleFloatNode((FloatNode)node);
        } else if (node2 instanceof DVarNode) {
            expression = (Expression)this.handleINameNode((INameNode)node);
        } else if (node2 instanceof LocalVarNode) {
            expression = (Expression)this.handleINameNode((INameNode)node);
        } else if (node2 instanceof DAsgnNode) {
            expression = (Expression)this.handleDAsgnNode((DAsgnNode)node);
        } else if (node2 instanceof LocalAsgnNode) {
            expression = (Expression)this.handleLocalAsgnNode((LocalAsgnNode)node);
        } else {
            String string = Reflection.getOrCreateKotlinClass(node.getClass()).getSimpleName();
            if (string == null) {
                string = "";
            }
            expression = (Expression)this.handleNotSupported(node, string);
        }
        return expression;
    }

    private final BinaryOperator handleOperatorCallNode(OperatorCallNode node) {
        BinaryOperator binOp;
        block1: {
            MetadataProvider metadataProvider = (MetadataProvider)this;
            String string = node.getName().idString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idString(...)");
            binOp = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)metadataProvider, (String)string, null, (int)2, null);
            Node node2 = node.getReceiverNode();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getReceiverNode(...)");
            Object ResultNode = this.handle(node2);
            Expression expression = ResultNode instanceof Expression ? (Expression)ResultNode : null;
            if (expression != null) {
                Expression it = expression;
                boolean bl = false;
                binOp.setLhs(it);
            }
            Node node3 = node.getArgsNode();
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type org.jruby.ast.ArrayNode");
            ArrayNode list = (ArrayNode)node3;
            Node node4 = list.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"get(...)");
            Object ResultNode2 = this.handle(node4);
            Expression expression2 = ResultNode2 instanceof Expression ? (Expression)ResultNode2 : null;
            if (expression2 == null) break block1;
            Expression it = expression2;
            boolean bl = false;
            binOp.setRhs(it);
        }
        return binOp;
    }

    private final Reference handleINameNode(INameNode node) {
        return ExpressionBuilderKt.newReference$default((MetadataProvider)((MetadataProvider)this), (CharSequence)node.getName().idString(), null, null, (int)6, null);
    }

    private final LambdaExpression handleIterNode(IterNode node) {
        FunctionDeclaration func = DeclarationBuilderKt.newFunctionDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)"", (boolean)false, (Object)node, (int)2, null);
        ((RubyLanguageFrontend)this.getFrontend()).getScopeManager().enterScope((de.fraunhofer.aisec.cpg.graph.Node)func);
        Iterator iterator = ArrayIteratorKt.iterator((Object[])node.getArgsNode().getArgs());
        while (iterator.hasNext()) {
            Node arg = (Node)iterator.next();
            DeclarationHandler declarationHandler = ((RubyLanguageFrontend)this.getFrontend()).getDeclarationHandler();
            Intrinsics.checkNotNull((Object)arg);
            Declaration param = (Declaration)declarationHandler.handle(arg);
            ScopeManager.addDeclaration$default((ScopeManager)((RubyLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)param, (boolean)false, (int)2, null);
        }
        StatementHandler statementHandler = ((RubyLanguageFrontend)this.getFrontend()).getStatementHandler();
        Node node2 = node.getBodyNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getBodyNode(...)");
        func.setBody((Statement)statementHandler.handle(node2));
        ((RubyLanguageFrontend)this.getFrontend()).getScopeManager().leaveScope((de.fraunhofer.aisec.cpg.graph.Node)func);
        LambdaExpression lambda = ExpressionBuilderKt.newLambdaExpression$default((MetadataProvider)((MetadataProvider)this), null, (int)1, null);
        lambda.setFunction(func);
        return lambda;
    }

    private final AssignExpression handleDAsgnNode(DAsgnNode node) {
        AssignExpression assign = ExpressionBuilderKt.newAssignExpression$default((MetadataProvider)((MetadataProvider)this), (String)"=", null, null, null, (int)14, null);
        Object[] objectArray = new Expression[]{this.handleINameNode((INameNode)node)};
        assign.setLhs(CollectionsKt.mutableListOf((Object[])objectArray));
        objectArray = new Expression[1];
        Node node2 = node.getValueNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getValueNode(...)");
        objectArray[0] = this.handle(node2);
        assign.setRhs(CollectionsKt.mutableListOf((Object[])objectArray));
        return assign;
    }

    private final AssignExpression handleLocalAsgnNode(LocalAsgnNode node) {
        AssignExpression assign = ExpressionBuilderKt.newAssignExpression$default((MetadataProvider)((MetadataProvider)this), (String)"=", null, null, null, (int)14, null);
        Object[] objectArray = new Expression[]{this.handleINameNode((INameNode)node)};
        assign.setLhs(CollectionsKt.mutableListOf((Object[])objectArray));
        objectArray = new Expression[1];
        Node node2 = node.getValueNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getValueNode(...)");
        objectArray[0] = this.handle(node2);
        assign.setRhs(CollectionsKt.mutableListOf((Object[])objectArray));
        return assign;
    }

    private final Expression handleCallNode(CallNode node) {
        MemberCallExpression mce;
        block3: {
            Node node2 = node.getReceiverNode();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getReceiverNode(...)");
            Object ResultNode = this.handle(node2);
            Expression expression = ResultNode instanceof Expression ? (Expression)ResultNode : null;
            if (expression == null) {
                return (Expression)new ProblemExpression("could not parse base", null, 2, null);
            }
            Expression base = expression;
            MemberExpression callee = ExpressionBuilderKt.newMemberExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)node.getName().asJavaString(), (Expression)base, null, null, null, (int)28, null);
            mce = ExpressionBuilderKt.newMemberCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)callee), (boolean)false, null, (int)4, null);
            Object object = node.getArgsNode();
            if (object == null || (object = object.childNodes()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Node arg = (Node)iterator.next();
                Intrinsics.checkNotNull((Object)arg);
                mce.addArgument((Expression)this.handle(arg));
            }
            Node node3 = node.getIterNode();
            if (node3 == null) break block3;
            Node it = node3;
            boolean bl = false;
            mce.addArgument((Expression)this.handle(it));
        }
        return (Expression)mce;
    }

    private final Expression handleFCallNode(FCallNode node) {
        CallExpression call;
        block2: {
            Reference callee = this.handleINameNode((INameNode)node);
            call = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)callee), null, (boolean)false, null, (int)14, null);
            Object object = node.getArgsNode();
            if (object == null || (object = object.childNodes()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Node arg = (Node)iterator.next();
                Intrinsics.checkNotNull((Object)arg);
                call.addArgument((Expression)this.handle(arg));
            }
            Node node2 = node.getIterNode();
            if (node2 == null) break block2;
            Node it = node2;
            boolean bl = false;
            call.addArgument((Expression)this.handle(it));
        }
        return (Expression)call;
    }

    private final Literal<String> handleStrNode(StrNode node) {
        RawNodeTypeProvider rawNodeTypeProvider = (RawNodeTypeProvider)this;
        byte[] byArray = node.getValue().bytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes(...)");
        byte[] byArray2 = byArray;
        return ExpressionBuilderKt.newLiteral$default((RawNodeTypeProvider)rawNodeTypeProvider, (Object)new String(byArray2, Charsets.UTF_8), (Type)TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"String"), null, (int)4, null);
    }

    private final Literal<Long> handleFixnumNode(FixnumNode node) {
        return ExpressionBuilderKt.newLiteral$default((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)node.getValue(), (Type)TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"Integer"), null, (int)4, null);
    }

    private final Literal<Double> handleFloatNode(FloatNode node) {
        return ExpressionBuilderKt.newLiteral$default((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)node.getValue(), (Type)TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"Float"), null, (int)4, null);
    }

    private static final Expression _init_$lambda$0() {
        return (Expression)new ProblemExpression(null, null, 3, null);
    }
}

