/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.python;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.python.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.python.JepSingleton;
import de.fraunhofer.aisec.cpg.frontends.python.Python;
import de.fraunhofer.aisec.cpg.frontends.python.PythonLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.frontends.python.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.NameKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.CommentMatcher;
import de.fraunhofer.aisec.cpg.passes.PythonAddDeclarationsPass;
import de.fraunhofer.aisec.cpg.passes.configuration.RegisterExtraPass;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jep.SharedInterpreter;
import jep.python.PyObject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RegisterExtraPass(value=PythonAddDeclarationsPass.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0002\b\u00030#j\u0006\u0012\u0002\b\u0003`$2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\u0002H\u0016J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0*H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0*2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010,2\u0006\u0010(\u001a\u00020\u0002H\u0016J\u000e\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u000f2\u0006\u00101\u001a\u000204J\u0010\u00105\u001a\u00020!2\u0006\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000fH\u0002J$\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0*H\u0002J\u0018\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020?2\u0006\u0010(\u001a\u00020\u0002H\u0016J\u0012\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/python/PythonLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/python/Python$AST;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/python/ExpressionHandler;", "getExpressionHandler$cpg_language_python", "()Lde/fraunhofer/aisec/cpg/frontends/python/ExpressionHandler;", "setExpressionHandler$cpg_language_python", "(Lde/fraunhofer/aisec/cpg/frontends/python/ExpressionHandler;)V", "fileContent", "", "jep", "Lde/fraunhofer/aisec/cpg/frontends/python/JepSingleton;", "lineSeparator", "", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/python/StatementHandler;", "getStatementHandler$cpg_language_python", "()Lde/fraunhofer/aisec/cpg/frontends/python/StatementHandler;", "setStatementHandler$cpg_language_python", "(Lde/fraunhofer/aisec/cpg/frontends/python/StatementHandler;)V", "tokenTypeIndex", "", "uri", "Ljava/net/URI;", "addCommentsToCPG", "", "tud", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "pyTokens", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pyCommentCode", "", "codeOf", "astNode", "fixStartColumn", "", "location", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "lines", "getRelevantLines", "locationOf", "operatorToString", "op", "Lde/fraunhofer/aisec/cpg/frontends/python/Python$ASTBASEoperator;", "operatorUnaryToString", "Lde/fraunhofer/aisec/cpg/frontends/python/Python$ASTBASEunaryop;", "parse", "file", "Ljava/io/File;", "pythonASTtoCPG", "pyAST", "Ljep/python/PyObject;", "path", "removeExtraAtEnd", "setComment", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "typeOf", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "type", "cpg-language-python"})
public final class PythonLanguageFrontend
extends LanguageFrontend<Python.AST, Python.AST> {
    private final char lineSeparator;
    private final int tokenTypeIndex;
    @NotNull
    private final JepSingleton jep;
    @NotNull
    private StatementHandler statementHandler;
    @NotNull
    private ExpressionHandler expressionHandler;
    private String fileContent;
    private URI uri;

    public PythonLanguageFrontend(@NotNull Language<PythonLanguageFrontend> language, @NotNull TranslationContext ctx2) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        super(language, ctx2);
        this.lineSeparator = (char)10;
        this.jep = JepSingleton.INSTANCE;
        this.statementHandler = new StatementHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
    }

    @NotNull
    public final StatementHandler getStatementHandler$cpg_language_python() {
        return this.statementHandler;
    }

    public final void setStatementHandler$cpg_language_python(@NotNull StatementHandler statementHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)statementHandler), (String)"<set-?>");
        this.statementHandler = statementHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler$cpg_language_python() {
        return this.expressionHandler;
    }

    public final void setExpressionHandler$cpg_language_python(@NotNull ExpressionHandler expressionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)expressionHandler), (String)"<set-?>");
        this.expressionHandler = expressionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) throws TranslationException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileContent = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        URI uRI = file.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        this.uri = uRI;
        AutoCloseable autoCloseable = (AutoCloseable)this.jep.getInterp();
        Throwable throwable = null;
        try {
            SharedInterpreter it = (SharedInterpreter)autoCloseable;
            boolean bl = false;
            String string = this.fileContent;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileContent");
                string = null;
            }
            it.set("content", (Object)string);
            it.set("filename", (Object)file.getAbsolutePath());
            it.exec("import ast");
            it.exec("parsed = ast.parse(content, filename=filename, type_comments=True)");
            Object object = it.getValue("parsed");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type jep.python.PyObject");
            PyObject pyAST = (PyObject)object;
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            TranslationUnitDeclaration tud = this.pythonASTtoCPG(pyAST, string2);
            if (this.getConfig().getMatchCommentsToNodes()) {
                it.exec("import tokenize");
                it.exec("reader = tokenize.open(filename).readline");
                it.exec("tokens = tokenize.generate_tokens(reader)");
                it.exec("tokenList = list(tokens)");
                it.exec("commentCode = tokenize.COMMENT");
                Object object2 = it.getValue("commentCode");
                Long l = object2 instanceof Long ? (Long)object2 : null;
                if (l == null) {
                    object2 = "Cannot get comment of " + it;
                    throw new NotImplementedError("An operation is not implemented: " + (String)object2);
                }
                long pyCommentCode = l;
                Object object3 = it.getValue("tokenList");
                ArrayList arrayList = object3 instanceof ArrayList ? (ArrayList)object3 : null;
                if (arrayList == null) {
                    object3 = "Cannot get tokens of " + it;
                    throw new NotImplementedError("An operation is not implemented: " + (String)object3);
                }
                ArrayList pyTokens = arrayList;
                this.addCommentsToCPG(tud, pyTokens, pyCommentCode);
            }
            TranslationUnitDeclaration translationUnitDeclaration = tud;
            return translationUnitDeclaration;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void addCommentsToCPG(TranslationUnitDeclaration tud, ArrayList<?> pyTokens, long pyCommentCode) {
        CommentMatcher commentMatcher = new CommentMatcher();
        for (Object token : pyTokens) {
            if (!(token instanceof List) || ((List)token).size() != 5) {
                throw new NotImplementedError(null, 1, null);
            }
            Object e = ((List)token).get(this.tokenTypeIndex);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Long");
            if ((Long)e != pyCommentCode) continue;
            Object e2 = ((List)token).get(2);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List start = (List)e2;
            Object e3 = ((List)token).get(3);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List end = (List)e3;
            Object e4 = start.get(0);
            Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type kotlin.Long");
            long startLine = (Long)e4;
            Object e5 = start.get(1);
            Intrinsics.checkNotNull(e5, (String)"null cannot be cast to non-null type kotlin.Long");
            long startCol = (Long)e5;
            Object e6 = end.get(0);
            Intrinsics.checkNotNull(e6, (String)"null cannot be cast to non-null type kotlin.Long");
            long endLine = (Long)e6;
            Object e7 = end.get(1);
            Intrinsics.checkNotNull(e7, (String)"null cannot be cast to non-null type kotlin.Long");
            long endCol = (Long)e7;
            Object e8 = ((List)token).get(1);
            Intrinsics.checkNotNull(e8, (String)"null cannot be cast to non-null type kotlin.String");
            CommentMatcher.matchCommentToNode$default((CommentMatcher)commentMatcher, (String)((String)e8), (Region)new Region((int)startLine, (int)(startCol + 1L), (int)endLine, (int)(endCol + 1L)), (TranslationUnitDeclaration)tud, null, (int)8, null);
        }
    }

    @NotNull
    public Type typeOf(@Nullable Python.AST type2) {
        Type type3;
        Python.AST aST = type2;
        if (aST == null) {
            type3 = TypeBuilderKt.autoType((LanguageProvider)((LanguageProvider)this));
        } else if (aST instanceof Python.ASTName) {
            String id2 = ((Python.ASTName)type2).getId();
            if (this.getLanguage().getPrimitiveTypeNames().contains(id2)) {
                return TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)id2);
            }
            Name name2 = StringsKt.contains$default((CharSequence)id2, (CharSequence)this.getLanguage().getNamespaceDelimiter(), (boolean)false, (int)2, null) ? NameKt.parseName((LanguageProvider)((LanguageProvider)this), (CharSequence)id2) : NameKt.fqn((Name)this.getScopeManager().getCurrentNamespace(), (String)id2);
            type3 = TypeBuilderKt.objectType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)((CharSequence)name2), null, (int)2, null);
        } else {
            type3 = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
        }
        return type3;
    }

    @Nullable
    public String codeOf(@NotNull Python.AST astNode) {
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        PhysicalLocation location = this.locationOf(astNode);
        if (location != null) {
            List<String> lines = this.getRelevantLines(location);
            lines = this.removeExtraAtEnd(location, lines);
            lines = this.fixStartColumn(location, lines);
            return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)String.valueOf(this.lineSeparator), null, null, (int)0, null, null, (int)62, null);
        }
        return null;
    }

    private final List<String> getRelevantLines(PhysicalLocation location) {
        String string = this.fileContent;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileContent");
            string = null;
        }
        char[] cArray = new char[]{this.lineSeparator};
        List lines = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null).subList(location.getRegion().startLine - 1, location.getRegion().getEndLine());
        return CollectionsKt.toMutableList((Collection)lines);
    }

    private final List<String> fixStartColumn(PhysicalLocation location, List<String> lines) {
        int n = lines.size();
        for (int idx = 0; idx < n; ++idx) {
            int prefixLength = Math.min(location.getRegion().startColumn - 1, lines.get(idx).length());
            if (idx != 0) continue;
            String string = lines.get(idx).substring(prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            lines.set(idx, string);
        }
        return lines;
    }

    private final List<String> removeExtraAtEnd(PhysicalLocation location, List<String> lines) {
        int locationEndColumn;
        int lastLineIdx = CollectionsKt.getLastIndex(lines);
        int lastLineLength = lines.get(lastLineIdx).length();
        int toRemove = lastLineLength - (locationEndColumn = location.getRegion().getEndColumn()) + 1;
        if (toRemove > 0) {
            lines.set(lastLineIdx, StringsKt.dropLast((String)lines.get(lastLineIdx), (int)toRemove));
        }
        return lines;
    }

    @Nullable
    public PhysicalLocation locationOf(@NotNull Python.AST astNode) {
        PhysicalLocation physicalLocation;
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        if (astNode instanceof Python.WithPythonLocation) {
            URI uRI = this.uri;
            if (uRI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                uRI = null;
            }
            int n = ((Python.WithPythonLocation)((Object)astNode)).getLineno();
            int n2 = ((Python.WithPythonLocation)((Object)astNode)).getEnd_lineno();
            int n3 = ((Python.WithPythonLocation)((Object)astNode)).getCol_offset() + 1;
            int n4 = ((Python.WithPythonLocation)((Object)astNode)).getEnd_col_offset() + 1;
            PhysicalLocation physicalLocation2 = new PhysicalLocation(uRI, new Region(n, n3, n2, n4));
            physicalLocation = physicalLocation2;
        } else {
            physicalLocation = null;
        }
        return physicalLocation;
    }

    public void setComment(@NotNull Node node, @NotNull Python.AST astNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
    }

    private final TranslationUnitDeclaration pythonASTtoCPG(PyObject pyAST, String path) {
        Object object = PythonLanguageFrontendKt.fromPython(pyAST);
        Python.ASTModule aSTModule = object instanceof Python.ASTModule ? (Python.ASTModule)object : null;
        if (aSTModule == null) {
            object = "Python ast of type " + PythonLanguageFrontendKt.fromPython(pyAST).getClass() + " is not supported yet";
            throw new NotImplementedError("An operation is not implemented: " + (String)object);
        }
        Python.ASTModule pythonASTModule = aSTModule;
        TranslationUnitDeclaration tud = DeclarationBuilderKt.newTranslationUnitDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)path, (Object)pythonASTModule);
        this.getScopeManager().resetToGlobal(tud);
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        String nsdName = PathsKt.getNameWithoutExtension((Path)path2);
        NamespaceDeclaration nsd = DeclarationBuilderKt.newNamespaceDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)nsdName, (Object)pythonASTModule);
        tud.addDeclaration((Declaration)nsd);
        this.getScopeManager().enterScope((Node)nsd);
        for (Python.ASTBASEstmt stmt2 : pythonASTModule.getBody()) {
            nsd.setStatements(CollectionsKt.plus((Collection)nsd.getStatements(), this.statementHandler.handle((Python.AST)stmt2)));
        }
        this.getScopeManager().leaveScope((Node)nsd);
        ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)((Declaration)nsd), (boolean)false, (int)2, null);
        return tud;
    }

    @NotNull
    public final String operatorToString(@NotNull Python.ASTBASEoperator op2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)op2, (String)"op");
        Python.ASTBASEoperator aSTBASEoperator = op2;
        if (aSTBASEoperator instanceof Python.ASTAdd) {
            string = "+";
        } else if (aSTBASEoperator instanceof Python.ASTSub) {
            string = "-";
        } else if (aSTBASEoperator instanceof Python.ASTMult) {
            string = "*";
        } else if (aSTBASEoperator instanceof Python.ASTMatMult) {
            string = "*";
        } else if (aSTBASEoperator instanceof Python.ASTDiv) {
            string = "/";
        } else if (aSTBASEoperator instanceof Python.ASTMod) {
            string = "%";
        } else if (aSTBASEoperator instanceof Python.ASTPow) {
            string = "**";
        } else if (aSTBASEoperator instanceof Python.ASTLShift) {
            string = "<<";
        } else if (aSTBASEoperator instanceof Python.ASTRShift) {
            string = ">>";
        } else if (aSTBASEoperator instanceof Python.ASTBitOr) {
            string = "|";
        } else if (aSTBASEoperator instanceof Python.ASTBitXor) {
            string = "^";
        } else if (aSTBASEoperator instanceof Python.ASTBitAnd) {
            string = "&";
        } else if (aSTBASEoperator instanceof Python.ASTFloorDiv) {
            string = "//";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String operatorUnaryToString(@NotNull Python.ASTBASEunaryop op2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)op2, (String)"op");
        Python.ASTBASEunaryop aSTBASEunaryop = op2;
        if (aSTBASEunaryop instanceof Python.ASTInvert) {
            string = "~";
        } else if (aSTBASEunaryop instanceof Python.ASTNot) {
            string = "not";
        } else if (aSTBASEunaryop instanceof Python.ASTUAdd) {
            string = "+";
        } else if (aSTBASEunaryop instanceof Python.ASTUSub) {
            string = "-";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

