/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.python;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.python.JepSingleton;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import jep.JepException;
import jep.SubInterpreter;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\t\u001a\u0004\u0018\u00010\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J)\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\u001b\u001a\u0002H\u001a2\u0006\u0010\u0004\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/python/PythonLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "jep", "Lde/fraunhofer/aisec/cpg/frontends/python/JepSingleton;", "getCodeFromRawNode", "", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "parseInternal", "code", "path", "setComment", "", "S", "s", "(Ljava/lang/Object;Ljava/lang/Object;)V", "cpg-language-python"})
public final class PythonLanguageFrontend
extends LanguageFrontend {
    @NotNull
    private final JepSingleton jep;

    public PythonLanguageFrontend(@NotNull Language<PythonLanguageFrontend> language, @NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(language, ctx);
        this.jep = JepSingleton.INSTANCE;
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) throws TranslationException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return this.parseInternal(string, string2);
    }

    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        return null;
    }

    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        return null;
    }

    public <S, T> void setComment(S s, T ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TranslationUnitDeclaration parseInternal(String code, String path) {
        SubInterpreter pythonInterpreter = this.jep.getInterp();
        TranslationUnitDeclaration tu = null;
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        String absolutePath = ((Object)path2.toAbsolutePath()).toString();
        try {
            Object[] objectArray = new Object[]{this, code, absolutePath};
            Object object = pythonInterpreter.invoke("parse_code", objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration");
            tu = (TranslationUnitDeclaration)object;
            if (this.getConfig().getMatchCommentsToNodes()) {
                Object[] objectArray2 = new Object[]{this, code, absolutePath, tu};
                pythonInterpreter.invoke("parse_comments", objectArray2);
            }
        }
        catch (JepException e) {
            e.printStackTrace();
            throw new TranslationException("Python failed with message: " + e);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            pythonInterpreter.close();
        }
        return tu;
    }
}

