/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.python;

import de.fraunhofer.aisec.cpg.frontends.HasShortCircuitOperators;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.python.PythonLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.BooleanType;
import de.fraunhofer.aisec.cpg.graph.types.FloatingPointType;
import de.fraunhofer.aisec.cpg.graph.types.IntegerType;
import de.fraunhofer.aisec.cpg.graph.types.NumericType;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.StringType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Transient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\"\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00188\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lde/fraunhofer/aisec/cpg/frontends/python/PythonLanguage;", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Lde/fraunhofer/aisec/cpg/frontends/python/PythonLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/HasShortCircuitOperators;", "()V", "builtInTypes", "", "", "Lde/fraunhofer/aisec/cpg/graph/types/ObjectType;", "getBuiltInTypes", "()Ljava/util/Map;", "compoundAssignmentOperators", "", "getCompoundAssignmentOperators", "()Ljava/util/Set;", "conjunctiveOperators", "", "getConjunctiveOperators", "()Ljava/util/List;", "disjunctiveOperators", "getDisjunctiveOperators", "fileExtensions", "getFileExtensions", "frontend", "Lkotlin/reflect/KClass;", "getFrontend", "()Lkotlin/reflect/KClass;", "namespaceDelimiter", "getNamespaceDelimiter", "()Ljava/lang/String;", "propagateTypeOfBinaryOperation", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "operation", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "cpg-language-python"})
public final class PythonLanguage
extends Language<PythonLanguageFrontend>
implements HasShortCircuitOperators {
    @NotNull
    private final List<String> fileExtensions = CollectionsKt.listOf((Object)"py");
    @NotNull
    private final String namespaceDelimiter;
    @Transient
    @NotNull
    private final KClass<? extends PythonLanguageFrontend> frontend = Reflection.getOrCreateKotlinClass(PythonLanguageFrontend.class);
    @NotNull
    private final List<String> conjunctiveOperators = CollectionsKt.listOf((Object)"and");
    @NotNull
    private final List<String> disjunctiveOperators = CollectionsKt.listOf((Object)"or");
    @NotNull
    private final Set<String> compoundAssignmentOperators;
    @Transient
    @NotNull
    private final Map<String, ObjectType> builtInTypes;

    public PythonLanguage() {
        this.namespaceDelimiter = ".";
        Object[] objectArray = new String[]{"+=", "-=", "*=", "**=", "/=", "//=", "%=", "<<=", ">>=", "&=", "|=", "^=", "@="};
        this.compoundAssignmentOperators = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"bool", (Object)new BooleanType((CharSequence)"bool", null, (Language)this, null, 10, null)), TuplesKt.to((Object)"int", (Object)new IntegerType((CharSequence)"int", Integer.valueOf(Integer.MAX_VALUE), (Language)this, NumericType.Modifier.NOT_APPLICABLE)), TuplesKt.to((Object)"float", (Object)new FloatingPointType((CharSequence)"float", Integer.valueOf(32), (Language)this, NumericType.Modifier.NOT_APPLICABLE)), TuplesKt.to((Object)"complex", (Object)new NumericType((CharSequence)"complex", null, (Language)this, NumericType.Modifier.NOT_APPLICABLE)), TuplesKt.to((Object)"str", (Object)new StringType((CharSequence)"str", (Language)this, CollectionsKt.emptyList()))};
        this.builtInTypes = MapsKt.mapOf((Pair[])objectArray);
    }

    @NotNull
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    @NotNull
    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    @NotNull
    public KClass<? extends PythonLanguageFrontend> getFrontend() {
        return this.frontend;
    }

    @NotNull
    public List<String> getConjunctiveOperators() {
        return this.conjunctiveOperators;
    }

    @NotNull
    public List<String> getDisjunctiveOperators() {
        return this.disjunctiveOperators;
    }

    @NotNull
    public Set<String> getCompoundAssignmentOperators() {
        return this.compoundAssignmentOperators;
    }

    @NotNull
    public Map<String, ObjectType> getBuiltInTypes() {
        return this.builtInTypes;
    }

    @NotNull
    public Type propagateTypeOfBinaryOperation(@NotNull BinaryOperator operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        UnknownType unknownType = UnknownType.Companion.getUnknownType((Language)this);
        if (Intrinsics.areEqual((Object)operation.getOperatorCode(), (Object)"/") && operation.getLhs().getPropagationType() instanceof NumericType && operation.getRhs().getPropagationType() instanceof NumericType) {
            Type type = this.getSimpleTypeOf("float");
            if (type == null) {
                type = (Type)unknownType;
            }
            return type;
        }
        if (Intrinsics.areEqual((Object)operation.getOperatorCode(), (Object)"//") && operation.getLhs().getPropagationType() instanceof NumericType && operation.getRhs().getPropagationType() instanceof NumericType) {
            Type type;
            if (operation.getLhs().getPropagationType() instanceof IntegerType && operation.getRhs().getPropagationType() instanceof IntegerType) {
                type = this.getSimpleTypeOf("int");
                if (type == null) {
                    type = (Type)unknownType;
                }
            } else {
                type = this.getSimpleTypeOf("float");
                if (type == null) {
                    type = (Type)unknownType;
                }
            }
            return type;
        }
        return super.propagateTypeOfBinaryOperation(operation);
    }
}

