/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.python;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.python.JepSingleton;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import jep.JepException;
import jep.SubInterpreter;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u0011\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J)\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\r2\u0006\u0010\u001d\u001a\u0002H\u001c2\u0006\u0010\u001e\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/fraunhofer/aisec/cpg/frontends/python/PythonLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "jep", "Lde/fraunhofer/aisec/cpg/frontends/python/JepSingleton;", "getCodeFromRawNode", "", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "parseInternal", "code", "path", "setComment", "", "S", "s", "ctx", "(Ljava/lang/Object;Ljava/lang/Object;)V", "cpg-language-python"})
public final class PythonLanguageFrontend
extends LanguageFrontend {
    @NotNull
    private final JepSingleton jep;

    public PythonLanguageFrontend(@NotNull Language<PythonLanguageFrontend> language, @NotNull TranslationConfiguration config, @NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        super(language, config, scopeManager);
        this.jep = JepSingleton.INSTANCE;
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) throws TranslationException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        return this.parseInternal(string, string2);
    }

    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        return null;
    }

    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        return null;
    }

    public <S, T> void setComment(S s, T ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TranslationUnitDeclaration parseInternal(String code, String path) {
        SubInterpreter pythonInterpreter = this.jep.getInterp();
        TranslationUnitDeclaration tu = null;
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        String absolutePath = ((Object)path2.toAbsolutePath()).toString();
        try {
            Object[] objectArray = new Object[]{this, code, absolutePath};
            Object object = pythonInterpreter.invoke("parse_code", objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration");
            tu = (TranslationUnitDeclaration)object;
            if (this.getConfig().getMatchCommentsToNodes()) {
                Object[] objectArray2 = new Object[]{this, code, absolutePath, tu};
                pythonInterpreter.invoke("parse_comments", objectArray2);
            }
        }
        catch (JepException e) {
            e.printStackTrace();
            throw new TranslationException("Python failed with message: " + e);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            pythonInterpreter.close();
        }
        return tu;
    }
}

