/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParameterDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.GlobalScope;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Block;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "Lorg/bytedeco/javacpp/Pointer;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "getLiteralStructName", "", "typeRef", "Lorg/bytedeco/llvm/LLVM/LLVMTypeRef;", "alreadyVisited", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "handleFunction", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "func", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "handleGlobal", "valueRef", "handleStructureType", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "handleValue", "value", "replaceCharsInName", "name", "cpg-language-llvm"})
@SourceDebugExtension(value={"SMAP\nDeclarationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler\n+ 2 ScopeManager.kt\nde/fraunhofer/aisec/cpg/ScopeManager\n*L\n1#1,284:1\n915#2:285\n*S KotlinDebug\n*F\n+ 1 DeclarationHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler\n*L\n199#1:285\n*E\n"})
public final class DeclarationHandler
extends Handler<Declaration, Pointer, LLVMIRLanguageFrontend> {
    public DeclarationHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(() -> new ProblemDeclaration(null, null, 3, null), (LanguageFrontend)lang);
        this.getMap().put(LLVMValueRef.class, arg_0 -> DeclarationHandler._init_$lambda$1(this, arg_0));
        this.getMap().put(LLVMTypeRef.class, arg_0 -> DeclarationHandler._init_$lambda$2(this, arg_0));
    }

    private final Declaration handleValue(LLVMValueRef value) {
        int kind = LLVM.LLVMGetValueKind((LLVMValueRef)value);
        return switch (kind) {
            case 5 -> (Declaration)this.handleFunction(value);
            case 8 -> this.handleGlobal(value);
            default -> {
                Handler.getLog().error("Not handling declaration kind {} yet", (Object)kind);
                yield (Declaration)DeclarationBuilderKt.newProblemDeclaration((MetadataProvider)((MetadataProvider)this), (String)("Not handling declaration kind " + kind + " yet."), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
            }
        };
    }

    private final Declaration handleGlobal(LLVMValueRef valueRef) {
        String name = LLVM.LLVMGetValueName((LLVMValueRef)valueRef).getString();
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef);
        VariableDeclaration variableDeclaration = DeclarationBuilderKt.newVariableDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)type, (boolean)false, (Object)valueRef);
        ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put(LLVMIRLanguageFrontendKt.getSymbolName(valueRef), (Declaration)variableDeclaration);
        int size = LLVM.LLVMGetNumOperands((LLVMValueRef)valueRef);
        if (size > 0) {
            ExpressionHandler expressionHandler = ((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler();
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)valueRef, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            Expression expr = (Expression)expressionHandler.handle(lLVMValueRef);
            variableDeclaration.setInitializer(expr);
        }
        return (Declaration)variableDeclaration;
    }

    private final FunctionDeclaration handleFunction(LLVMValueRef func) {
        BytePointer name = LLVM.LLVMGetValueName((LLVMValueRef)func);
        FunctionDeclaration functionDeclaration = DeclarationBuilderKt.newFunctionDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name.getString(), (boolean)false, (Object)func, (int)2, null);
        LLVMTypeRef funcPtrType = LLVM.LLVMTypeOf((LLVMValueRef)func);
        LLVMTypeRef funcType = LLVM.LLVMGetElementType((LLVMTypeRef)funcPtrType);
        LLVMTypeRef returnType = LLVM.LLVMGetReturnType((LLVMTypeRef)funcType);
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
        Intrinsics.checkNotNull((Object)returnType);
        functionDeclaration.setType(lLVMIRLanguageFrontend.typeOf(returnType));
        ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().enterScope((Node)functionDeclaration);
        LLVMValueRef param = LLVM.LLVMGetFirstParam((LLVMValueRef)func);
        while (param != null) {
            Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(param);
            String paramName = (String)namePair.getFirst();
            String paramSymbolName = (String)namePair.getSecond();
            Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(param);
            ParameterDeclaration decl = DeclarationBuilderKt.newParameterDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)paramName, (Type)type, (boolean)false, (Object)param);
            ScopeManager.addDeclaration$default((ScopeManager)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)((Declaration)decl), (boolean)false, (int)2, null);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put(paramSymbolName, (Declaration)decl);
            param = LLVM.LLVMGetNextParam((LLVMValueRef)param);
        }
        LLVMBasicBlockRef bb = LLVM.LLVMGetFirstBasicBlock((LLVMValueRef)func);
        while (bb != null) {
            Statement stmt = (Statement)((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler().handle(bb);
            if (Intrinsics.areEqual((Object)LLVM.LLVMGetEntryBasicBlock((LLVMValueRef)func), (Object)bb) && stmt instanceof Block) {
                functionDeclaration.setBody(stmt);
            } else if (Intrinsics.areEqual((Object)LLVM.LLVMGetEntryBasicBlock((LLVMValueRef)func), (Object)bb)) {
                functionDeclaration.setBody((Statement)ExpressionBuilderKt.newBlock$default((MetadataProvider)((MetadataProvider)this), null, (int)1, null));
                if (stmt != null) {
                    Statement statement = functionDeclaration.getBody();
                    Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Block");
                    ((Block)statement).addStatement(stmt);
                }
            } else if (stmt != null) {
                Statement statement = functionDeclaration.getBody();
                Block block = statement instanceof Block ? (Block)statement : null;
                if (block != null) {
                    block.addStatement(stmt);
                }
            }
            bb = LLVM.LLVMGetNextBasicBlock((LLVMBasicBlockRef)bb);
        }
        ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().leaveScope((Node)functionDeclaration);
        return functionDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RecordDeclaration handleStructureType(@NotNull LLVMTypeRef typeRef, @NotNull Map<LLVMTypeRef, Type> alreadyVisited) {
        RecordDeclaration record2;
        block4: {
            void stopIfFound$iv;
            void searchScope$iv;
            void this_$iv;
            String string;
            Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
            Intrinsics.checkNotNullParameter(alreadyVisited, (String)"alreadyVisited");
            if (LLVM.LLVMIsLiteralStruct((LLVMTypeRef)typeRef) == 1) {
                string = this.getLiteralStructName(typeRef, alreadyVisited);
            } else {
                String string2 = LLVM.LLVMGetStructName((LLVMTypeRef)typeRef).getString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                string = this.replaceCharsInName(string2);
            }
            String name = string;
            ScopeManager scopeManager = ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager();
            Scope scope = (Scope)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().getGlobalScope();
            boolean bl = true;
            Function1 predicate$iv = (Function1)new Function1<RecordDeclaration, Boolean>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull RecordDeclaration it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getName().toString(), (Object)this.$name);
                }
            };
            boolean $i$f$resolve = false;
            record2 = (RecordDeclaration)CollectionsKt.firstOrNull((List)this_$iv.resolve(RecordDeclaration.class, (Scope)searchScope$iv, (boolean)stopIfFound$iv, predicate$iv));
            if (record2 != null) {
                return record2;
            }
            record2 = DeclarationBuilderKt.newRecordDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (String)"struct", null, (int)4, null);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().enterScope((Node)record2);
            int size = LLVM.LLVMCountStructElementTypes((LLVMTypeRef)typeRef);
            for (int i = 0; i < size; ++i) {
                LLVMTypeRef a = LLVM.LLVMStructGetTypeAtIndex((LLVMTypeRef)typeRef, (int)i);
                LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
                Intrinsics.checkNotNull((Object)a);
                Type fieldType = lLVMIRLanguageFrontend.typeOf$cpg_language_llvm(a, alreadyVisited);
                String fieldName = "field_" + i;
                FieldDeclaration field = DeclarationBuilderKt.newFieldDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)fieldName, (Type)fieldType, (List)CollectionsKt.emptyList(), null, (boolean)false, null, (int)32, null);
                ScopeManager.addDeclaration$default((ScopeManager)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)((Declaration)field), (boolean)false, (int)2, null);
            }
            ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().leaveScope((Node)record2);
            GlobalScope globalScope = ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().getGlobalScope();
            if (globalScope == null) break block4;
            globalScope.addDeclaration((Declaration)record2, true);
        }
        return record2;
    }

    public static /* synthetic */ RecordDeclaration handleStructureType$default(DeclarationHandler declarationHandler, LLVMTypeRef lLVMTypeRef, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        return declarationHandler.handleStructureType(lLVMTypeRef, map);
    }

    private final String getLiteralStructName(LLVMTypeRef typeRef, Map<LLVMTypeRef, Type> alreadyVisited) {
        String typeStr = LLVM.LLVMPrintTypeToString((LLVMTypeRef)typeRef).getString();
        if (((LLVMIRLanguageFrontend)this.getFrontend()).getTypeCache().containsKey(typeStr)) {
            String localName;
            Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).getTypeCache().get(typeStr);
            String string = type != null && (type = type.getName()) != null ? type.getLocalName() : (localName = null);
            if (localName != null) {
                return localName;
            }
        }
        Object name = "literal";
        int size = LLVM.LLVMCountStructElementTypes((LLVMTypeRef)typeRef);
        for (int i = 0; i < size; ++i) {
            LLVMTypeRef field = LLVM.LLVMStructGetTypeAtIndex((LLVMTypeRef)typeRef, (int)i);
            LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
            Intrinsics.checkNotNull((Object)field);
            Type fieldType = lLVMIRLanguageFrontend.typeOf$cpg_language_llvm(field, alreadyVisited);
            name = (String)name + "_" + fieldType.getTypeName();
        }
        return this.replaceCharsInName((String)name);
    }

    private final String replaceCharsInName(String name) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)"[]", (String)"Array", (boolean)false, (int)4, null), (String)"*", (String)"Ptr", (boolean)false, (int)4, null), (String)"+", (String)"%2B", (boolean)false, (int)4, null), (String)"&", (String)"%26", (boolean)false, (int)4, null), (String)"#", (String)"%23", (boolean)false, (int)4, null), (String)"<", (String)"%3c", (boolean)false, (int)4, null), (String)">", (String)"%3e", (boolean)false, (int)4, null), (String)"@", (String)"%40", (boolean)false, (int)4, null), (String)"[", (String)"%5b", (boolean)false, (int)4, null), (String)"]", (String)"%5d", (boolean)false, (int)4, null), (String)"{", (String)"%7b", (boolean)false, (int)4, null), (String)"}", (String)"%7d", (boolean)false, (int)4, null);
    }

    private static final Declaration _init_$lambda$1(DeclarationHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleValue((LLVMValueRef)it);
    }

    private static final Declaration _init_$lambda$2(DeclarationHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Declaration)DeclarationHandler.handleStructureType$default(this$0, (LLVMTypeRef)it, null, 2, null);
    }
}

