/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.llvm.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.frontends.llvm.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.ContextProvider;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.CompressLLVMPass;
import de.fraunhofer.aisec.cpg.passes.order.RegisterExtraPass;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMContextRef;
import org.bytedeco.llvm.LLVM.LLVMMemoryBufferRef;
import org.bytedeco.llvm.LLVM.LLVMModuleRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RegisterExtraPass(value=CompressLLVMPass.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020\u0002H\u0016J\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0.2\u0006\u0010/\u001a\u00020!J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020!J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000bJ\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010,\u001a\u00020\u0002H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010,\u001a\u00020\u0002H\u0016J\u0010\u0010C\u001a\u00020)2\u0006\u0010D\u001a\u00020\u0003H\u0016J-\u0010C\u001a\u00020)2\u0006\u0010E\u001a\u00020\u00032\u0016\b\u0002\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010)0\nH\u0000\u00a2\u0006\u0002\bGJ\u000e\u0010C\u001a\u00020)2\u0006\u0010/\u001a\u00020!R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001d\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020)0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000e\u00a8\u0006H"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lorg/bytedeco/javacpp/Pointer;", "Lorg/bytedeco/llvm/LLVM/LLVMTypeRef;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "bindingsCache", "", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "getBindingsCache", "()Ljava/util/Map;", "setBindingsCache", "(Ljava/util/Map;)V", "ctxRef", "Lorg/bytedeco/llvm/LLVM/LLVMContextRef;", "getCtxRef", "()Lorg/bytedeco/llvm/LLVM/LLVMContextRef;", "setCtxRef", "(Lorg/bytedeco/llvm/LLVM/LLVMContextRef;)V", "declarationHandler", "Lde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler;", "getDeclarationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler;", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "getExpressionHandler", "()Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "phiList", "", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "getPhiList", "()Ljava/util/List;", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "getStatementHandler", "()Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "typeCache", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "getTypeCache", "codeOf", "astNode", "getNameOf", "Lkotlin/Pair;", "valueRef", "getOperandValueAtIndex", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "instr", "idx", "", "guessSlotNumber", "isKnownStructTypeName", "", "name", "locationOf", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "setComment", "", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "typeOf", "type", "typeRef", "alreadyVisited", "typeOf$cpg_language_llvm", "cpg-language-llvm"})
@SourceDebugExtension(value={"SMAP\nLLVMIRLanguageFrontend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLVMIRLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend\n+ 2 LLVMIRLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontendKt\n+ 3 ScopeManager.kt\nde/fraunhofer/aisec/cpg/ScopeManager\n*L\n1#1,302:1\n289#2:303\n785#3:304\n*S KotlinDebug\n*F\n+ 1 LLVMIRLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend\n*L\n167#1:303\n246#1:304\n*E\n"})
public final class LLVMIRLanguageFrontend
extends LanguageFrontend<Pointer, LLVMTypeRef> {
    @NotNull
    private final StatementHandler statementHandler;
    @NotNull
    private final DeclarationHandler declarationHandler;
    @NotNull
    private final ExpressionHandler expressionHandler;
    @NotNull
    private final Map<String, Type> typeCache;
    @NotNull
    private final List<LLVMValueRef> phiList;
    @Nullable
    private LLVMContextRef ctxRef;
    @NotNull
    private Map<String, Declaration> bindingsCache;

    public LLVMIRLanguageFrontend(@NotNull Language<LLVMIRLanguageFrontend> language, @NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(language, ctx);
        this.statementHandler = new StatementHandler(this);
        this.declarationHandler = new DeclarationHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
        this.typeCache = new LinkedHashMap();
        this.phiList = new ArrayList();
        this.bindingsCache = new LinkedHashMap();
    }

    @NotNull
    public final StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    @NotNull
    public final DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    @NotNull
    public final Map<String, Type> getTypeCache() {
        return this.typeCache;
    }

    @NotNull
    public final List<LLVMValueRef> getPhiList() {
        return this.phiList;
    }

    @Nullable
    public final LLVMContextRef getCtxRef() {
        return this.ctxRef;
    }

    public final void setCtxRef(@Nullable LLVMContextRef lLVMContextRef) {
        this.ctxRef = lLVMContextRef;
    }

    @NotNull
    public final Map<String, Declaration> getBindingsCache() {
        return this.bindingsCache;
    }

    public final void setBindingsCache(@NotNull Map<String, Declaration> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.bindingsCache = map;
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Benchmark bench = new Benchmark(((Object)((Object)this)).getClass(), "Parsing sourcefile", false, null, 12, null);
        this.bindingsCache.clear();
        LLVMModuleRef mod = new LLVMModuleRef();
        LLVMMemoryBufferRef buf = new LLVMMemoryBufferRef();
        this.ctxRef = LLVM.LLVMContextCreate();
        LLVM.LLVMContextSetOpaquePointers((LLVMContextRef)this.ctxRef, (int)0);
        ByteBuffer errorMessage = ByteBuffer.allocate(10000);
        int result = LLVM.LLVMCreateMemoryBufferWithContentsOfFile((BytePointer)new BytePointer(((Object)file.toPath()).toString()), (LLVMMemoryBufferRef)buf, (ByteBuffer)errorMessage);
        if (result != 0) {
            byte[] byArray = errorMessage.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            byte[] byArray2 = byArray;
            String errorMsg = new String(byArray2, Charsets.UTF_8);
            LLVM.LLVMContextDispose((LLVMContextRef)this.ctxRef);
            throw new TranslationException("Could not create memory buffer: " + errorMsg);
        }
        result = LLVM.LLVMParseIRInContext((LLVMContextRef)this.ctxRef, (LLVMMemoryBufferRef)buf, (LLVMModuleRef)mod, (ByteBuffer)errorMessage);
        if (result != 0) {
            byte[] byArray = errorMessage.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            byte[] byArray3 = byArray;
            String errorMsg = new String(byArray3, Charsets.UTF_8);
            LLVM.LLVMContextDispose((LLVMContextRef)this.ctxRef);
            throw new TranslationException("Could not parse IR: " + errorMsg);
        }
        MeasurementHolder.addMeasurement$default((MeasurementHolder)((MeasurementHolder)bench), null, null, (int)3, null);
        bench = new Benchmark(((Object)((Object)this)).getClass(), "Transform to CPG", false, null, 12, null);
        TranslationUnitDeclaration tu = DeclarationBuilderKt.newTranslationUnitDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)file.getName(), null, (int)2, null);
        this.getScopeManager().resetToGlobal(tu);
        LLVMValueRef global = LLVM.LLVMGetFirstGlobal((LLVMModuleRef)mod);
        while (global != null) {
            Declaration declaration = (Declaration)this.declarationHandler.handle(global);
            ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)declaration, (boolean)false, (int)2, null);
            global = LLVM.LLVMGetNextGlobal((LLVMValueRef)global);
        }
        LLVMValueRef func = LLVM.LLVMGetFirstFunction((LLVMModuleRef)mod);
        while (func != null) {
            Declaration declaration = (Declaration)this.declarationHandler.handle(func);
            ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)declaration, (boolean)false, (int)2, null);
            func = LLVM.LLVMGetNextFunction((LLVMValueRef)func);
        }
        int counter = 0;
        List flatAST = CollectionsKt.toMutableList((Collection)SubgraphWalker.INSTANCE.flattenAST((Node)tu));
        for (LLVMValueRef phiInstr : this.phiList) {
            this.statementHandler.handlePhi(phiInstr, tu, flatAST);
            ++counter;
        }
        LLVM.LLVMContextDispose((LLVMContextRef)this.ctxRef);
        MeasurementHolder.addMeasurement$default((MeasurementHolder)((MeasurementHolder)bench), null, null, (int)3, null);
        return tu;
    }

    @NotNull
    public Type typeOf(@NotNull LLVMTypeRef type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.typeOf$cpg_language_llvm(type, new LinkedHashMap());
    }

    @NotNull
    public final Pair<String, String> getNameOf(@NotNull LLVMValueRef valueRef) {
        Intrinsics.checkNotNullParameter((Object)valueRef, (String)"valueRef");
        LLVMValueRef $this$name$iv = valueRef;
        boolean $i$f$getName = false;
        String string = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String name = string;
        Object symbolName = LLVMIRLanguageFrontendKt.getSymbolName(valueRef);
        if (Intrinsics.areEqual((Object)name, (Object)"")) {
            name = this.guessSlotNumber(valueRef);
            symbolName = "%" + name;
        }
        return new Pair((Object)name, symbolName);
    }

    @NotNull
    public final Type typeOf(@NotNull LLVMValueRef valueRef) {
        Intrinsics.checkNotNullParameter((Object)valueRef, (String)"valueRef");
        LLVMTypeRef typeRef = LLVM.LLVMTypeOf((LLVMValueRef)valueRef);
        Intrinsics.checkNotNull((Object)typeRef);
        return this.typeOf(typeRef);
    }

    @NotNull
    public final Type typeOf$cpg_language_llvm(@NotNull LLVMTypeRef typeRef, @NotNull Map<LLVMTypeRef, Type> alreadyVisited) {
        Type result;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter(alreadyVisited, (String)"alreadyVisited");
        String typeStr = LLVM.LLVMPrintTypeToString((LLVMTypeRef)typeRef).getString();
        if (this.typeCache.containsKey(typeStr) && (result = this.typeCache.get(typeStr)) != null) {
            return result;
        }
        if (alreadyVisited.containsKey(typeRef)) {
            Type type = alreadyVisited.get(typeRef);
            if (type == null) {
                type = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
            }
            return type;
        }
        alreadyVisited.put(typeRef, null);
        Type res = switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)typeRef)) {
            case 11, 13 -> {
                LLVMTypeRef v1 = LLVM.LLVMGetElementType((LLVMTypeRef)typeRef);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"LLVMGetElementType(...)");
                Type elementType = this.typeOf$cpg_language_llvm(v1, alreadyVisited);
                yield TypeBuilderKt.array((ContextProvider)((ContextProvider)this), (Type)elementType);
            }
            case 12 -> {
                LLVMTypeRef v3 = LLVM.LLVMGetElementType((LLVMTypeRef)typeRef);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"LLVMGetElementType(...)");
                Type elementType = this.typeOf$cpg_language_llvm(v3, alreadyVisited);
                yield TypeBuilderKt.pointer((ContextProvider)((ContextProvider)this), (Type)elementType);
            }
            case 10 -> {
                RecordDeclaration record = this.declarationHandler.handleStructureType(typeRef, alreadyVisited);
                yield record.toType();
            }
            default -> {
                LanguageProvider v4 = (LanguageProvider)this;
                Intrinsics.checkNotNull((Object)typeStr);
                yield TypeBuilderKt.objectType$default((LanguageProvider)v4, (CharSequence)typeStr, null, (int)2, null);
            }
        };
        alreadyVisited.put(typeRef, res);
        Intrinsics.checkNotNull((Object)typeStr);
        this.typeCache.put(typeStr, res);
        return res;
    }

    public static /* synthetic */ Type typeOf$cpg_language_llvm$default(LLVMIRLanguageFrontend lLVMIRLanguageFrontend, LLVMTypeRef lLVMTypeRef, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        return lLVMIRLanguageFrontend.typeOf$cpg_language_llvm(lLVMTypeRef, map);
    }

    @Nullable
    public String codeOf(@NotNull Pointer astNode) {
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        if (astNode instanceof LLVMValueRef) {
            BytePointer code = LLVM.LLVMPrintValueToString((LLVMValueRef)((LLVMValueRef)astNode));
            return code.getString();
        }
        if (astNode instanceof LLVMBasicBlockRef) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)((LLVMBasicBlockRef)astNode));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMBasicBlockAsValue(...)");
            return this.codeOf((Pointer)lLVMValueRef);
        }
        return null;
    }

    @Nullable
    public PhysicalLocation locationOf(@NotNull Pointer astNode) {
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        return null;
    }

    public void setComment(@NotNull Node node, @NotNull Pointer astNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isKnownStructTypeName(@NotNull String name) {
        void stopIfFound$iv;
        void searchScope$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ScopeManager scopeManager = this.getScopeManager();
        Scope scope = (Scope)this.getScopeManager().getGlobalScope();
        boolean bl = true;
        Function1 predicate$iv = (Function1)new Function1<RecordDeclaration, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RecordDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName().toString(), (Object)this.$name);
            }
        };
        boolean $i$f$resolve = false;
        return !((Collection)this_$iv.resolve(RecordDeclaration.class, (Scope)searchScope$iv, (boolean)stopIfFound$iv, predicate$iv)).isEmpty();
    }

    @NotNull
    public final Expression getOperandValueAtIndex(@NotNull LLVMValueRef instr, int idx) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        LLVMValueRef operand = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
        Intrinsics.checkNotNull((Object)operand);
        Node node = this.expressionHandler.handle(operand);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
        return (Expression)node;
    }

    @NotNull
    public final String guessSlotNumber(@NotNull LLVMValueRef valueRef) {
        String string;
        String code;
        Intrinsics.checkNotNullParameter((Object)valueRef, (String)"valueRef");
        String string2 = code = this.codeOf((Pointer)valueRef);
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"=", (boolean)false, (int)2, null) : false;
        if (bl) {
            char[] cArray;
            String[] stringArray = new String[]{"="};
            string = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)code, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null || (string = StringsKt.trim((String)string, (char[])(cArray = new char[]{'%'}))) == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }
}

