/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.RawNodeTypeProvider;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.SubscriptExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0015\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u000e\u0010\u0018\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u00a8\u0006\u001e"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "handleCastInstruction", "instr", "handleConstantDataArrayValue", "valueRef", "handleConstantExprValueKind", "value", "handleConstantFP", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "", "handleConstantInt", "", "handleConstantStructValue", "handleFunction", "handleGetElementPtr", "handleGetElementPtr$cpg_language_llvm", "handleNullPointer", "handleReference", "handleSelect", "handleValue", "initializeAsUndef", "type", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "initializeAsZero", "cpg-language-llvm"})
@SourceDebugExtension(value={"SMAP\nExpressionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler\n+ 2 LLVMIRLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontendKt\n+ 3 ScopeManager.kt\nde/fraunhofer/aisec/cpg/ScopeManager\n*L\n1#1,568:1\n289#2:569\n300#2:570\n785#3:571\n*S KotlinDebug\n*F\n+ 1 ExpressionHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler\n*L\n138#1:569\n415#1:570\n486#1:571\n*E\n"})
public final class ExpressionHandler
extends Handler<Expression, LLVMValueRef, LLVMIRLanguageFrontend> {
    public ExpressionHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(() -> new ProblemExpression(null, null, 3, null), (LanguageFrontend)lang);
        this.getMap().put(LLVMValueRef.class, arg_0 -> ExpressionHandler._init_$lambda$1(this, arg_0));
    }

    private final Expression handleValue(LLVMValueRef value) {
        Expression expression;
        int kind = LLVM.LLVMGetValueKind((LLVMValueRef)value);
        switch (kind) {
            case 10: {
                expression = this.handleConstantExprValueKind(value);
                break;
            }
            case 11: 
            case 12: {
                expression = this.handleConstantStructValue(value);
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                expression = this.handleConstantDataArrayValue(value);
                break;
            }
            case 18: {
                expression = (Expression)this.handleConstantInt(value);
                break;
            }
            case 19: {
                expression = (Expression)this.handleConstantFP(value);
                break;
            }
            case 20: {
                expression = this.handleNullPointer(value);
                break;
            }
            case 25: {
                expression = (Expression)ExpressionBuilderKt.newReference((MetadataProvider)((MetadataProvider)this), (CharSequence)"poison", (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value), (Object)value);
                break;
            }
            case 21: {
                expression = (Expression)ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), null, (Type)TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this)), (Object)value);
                break;
            }
            case 14: {
                expression = this.initializeAsUndef(((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value), value);
                break;
            }
            case 15: {
                expression = this.initializeAsZero(((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value), value);
                break;
            }
            case 0: 
            case 8: 
            case 24: {
                expression = this.handleReference(value);
                break;
            }
            case 5: {
                expression = this.handleFunction(value);
                break;
            }
            case 6: {
                String name = (String)((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(value).getFirst();
                expression = (Expression)ExpressionBuilderKt.newReference((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value), (Object)value);
                break;
            }
            case 22: 
            case 23: {
                return (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)"Metadata or ASM value kind not supported yet", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
            }
            default: {
                Expression expression2;
                Handler.getLog().info("Not handling value kind {} in handleValue yet. Falling back to the legacy way. Please change", (Object)kind);
                Type cpgType = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
                if (LLVM.LLVMIsConstant((LLVMValueRef)value) != 1) {
                    String string;
                    if (LLVM.LLVMIsAGlobalAlias((LLVMValueRef)value) != null || LLVM.LLVMIsGlobalConstant((LLVMValueRef)value) == 1) {
                        LLVMValueRef aliasee = LLVM.LLVMAliasGetAliasee((LLVMValueRef)value);
                        var5_6 = LLVM.LLVMPrintValueToString((LLVMValueRef)aliasee).getString();
                        Intrinsics.checkNotNull((Object)var5_6);
                        string = var5_6;
                    } else {
                        var5_6 = LLVM.LLVMPrintValueToString((LLVMValueRef)value).getString();
                        Intrinsics.checkNotNull((Object)var5_6);
                        string = var5_6;
                    }
                    String operandName = string;
                    expression2 = (Expression)ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)operandName, (Type)cpgType, (Object)value);
                } else if (LLVM.LLVMIsUndef((LLVMValueRef)value) == 1) {
                    expression2 = (Expression)ExpressionBuilderKt.newReference((MetadataProvider)((MetadataProvider)this), (CharSequence)"undef", (Type)cpgType, (Object)value);
                } else if (LLVM.LLVMIsPoison((LLVMValueRef)value) == 1) {
                    expression2 = (Expression)ExpressionBuilderKt.newReference((MetadataProvider)((MetadataProvider)this), (CharSequence)"poison", (Type)cpgType, (Object)value);
                } else {
                    Handler.getLog().error("Unknown expression {}", (Object)kind);
                    expression2 = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)("Unknown expression " + kind), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
                }
                return expression2;
            }
        }
        return expression;
    }

    private final Expression handleFunction(LLVMValueRef valueRef) {
        MetadataProvider metadataProvider = (MetadataProvider)this;
        LLVMValueRef $this$name$iv = valueRef;
        boolean $i$f$getName = false;
        String string = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return (Expression)ExpressionBuilderKt.newReference((MetadataProvider)metadataProvider, (CharSequence)string, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (Object)valueRef);
    }

    private final Expression handleReference(LLVMValueRef valueRef) {
        Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(valueRef);
        String name = (String)namePair.getFirst();
        String symbolName = (String)namePair.getSecond();
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef);
        Reference ref = ExpressionBuilderKt.newReference((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)type, (Object)valueRef);
        Declaration decl = ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().get(symbolName);
        if (decl == null) {
            Handler.getLog().warn("Could not resolve reference " + symbolName + ". This should not happen.");
        } else {
            ref.setRefersTo(decl);
        }
        return (Expression)ref;
    }

    private final Literal<Long> handleConstantInt(LLVMValueRef valueRef) {
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef);
        long value = StringsKt.startsWith$default((String)type.getTypeName(), (String)"ui", (boolean)false, (int)2, null) ? LLVM.LLVMConstIntGetZExtValue((LLVMValueRef)valueRef) : LLVM.LLVMConstIntGetSExtValue((LLVMValueRef)valueRef);
        Literal literal = ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)value, (Type)type, (Object)valueRef);
        literal.setName(new Name(String.valueOf(value), null, null, 6, null));
        return literal;
    }

    private final Literal<Double> handleConstantFP(LLVMValueRef valueRef) {
        int[] losesInfo = new int[1];
        double value = LLVM.LLVMConstRealGetDouble((LLVMValueRef)valueRef, (int[])losesInfo);
        Literal literal = ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)value, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (Object)valueRef);
        literal.setName(new Name(String.valueOf(value), null, null, 6, null));
        return literal;
    }

    private final Expression handleConstantExprValueKind(LLVMValueRef value) {
        Expression expression;
        int kind = LLVM.LLVMGetConstOpcode((LLVMValueRef)value);
        switch (kind) {
            case 29: {
                expression = this.handleGetElementPtr$cpg_language_llvm(value);
                break;
            }
            case 46: {
                expression = this.handleSelect(value);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 60: {
                expression = this.handleCastInstruction(value);
                break;
            }
            case 8: 
            case 9: {
                Statement statement = StatementHandler.handleBinaryOperator$default(((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler(), value, "+", false, false, 8, null);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant binary operation +", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
                break;
            }
            case 10: 
            case 11: {
                Statement statement = StatementHandler.handleBinaryOperator$default(((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler(), value, "-", false, false, 8, null);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant binary operation -", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
                break;
            }
            case 22: {
                Statement statement = StatementHandler.handleBinaryOperator$default(((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler(), value, ">>", false, false, 8, null);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant binary operation >>", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
                break;
            }
            case 42: {
                Statement statement = ((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler().handleIntegerComparison(value);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant comparison", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
                break;
            }
            default: {
                Handler.getLog().error("Not handling constant expression of opcode {} yet", (Object)kind);
                expression = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)("Not handling constant expression of opcode " + kind + " yet"), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)value);
            }
        }
        Expression expr = expression;
        return expr;
    }

    private final Expression handleConstantStructValue(LLVMValueRef value) {
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
        ConstructExpression expr = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)((LLVMIRLanguageFrontend)this.getFrontend()).codeOf((Pointer)value), null, (int)2, null);
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
        int n = LLVM.LLVMGetNumOperands((LLVMValueRef)value);
        for (int i = 0; i < n; ++i) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)value, (int)i);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            Expression arg = (Expression)this.handle(lLVMValueRef);
            if (arg == null) continue;
            expr.addArgument(arg);
        }
        return (Expression)expr;
    }

    private final Expression handleConstantDataArrayValue(LLVMValueRef valueRef) {
        if (LLVM.LLVMIsConstantString((LLVMValueRef)valueRef) == 1) {
            String string = LLVM.LLVMGetAsString((LLVMValueRef)valueRef, (SizeTPointer)new SizeTPointer(0L)).getString();
            return (Expression)ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)string, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (Object)valueRef);
        }
        LLVMTypeRef arrayType = LLVM.LLVMTypeOf((LLVMValueRef)valueRef);
        InitializerListExpression list = ExpressionBuilderKt.newInitializerListExpression((MetadataProvider)((MetadataProvider)this), (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (Object)valueRef);
        int length = LLVM.LLVMIsAConstantDataArray((LLVMValueRef)valueRef) != null ? LLVM.LLVMGetArrayLength((LLVMTypeRef)arrayType) : LLVM.LLVMGetVectorSize((LLVMTypeRef)arrayType);
        List initializers = new ArrayList();
        for (int i = 0; i < length; ++i) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetAggregateElement((LLVMValueRef)valueRef, (int)i);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetAggregateElement(...)");
            Node node = this.handle(lLVMValueRef);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
            Expression expr = (Expression)node;
            ((Collection)initializers).add(expr);
        }
        list.setInitializers(initializers);
        return (Expression)list;
    }

    /*
     * WARNING - void declaration
     */
    private final Expression initializeAsUndef(Type type, LLVMValueRef value) {
        Expression expression;
        if (!((LLVMIRLanguageFrontend)this.getFrontend()).isKnownStructTypeName(type.getName().toString()) && !StringsKt.contains$default((CharSequence)((CharSequence)type.getName()), (CharSequence)"{", (boolean)false, (int)2, null)) {
            expression = (Expression)ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), null, (Type)type, (Object)value);
        } else {
            void var3_3;
            ConstructExpression expr = ExpressionBuilderKt.newConstructExpression((MetadataProvider)((MetadataProvider)this), (CharSequence)((LLVMIRLanguageFrontend)this.getFrontend()).codeOf((Pointer)value), (Object)value);
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            expr.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
            if (expr.getInstantiates() == null) {
                return (Expression)expr;
            }
            Declaration declaration = expr.getInstantiates();
            Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
            for (FieldDeclaration field : ((RecordDeclaration)declaration).getFields()) {
                Expression arg = this.initializeAsUndef(field.getType(), value);
                expr.addArgument(arg);
            }
            expression = (Expression)var3_3;
        }
        return expression;
    }

    /*
     * WARNING - void declaration
     */
    private final Expression initializeAsZero(Type type, LLVMValueRef value) {
        Expression expression;
        if (!((LLVMIRLanguageFrontend)this.getFrontend()).isKnownStructTypeName(type.getName().toString()) && !StringsKt.contains$default((CharSequence)((CharSequence)type.getName()), (CharSequence)"{", (boolean)false, (int)2, null)) {
            expression = (Expression)ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)0, (Type)type, (Object)value);
        } else {
            void var3_3;
            ConstructExpression expr = ExpressionBuilderKt.newConstructExpression((MetadataProvider)((MetadataProvider)this), (CharSequence)((LLVMIRLanguageFrontend)this.getFrontend()).codeOf((Pointer)value), (Object)value);
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            expr.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
            if (expr.getInstantiates() == null) {
                return (Expression)expr;
            }
            Declaration declaration = expr.getInstantiates();
            Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
            for (FieldDeclaration field : ((RecordDeclaration)declaration).getFields()) {
                Expression arg = this.initializeAsZero(field.getType(), value);
                expr.addArgument(arg);
            }
            expression = (Expression)var3_3;
        }
        return expression;
    }

    private final Expression handleNullPointer(LLVMValueRef value) {
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
        return (Expression)ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), null, (Type)type, (Object)value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Expression handleGetElementPtr$cpg_language_llvm(@NotNull LLVMValueRef instr) {
        Expression operand;
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        boolean isGetElementPtr = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 29 || LLVM.LLVMIsAConstantExpr((LLVMValueRef)instr) != null && LLVM.LLVMGetConstOpcode((LLVMValueRef)instr) == 29;
        int numOps = 0;
        int loopStart = 0;
        IntPointer indices = new IntPointer();
        if (isGetElementPtr) {
            numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
            loopStart = 1;
        } else {
            numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
            loopStart = 0;
            IntPointer intPointer = LLVM.LLVMGetIndices((LLVMValueRef)instr);
            Intrinsics.checkNotNullExpressionValue((Object)intPointer, (String)"LLVMGetIndices(...)");
            indices = intPointer;
        }
        Ref.ObjectRef baseType = new Ref.ObjectRef();
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
        baseType.element = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression base = operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression expr = (Expression)ExpressionBuilderKt.newProblemExpression((MetadataProvider)((MetadataProvider)this), (String)"Default node for getelementptr", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (Object)instr);
        for (int idx = loopStart; idx < numOps; ++idx) {
            FieldDeclaration fieldDeclaration;
            String fieldName;
            RecordDeclaration record2;
            Integer index;
            if (isGetElementPtr) {
                operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, idx);
                if (operand instanceof Literal) {
                    Object object = ((Literal)operand).getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    v4 = (int)((Long)object).longValue();
                } else {
                    Expression expression = operand;
                    Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference");
                    v4 = (Reference)expression;
                }
            } else {
                v4 = index = Integer.valueOf(indices.get((long)idx));
            }
            if (baseType.element instanceof PointerType) {
                SubscriptExpression arrayExpr = ExpressionBuilderKt.newSubscriptExpression$default((MetadataProvider)((MetadataProvider)this), null, (int)1, null);
                arrayExpr.setArrayExpression(base);
                arrayExpr.setName(new Name(((Object)index).toString(), null, null, 6, null));
                arrayExpr.setSubscriptExpression(operand);
                expr = (Expression)arrayExpr;
                baseType.element = ((Type)baseType.element).dereference();
                base = expr;
                continue;
            }
            Object object = baseType.element;
            ObjectType objectType = object instanceof ObjectType ? (ObjectType)object : null;
            Object object2 = record2 = objectType != null ? objectType.getRecordDeclaration() : null;
            if (record2 == null) {
                void stopIfFound$iv;
                Object searchScope$iv;
                void this_$iv;
                ScopeManager scopeManager = ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager();
                object = (Scope)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().getGlobalScope();
                boolean bl = true;
                Function1 predicate$iv = (Function1)new Function1<RecordDeclaration, Boolean>((Ref.ObjectRef<Type>)baseType){
                    final /* synthetic */ Ref.ObjectRef<Type> $baseType;
                    {
                        this.$baseType = $baseType;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull RecordDeclaration it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getName(), (Object)((Type)this.$baseType.element).getName());
                    }
                };
                boolean $i$f$resolve = false;
                record2 = (RecordDeclaration)CollectionsKt.firstOrNull((List)this_$iv.resolve(RecordDeclaration.class, (Scope)searchScope$iv, (boolean)stopIfFound$iv, predicate$iv));
                if (record2 != null) {
                    searchScope$iv = baseType.element;
                    ObjectType objectType2 = searchScope$iv instanceof ObjectType ? (ObjectType)searchScope$iv : null;
                    if (objectType2 != null) {
                        objectType2.setRecordDeclaration(record2);
                    }
                }
            }
            if (record2 == null) {
                Handler.getLog().error("Could not find structure type with name {}, cannot continue", (Object)((Type)baseType.element).getTypeName());
                break;
            }
            Handler.getLog().debug("Trying to access a field within the record declaration of {}", (Object)record2.getName());
            FieldDeclaration field = null;
            if (index instanceof Integer) {
                field = (FieldDeclaration)ExtensionsKt.get$default((Collection)record2.getFields(), (String)("field_" + index), null, (int)2, null);
                v9 = field;
                if (v9 == null || (v9 = v9.getName()) == null || (v9 = v9.getLocalName()) == null) {
                    v9 = "";
                }
            } else {
                field = null;
                Expression expression = operand;
                Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference");
                v9 = fieldName = "[" + ((Reference)expression).getName().getLocalName() + "]";
            }
            if ((fieldDeclaration = field) == null || (fieldDeclaration = fieldDeclaration.getType()) == null) {
                fieldDeclaration = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
            }
            baseType.element = fieldDeclaration;
            MetadataProvider metadataProvider = (MetadataProvider)this;
            CharSequence charSequence = fieldName;
            FieldDeclaration fieldDeclaration2 = field;
            if (fieldDeclaration2 == null || (fieldDeclaration2 = fieldDeclaration2.getType()) == null) {
                fieldDeclaration2 = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
            }
            expr = (Expression)ExpressionBuilderKt.newMemberExpression$default((MetadataProvider)metadataProvider, (CharSequence)charSequence, (Expression)base, (Type)fieldDeclaration2, (String)".", null, (int)16, null);
            Handler.getLog().info("{}", (Object)expr);
            base = expr;
        }
        if (isGetElementPtr) {
            UnaryOperator ref = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"&", (boolean)false, (boolean)true, null, (int)8, null);
            ref.setInput(expr);
            expr = (Expression)ref;
        }
        return expr;
    }

    @NotNull
    public final Expression handleSelect(@NotNull LLVMValueRef instr) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        Expression cond = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression value1 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
        Expression value2 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 2);
        return (Expression)ExpressionBuilderKt.newConditionalExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)cond, (Expression)value1, (Expression)value2, (Type)value1.getType(), null, (int)16, null);
    }

    @NotNull
    public final Expression handleCastInstruction(@NotNull LLVMValueRef instr) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        CastExpression castExpr = ExpressionBuilderKt.newCastExpression((MetadataProvider)((MetadataProvider)this), (Object)instr);
        castExpr.setCastType(((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr));
        castExpr.setExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        return (Expression)castExpr;
    }

    private static final Expression _init_$lambda$1(ExpressionHandler this$0, LLVMValueRef it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleValue(it);
    }
}

