/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.llvm.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.StatementBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.annotations.FunctionReplacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0019\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0007J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010,\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\n2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020504J\u0010\u00106\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00107\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00109\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0011H\u0002\u00a8\u0006="}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lorg/bytedeco/javacpp/Pointer;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "assembleGotoStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/GotoStatement;", "instr", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "bbTarget", "declarationOrNot", "rhs", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "valueRef", "getBasicBlockName", "", "bb", "Lorg/bytedeco/llvm/LLVM/LLVMBasicBlockRef;", "handleAlloca", "handleAtomiccmpxchg", "handleAtomicrmw", "handleBasicBlock", "handleBinaryInstruction", "handleBinaryOperator", "op", "unsigned", "", "unordered", "handleBrStatement", "handleCatchpad", "handleCatchret", "handleCatchswitch", "handleCleanuppad", "handleExtractelement", "handleFence", "handleFloatComparison", "handleFreeze", "handleFunctionCall", "handleIndirectbrStatement", "handleInsertValue", "handleInsertelement", "handleInstruction", "handleIntegerComparison", "handleLandingpad", "handleLoad", "handlePhi", "", "tu", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "flatAST", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "handleShufflevector", "handleStore", "handleSwitchStatement", "handleVaArg", "llvmInternalRef", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeclaredReferenceExpression;", "name", "cpg-language-llvm"})
@SourceDebugExtension(value={"SMAP\nStatementHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatementHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler\n+ 2 LLVMIRLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontendKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1689:1\n293#2:1690\n293#2:1691\n293#2:1692\n293#2:1693\n293#2:1694\n293#2:1695\n282#2:1701\n288#3,2:1696\n766#3:1698\n857#3,2:1699\n1#4:1702\n*S KotlinDebug\n*F\n+ 1 StatementHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler\n*L\n73#1:1690\n232#1:1691\n241#1:1692\n431#1:1693\n1131#1:1694\n1160#1:1695\n1421#1:1701\n1385#1:1696,2\n1409#1:1698\n1409#1:1699,2\n*E\n"})
public final class StatementHandler
extends Handler<Statement, Pointer, LLVMIRLanguageFrontend> {
    public StatementHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(() -> new ProblemExpression(null, null, 3, null), (LanguageFrontend)lang);
        this.getMap().put(LLVMValueRef.class, arg_0 -> StatementHandler._init_$lambda$1(this, arg_0));
        this.getMap().put(LLVMBasicBlockRef.class, arg_0 -> StatementHandler._init_$lambda$2(this, arg_0));
    }

    private final Statement handleInstruction(LLVMValueRef instr) {
        if (LLVM.LLVMIsABinaryOperator((LLVMValueRef)instr) != null) {
            return this.handleBinaryInstruction(instr);
        }
        if (LLVM.LLVMIsACastInst((LLVMValueRef)instr) != null) {
            return this.declarationOrNot(((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler().handleCastInstruction(instr), instr);
        }
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        int opcode = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv);
        switch (opcode) {
            case 1: {
                ReturnStatement ret = StatementBuilderKt.newReturnStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
                int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
                if (numOps != 0) {
                    ret.setReturnValue(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
                }
                return (Statement)ret;
            }
            case 2: {
                return this.handleBrStatement(instr);
            }
            case 3: {
                return this.handleSwitchStatement(instr);
            }
            case 4: {
                return this.handleIndirectbrStatement(instr);
            }
            case 5: 
            case 45: {
                return this.handleFunctionCall(instr);
            }
            case 7: {
                return (Statement)StatementBuilderKt.newEmptyStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
            }
            case 67: {
                Handler.getLog().error("Cannot parse callbr instruction yet");
                break;
            }
            case 66: {
                UnaryOperator fneg = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"-", (boolean)false, (boolean)true, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)16, null);
                fneg.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
                return (Statement)fneg;
            }
            case 26: {
                return this.handleAlloca(instr);
            }
            case 27: {
                return this.handleLoad(instr);
            }
            case 28: {
                return this.handleStore(instr);
            }
            case 29: 
            case 53: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler().handleGetElementPtr$cpg_language_llvm(instr), instr);
            }
            case 42: {
                return this.handleIntegerComparison(instr);
            }
            case 43: {
                return this.handleFloatComparison(instr);
            }
            case 44: {
                ((LLVMIRLanguageFrontend)this.getFrontend()).getPhiList().add(instr);
                return (Statement)StatementBuilderKt.newEmptyStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
            }
            case 46: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler().handleSelect(instr), instr);
            }
            case 47: 
            case 48: {
                Handler.getLog().info("userop instruction is not a real instruction. Replacing it with empty statement");
                return (Statement)StatementBuilderKt.newEmptyStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
            }
            case 49: {
                return this.handleVaArg(instr);
            }
            case 50: {
                return this.handleExtractelement(instr);
            }
            case 51: {
                return this.handleInsertelement(instr);
            }
            case 52: {
                return this.handleShufflevector(instr);
            }
            case 54: {
                return this.handleInsertValue(instr);
            }
            case 68: {
                return this.handleFreeze(instr);
            }
            case 55: {
                return this.handleFence(instr);
            }
            case 56: {
                return this.handleAtomiccmpxchg(instr);
            }
            case 57: {
                return this.handleAtomicrmw(instr);
            }
            case 58: {
                return (Statement)ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"throw", (boolean)false, (boolean)true, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)16, null);
            }
            case 59: {
                return this.handleLandingpad(instr);
            }
            case 61: {
                return this.handleCatchret(instr);
            }
            case 62: {
                return this.handleCatchret(instr);
            }
            case 63: {
                return this.handleCatchpad(instr);
            }
            case 64: {
                return this.handleCleanuppad(instr);
            }
            case 65: {
                return this.handleCatchswitch(instr);
            }
        }
        Handler.getLog().error("Not handling instruction opcode {} yet", (Object)opcode);
        return (Statement)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)("Not handling instruction opcode " + opcode + " yet"), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
    }

    private final Statement handleCatchret(LLVMValueRef instr) {
        Statement statement;
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        LLVMValueRef unwindDest = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 62 ? LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1) : (LLVM.LLVMGetUnwindDest((LLVMValueRef)instr) != null ? LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)LLVM.LLVMGetUnwindDest((LLVMValueRef)instr)) : null);
        LLVMValueRef $this$opCode$iv2 = instr;
        boolean $i$f$getOpCode2 = false;
        Name name = new Name(LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv2) == 62 ? "catchret" : "cleanuppad", null, null, 6, null);
        if (unwindDest != null) {
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, unwindDest);
            gotoStatement.setName(name);
            statement = (Statement)gotoStatement;
        } else {
            EmptyStatement emptyStatement = StatementBuilderKt.newEmptyStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
            emptyStatement.setName(name);
            statement = (Statement)emptyStatement;
        }
        return statement;
    }

    @FunctionReplacement(addedFunctions={"llvm.catchswitch", "llvm.matchesCatchpad"}, replaces="catchswitch")
    private final Statement handleCatchswitch(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        Expression parent = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        CompoundStatement compoundStatement = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
        CallExpression dummyCall = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.catchswitch")), (CharSequence)"llvm.catchswitch", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), (boolean)false, null, (int)16, null);
        dummyCall.addArgument(parent, "parent");
        Statement statement = this.declarationOrNot((Expression)dummyCall, instr);
        Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement");
        DeclarationStatement tokenGeneration = (DeclarationStatement)statement;
        compoundStatement.addStatement((Statement)tokenGeneration);
        IfStatement ifStatement = StatementBuilderKt.newIfStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
        IfStatement currentIfStatement = null;
        for (int idx = 1; idx < numOps; ++idx) {
            if (currentIfStatement == null) {
                currentIfStatement = ifStatement;
            } else {
                IfStatement newIf = StatementBuilderKt.newIfStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
                currentIfStatement.setElseStatement((Statement)newIf);
                currentIfStatement = newIf;
            }
            LLVMValueRef bbTarget = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            LLVMValueRef catchpad = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)LLVM.LLVMValueAsBasicBlock((LLVMValueRef)bbTarget));
            int catchOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)catchpad);
            CallExpression matchesCatchpad = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.matchesCatchpad")), (CharSequence)"llvm.matchesCatchpad", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), (boolean)false, null, (int)16, null);
            LLVMValueRef parentCatchSwitch = LLVM.LLVMGetParentCatchSwitch((LLVMValueRef)catchpad);
            ExpressionHandler expressionHandler = ((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler();
            Intrinsics.checkNotNull((Object)parentCatchSwitch);
            Node node = expressionHandler.handle(parentCatchSwitch);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
            Expression catchswitch = (Expression)node;
            matchesCatchpad.addArgument(catchswitch, "parentCatchswitch");
            for (int i = 0; i < catchOps; ++i) {
                LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
                Intrinsics.checkNotNull((Object)catchpad);
                Expression arg = lLVMIRLanguageFrontend.getOperandValueAtIndex(catchpad, i);
                matchesCatchpad.addArgument(arg, "args_" + i);
            }
            currentIfStatement.setCondition((Expression)matchesCatchpad);
            Intrinsics.checkNotNull((Object)bbTarget);
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, bbTarget);
            currentIfStatement.setThenStatement((Statement)gotoStatement);
        }
        LLVMBasicBlockRef unwindDest = LLVM.LLVMGetUnwindDest((LLVMValueRef)instr);
        if (unwindDest != null) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)unwindDest);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMBasicBlockAsValue(...)");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, lLVMValueRef);
            if (currentIfStatement == null) {
                currentIfStatement = ifStatement;
            }
            currentIfStatement.setElseStatement((Statement)gotoStatement);
        } else {
            UnaryOperator throwOperation = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"throw", (boolean)false, (boolean)true, (String)nodeCode, null, (int)16, null);
            IfStatement ifStatement2 = currentIfStatement;
            if (ifStatement2 != null) {
                ifStatement2.setElseStatement((Statement)throwOperation);
            }
        }
        compoundStatement.addStatement((Statement)ifStatement);
        return (Statement)compoundStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.cleanuppad"}, replaces="cleanuppad")
    private final Statement handleCleanuppad(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)instr);
        Expression catchswitch = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        CallExpression dummyCall = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.cleanuppad")), (CharSequence)"llvm.cleanuppad", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), (boolean)false, null, (int)16, null);
        dummyCall.addArgument(catchswitch, "parentCatchswitch");
        for (int i = 1; i < numOps; ++i) {
            Expression arg = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, i);
            dummyCall.addArgument(arg, "args_" + (i - 1));
        }
        return this.declarationOrNot((Expression)dummyCall, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.catchpad"}, replaces="catchpad")
    private final Statement handleCatchpad(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)instr);
        LLVMValueRef parentCatchSwitch = LLVM.LLVMGetParentCatchSwitch((LLVMValueRef)instr);
        ExpressionHandler expressionHandler = ((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler();
        Intrinsics.checkNotNull((Object)parentCatchSwitch);
        Node node = expressionHandler.handle(parentCatchSwitch);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
        Expression catchswitch = (Expression)node;
        CallExpression dummyCall = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.catchpad")), (CharSequence)"llvm.catchpad", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), (boolean)false, null, (int)16, null);
        dummyCall.addArgument(catchswitch, "parentCatchswitch");
        for (int i = 0; i < numOps; ++i) {
            Expression arg = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, i);
            dummyCall.addArgument(arg, "args_" + i);
        }
        return this.declarationOrNot((Expression)dummyCall, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.va_arg"}, replaces="va_arg")
    private final Statement handleVaArg(LLVMValueRef instr) {
        CallExpression callExpr = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.va_arg")), (CharSequence)"llvm.va_arg", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), (boolean)false, null, (int)16, null);
        Expression operandName = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        callExpr.addArgument(operandName);
        Type expectedType = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr);
        Literal typeLiteral = ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)expectedType, (Type)expectedType, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
        callExpr.addArgument((Expression)typeLiteral);
        return this.declarationOrNot((Expression)callExpr, instr);
    }

    private final Statement handleBinaryInstruction(LLVMValueRef instr) {
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        switch (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv)) {
            case 8: 
            case 9: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "+", false, false, 8, null);
            }
            case 10: 
            case 11: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "-", false, false, 8, null);
            }
            case 12: 
            case 13: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "*", false, false, 8, null);
            }
            case 14: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", true, false, 8, null);
            }
            case 15: 
            case 16: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", false, false, 8, null);
            }
            case 17: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", true, false, 8, null);
            }
            case 18: 
            case 19: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", false, false, 8, null);
            }
            case 20: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "<<", false, false, 8, null);
            }
            case 21: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", true, false, 8, null);
            }
            case 22: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", false, false, 8, null);
            }
            case 23: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "&", false, false, 8, null);
            }
            case 24: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "|", false, false, 8, null);
            }
            case 25: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "^", false, false, 8, null);
            }
        }
        return (Statement)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Not opcode found for binary operator", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
    }

    private final Statement handleAlloca(LLVMValueRef instr) {
        ArrayCreationExpression array = ExpressionBuilderKt.newArrayCreationExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
        array.setType(((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr));
        Expression size = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        array.addDimension(size);
        return this.declarationOrNot((Expression)array, instr);
    }

    private final Statement handleStore(LLVMValueRef instr) {
        BinaryOperator binOp = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"=", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)4, null);
        UnaryOperator dereference = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)"", null, (int)16, null);
        dereference.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1));
        binOp.setLhs((Expression)dereference);
        binOp.setRhs(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        return (Statement)binOp;
    }

    private final Statement handleLoad(LLVMValueRef instr) {
        UnaryOperator ref = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)"", null, (int)16, null);
        ref.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        return this.declarationOrNot((Expression)ref, instr);
    }

    @NotNull
    public final Statement handleIntegerComparison(@NotNull LLVMValueRef instr) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        boolean unsigned = false;
        String cmpPred = switch (LLVM.LLVMGetICmpPredicate((LLVMValueRef)instr)) {
            case 32 -> "==";
            case 33 -> "!=";
            case 34 -> {
                unsigned = true;
                yield ">";
            }
            case 35 -> {
                unsigned = true;
                yield ">=";
            }
            case 36 -> {
                unsigned = true;
                yield "<";
            }
            case 37 -> {
                unsigned = true;
                yield "<=";
            }
            case 38 -> ">";
            case 39 -> ">=";
            case 40 -> "<";
            case 41 -> "<=";
            default -> "unknown";
        };
        return StatementHandler.handleBinaryOperator$default(this, instr, cmpPred, unsigned, false, 8, null);
    }

    private final Statement handleFloatComparison(LLVMValueRef instr) {
        String string;
        boolean unordered = false;
        switch (LLVM.LLVMGetFCmpPredicate((LLVMValueRef)instr)) {
            case 0: {
                return (Statement)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)false, (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"i1", (boolean)false, (int)2, null), (String)"false", null, (int)8, null);
            }
            case 1: {
                string = "==";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = ">=";
                break;
            }
            case 4: {
                string = "<";
                break;
            }
            case 5: {
                string = "<=";
                break;
            }
            case 6: {
                string = "!=";
                break;
            }
            case 7: {
                string = "ord";
                break;
            }
            case 8: {
                string = "uno";
                break;
            }
            case 9: {
                unordered = true;
                string = "==";
                break;
            }
            case 10: {
                unordered = true;
                string = ">";
                break;
            }
            case 11: {
                unordered = true;
                string = ">=";
                break;
            }
            case 12: {
                unordered = true;
                string = "<";
                break;
            }
            case 13: {
                unordered = true;
                string = "<=";
                break;
            }
            case 14: {
                unordered = true;
                string = "!=";
                break;
            }
            case 15: {
                return (Statement)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)true, (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"i1", (boolean)false, (int)2, null), (String)"true", null, (int)8, null);
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return this.handleBinaryOperator(instr, cmpPred, false, unordered);
    }

    private final Statement handleInsertValue(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
        IntPointer indices = LLVM.LLVMGetIndices((LLVMValueRef)instr);
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
        Type baseType = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression valueToSet = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
        Expression base = operand;
        Statement copy = (Statement)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Default statement for insertvalue", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
        if (!(operand instanceof ConstructExpression) && (copy = this.declarationOrNot(operand, instr)) instanceof DeclarationStatement) {
            MetadataProvider metadataProvider = (MetadataProvider)this;
            Declaration declaration = ((DeclarationStatement)copy).getSingleDeclaration();
            CharSequence charSequence = declaration != null && (declaration = declaration.getName()) != null ? declaration.getLocalName() : null;
            Declaration declaration2 = ((DeclarationStatement)copy).getSingleDeclaration();
            VariableDeclaration variableDeclaration = declaration2 instanceof VariableDeclaration ? (VariableDeclaration)declaration2 : null;
            if (variableDeclaration == null || (variableDeclaration = variableDeclaration.getType()) == null) {
                variableDeclaration = (Type)NodeBuilderKt.newUnknownType((MetadataProvider)((MetadataProvider)this));
            }
            base = (Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)metadataProvider, (CharSequence)charSequence, (Type)variableDeclaration, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
        }
        Expression expr = null;
        for (int idx = 0; idx < numOps; ++idx) {
            RecordDeclaration record2;
            int index = indices.get((long)idx);
            if (base instanceof ConstructExpression) {
                if (idx == numOps - 1) {
                    ((ConstructExpression)base).setArgument(index, valueToSet);
                    return this.declarationOrNot(operand, instr);
                }
                base = (Expression)((ConstructExpression)base).getArguments().get(index);
                continue;
            }
            if (baseType instanceof PointerType) {
                ArraySubscriptionExpression arrayExpr = ExpressionBuilderKt.newArraySubscriptionExpression$default((MetadataProvider)((MetadataProvider)this), (String)"", null, (int)2, null);
                arrayExpr.setArrayExpression(base);
                arrayExpr.setName(new Name(String.valueOf(index), null, null, 6, null));
                arrayExpr.setSubscriptExpression(operand);
                expr = (Expression)arrayExpr;
                baseType = baseType.dereference();
                base = expr;
                continue;
            }
            Type type = baseType;
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            Object object = record2 = objectType != null ? objectType.getRecordDeclaration() : null;
            if (record2 == null) {
                Handler.getLog().error("Could not find structure type with name {}, cannot continue", (Object)baseType.getTypeName());
                break;
            }
            Handler.getLog().debug("Trying to access a field within the record declaration of " + record2.getName());
            FieldDeclaration field = (FieldDeclaration)ExtensionsKt.get$default((Collection)record2.getFields(), (String)("field_" + index), null, (int)2, null);
            FieldDeclaration fieldDeclaration = field;
            if (fieldDeclaration == null || (fieldDeclaration = fieldDeclaration.getType()) == null) {
                fieldDeclaration = (Type)NodeBuilderKt.newUnknownType((MetadataProvider)((MetadataProvider)this));
            }
            baseType = fieldDeclaration;
            FieldDeclaration fieldDeclaration2 = field;
            expr = (Expression)ExpressionBuilderKt.newMemberExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)(fieldDeclaration2 != null && (fieldDeclaration2 = fieldDeclaration2.getName()) != null ? fieldDeclaration2.getLocalName() : null), (Expression)base, (Type)baseType, (String)".", (String)"", null, (int)32, null);
            Handler.getLog().info("{}", (Object)expr);
            base = expr;
        }
        CompoundStatement compoundStatement = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
        BinaryOperator assignment = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"=", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)4, null);
        assignment.setLhs(base);
        assignment.setRhs(valueToSet);
        compoundStatement.addStatement(copy);
        compoundStatement.addStatement((Statement)assignment);
        return (Statement)compoundStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.freeze"}, replaces="freeze")
    private final Statement handleFreeze(LLVMValueRef instr) {
        Expression operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        String instrCode = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        BinaryOperator condition = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"&&", (String)instrCode, null, (int)4, null);
        BinaryOperator undefCheck = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"!=", (String)instrCode, null, (int)4, null);
        undefCheck.setLhs(operand);
        undefCheck.setRhs((Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), null, (Type)operand.getType(), (String)instrCode, null, (int)8, null));
        condition.setLhs((Expression)undefCheck);
        BinaryOperator poisonCheck = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"!=", (String)instrCode, null, (int)4, null);
        poisonCheck.setLhs(operand);
        poisonCheck.setRhs((Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)"POISON", (Type)operand.getType(), (String)instrCode, null, (int)8, null));
        condition.setRhs((Expression)poisonCheck);
        CallExpression callExpression = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.freeze")), (CharSequence)"llvm.freeze", (String)instrCode, (boolean)false, null, (int)16, null);
        callExpression.addArgument(operand);
        ConditionalExpression conditional = ExpressionBuilderKt.newConditionalExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)condition), (Expression)operand, (Expression)((Expression)callExpression), (Type)operand.getType(), null, null, (int)48, null);
        return this.declarationOrNot((Expression)conditional, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.fence"}, replaces="fence")
    private final Statement handleFence(LLVMValueRef instr) {
        String instrString = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        CallExpression callExpression = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("llvm.fence")), (CharSequence)"llvm.fence", (String)instrString, (boolean)false, null, (int)16, null);
        Literal ordering = ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)LLVM.LLVMGetOrdering((LLVMValueRef)instr), (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"i32", (boolean)false, (int)2, null), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
        callExpression.addArgument((Expression)ordering, "ordering");
        String string = instrString;
        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"syncscope", (boolean)false, (int)2, null) : false;
        if (bl) {
            String[] stringArray = new String[]{"\""};
            String syncscope = (String)StringsKt.split$default((CharSequence)instrString, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            callExpression.addArgument((Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)syncscope, (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"String", (boolean)false, (int)2, null), (String)instrString, null, (int)8, null), "syncscope");
        }
        return (Statement)callExpression;
    }

    private final Statement handleAtomiccmpxchg(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        compoundStatement.setName(new Name("atomiccmpxchg", null, null, 6, null));
        Expression ptr = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression cmp = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
        Expression value = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 2);
        UnaryOperator ptrDerefCmp = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
        ptrDerefCmp.setInput(ptr);
        BinaryOperator cmpExpr = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"==", (String)instrStr, null, (int)4, null);
        cmpExpr.setLhs((Expression)ptrDerefCmp);
        cmpExpr.setRhs(cmp);
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            Type targetType = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr);
            ConstructExpression construct = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)"", null, null, (int)6, null);
            ObjectType objectType = targetType instanceof ObjectType ? (ObjectType)targetType : null;
            construct.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
            UnaryOperator ptrDerefConstruct = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
            ptrDerefConstruct.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
            UnaryOperator ptrDerefCmpConstruct = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
            ptrDerefCmpConstruct.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
            BinaryOperator cmpExprConstruct = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"==", (String)instrStr, null, (int)4, null);
            cmpExprConstruct.setLhs((Expression)ptrDerefCmpConstruct);
            cmpExprConstruct.setRhs(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1));
            construct.addArgument((Expression)ptrDerefConstruct);
            construct.addArgument((Expression)cmpExprConstruct);
            Statement decl = this.declarationOrNot((Expression)construct, instr);
            compoundStatement.addStatement(decl);
        }
        UnaryOperator ptrDerefAssign = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
        ptrDerefAssign.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        BinaryOperator assignment = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"=", (String)instrStr, null, (int)4, null);
        assignment.setLhs((Expression)ptrDerefAssign);
        assignment.setRhs(value);
        IfStatement ifStatement = StatementBuilderKt.newIfStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        ifStatement.setCondition((Expression)cmpExpr);
        ifStatement.setThenStatement((Statement)assignment);
        compoundStatement.addStatement((Statement)ifStatement);
        return (Statement)compoundStatement;
    }

    private final Statement handleAtomicrmw(LLVMValueRef instr) {
        Statement statement;
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        String instrStr = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        int operation = LLVM.LLVMGetAtomicRMWBinOp((LLVMValueRef)instr);
        Expression ptr = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression value = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
        Type ty = value.getType();
        BinaryOperator exchOp = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"=", (String)instrStr, null, (int)4, null);
        exchOp.setName(new Name("atomicrmw", null, null, 6, null));
        UnaryOperator ptrDeref = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
        ptrDeref.setInput(ptr);
        UnaryOperator ptrDerefExch = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
        ptrDerefExch.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        exchOp.setLhs((Expression)ptrDerefExch);
        switch (operation) {
            case 0: {
                exchOp.setRhs(value);
                break;
            }
            case 1: 
            case 11: {
                BinaryOperator binaryOperator = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"+", (String)instrStr, null, (int)4, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 2: 
            case 12: {
                BinaryOperator binaryOperator = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"-", (String)instrStr, null, (int)4, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 3: {
                BinaryOperator binaryOperator = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"&", (String)instrStr, null, (int)4, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 4: {
                BinaryOperator binaryOperator = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"|", (String)instrStr, null, (int)4, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                UnaryOperator unaryOperator = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"~", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
                unaryOperator.setInput((Expression)binaryOperator);
                exchOp.setRhs((Expression)unaryOperator);
                break;
            }
            case 5: {
                BinaryOperator binaryOperator = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"|", (String)instrStr, null, (int)4, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 6: {
                BinaryOperator binaryOperator = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"^", (String)instrStr, null, (int)4, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 7: 
            case 8: {
                String operatorCode = operation == 8 ? "<" : ">";
                BinaryOperator condition = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)operatorCode, (String)instrStr, null, (int)4, null);
                condition.setLhs((Expression)ptrDeref);
                condition.setRhs(value);
                UnaryOperator ptrDerefConditional = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
                ptrDerefConditional.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
                ConditionalExpression conditional = ExpressionBuilderKt.newConditionalExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)condition), (Expression)((Expression)ptrDerefConditional), (Expression)value, (Type)ty, null, null, (int)48, null);
                exchOp.setRhs((Expression)conditional);
                break;
            }
            case 9: 
            case 10: {
                String operatorCode = operation == 10 ? "<" : ">";
                BinaryOperator condition = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)operatorCode, (String)instrStr, null, (int)4, null);
                CastExpression castExprLhs = ExpressionBuilderKt.newCastExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
                castExprLhs.setCastType(NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)("u" + ty.getName()), (boolean)false, (int)2, null));
                castExprLhs.setExpression((Expression)ptrDeref);
                condition.setLhs((Expression)castExprLhs);
                CastExpression castExprRhs = ExpressionBuilderKt.newCastExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
                castExprRhs.setCastType(NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)("u" + ty.getName()), (boolean)false, (int)2, null));
                castExprRhs.setExpression(value);
                condition.setRhs((Expression)castExprRhs);
                UnaryOperator ptrDerefConditional = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
                ptrDerefConditional.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
                ConditionalExpression conditional = ExpressionBuilderKt.newConditionalExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)condition), (Expression)((Expression)ptrDerefConditional), (Expression)value, (Type)ty, null, null, (int)48, null);
                exchOp.setRhs((Expression)conditional);
                break;
            }
            default: {
                throw new TranslationException("LLVMAtomicRMWBinOp " + operation + " not supported");
            }
        }
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            CompoundStatement compoundStatement = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
            UnaryOperator ptrDerefAssignment = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)true, (String)instrStr, null, (int)16, null);
            ptrDerefAssignment.setInput(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
            Object[] objectArray = new Statement[]{this.declarationOrNot((Expression)ptrDerefAssignment, instr), exchOp};
            compoundStatement.setStatements(CollectionsKt.listOf((Object[])objectArray));
            statement = (Statement)compoundStatement;
        } else {
            statement = (Statement)exchOp;
        }
        return statement;
    }

    private final Statement handleIndirectbrStatement(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        if (numOps < 2) {
            throw new TranslationException("Indirectbr statement without address and at least one target");
        }
        Expression address = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = StatementBuilderKt.newSwitchStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
        switchStatement.setSelector(address);
        CompoundStatement caseStatements = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
        for (int idx = 1; idx < numOps; ++idx) {
            long caseBBAddress = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx)).address();
            CaseStatement caseStatement = StatementBuilderKt.newCaseStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
            caseStatement.setCaseExpression((Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)caseBBAddress, (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"i64", (boolean)false, (int)2, null), (String)nodeCode, null, (int)8, null));
            caseStatements.addStatement((Statement)caseStatement);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, lLVMValueRef);
            caseStatements.addStatement((Statement)gotoStatement);
        }
        switchStatement.setStatement((Statement)caseStatements);
        return (Statement)switchStatement;
    }

    private final Statement handleBrStatement(LLVMValueRef instr) {
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 3) {
            IfStatement ifStatement = StatementBuilderKt.newIfStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
            Expression condition = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
            ifStatement.setCondition(condition);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            ifStatement.setElseStatement((Statement)this.assembleGotoStatement(instr, lLVMValueRef));
            LLVMValueRef lLVMValueRef2 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef2, (String)"LLVMGetOperand(...)");
            ifStatement.setThenStatement((Statement)this.assembleGotoStatement(instr, lLVMValueRef2));
            return (Statement)ifStatement;
        }
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 1) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            return (Statement)this.assembleGotoStatement(instr, lLVMValueRef);
        }
        throw new TranslationException("Wrong number of operands in br statement");
    }

    private final Statement handleSwitchStatement(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        if (numOps < 2 || numOps % 2 != 0) {
            throw new TranslationException("Switch statement without operand and default branch");
        }
        Expression operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = StatementBuilderKt.newSwitchStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
        switchStatement.setSelector(operand);
        CompoundStatement caseStatements = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
        for (int idx = 2; idx < numOps; ++idx) {
            CaseStatement caseStatement = StatementBuilderKt.newCaseStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null);
            caseStatement.setCaseExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, idx));
            caseStatements.addStatement((Statement)caseStatement);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)(++idx));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, lLVMValueRef);
            caseStatements.addStatement((Statement)gotoStatement);
        }
        caseStatements.addStatement((Statement)StatementBuilderKt.newDefaultStatement$default((MetadataProvider)((MetadataProvider)this), (String)nodeCode, null, (int)2, null));
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
        GotoStatement defaultGoto = this.assembleGotoStatement(instr, lLVMValueRef);
        caseStatements.addStatement((Statement)defaultGoto);
        switchStatement.setStatement((Statement)caseStatements);
        return (Statement)switchStatement;
    }

    private final Statement handleFunctionCall(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        LLVMValueRef calledFunc = LLVM.LLVMGetCalledValue((LLVMValueRef)instr);
        String string = LLVM.LLVMGetValueName((LLVMValueRef)calledFunc).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        CharSequence calledFuncName = string;
        int max = LLVM.LLVMGetNumOperands((LLVMValueRef)instr) - 1;
        int idx = 0;
        if (Intrinsics.areEqual((Object)calledFuncName, (Object)"")) {
            Expression opName = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, max);
            calledFuncName = (CharSequence)opName.getName();
        }
        GotoStatement gotoCatch = StatementBuilderKt.newGotoStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        GotoStatement tryContinue = StatementBuilderKt.newGotoStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 5) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)(--max));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            gotoCatch = this.assembleGotoStatement(instr, lLVMValueRef);
            LLVMValueRef lLVMValueRef2 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)(--max));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef2, (String)"LLVMGetOperand(...)");
            tryContinue = this.assembleGotoStatement(instr, lLVMValueRef2);
            --max;
            Handler.getLog().info("Invoke expression: Usually continues at " + tryContinue.getLabelName() + ", exception continues at " + gotoCatch.getLabelName());
        }
        MetadataProvider metadataProvider = (MetadataProvider)this;
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
        Intrinsics.checkNotNull((Object)calledFunc);
        DeclaredReferenceExpression callee = ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)metadataProvider, (CharSequence)calledFuncName, (Type)lLVMIRLanguageFrontend.typeOf(calledFunc), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(calledFunc), null, (int)8, null);
        CallExpression callExpr = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)callee), (CharSequence)calledFuncName, (String)instrStr, (boolean)false, null, (int)16, null);
        while (idx < max) {
            Expression operandName = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, idx);
            callExpr.addArgument(operandName);
            ++idx;
        }
        LLVMValueRef $this$opCode$iv2 = instr;
        boolean $i$f$getOpCode2 = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv2) == 5) {
            TryStatement tryStatement = StatementBuilderKt.newTryStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().enterScope((Node)tryStatement);
            CompoundStatement tryBlock = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
            tryBlock.addStatement(this.declarationOrNot((Expression)callExpr, instr));
            tryBlock.addStatement((Statement)tryContinue);
            tryStatement.setTryBlock(tryBlock);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().leaveScope((Node)tryStatement);
            CatchClause catchClause = StatementBuilderKt.newCatchClause$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
            catchClause.setName(new Name(gotoCatch.getLabelName(), null, null, 6, null));
            catchClause.setParameter(DeclarationBuilderKt.newVariableDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)("e_" + gotoCatch.getLabelName()), (Type)((Type)NodeBuilderKt.newUnknownType((MetadataProvider)((MetadataProvider)this))), (String)instrStr, (boolean)true, (Object)((LLVMIRLanguageFrontend)this.getFrontend()).getLanguage()));
            CompoundStatement catchCompoundStatement = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
            catchCompoundStatement.addStatement((Statement)gotoCatch);
            catchClause.setBody(catchCompoundStatement);
            Object[] objectArray = new CatchClause[]{catchClause};
            tryStatement.setCatchClauses(CollectionsKt.mutableListOf((Object[])objectArray));
            return (Statement)tryStatement;
        }
        return this.declarationOrNot((Expression)callExpr, instr);
    }

    private final Statement handleLandingpad(LLVMValueRef instr) {
        String lhs;
        CatchClause catchInstr = StatementBuilderKt.newCatchClause$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
        int numClauses = LLVM.LLVMGetNumClauses((LLVMValueRef)instr);
        Object catchType = "";
        for (int i = 0; i < numClauses; ++i) {
            LLVMValueRef clause = LLVM.LLVMGetClause((LLVMValueRef)instr, (int)i);
            if (LLVM.LLVMIsAConstantArray((LLVMValueRef)clause) != null) continue;
            catchType = (String)catchType + (String)(LLVM.LLVMIsNull((LLVMValueRef)clause) == 1 ? "... | " : LLVM.LLVMGetValueName((LLVMValueRef)clause).getString() + " | ");
        }
        if (StringsKt.endsWith$default((String)catchType, (String)" | ", (boolean)false, (int)2, null)) {
            String string = ((String)catchType).substring(0, ((String)catchType).length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            catchType = string;
        }
        String exceptionName = !Intrinsics.areEqual((Object)(lhs = (String)((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(instr).getFirst()), (Object)"") ? lhs : "e_" + instr.address();
        VariableDeclaration except = DeclarationBuilderKt.newVariableDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)exceptionName, (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)((CharSequence)catchType), (boolean)false, (int)2, null), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), (boolean)false, (Object)((LLVMIRLanguageFrontend)this.getFrontend()).getLanguage());
        ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put("%" + exceptionName, (Declaration)except);
        catchInstr.setParameter(except);
        catchInstr.setName(new Name((String)catchType, null, null, 6, null));
        return (Statement)catchInstr;
    }

    private final Statement handleInsertelement(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        Statement newArrayDecl = this.declarationOrNot(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0), instr);
        compoundStatement.addStatement(newArrayDecl);
        Object e = newArrayDecl.getDeclarations().get(0);
        VariableDeclaration decl = e instanceof VariableDeclaration ? (VariableDeclaration)e : null;
        ArraySubscriptionExpression arrayExpr = ExpressionBuilderKt.newArraySubscriptionExpression$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        MetadataProvider metadataProvider = (MetadataProvider)this;
        Object object = decl;
        if (object == null || (object = object.getName()) == null || (object = object.toString()) == null) {
            object = "";
        }
        CharSequence charSequence = (CharSequence)object;
        VariableDeclaration variableDeclaration = decl;
        if (variableDeclaration == null || (variableDeclaration = variableDeclaration.getType()) == null) {
            variableDeclaration = (Type)NodeBuilderKt.newUnknownType((MetadataProvider)((MetadataProvider)this));
        }
        arrayExpr.setArrayExpression((Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)metadataProvider, (CharSequence)charSequence, (Type)variableDeclaration, (String)instrStr, null, (int)8, null));
        arrayExpr.setSubscriptExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 2));
        BinaryOperator binaryExpr = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"=", (String)instrStr, null, (int)4, null);
        binaryExpr.setLhs((Expression)arrayExpr);
        binaryExpr.setRhs(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1));
        compoundStatement.addStatement((Statement)binaryExpr);
        return (Statement)compoundStatement;
    }

    private final Statement handleExtractelement(LLVMValueRef instr) {
        ArraySubscriptionExpression arrayExpr = ExpressionBuilderKt.newArraySubscriptionExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
        arrayExpr.setArrayExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        arrayExpr.setSubscriptExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1));
        return this.declarationOrNot((Expression)arrayExpr, instr);
    }

    private final Statement handleShufflevector(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        InitializerListExpression list = ExpressionBuilderKt.newInitializerListExpression$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
        Type elementType = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr).dereference();
        List initializers = new ArrayList();
        Expression array1 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        int array1Length = array1 instanceof Literal && ((Literal)array1).getValue() == null ? 0 : LLVM.LLVMGetVectorSize((LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0)));
        Expression array2 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
        int array2Length = array2 instanceof Literal && ((Literal)array2).getValue() == null ? 0 : LLVM.LLVMGetVectorSize((LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1)));
        int indices = LLVM.LLVMGetNumMaskElements((LLVMValueRef)instr);
        for (int idx = 0; idx < indices; ++idx) {
            ArraySubscriptionExpression arrayExpr;
            int idxInt = LLVM.LLVMGetMaskValue((LLVMValueRef)instr, (int)idx);
            if (idxInt < array1Length) {
                if (array1 instanceof InitializerListExpression) {
                    ((Collection)initializers).add(((InitializerListExpression)array1).getInitializers().get(idxInt));
                    continue;
                }
                if (array1 instanceof Literal && ((Literal)array1).getValue() == null) {
                    ((Collection)initializers).add(ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), null, (Type)elementType, (String)instrStr, null, (int)8, null));
                    continue;
                }
                arrayExpr = ExpressionBuilderKt.newArraySubscriptionExpression$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
                arrayExpr.setArrayExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
                arrayExpr.setSubscriptExpression((Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)idxInt, (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"i32", (boolean)false, (int)2, null), (String)instrStr, null, (int)8, null));
                ((Collection)initializers).add(arrayExpr);
                continue;
            }
            if (idxInt < array1Length + array2Length) {
                if (array2 instanceof InitializerListExpression) {
                    ((Collection)initializers).add(((InitializerListExpression)array2).getInitializers().get(idxInt - array1Length));
                    continue;
                }
                if (array2 instanceof Literal && ((Literal)array2).getValue() == null) {
                    ((Collection)initializers).add(ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), null, (Type)elementType, (String)instrStr, null, (int)8, null));
                    continue;
                }
                arrayExpr = ExpressionBuilderKt.newArraySubscriptionExpression$default((MetadataProvider)((MetadataProvider)this), (String)instrStr, null, (int)2, null);
                arrayExpr.setArrayExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1));
                arrayExpr.setSubscriptExpression((Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)(idxInt - array1Length), (Type)NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)"i32", (boolean)false, (int)2, null), (String)instrStr, null, (int)8, null));
                ((Collection)initializers).add(arrayExpr);
                continue;
            }
            ((Collection)initializers).add(ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), null, (Type)elementType, (String)instrStr, null, (int)8, null));
        }
        list.setInitializers(initializers);
        return this.declarationOrNot((Expression)list, instr);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void handlePhi(@NotNull LLVMValueRef instr, @NotNull TranslationUnitDeclaration tu, @NotNull List<Node> flatAST) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
        Intrinsics.checkNotNullParameter(flatAST, (String)"flatAST");
        labelMap = new LinkedHashMap<K, V>();
        numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        i = 0;
        bbsFunction = null;
        while (i < numOps) {
            block15: {
                valI = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, i);
                incomingBB = LLVM.LLVMGetIncomingBlock((LLVMValueRef)instr, (int)i);
                if (bbsFunction == null) {
                    bbsFunction = LLVM.LLVMGetBasicBlockParent((LLVMBasicBlockRef)incomingBB);
                } else if (bbsFunction.address() != LLVM.LLVMGetBasicBlockParent((LLVMBasicBlockRef)incomingBB).address()) {
                    Handler.getLog().error("The basic blocks of the phi instructions are in different functions. Can't handle this!");
                    throw new TranslationException("The basic blocks of the phi instructions are in different functions.");
                }
                Intrinsics.checkNotNull((Object)incomingBB);
                labelName = this.getBasicBlockName(incomingBB);
                $this$firstOrNull$iv = flatAST;
                $i$f$firstOrNull = false;
                var14_20 = $this$firstOrNull$iv.iterator();
                while (var14_20.hasNext()) {
                    element$iv /* !! */  = var14_20.next();
                    s = (Node)element$iv /* !! */ ;
                    $i$a$-firstOrNull-StatementHandler$handlePhi$labelI$1 = false;
                    if (!(s instanceof LabelStatement != false && Intrinsics.areEqual((Object)((LabelStatement)s).getLabel(), (Object)labelName) != false)) continue;
                    v0 /* !! */  = element$iv /* !! */ ;
                    break block15;
                }
                v0 /* !! */  = null;
            }
            labelI = (Node)v0 /* !! */ ;
            ++i;
            if (labelI == null) {
                Handler.getLog().error("Expecting to find a label with name " + labelName + " for Phi statement.");
            }
            Intrinsics.checkNotNull((Object)labelI, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.LabelStatement");
            labelMap.put((LabelStatement)labelI, valI);
        }
        if (labelMap.keySet().size() == 1) {
            valI = (Map.Entry)CollectionsKt.elementAt((Iterable)labelMap.entrySet(), (int)0);
            key = (LabelStatement)valI.getKey();
            value = (Expression)valI.getValue();
            $this$firstOrNull$iv = key.getSubStatement();
            basicBlock = $this$firstOrNull$iv instanceof CompoundStatement != false ? (CompoundStatement)$this$firstOrNull$iv : null;
            decl = this.declarationOrNot(value, instr);
            flatAST.addAll(SubgraphWalker.INSTANCE.flattenAST((Node)decl));
            v1 /* !! */  = basicBlock;
            v2 = mutableStatements = v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getStatements()) != null ? CollectionsKt.toMutableList((Collection)((Collection)v1 /* !! */ )) : null;
            if (v2 != null) {
                v2.add(basicBlock.getStatements().size() - 1, decl);
            }
            if (mutableStatements != null) {
                basicBlock.setStatements(mutableStatements);
            }
            return;
        }
        functionName = LLVM.LLVMGetValueName(bbsFunction).getString();
        $this$filter$iv = tu.getDeclarations();
        $i$f$filter = false;
        decl = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            d = (Declaration)element$iv$iv;
            $i$a$-filter-StatementHandler$handlePhi$functions$1 = false;
            v3 = d instanceof FunctionDeclaration != false ? (FunctionDeclaration)d : null;
            if ((v3 != null ? v3.getName() : null) == null) ** GOTO lbl-1000
            v4 = d instanceof FunctionDeclaration != false ? (FunctionDeclaration)d : null;
            if (Intrinsics.areEqual((Object)String.valueOf(v4 != null ? v4.getName() : null), (Object)functionName)) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        functions = (List)destination$iv$iv;
        if (functions.size() != 1) {
            Handler.getLog().error(functions.size() + " functions match the name of the one where the phi instruction is inserted. Can't handle this case.");
            throw new TranslationException("Wrong number of functions for phi statement.");
        }
        v6 = functions.get(0);
        Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration");
        v7 = ((FunctionDeclaration)v6).getBody();
        Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
        firstBB = (CompoundStatement)v7;
        $this$name$iv = instr;
        $i$f$getName = false;
        v8 = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getString(...)");
        varName = v8;
        type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr);
        code = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr);
        declaration = DeclarationBuilderKt.newVariableDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)varName, (Type)type, (String)code, (boolean)false, (Object)((LLVMIRLanguageFrontend)this.getFrontend()).getLanguage());
        declaration.setType(type);
        flatAST.add((Node)declaration);
        ScopeManager.addDeclaration$default((ScopeManager)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)((Declaration)declaration), (boolean)false, (int)2, null);
        ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put(LLVMIRLanguageFrontendKt.getSymbolName(instr), (Declaration)declaration);
        declStatement = StatementBuilderKt.newDeclarationStatement$default((MetadataProvider)((MetadataProvider)this), (String)code, null, (int)2, null);
        declStatement.setSingleDeclaration((Declaration)declaration);
        mutableFunctionStatements = CollectionsKt.toMutableList((Collection)firstBB.getStatements());
        mutableFunctionStatements.add(0, declStatement);
        firstBB.setStatements(mutableFunctionStatements);
        for (Map.Entry<K, V> var18_29 : labelMap.entrySet()) {
            l = (LabelStatement)var18_29.getKey();
            r = (Expression)var18_29.getValue();
            assignment = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"=", (String)code, null, (int)4, null);
            assignment.setRhs(r);
            assignment.setLhs((Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)varName, (Type)type, (String)code, null, (int)8, null));
            v9 = assignment.getLhs();
            Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            ((DeclaredReferenceExpression)v9).setType(type);
            v10 = assignment.getLhs();
            Intrinsics.checkNotNull((Object)v10, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            ((DeclaredReferenceExpression)v10).unregisterTypeListener((HasType.TypeListener)assignment);
            v11 = assignment.getLhs();
            Intrinsics.checkNotNull((Object)v11, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            assignment.unregisterTypeListener((HasType.TypeListener)((DeclaredReferenceExpression)v11));
            v12 = assignment.getLhs();
            Intrinsics.checkNotNull((Object)v12, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            ((DeclaredReferenceExpression)v12).setRefersTo((Declaration)declaration);
            flatAST.add((Node)assignment);
            var23_34 = l.getSubStatement();
            basicBlock = var23_34 instanceof CompoundStatement != false ? (CompoundStatement)var23_34 : null;
            v13 /* !! */  = basicBlock;
            v14 = mutableStatements = v13 /* !! */  != null && (v13 /* !! */  = v13 /* !! */ .getStatements()) != null ? CollectionsKt.toMutableList((Collection)((Collection)v13 /* !! */ )) : null;
            if (v14 != null) {
                v14.add(basicBlock.getStatements().size() - 1, assignment);
            }
            if (mutableStatements == null) continue;
            basicBlock.setStatements(mutableStatements);
        }
    }

    private final Statement declarationOrNot(Expression rhs, LLVMValueRef valueRef) {
        Statement statement;
        Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(valueRef);
        String lhs = (String)namePair.getFirst();
        String symbolName = (String)namePair.getSecond();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            VariableDeclaration decl = DeclarationBuilderKt.newVariableDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)lhs, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(valueRef), (boolean)false, (Object)((LLVMIRLanguageFrontend)this.getFrontend()).getLanguage());
            decl.setInitializer(rhs);
            ScopeManager.addDeclaration$default((ScopeManager)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)((Declaration)decl), (boolean)false, (int)2, null);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put(symbolName, (Declaration)decl);
            DeclarationStatement declStatement = new DeclarationStatement();
            declStatement.setSingleDeclaration((Declaration)decl);
            statement = (Statement)declStatement;
        } else {
            statement = (Statement)rhs;
        }
        return statement;
    }

    private final Statement handleBasicBlock(LLVMBasicBlockRef bb) {
        CompoundStatement compound = StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), (String)"", null, (int)2, null);
        LLVMValueRef instr = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)bb);
        while (instr != null) {
            Handler.getLog().debug("Parsing {}", (Object)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr));
            Statement stmt = (Statement)((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler().handle(instr);
            if (stmt != null) {
                compound.addStatement(stmt);
            }
            instr = LLVM.LLVMGetNextInstruction((LLVMValueRef)instr);
        }
        String labelName = this.getBasicBlockName(bb);
        if (!Intrinsics.areEqual((Object)labelName, (Object)"")) {
            LabelStatement labelStatement = StatementBuilderKt.newLabelStatement$default((MetadataProvider)((MetadataProvider)this), (String)labelName, null, (int)2, null);
            labelStatement.setName(new Name(labelName, null, null, 6, null));
            labelStatement.setLabel(labelName);
            labelStatement.setSubStatement((Statement)compound);
            return (Statement)labelStatement;
        }
        return (Statement)compound;
    }

    @FunctionReplacement(addedFunctions={"isunordered"})
    @NotNull
    public final Statement handleBinaryOperator(@NotNull LLVMValueRef instr, @NotNull String op, boolean unsigned, boolean unordered) {
        Expression decl;
        block12: {
            Expression it;
            Expression expression;
            block11: {
                block10: {
                    Expression declOp;
                    Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
                    Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                    Expression op1 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
                    Expression op2 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
                    Expression binaryOperator = null;
                    BinaryOperator binOpUnordered = null;
                    if (Intrinsics.areEqual((Object)op, (Object)"uno")) {
                        binaryOperator = (Expression)ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("isunordered")), (CharSequence)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, (int)16, null);
                        ((CallExpression)binaryOperator).addArgument(op1);
                        ((CallExpression)binaryOperator).addArgument(op2);
                    } else if (Intrinsics.areEqual((Object)op, (Object)"ord")) {
                        unorderedCall = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("isunordered")), (CharSequence)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, (int)16, null);
                        unorderedCall.addArgument(op1);
                        unorderedCall.addArgument(op2);
                        binaryOperator = (Expression)ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"!", (boolean)false, (boolean)true, (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), null, (int)16, null);
                        ((UnaryOperator)binaryOperator).setInput((Expression)unorderedCall);
                    } else {
                        binaryOperator = (Expression)ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)op, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)4, null);
                        if (unsigned) {
                            String op1Type = "u" + op1.getType().getName();
                            CastExpression castExprLhs = ExpressionBuilderKt.newCastExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
                            castExprLhs.setCastType(NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)op1Type, (boolean)false, (int)2, null));
                            castExprLhs.setExpression(op1);
                            ((BinaryOperator)binaryOperator).setLhs((Expression)castExprLhs);
                            String op2Type = "u" + op2.getType().getName();
                            CastExpression castExprRhs = ExpressionBuilderKt.newCastExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
                            castExprRhs.setCastType(NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)op2Type, (boolean)false, (int)2, null));
                            castExprRhs.setExpression(op2);
                            ((BinaryOperator)binaryOperator).setRhs((Expression)castExprRhs);
                        } else {
                            ((BinaryOperator)binaryOperator).setLhs(op1);
                            ((BinaryOperator)binaryOperator).setRhs(op2);
                        }
                        if (unordered) {
                            binOpUnordered = ExpressionBuilderKt.newBinaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"||", (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)4, null);
                            binOpUnordered.setRhs(binaryOperator);
                            unorderedCall = ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)((Expression)this.llvmInternalRef("isunordered")), (CharSequence)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, (int)16, null);
                            unorderedCall.addArgument(op1);
                            unorderedCall.addArgument(op2);
                            binOpUnordered.setLhs((Expression)unorderedCall);
                        }
                    }
                    if ((expression = (declOp = unordered ? (Expression)binOpUnordered : binaryOperator)) == null) break block10;
                    it = expression;
                    boolean bl = false;
                    Statement statement = this.declarationOrNot(it, instr);
                    expression = statement;
                    if (statement != null) break block11;
                }
                expression = (Statement)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Could not parse declaration", null, null, null, (int)14, null);
            }
            DeclarationStatement declarationStatement = (decl = expression) instanceof DeclarationStatement ? (DeclarationStatement)decl : null;
            if (declarationStatement == null) break block12;
            it = declarationStatement;
            boolean bl = false;
            Map<String, Declaration> map = ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache();
            String string = LLVMIRLanguageFrontendKt.getSymbolName(instr);
            Declaration declaration = ((DeclarationStatement)decl).getSingleDeclaration();
            Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            VariableDeclaration variableDeclaration = (VariableDeclaration)declaration;
            map.put(string, (Declaration)variableDeclaration);
        }
        return decl;
    }

    public static /* synthetic */ Statement handleBinaryOperator$default(StatementHandler statementHandler, LLVMValueRef lLVMValueRef, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return statementHandler.handleBinaryOperator(lLVMValueRef, string, bl, bl2);
    }

    private final GotoStatement assembleGotoStatement(LLVMValueRef instr, LLVMValueRef bbTarget) {
        GotoStatement gotoStatement = StatementBuilderKt.newGotoStatement$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
        BiConsumer<Object, Node> assigneeTargetLabel = (arg_0, arg_1) -> StatementHandler.assembleGotoStatement$lambda$7(gotoStatement, arg_0, arg_1);
        LLVMBasicBlockRef lLVMBasicBlockRef = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)bbTarget);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMBasicBlockRef, (String)"LLVMValueAsBasicBlock(...)");
        LLVMBasicBlockRef bb = lLVMBasicBlockRef;
        String labelName = LLVM.LLVMGetBasicBlockName((LLVMBasicBlockRef)bb).getString();
        Intrinsics.checkNotNull((Object)labelName);
        gotoStatement.setLabelName(labelName);
        LabelStatement label = StatementBuilderKt.newLabelStatement$default((MetadataProvider)((MetadataProvider)this), (String)labelName, null, (int)2, null);
        label.setName(new Name(labelName, null, null, 6, null));
        ((LLVMIRLanguageFrontend)this.getFrontend()).registerObjectListener(label, assigneeTargetLabel);
        if (gotoStatement.getTargetLabel() == null) {
            ((LLVMIRLanguageFrontend)this.getFrontend()).registerPredicateListener((arg_0, arg_1) -> StatementHandler.assembleGotoStatement$lambda$8(gotoStatement, arg_0, arg_1), assigneeTargetLabel);
        }
        return gotoStatement;
    }

    private final String getBasicBlockName(LLVMBasicBlockRef bb) {
        String labelName = LLVM.LLVMGetBasicBlockName((LLVMBasicBlockRef)bb).getString();
        CharSequence charSequence = labelName;
        if (charSequence == null || charSequence.length() == 0) {
            String bbStr = LLVM.LLVMPrintValueToString((LLVMValueRef)LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)bb)).getString();
            Intrinsics.checkNotNull((Object)bbStr);
            String[] stringArray = new String[]{"\n"};
            String firstLine = (String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)bbStr)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            if (StringsKt.contains$default((CharSequence)firstLine, (CharSequence)":", (boolean)false, (int)2, null)) {
                String string = firstLine.substring(0, StringsKt.indexOf$default((CharSequence)firstLine, (String)":", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                labelName = string;
            }
        }
        charSequence = labelName;
        Intrinsics.checkNotNull((Object)charSequence);
        return charSequence;
    }

    private final DeclaredReferenceExpression llvmInternalRef(String name) {
        return ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, null, null, null, (int)14, null);
    }

    private static final Statement _init_$lambda$1(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleInstruction((LLVMValueRef)it);
    }

    private static final Statement _init_$lambda$2(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleBasicBlock((LLVMBasicBlockRef)it);
    }

    private static final void assembleGotoStatement$lambda$7(GotoStatement $goto, Object object, Node to) {
        Intrinsics.checkNotNullParameter((Object)$goto, (String)"$goto");
        Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (to instanceof LabelStatement) {
            $goto.setTargetLabel((LabelStatement)to);
        } else if (!Intrinsics.areEqual((Object)$goto.getTargetLabel(), (Object)to)) {
            Handler.getLog().error(to + " is not a LabelStatement");
        }
    }

    private static final boolean assembleGotoStatement$lambda$8(GotoStatement $goto, Object object, Object to) {
        Intrinsics.checkNotNullParameter((Object)$goto, (String)"$goto");
        return to instanceof LabelStatement && Intrinsics.areEqual((Object)((LabelStatement)to).getLabel(), (Object)$goto.getLabelName());
    }
}

