/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.StatementBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.GlobalScope;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.scopes.StructureDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.scopes.ValueDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "Lorg/bytedeco/javacpp/Pointer;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "getLiteralStructName", "", "typeRef", "Lorg/bytedeco/llvm/LLVM/LLVMTypeRef;", "alreadyVisited", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "handleFunction", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "func", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "handleGlobal", "valueRef", "handleStructureType", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "handleValue", "value", "replaceCharsInName", "name", "cpg-language-llvm"})
@SourceDebugExtension(value={"SMAP\nDeclarationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler\n+ 2 ScopeManager.kt\nde/fraunhofer/aisec/cpg/ScopeManager\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n727#2,6:303\n735#2,2:323\n740#2,4:328\n748#2,15:335\n800#3,11:309\n766#3:320\n857#3,2:321\n766#3:325\n857#3,2:326\n766#3:332\n857#3,2:333\n*S KotlinDebug\n*F\n+ 1 DeclarationHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/DeclarationHandler\n*L\n207#1:303,6\n207#1:323,2\n207#1:328,4\n207#1:335,15\n207#1:309,11\n207#1:320\n207#1:321,2\n207#1:325\n207#1:326,2\n207#1:332\n207#1:333,2\n*E\n"})
public final class DeclarationHandler
extends Handler<Declaration, Pointer, LLVMIRLanguageFrontend> {
    public DeclarationHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(() -> new ProblemDeclaration(null, null, 3, null), (LanguageFrontend)lang);
        this.getMap().put(LLVMValueRef.class, arg_0 -> DeclarationHandler._init_$lambda$1(this, arg_0));
        this.getMap().put(LLVMTypeRef.class, arg_0 -> DeclarationHandler._init_$lambda$2(this, arg_0));
    }

    private final Declaration handleValue(LLVMValueRef value) {
        int kind = LLVM.LLVMGetValueKind((LLVMValueRef)value);
        return switch (kind) {
            case 5 -> (Declaration)this.handleFunction(value);
            case 8 -> this.handleGlobal(value);
            default -> {
                Handler.getLog().error("Not handling declaration kind {} yet", (Object)kind);
                yield (Declaration)DeclarationBuilderKt.newProblemDeclaration$default((MetadataProvider)((MetadataProvider)this), (String)("Not handling declaration kind " + kind + " yet."), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
            }
        };
    }

    private final Declaration handleGlobal(LLVMValueRef valueRef) {
        String name = LLVM.LLVMGetValueName((LLVMValueRef)valueRef).getString();
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef);
        VariableDeclaration variableDeclaration = DeclarationBuilderKt.newVariableDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)type, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(valueRef), (boolean)false, null, (int)16, null);
        ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put(LLVMIRLanguageFrontendKt.getSymbolName(valueRef), (Declaration)variableDeclaration);
        int size = LLVM.LLVMGetNumOperands((LLVMValueRef)valueRef);
        if (size > 0) {
            ExpressionHandler expressionHandler = ((LLVMIRLanguageFrontend)this.getFrontend()).getExpressionHandler();
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)valueRef, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(...)");
            Expression expr = (Expression)expressionHandler.handle(lLVMValueRef);
            variableDeclaration.setInitializer(expr);
        }
        return (Declaration)variableDeclaration;
    }

    private final FunctionDeclaration handleFunction(LLVMValueRef func) {
        BytePointer name = LLVM.LLVMGetValueName((LLVMValueRef)func);
        FunctionDeclaration functionDeclaration = DeclarationBuilderKt.newFunctionDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name.getString(), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(func), null, (boolean)false, (int)12, null);
        LLVMTypeRef funcPtrType = LLVM.LLVMTypeOf((LLVMValueRef)func);
        LLVMTypeRef funcType = LLVM.LLVMGetElementType((LLVMTypeRef)funcPtrType);
        LLVMTypeRef returnType = LLVM.LLVMGetReturnType((LLVMTypeRef)funcType);
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
        Intrinsics.checkNotNull((Object)returnType);
        functionDeclaration.setType(LLVMIRLanguageFrontend.typeFrom$cpg_language_llvm$default(lLVMIRLanguageFrontend, returnType, null, 2, null));
        ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().enterScope((Node)functionDeclaration);
        LLVMValueRef param = LLVM.LLVMGetFirstParam((LLVMValueRef)func);
        while (param != null) {
            Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(param);
            String paramName = (String)namePair.getFirst();
            String paramSymbolName = (String)namePair.getSecond();
            Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(param);
            ParamVariableDeclaration decl = DeclarationBuilderKt.newParamVariableDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)paramName, (Type)type, (boolean)false, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(param), null, (int)16, null);
            ScopeManager.addDeclaration$default((ScopeManager)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)((Declaration)decl), (boolean)false, (int)2, null);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().put(paramSymbolName, (Declaration)decl);
            param = LLVM.LLVMGetNextParam((LLVMValueRef)param);
        }
        LLVMBasicBlockRef bb = LLVM.LLVMGetFirstBasicBlock((LLVMValueRef)func);
        while (bb != null) {
            Statement stmt = (Statement)((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler().handle(bb);
            if (Intrinsics.areEqual((Object)LLVM.LLVMGetEntryBasicBlock((LLVMValueRef)func), (Object)bb) && stmt instanceof CompoundStatement) {
                functionDeclaration.setBody(stmt);
            } else if (Intrinsics.areEqual((Object)LLVM.LLVMGetEntryBasicBlock((LLVMValueRef)func), (Object)bb)) {
                functionDeclaration.setBody((Statement)StatementBuilderKt.newCompoundStatement$default((MetadataProvider)((MetadataProvider)this), null, null, (int)3, null));
                if (stmt != null) {
                    Statement statement = functionDeclaration.getBody();
                    Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
                    ((CompoundStatement)statement).addStatement(stmt);
                }
            } else if (stmt != null) {
                Statement statement = functionDeclaration.getBody();
                CompoundStatement compoundStatement = statement instanceof CompoundStatement ? (CompoundStatement)statement : null;
                if (compoundStatement != null) {
                    compoundStatement.addStatement(stmt);
                }
            }
            bb = LLVM.LLVMGetNextBasicBlock((LLVMBasicBlockRef)bb);
        }
        ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().leaveScope((Node)functionDeclaration);
        return functionDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RecordDeclaration handleStructureType(@NotNull LLVMTypeRef typeRef, @NotNull Map<LLVMTypeRef, Type> alreadyVisited) {
        RecordDeclaration record2;
        block16: {
            List list;
            String name;
            block15: {
                String string;
                Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
                Intrinsics.checkNotNullParameter(alreadyVisited, (String)"alreadyVisited");
                if (LLVM.LLVMIsLiteralStruct((LLVMTypeRef)typeRef) == 1) {
                    string = this.getLiteralStructName(typeRef, alreadyVisited);
                } else {
                    String string2 = LLVM.LLVMGetStructName((LLVMTypeRef)typeRef).getString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                    string = this.replaceCharsInName(string2);
                }
                name = string;
                ScopeManager scopeManager = ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager();
                Scope scope = (Scope)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().getGlobalScope();
                boolean bl = true;
                Function1 predicate$iv = (Function1)new Function1<RecordDeclaration, Boolean>(name){
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull RecordDeclaration it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getName().toString(), (Object)this.$name);
                    }
                };
                boolean $i$f$resolve = false;
                List declarations$iv = new ArrayList();
                for (Scope scope$iv = searchScope$iv; scope$iv != null; scope$iv = scope$iv.getParent()) {
                    Iterable destination$iv$iv$iv;
                    if (scope$iv instanceof ValueDeclarationScope) {
                        void $this$filterTo$iv$iv$iv;
                        void $this$filter$iv$iv;
                        void $this$filterIsInstanceTo$iv$iv$iv;
                        Iterable $this$filterIsInstance$iv$iv;
                        Iterable iterable = ((ValueDeclarationScope)scope$iv).getValueDeclarations();
                        List list2 = declarations$iv;
                        boolean $i$f$filterIsInstance = false;
                        void var15_19 = $this$filterIsInstance$iv$iv;
                        destination$iv$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Iterator element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                            if (!(element$iv$iv$iv instanceof RecordDeclaration)) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
                        boolean $i$f$filter = false;
                        $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                        destination$iv$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Iterator element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                            if (!((Boolean)predicate$iv.invoke(element$iv$iv$iv)).booleanValue()) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        list2.addAll((List)destination$iv$iv$iv);
                    }
                    if (scope$iv instanceof StructureDeclarationScope) {
                        void $this$filterTo$iv$iv$iv;
                        void $this$filter$iv$iv;
                        void $this$filterIsInstanceTo$iv$iv$iv;
                        Iterator element$iv$iv$iv;
                        Iterable $this$filterIsInstance$iv$iv = ((StructureDeclarationScope)scope$iv).getStructureDeclarations();
                        boolean $i$f$filterIsInstance = false;
                        destination$iv$iv$iv = $this$filterIsInstance$iv$iv;
                        Collection destination$iv$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv$iv2 : $this$filterIsInstanceTo$iv$iv$iv) {
                            if (!(element$iv$iv$iv2 instanceof RecordDeclaration)) continue;
                            destination$iv$iv$iv2.add(element$iv$iv$iv2);
                        }
                        $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv2;
                        boolean $i$f$filter = false;
                        $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                        destination$iv$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        element$iv$iv$iv = $this$filterTo$iv$iv$iv.iterator();
                        while (element$iv$iv$iv.hasNext()) {
                            Object element$iv$iv$iv2;
                            element$iv$iv$iv2 = element$iv$iv$iv.next();
                            if (!((Boolean)predicate$iv.invoke(element$iv$iv$iv2)).booleanValue()) continue;
                            destination$iv$iv$iv2.add(element$iv$iv$iv2);
                        }
                        List list$iv = (List)destination$iv$iv$iv2;
                        if (list$iv.isEmpty()) {
                            for (Declaration declaration$iv : ((StructureDeclarationScope)scope$iv).getStructureDeclarations()) {
                                void $this$filterTo$iv$iv$iv2;
                                void $this$filter$iv$iv2;
                                void $this$filterIsInstanceTo$iv$iv$iv2;
                                if (!(declaration$iv instanceof RecordDeclaration)) continue;
                                Iterable $this$filterIsInstance$iv$iv2 = ((RecordDeclaration)declaration$iv).getTemplates();
                                boolean $i$f$filterIsInstance2 = false;
                                Iterable $i$f$filterTo2 = $this$filterIsInstance$iv$iv2;
                                Collection destination$iv$iv$iv3 = new ArrayList();
                                boolean $i$f$filterIsInstanceTo2 = false;
                                for (Object element$iv$iv$iv3 : $this$filterIsInstanceTo$iv$iv$iv2) {
                                    if (!(element$iv$iv$iv3 instanceof RecordDeclaration)) continue;
                                    destination$iv$iv$iv3.add(element$iv$iv$iv3);
                                }
                                $this$filterIsInstance$iv$iv2 = (List)destination$iv$iv$iv3;
                                boolean $i$f$filter2 = false;
                                $this$filterIsInstanceTo$iv$iv$iv2 = $this$filter$iv$iv2;
                                destination$iv$iv$iv3 = new ArrayList();
                                boolean $i$f$filterTo3 = false;
                                for (Object element$iv$iv$iv3 : $this$filterTo$iv$iv$iv2) {
                                    if (!((Boolean)predicate$iv.invoke(element$iv$iv$iv3)).booleanValue()) continue;
                                    destination$iv$iv$iv3.add(element$iv$iv$iv3);
                                }
                                list$iv = (List)destination$iv$iv$iv3;
                            }
                        }
                        declarations$iv.addAll(list$iv);
                    }
                    if (!(!((Collection)declarations$iv).isEmpty())) continue;
                    list = declarations$iv;
                    break block15;
                }
                list = declarations$iv;
            }
            record2 = (RecordDeclaration)CollectionsKt.firstOrNull((List)list);
            if (record2 != null) {
                return record2;
            }
            record2 = DeclarationBuilderKt.newRecordDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (String)"struct", (String)"", null, (int)8, null);
            ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().enterScope((Node)record2);
            int size = LLVM.LLVMCountStructElementTypes((LLVMTypeRef)typeRef);
            for (int i = 0; i < size; ++i) {
                LLVMTypeRef a = LLVM.LLVMStructGetTypeAtIndex((LLVMTypeRef)typeRef, (int)i);
                LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
                Intrinsics.checkNotNull((Object)a);
                Type fieldType = lLVMIRLanguageFrontend.typeFrom$cpg_language_llvm(a, alreadyVisited);
                String fieldName = "field_" + i;
                FieldDeclaration field = DeclarationBuilderKt.newFieldDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)fieldName, (Type)fieldType, (List)CollectionsKt.emptyList(), (String)"", null, null, (boolean)false, (Object)((LLVMIRLanguageFrontend)this.getFrontend()).getLanguage());
                ScopeManager.addDeclaration$default((ScopeManager)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager(), (Declaration)((Declaration)field), (boolean)false, (int)2, null);
            }
            ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().leaveScope((Node)record2);
            GlobalScope globalScope = ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().getGlobalScope();
            if (globalScope == null) break block16;
            globalScope.addDeclaration((Declaration)record2, true);
        }
        return record2;
    }

    public static /* synthetic */ RecordDeclaration handleStructureType$default(DeclarationHandler declarationHandler, LLVMTypeRef lLVMTypeRef, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        return declarationHandler.handleStructureType(lLVMTypeRef, map);
    }

    private final String getLiteralStructName(LLVMTypeRef typeRef, Map<LLVMTypeRef, Type> alreadyVisited) {
        String typeStr = LLVM.LLVMPrintTypeToString((LLVMTypeRef)typeRef).getString();
        if (((LLVMIRLanguageFrontend)this.getFrontend()).getTypeCache().containsKey(typeStr)) {
            String localName;
            Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).getTypeCache().get(typeStr);
            String string = type != null && (type = type.getName()) != null ? type.getLocalName() : (localName = null);
            if (localName != null) {
                return localName;
            }
        }
        Object name = "literal";
        int size = LLVM.LLVMCountStructElementTypes((LLVMTypeRef)typeRef);
        for (int i = 0; i < size; ++i) {
            LLVMTypeRef field = LLVM.LLVMStructGetTypeAtIndex((LLVMTypeRef)typeRef, (int)i);
            LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
            Intrinsics.checkNotNull((Object)field);
            Type fieldType = lLVMIRLanguageFrontend.typeFrom$cpg_language_llvm(field, alreadyVisited);
            name = (String)name + "_" + fieldType.getTypeName();
        }
        return this.replaceCharsInName((String)name);
    }

    private final String replaceCharsInName(String name) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)"[]", (String)"Array", (boolean)false, (int)4, null), (String)"*", (String)"Ptr", (boolean)false, (int)4, null), (String)"+", (String)"%2B", (boolean)false, (int)4, null), (String)"&", (String)"%26", (boolean)false, (int)4, null), (String)"#", (String)"%23", (boolean)false, (int)4, null), (String)"<", (String)"%3c", (boolean)false, (int)4, null), (String)">", (String)"%3e", (boolean)false, (int)4, null), (String)"@", (String)"%40", (boolean)false, (int)4, null), (String)"[", (String)"%5b", (boolean)false, (int)4, null), (String)"]", (String)"%5d", (boolean)false, (int)4, null), (String)"{", (String)"%7b", (boolean)false, (int)4, null), (String)"}", (String)"%7d", (boolean)false, (int)4, null);
    }

    private static final Declaration _init_$lambda$1(DeclarationHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleValue((LLVMValueRef)it);
    }

    private static final Declaration _init_$lambda$2(DeclarationHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Declaration)DeclarationHandler.handleStructureType$default(this$0, (LLVMTypeRef)it, null, 2, null);
    }
}

