/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.scopes.StructureDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.scopes.ValueDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0015\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u000e\u0010\u0018\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006 "}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "handleCastInstruction", "instr", "handleConstantDataArrayValue", "valueRef", "handleConstantExprValueKind", "value", "handleConstantFP", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "", "handleConstantInt", "", "handleConstantStructValue", "handleFunction", "handleGetElementPtr", "handleGetElementPtr$cpg_language_llvm", "handleNullPointer", "handleReference", "handleSelect", "handleValue", "initializeAsUndef", "type", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "code", "", "initializeAsZero", "cpg-language-llvm"})
@SourceDebugExtension(value={"SMAP\nExpressionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler\n+ 2 LLVMIRLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontendKt\n+ 3 ScopeManager.kt\nde/fraunhofer/aisec/cpg/ScopeManager\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,579:1\n289#2:580\n300#2:581\n691#3,6:582\n699#3,2:602\n704#3,4:607\n712#3,15:614\n800#4,11:588\n766#4:599\n857#4,2:600\n766#4:604\n857#4,2:605\n766#4:611\n857#4,2:612\n*S KotlinDebug\n*F\n+ 1 ExpressionHandler.kt\nde/fraunhofer/aisec/cpg/frontends/llvm/ExpressionHandler\n*L\n143#1:580\n420#1:581\n491#1:582,6\n491#1:602,2\n491#1:607,4\n491#1:614,15\n491#1:588,11\n491#1:599\n491#1:600,2\n491#1:604\n491#1:605,2\n491#1:611\n491#1:612,2\n*E\n"})
public final class ExpressionHandler
extends Handler<Expression, LLVMValueRef, LLVMIRLanguageFrontend> {
    public ExpressionHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(() -> new ProblemExpression(null, null, 3, null), (LanguageFrontend)lang);
        this.getMap().put(LLVMValueRef.class, arg_0 -> ExpressionHandler._init_$lambda$1(this, arg_0));
    }

    private final Expression handleValue(LLVMValueRef value) {
        Expression expression;
        int kind = LLVM.LLVMGetValueKind((LLVMValueRef)value);
        switch (kind) {
            case 10: {
                expression = this.handleConstantExprValueKind(value);
                break;
            }
            case 11: 
            case 12: {
                expression = this.handleConstantStructValue(value);
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                expression = this.handleConstantDataArrayValue(value);
                break;
            }
            case 18: {
                expression = (Expression)this.handleConstantInt(value);
                break;
            }
            case 19: {
                expression = (Expression)this.handleConstantFP(value);
                break;
            }
            case 20: {
                expression = this.handleNullPointer(value);
                break;
            }
            case 25: {
                expression = (Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)"poison", (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value), (String)"poison", null, (int)8, null);
                break;
            }
            case 21: {
                MetadataProvider metadataProvider = (MetadataProvider)this;
                UnknownType unknownType = UnknownType.getUnknownType((Language)this.getLanguage());
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType(language)");
                expression = (Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)metadataProvider, null, (Type)((Type)unknownType), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
                break;
            }
            case 14: {
                Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
                String string = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value);
                Intrinsics.checkNotNull((Object)string);
                expression = this.initializeAsUndef(type, string);
                break;
            }
            case 15: {
                Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
                String string = ((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value);
                Intrinsics.checkNotNull((Object)string);
                expression = this.initializeAsZero(type, string);
                break;
            }
            case 0: 
            case 8: 
            case 24: {
                expression = this.handleReference(value);
                break;
            }
            case 5: {
                expression = this.handleFunction(value);
                break;
            }
            case 6: {
                String name = (String)((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(value).getFirst();
                expression = (Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
                break;
            }
            case 22: 
            case 23: {
                return (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Metadata or ASM value kind not supported yet", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
            }
            default: {
                Handler.getLog().info("Not handling value kind {} in handleValue yet. Falling back to the legacy way. Please change", (Object)kind);
                Type cpgType = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
                if (LLVM.LLVMIsConstant((LLVMValueRef)value) != 1) {
                    String string;
                    if (LLVM.LLVMIsAGlobalAlias((LLVMValueRef)value) != null || LLVM.LLVMIsGlobalConstant((LLVMValueRef)value) == 1) {
                        LLVMValueRef aliasee = LLVM.LLVMAliasGetAliasee((LLVMValueRef)value);
                        String string2 = LLVM.LLVMPrintValueToString((LLVMValueRef)aliasee).getString();
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                      \u2026                        }");
                    } else {
                        String string3 = LLVM.LLVMPrintValueToString((LLVMValueRef)value).getString();
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                      \u2026                        }");
                    }
                    String operandName = string;
                    return (Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)operandName, (Type)cpgType, (String)operandName, null, (int)8, null);
                }
                if (LLVM.LLVMIsUndef((LLVMValueRef)value) == 1) {
                    return (Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)"undef", (Type)cpgType, (String)"undef", null, (int)8, null);
                }
                if (LLVM.LLVMIsPoison((LLVMValueRef)value) == 1) {
                    return (Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)"poison", (Type)cpgType, (String)"poison", null, (int)8, null);
                }
                Handler.getLog().error("Unknown expression {}", (Object)kind);
                return (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)("Unknown expression " + kind), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
            }
        }
        return expression;
    }

    private final Expression handleFunction(LLVMValueRef valueRef) {
        MetadataProvider metadataProvider = (MetadataProvider)this;
        LLVMValueRef $this$name$iv = valueRef;
        boolean $i$f$getName = false;
        String string = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LLVMGetValueName(this).string");
        return (Expression)ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)metadataProvider, (CharSequence)string, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(valueRef), null, (int)8, null);
    }

    private final Expression handleReference(LLVMValueRef valueRef) {
        Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.getFrontend()).getNameOf(valueRef);
        String name = (String)namePair.getFirst();
        String symbolName = (String)namePair.getSecond();
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef);
        DeclaredReferenceExpression ref = ExpressionBuilderKt.newDeclaredReferenceExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)type, (String)(type.getTypeName() + " " + name), null, (int)8, null);
        Declaration decl = ((LLVMIRLanguageFrontend)this.getFrontend()).getBindingsCache().get(symbolName);
        if (decl == null) {
            Handler.getLog().warn("Could not resolve reference " + symbolName + ". This should not happen.");
        } else {
            ref.setRefersTo(decl);
        }
        return (Expression)ref;
    }

    private final Literal<Long> handleConstantInt(LLVMValueRef valueRef) {
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef);
        String string = type.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.typeName");
        long value = StringsKt.startsWith$default((String)string, (String)"ui", (boolean)false, (int)2, null) ? LLVM.LLVMConstIntGetZExtValue((LLVMValueRef)valueRef) : LLVM.LLVMConstIntGetSExtValue((LLVMValueRef)valueRef);
        Literal literal = ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)value, (Type)type, (String)String.valueOf(value), null, (int)8, null);
        literal.setName(new Name(String.valueOf(value), null, null, 6, null));
        return literal;
    }

    private final Literal<Double> handleConstantFP(LLVMValueRef valueRef) {
        int[] losesInfo = new int[1];
        double value = LLVM.LLVMConstRealGetDouble((LLVMValueRef)valueRef, (int[])losesInfo);
        Literal literal = ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)value, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (String)String.valueOf(value), null, (int)8, null);
        literal.setName(new Name(String.valueOf(value), null, null, 6, null));
        return literal;
    }

    private final Expression handleConstantExprValueKind(LLVMValueRef value) {
        Expression expression;
        int kind = LLVM.LLVMGetConstOpcode((LLVMValueRef)value);
        switch (kind) {
            case 29: {
                expression = this.handleGetElementPtr$cpg_language_llvm(value);
                break;
            }
            case 46: {
                expression = this.handleSelect(value);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 60: {
                expression = this.handleCastInstruction(value);
                break;
            }
            case 8: 
            case 9: {
                Statement statement = StatementHandler.handleBinaryOperator$default(((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler(), value, "+", false, false, 8, null);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant binary operation +", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
                break;
            }
            case 10: 
            case 11: {
                Statement statement = StatementHandler.handleBinaryOperator$default(((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler(), value, "-", false, false, 8, null);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant binary operation -", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
                break;
            }
            case 22: {
                Statement statement = StatementHandler.handleBinaryOperator$default(((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler(), value, ">>", false, false, 8, null);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant binary operation >>", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
                break;
            }
            case 42: {
                Statement statement = ((LLVMIRLanguageFrontend)this.getFrontend()).getStatementHandler().handleIntegerComparison(value);
                expression = statement instanceof Expression ? (Expression)statement : null;
                if (expression != null) break;
                expression = (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Wrong type of constant comparison", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
                break;
            }
            default: {
                Handler.getLog().error("Not handling constant expression of opcode {} yet", (Object)kind);
                expression = (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)("Not handling constant expression of opcode " + kind + " yet"), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
            }
        }
        Expression expr = expression;
        return expr;
    }

    private final Expression handleConstantStructValue(LLVMValueRef value) {
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
        ConstructExpression expr = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, null, (int)6, null);
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
        int n = LLVM.LLVMGetNumOperands((LLVMValueRef)value);
        for (int i = 0; i < n; ++i) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)value, (int)i);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(value, i)");
            Expression arg = (Expression)this.handle(lLVMValueRef);
            if (arg == null) continue;
            expr.addArgument(arg);
        }
        return (Expression)expr;
    }

    private final Expression handleConstantDataArrayValue(LLVMValueRef valueRef) {
        if (LLVM.LLVMIsConstantString((LLVMValueRef)valueRef) == 1) {
            String string = LLVM.LLVMGetAsString((LLVMValueRef)valueRef, (SizeTPointer)new SizeTPointer(0L)).getString();
            return (Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)string, (Type)((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(valueRef), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(valueRef), null, (int)8, null);
        }
        InitializerListExpression list = ExpressionBuilderKt.newInitializerListExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(valueRef), null, (int)2, null);
        LLVMTypeRef arrayType = LLVM.LLVMTypeOf((LLVMValueRef)valueRef);
        int length = LLVM.LLVMIsAConstantDataArray((LLVMValueRef)valueRef) != null ? LLVM.LLVMGetArrayLength((LLVMTypeRef)arrayType) : LLVM.LLVMGetVectorSize((LLVMTypeRef)arrayType);
        List initializers = new ArrayList();
        for (int i = 0; i < length; ++i) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetAggregateElement((LLVMValueRef)valueRef, (int)i);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetAggregateElement(valueRef, i)");
            Node node = this.handle(lLVMValueRef);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
            Expression expr = (Expression)node;
            ((Collection)initializers).add(expr);
        }
        list.setInitializers(initializers);
        return (Expression)list;
    }

    private final Expression initializeAsUndef(Type type, String code) {
        if (!((LLVMIRLanguageFrontend)this.getFrontend()).isKnownStructTypeName(type.getName().toString()) && !StringsKt.contains$default((CharSequence)((CharSequence)type.getName()), (CharSequence)"{", (boolean)false, (int)2, null)) {
            return (Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), null, (Type)type, (String)code, null, (int)8, null);
        }
        ConstructExpression expr = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)code, null, null, (int)6, null);
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
        if (expr.getInstantiates() == null) {
            return (Expression)expr;
        }
        Declaration declaration = expr.getInstantiates();
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
        for (FieldDeclaration field : ((RecordDeclaration)declaration).getFields()) {
            Expression arg = this.initializeAsUndef(field.getType(), code);
            expr.addArgument(arg);
        }
        return (Expression)expr;
    }

    private final Expression initializeAsZero(Type type, String code) {
        if (!((LLVMIRLanguageFrontend)this.getFrontend()).isKnownStructTypeName(type.getName().toString()) && !StringsKt.contains$default((CharSequence)((CharSequence)type.getName()), (CharSequence)"{", (boolean)false, (int)2, null)) {
            return (Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), (Object)0, (Type)type, (String)code, null, (int)8, null);
        }
        ConstructExpression expr = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)code, null, null, (int)6, null);
        ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
        expr.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
        if (expr.getInstantiates() == null) {
            return (Expression)expr;
        }
        Declaration declaration = expr.getInstantiates();
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
        for (FieldDeclaration field : ((RecordDeclaration)declaration).getFields()) {
            Expression arg = this.initializeAsZero(field.getType(), code);
            expr.addArgument(arg);
        }
        return (Expression)expr;
    }

    private final Expression handleNullPointer(LLVMValueRef value) {
        Type type = ((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(value);
        return (Expression)ExpressionBuilderKt.newLiteral$default((MetadataProvider)((MetadataProvider)this), null, (Type)type, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(value), null, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Expression handleGetElementPtr$cpg_language_llvm(@NotNull LLVMValueRef instr) {
        Expression operand;
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        boolean isGetElementPtr = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 29 || LLVM.LLVMIsAConstantExpr((LLVMValueRef)instr) != null && LLVM.LLVMGetConstOpcode((LLVMValueRef)instr) == 29;
        int numOps = 0;
        int loopStart = 0;
        IntPointer indices = new IntPointer();
        if (isGetElementPtr) {
            numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
            loopStart = 1;
        } else {
            numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
            loopStart = 0;
            IntPointer intPointer = LLVM.LLVMGetIndices((LLVMValueRef)instr);
            Intrinsics.checkNotNullExpressionValue((Object)intPointer, (String)"LLVMGetIndices(instr)");
            indices = intPointer;
        }
        Ref.ObjectRef baseType = new Ref.ObjectRef();
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.getFrontend();
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
        baseType.element = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression base = operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression expr = (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"Default node for getelementptr", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)8, null);
        for (int idx = loopStart; idx < numOps; ++idx) {
            FieldDeclaration fieldDeclaration;
            String fieldName;
            RecordDeclaration record2;
            Integer index;
            if (isGetElementPtr) {
                operand = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, idx);
                if (operand instanceof Literal) {
                    Object object = ((Literal)operand).getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    v4 = (int)((Long)object).longValue();
                } else {
                    Expression expression = operand;
                    Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
                    v4 = (DeclaredReferenceExpression)expression;
                }
            } else {
                v4 = index = Integer.valueOf(indices.get((long)idx));
            }
            if (baseType.element instanceof PointerType) {
                ArraySubscriptionExpression arrayExpr = ExpressionBuilderKt.newArraySubscriptionExpression$default((MetadataProvider)((MetadataProvider)this), (String)"", null, (int)2, null);
                arrayExpr.setArrayExpression(base);
                arrayExpr.setName(new Name(((Object)index).toString(), null, null, 6, null));
                arrayExpr.setSubscriptExpression(operand);
                expr = (Expression)arrayExpr;
                Intrinsics.checkNotNullExpressionValue((Object)((Type)baseType.element).dereference(), (String)"baseType.dereference()");
                baseType.element = baseType.element;
                base = expr;
                continue;
            }
            Object object = baseType.element;
            ObjectType objectType = object instanceof ObjectType ? (ObjectType)object : null;
            Object object2 = record2 = objectType != null ? objectType.getRecordDeclaration() : null;
            if (record2 == null) {
                List list;
                block29: {
                    ScopeManager scopeManager = ((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager();
                    object = (Scope)((LLVMIRLanguageFrontend)this.getFrontend()).getScopeManager().getGlobalScope();
                    boolean bl = true;
                    Function1 predicate$iv = (Function1)new Function1<RecordDeclaration, Boolean>((Ref.ObjectRef<Type>)baseType){
                        final /* synthetic */ Ref.ObjectRef<Type> $baseType;
                        {
                            this.$baseType = $baseType;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull RecordDeclaration it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getName(), (Object)((Type)this.$baseType.element).getName());
                        }
                    };
                    boolean $i$f$resolve = false;
                    List declarations$iv = new ArrayList();
                    for (Scope scope$iv = searchScope$iv; scope$iv != null; scope$iv = scope$iv.getParent()) {
                        Iterable destination$iv$iv$iv;
                        if (scope$iv instanceof ValueDeclarationScope) {
                            void $this$filterTo$iv$iv$iv;
                            void $this$filter$iv$iv;
                            void $this$filterIsInstanceTo$iv$iv$iv;
                            Iterable $this$filterIsInstance$iv$iv;
                            Iterable iterable = ((ValueDeclarationScope)scope$iv).getValueDeclarations();
                            List list2 = declarations$iv;
                            boolean $i$f$filterIsInstance = false;
                            void var23_26 = $this$filterIsInstance$iv$iv;
                            destination$iv$iv$iv = new ArrayList();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (Iterator element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                                if (!(element$iv$iv$iv instanceof RecordDeclaration)) continue;
                                destination$iv$iv$iv.add(element$iv$iv$iv);
                            }
                            $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
                            boolean $i$f$filter = false;
                            $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                            destination$iv$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Iterator element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                                if (!((Boolean)predicate$iv.invoke(element$iv$iv$iv)).booleanValue()) continue;
                                destination$iv$iv$iv.add(element$iv$iv$iv);
                            }
                            list2.addAll((List)destination$iv$iv$iv);
                        }
                        if (scope$iv instanceof StructureDeclarationScope) {
                            void $this$filterTo$iv$iv$iv;
                            void $this$filter$iv$iv;
                            void $this$filterIsInstanceTo$iv$iv$iv;
                            Iterator element$iv$iv$iv;
                            Iterable $this$filterIsInstance$iv$iv = ((StructureDeclarationScope)scope$iv).getStructureDeclarations();
                            boolean $i$f$filterIsInstance = false;
                            destination$iv$iv$iv = $this$filterIsInstance$iv$iv;
                            Collection destination$iv$iv$iv2 = new ArrayList();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (Object element$iv$iv$iv2 : $this$filterIsInstanceTo$iv$iv$iv) {
                                if (!(element$iv$iv$iv2 instanceof RecordDeclaration)) continue;
                                destination$iv$iv$iv2.add(element$iv$iv$iv2);
                            }
                            $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv2;
                            boolean $i$f$filter = false;
                            $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                            destination$iv$iv$iv2 = new ArrayList();
                            boolean $i$f$filterTo2 = false;
                            element$iv$iv$iv = $this$filterTo$iv$iv$iv.iterator();
                            while (element$iv$iv$iv.hasNext()) {
                                Object element$iv$iv$iv2;
                                element$iv$iv$iv2 = element$iv$iv$iv.next();
                                if (!((Boolean)predicate$iv.invoke(element$iv$iv$iv2)).booleanValue()) continue;
                                destination$iv$iv$iv2.add(element$iv$iv$iv2);
                            }
                            List list$iv = (List)destination$iv$iv$iv2;
                            if (list$iv.isEmpty()) {
                                for (Declaration declaration$iv : ((StructureDeclarationScope)scope$iv).getStructureDeclarations()) {
                                    void $this$filterTo$iv$iv$iv2;
                                    void $this$filter$iv$iv2;
                                    void $this$filterIsInstanceTo$iv$iv$iv2;
                                    if (!(declaration$iv instanceof RecordDeclaration)) continue;
                                    Iterable $this$filterIsInstance$iv$iv2 = ((RecordDeclaration)declaration$iv).getTemplates();
                                    boolean $i$f$filterIsInstance2 = false;
                                    Iterable $i$f$filterTo2 = $this$filterIsInstance$iv$iv2;
                                    Collection destination$iv$iv$iv3 = new ArrayList();
                                    boolean $i$f$filterIsInstanceTo2 = false;
                                    for (Object element$iv$iv$iv3 : $this$filterIsInstanceTo$iv$iv$iv2) {
                                        if (!(element$iv$iv$iv3 instanceof RecordDeclaration)) continue;
                                        destination$iv$iv$iv3.add(element$iv$iv$iv3);
                                    }
                                    $this$filterIsInstance$iv$iv2 = (List)destination$iv$iv$iv3;
                                    boolean $i$f$filter2 = false;
                                    $this$filterIsInstanceTo$iv$iv$iv2 = $this$filter$iv$iv2;
                                    destination$iv$iv$iv3 = new ArrayList();
                                    boolean $i$f$filterTo3 = false;
                                    for (Object element$iv$iv$iv3 : $this$filterTo$iv$iv$iv2) {
                                        if (!((Boolean)predicate$iv.invoke(element$iv$iv$iv3)).booleanValue()) continue;
                                        destination$iv$iv$iv3.add(element$iv$iv$iv3);
                                    }
                                    list$iv = (List)destination$iv$iv$iv3;
                                }
                            }
                            declarations$iv.addAll(list$iv);
                        }
                        if (!(!((Collection)declarations$iv).isEmpty())) continue;
                        list = declarations$iv;
                        break block29;
                    }
                    list = declarations$iv;
                }
                record2 = (RecordDeclaration)CollectionsKt.firstOrNull((List)list);
                if (record2 != null) {
                    Object searchScope$iv = baseType.element;
                    ObjectType objectType2 = searchScope$iv instanceof ObjectType ? (ObjectType)searchScope$iv : null;
                    if (objectType2 != null) {
                        objectType2.setRecordDeclaration(record2);
                    }
                }
            }
            if (record2 == null) {
                Handler.getLog().error("Could not find structure type with name {}, cannot continue", (Object)((Type)baseType.element).getTypeName());
                break;
            }
            Handler.getLog().debug("Trying to access a field within the record declaration of " + record2.getName());
            FieldDeclaration field = null;
            if (index instanceof Integer) {
                field = (FieldDeclaration)ExtensionsKt.get$default((Collection)record2.getFields(), (String)("field_" + index), null, (int)2, null);
                v10 = field;
                if (v10 == null || (v10 = v10.getName()) == null || (v10 = v10.getLocalName()) == null) {
                    v10 = "";
                }
            } else {
                field = null;
                Expression expression = operand;
                Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
                v10 = fieldName = "[" + ((DeclaredReferenceExpression)expression).getName().getLocalName() + "]";
            }
            if ((fieldDeclaration = field) == null || (fieldDeclaration = fieldDeclaration.getType()) == null) {
                UnknownType unknownType = UnknownType.getUnknownType((Language)this.getLanguage());
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType(language)");
                fieldDeclaration = (Type)unknownType;
            }
            baseType.element = fieldDeclaration;
            MetadataProvider metadataProvider = (MetadataProvider)this;
            CharSequence charSequence = fieldName;
            FieldDeclaration fieldDeclaration2 = field;
            if (fieldDeclaration2 == null || (fieldDeclaration2 = fieldDeclaration2.getType()) == null) {
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                fieldDeclaration2 = (Type)unknownType;
            }
            expr = (Expression)ExpressionBuilderKt.newMemberExpression$default((MetadataProvider)metadataProvider, (CharSequence)charSequence, (Expression)base, (Type)fieldDeclaration2, (String)".", (String)"", null, (int)32, null);
            Handler.getLog().info("{}", (Object)expr);
            base = expr;
        }
        if (isGetElementPtr) {
            UnaryOperator ref = ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)"&", (boolean)false, (boolean)true, (String)"", null, (int)16, null);
            ref.setInput(expr);
            expr = (Expression)ref;
        }
        return expr;
    }

    @NotNull
    public final Expression handleSelect(@NotNull LLVMValueRef instr) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        Expression cond = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0);
        Expression value1 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 1);
        Expression value2 = ((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 2);
        return (Expression)ExpressionBuilderKt.newConditionalExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)cond, (Expression)value1, (Expression)value2, (Type)value1.getType(), null, null, (int)48, null);
    }

    @NotNull
    public final Expression handleCastInstruction(@NotNull LLVMValueRef instr) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        CastExpression castExpr = ExpressionBuilderKt.newCastExpression$default((MetadataProvider)((MetadataProvider)this), (String)((LLVMIRLanguageFrontend)this.getFrontend()).getCodeFromRawNode(instr), null, (int)2, null);
        castExpr.setCastType(((LLVMIRLanguageFrontend)this.getFrontend()).typeOf(instr));
        castExpr.setExpression(((LLVMIRLanguageFrontend)this.getFrontend()).getOperandValueAtIndex(instr, 0));
        return (Expression)castExpr;
    }

    private static final Expression _init_$lambda$1(ExpressionHandler this$0, LLVMValueRef it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.handleValue(it);
    }
}

