/*
 * Copyright (c) 2022, Fraunhofer AISEC. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *                    $$$$$$\  $$$$$$$\   $$$$$$\
 *                   $$  __$$\ $$  __$$\ $$  __$$\
 *                   $$ /  \__|$$ |  $$ |$$ /  \__|
 *                   $$ |      $$$$$$$  |$$ |$$$$\
 *                   $$ |      $$  ____/ $$ |\_$$ |
 *                   $$ |  $$\ $$ |      $$ |  $$ |
 *                   \$$$$$   |$$ |      \$$$$$   |
 *                    \______/ \__|       \______/
 *
 */
package de.fraunhofer.aisec.cpg.frontends.llvm

import de.fraunhofer.aisec.cpg.ScopeManager
import de.fraunhofer.aisec.cpg.TranslationConfiguration
import de.fraunhofer.aisec.cpg.frontends.Language
import kotlin.reflect.KClass

/** The LLVM IR language. */
class LLVMIRLanguage : Language<LLVMIRLanguageFrontend>() {
    override val fileExtensions = listOf("ll")
    override val namespaceDelimiter = "::"
    override val frontend: KClass<out LLVMIRLanguageFrontend> = LLVMIRLanguageFrontend::class
    override val primitiveTypes: Set<String>
        get() =
            setOf(
                "byte",
                "short",
                "int",
                "long",
                "float",
                "double",
                "boolean",
                "char",
                "i1",
                "i8",
                "i32",
                "i64",
                "i128",
                "half",
                "bfloat",
                "fp128",
                "x86_fp80",
                "ppc_fp128"
            )

    override fun newFrontend(
        config: TranslationConfiguration,
        scopeManager: ScopeManager
    ): LLVMIRLanguageFrontend {
        return LLVMIRLanguageFrontend(this, config, scopeManager)
    }
}
