/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.annotations.FunctionReplacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0019\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0007J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010,\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\n2\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00105\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00106\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0003\u00a8\u00067"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lorg/bytedeco/javacpp/Pointer;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "assembleGotoStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/GotoStatement;", "instr", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "bbTarget", "declarationOrNot", "rhs", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "valueRef", "getBasicBlockName", "", "bb", "Lorg/bytedeco/llvm/LLVM/LLVMBasicBlockRef;", "handleAlloca", "handleAtomiccmpxchg", "handleAtomicrmw", "handleBasicBlock", "handleBinaryInstruction", "handleBinaryOperator", "op", "unsigned", "", "unordered", "handleBrStatement", "handleCatchpad", "handleCatchret", "handleCatchswitch", "handleCleanuppad", "handleExtractelement", "handleFence", "handleFloatComparison", "handleFreeze", "handleFunctionCall", "handleIndirectbrStatement", "handleInsertValue", "handleInsertelement", "handleInstruction", "handleIntegerComparison", "handleLandingpad", "handleLoad", "handlePhi", "", "tu", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "handleShufflevector", "handleStore", "handleSwitchStatement", "handleVaArg", "cpg-language-llvm"})
public final class StatementHandler
extends Handler<Statement, Pointer, LLVMIRLanguageFrontend> {
    public StatementHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(() -> new ProblemExpression(null, null, 3, null), (LanguageFrontend)lang);
        this.map.put(LLVMValueRef.class, arg_0 -> StatementHandler._init_$lambda-1(this, arg_0));
        this.map.put(LLVMBasicBlockRef.class, arg_0 -> StatementHandler._init_$lambda-2(this, arg_0));
    }

    private final Statement handleInstruction(LLVMValueRef instr) {
        if (LLVM.LLVMIsABinaryOperator((LLVMValueRef)instr) != null) {
            return this.handleBinaryInstruction(instr);
        }
        if (LLVM.LLVMIsACastInst((LLVMValueRef)instr) != null) {
            return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleCastInstruction(instr), instr);
        }
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        int opcode = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv);
        switch (opcode) {
            case 1: {
                ReturnStatement ret = NodeBuilder.newReturnStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
                if (numOps != 0) {
                    ret.setReturnValue(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
                }
                return (Statement)ret;
            }
            case 2: {
                return this.handleBrStatement(instr);
            }
            case 3: {
                return this.handleSwitchStatement(instr);
            }
            case 4: {
                return this.handleIndirectbrStatement(instr);
            }
            case 5: 
            case 45: {
                return this.handleFunctionCall(instr);
            }
            case 7: {
                return (Statement)NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            }
            case 67: {
                Handler.log.error("Cannot parse callbr instruction yet");
                break;
            }
            case 66: {
                UnaryOperator fneg = NodeBuilder.newUnaryOperator$default((String)"-", (boolean)false, (boolean)true, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)48, null);
                fneg.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
                return (Statement)fneg;
            }
            case 26: {
                return this.handleAlloca(instr);
            }
            case 27: {
                return this.handleLoad(instr);
            }
            case 28: {
                return this.handleStore(instr);
            }
            case 29: 
            case 53: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleGetElementPtr$cpg_language_llvm(instr), instr);
            }
            case 42: {
                return this.handleIntegerComparison(instr);
            }
            case 43: {
                return this.handleFloatComparison(instr);
            }
            case 44: {
                ((LLVMIRLanguageFrontend)this.lang).getPhiList().add(instr);
                return (Statement)NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            }
            case 46: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleSelect(instr), instr);
            }
            case 47: 
            case 48: {
                Handler.log.info("userop instruction is not a real instruction. Replacing it with empty statement");
                return (Statement)NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            }
            case 49: {
                return this.handleVaArg(instr);
            }
            case 50: {
                return this.handleExtractelement(instr);
            }
            case 51: {
                return this.handleInsertelement(instr);
            }
            case 52: {
                return this.handleShufflevector(instr);
            }
            case 54: {
                return this.handleInsertValue(instr);
            }
            case 68: {
                return this.handleFreeze(instr);
            }
            case 55: {
                return this.handleFence(instr);
            }
            case 56: {
                return this.handleAtomiccmpxchg(instr);
            }
            case 57: {
                return this.handleAtomicrmw(instr);
            }
            case 58: {
                return (Statement)NodeBuilder.newUnaryOperator$default((String)"throw", (boolean)false, (boolean)true, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)48, null);
            }
            case 59: {
                return this.handleLandingpad(instr);
            }
            case 61: {
                return this.handleCatchret(instr);
            }
            case 62: {
                return this.handleCatchret(instr);
            }
            case 63: {
                return this.handleCatchpad(instr);
            }
            case 64: {
                return this.handleCleanuppad(instr);
            }
            case 65: {
                return this.handleCatchswitch(instr);
            }
        }
        Handler.log.error("Not handling instruction opcode {} yet", (Object)opcode);
        return (Statement)NodeBuilder.newProblemExpression$default((String)("Not handling instruction opcode " + opcode + " yet"), (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
    }

    private final Statement handleCatchret(LLVMValueRef instr) {
        LLVMValueRef unwindDest;
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 62 ? LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1) : (unwindDest = LLVM.LLVMGetUnwindDest((LLVMValueRef)instr) != null ? LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)LLVM.LLVMGetUnwindDest((LLVMValueRef)instr)) : (LLVMValueRef)null);
        if (unwindDest != null) {
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, unwindDest);
            LLVMValueRef $this$opCode$iv2 = instr;
            boolean $i$f$getOpCode2 = false;
            gotoStatement.setName(LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv2) == 62 ? "catchret" : "cleanuppad");
            return (Statement)gotoStatement;
        }
        EmptyStatement emptyStatement = NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        LLVMValueRef $this$opCode$iv3 = instr;
        boolean $i$f$getOpCode3 = false;
        emptyStatement.setName(LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv3) == 62 ? "catchret" : "cleanuppad");
        return (Statement)emptyStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.catchswitch", "llvm.matchesCatchpad"}, replaces="catchswitch")
    private final Statement handleCatchswitch(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        Expression parent = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)nodeCode, null, null, (int)6, null);
        CallExpression dummyCall = NodeBuilder.newCallExpression$default((String)"llvm.catchswitch", (String)"llvm.catchswitch", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        dummyCall.addArgument(parent, "parent");
        DeclarationStatement tokenGeneration = (DeclarationStatement)this.declarationOrNot((Expression)dummyCall, instr);
        compoundStatement.addStatement((Statement)tokenGeneration);
        IfStatement ifStatement = NodeBuilder.newIfStatement$default((String)nodeCode, null, null, (int)6, null);
        IfStatement currentIfStatement = null;
        for (int idx = 1; idx < numOps; ++idx) {
            if (currentIfStatement == null) {
                currentIfStatement = ifStatement;
            } else {
                IfStatement newIf = NodeBuilder.newIfStatement$default((String)nodeCode, null, null, (int)6, null);
                currentIfStatement.setElseStatement((Statement)newIf);
                currentIfStatement = newIf;
            }
            LLVMValueRef bbTarget = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            LLVMValueRef catchpad = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)LLVM.LLVMValueAsBasicBlock((LLVMValueRef)bbTarget));
            int catchOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)catchpad);
            CallExpression matchesCatchpad = NodeBuilder.newCallExpression$default((String)"llvm.matchesCatchpad", (String)"llvm.matchesCatchpad", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
            LLVMValueRef parentCatchSwitch = LLVM.LLVMGetParentCatchSwitch((LLVMValueRef)catchpad);
            Object object = ((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handle(parentCatchSwitch);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
            }
            Expression catchswitch = (Expression)object;
            matchesCatchpad.addArgument(catchswitch, "parentCatchswitch");
            for (int i = 0; i < catchOps; ++i) {
                LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.lang;
                Intrinsics.checkNotNullExpressionValue((Object)catchpad, (String)"catchpad");
                Expression arg = lLVMIRLanguageFrontend.getOperandValueAtIndex(catchpad, i);
                matchesCatchpad.addArgument(arg, "args_" + i);
            }
            currentIfStatement.setCondition((Expression)matchesCatchpad);
            Intrinsics.checkNotNullExpressionValue((Object)bbTarget, (String)"bbTarget");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, bbTarget);
            currentIfStatement.setThenStatement((Statement)gotoStatement);
        }
        LLVMBasicBlockRef unwindDest = LLVM.LLVMGetUnwindDest((LLVMValueRef)instr);
        if (unwindDest != null) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)unwindDest);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMBasicBlockAsValue(unwindDest)");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, lLVMValueRef);
            if (currentIfStatement == null) {
                currentIfStatement = ifStatement;
            }
            currentIfStatement.setElseStatement((Statement)gotoStatement);
        } else {
            UnaryOperator throwOperation = NodeBuilder.newUnaryOperator$default((String)"throw", (boolean)false, (boolean)true, (String)nodeCode, null, null, (int)48, null);
            IfStatement ifStatement2 = currentIfStatement;
            Intrinsics.checkNotNull((Object)ifStatement2);
            ifStatement2.setElseStatement((Statement)throwOperation);
        }
        compoundStatement.addStatement((Statement)ifStatement);
        return (Statement)compoundStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.cleanuppad"}, replaces="cleanuppad")
    private final Statement handleCleanuppad(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)instr);
        Expression catchswitch = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        CallExpression dummyCall = NodeBuilder.newCallExpression$default((String)"llvm.cleanuppad", (String)"llvm.cleanuppad", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        dummyCall.addArgument(catchswitch, "parentCatchswitch");
        for (int i = 1; i < numOps; ++i) {
            Expression arg = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, i);
            dummyCall.addArgument(arg, "args_" + (i - 1));
        }
        return this.declarationOrNot((Expression)dummyCall, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.catchpad"}, replaces="catchpad")
    private final Statement handleCatchpad(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)instr);
        LLVMValueRef parentCatchSwitch = LLVM.LLVMGetParentCatchSwitch((LLVMValueRef)instr);
        Object object = ((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handle(parentCatchSwitch);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
        }
        Expression catchswitch = (Expression)object;
        CallExpression dummyCall = NodeBuilder.newCallExpression$default((String)"llvm.catchpad", (String)"llvm.catchpad", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        dummyCall.addArgument(catchswitch, "parentCatchswitch");
        for (int i = 0; i < numOps; ++i) {
            Expression arg = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, i);
            dummyCall.addArgument(arg, "args_" + i);
        }
        return this.declarationOrNot((Expression)dummyCall, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.va_arg"}, replaces="va_arg")
    private final Statement handleVaArg(LLVMValueRef instr) {
        CallExpression callExpr = NodeBuilder.newCallExpression$default((String)"llvm.va_arg", (String)"llvm.va_arg", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        Expression operandName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        callExpr.addArgument(operandName);
        Type expectedType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr);
        Literal typeLiteral = NodeBuilder.newLiteral$default((Object)expectedType, (Type)expectedType, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        callExpr.addArgument((Expression)typeLiteral);
        return this.declarationOrNot((Expression)callExpr, instr);
    }

    private final Statement handleBinaryInstruction(LLVMValueRef instr) {
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        switch (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv)) {
            case 8: 
            case 9: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "+", false, false, 8, null);
            }
            case 10: 
            case 11: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "-", false, false, 8, null);
            }
            case 12: 
            case 13: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "*", false, false, 8, null);
            }
            case 14: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", true, false, 8, null);
            }
            case 15: 
            case 16: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", false, false, 8, null);
            }
            case 17: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", true, false, 8, null);
            }
            case 18: 
            case 19: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", false, false, 8, null);
            }
            case 20: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "<<", false, false, 8, null);
            }
            case 21: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", true, false, 8, null);
            }
            case 22: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", false, false, 8, null);
            }
            case 23: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "&", false, false, 8, null);
            }
            case 24: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "|", false, false, 8, null);
            }
            case 25: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "^", false, false, 8, null);
            }
        }
        return (Statement)NodeBuilder.newProblemExpression$default((String)"Not opcode found for binary operator", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
    }

    private final Statement handleAlloca(LLVMValueRef instr) {
        ArrayCreationExpression array = NodeBuilder.newArrayCreationExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        array.updateType(((LLVMIRLanguageFrontend)this.lang).typeOf(instr));
        Expression size = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        array.addDimension(size);
        return this.declarationOrNot((Expression)array, instr);
    }

    private final Statement handleStore(LLVMValueRef instr) {
        BinaryOperator binOp = NodeBuilder.newBinaryOperator$default((String)"=", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
        UnaryOperator dereference = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)"", null, null, (int)48, null);
        dereference.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        binOp.setLhs((Expression)dereference);
        binOp.setRhs(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        return (Statement)binOp;
    }

    private final Statement handleLoad(LLVMValueRef instr) {
        UnaryOperator ref = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)"", null, null, (int)48, null);
        ref.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        return this.declarationOrNot((Expression)ref, instr);
    }

    @NotNull
    public final Statement handleIntegerComparison(@NotNull LLVMValueRef instr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        boolean unsigned = false;
        switch (LLVM.LLVMGetICmpPredicate((LLVMValueRef)instr)) {
            case 32: {
                string = "==";
                break;
            }
            case 33: {
                string = "!=";
                break;
            }
            case 34: {
                unsigned = true;
                string = ">";
                break;
            }
            case 35: {
                unsigned = true;
                string = ">=";
                break;
            }
            case 36: {
                unsigned = true;
                string = "<";
                break;
            }
            case 37: {
                unsigned = true;
                string = "<=";
                break;
            }
            case 38: {
                string = ">";
                break;
            }
            case 39: {
                string = ">=";
                break;
            }
            case 40: {
                string = "<";
                break;
            }
            case 41: {
                string = "<=";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return StatementHandler.handleBinaryOperator$default(this, instr, cmpPred, unsigned, false, 8, null);
    }

    private final Statement handleFloatComparison(LLVMValueRef instr) {
        String string;
        boolean unordered = false;
        switch (LLVM.LLVMGetFCmpPredicate((LLVMValueRef)instr)) {
            case 0: {
                return (Statement)NodeBuilder.newLiteral$default((Object)false, (Type)TypeParser.createFrom((String)"i1", (boolean)true), (String)"false", null, null, (int)24, null);
            }
            case 1: {
                string = "==";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = ">=";
                break;
            }
            case 4: {
                string = "<";
                break;
            }
            case 5: {
                string = "<=";
                break;
            }
            case 6: {
                string = "!=";
                break;
            }
            case 7: {
                string = "ord";
                break;
            }
            case 8: {
                string = "uno";
                break;
            }
            case 9: {
                unordered = true;
                string = "==";
                break;
            }
            case 10: {
                unordered = true;
                string = ">";
                break;
            }
            case 11: {
                unordered = true;
                string = ">=";
                break;
            }
            case 12: {
                unordered = true;
                string = "<";
                break;
            }
            case 13: {
                unordered = true;
                string = "<=";
                break;
            }
            case 14: {
                unordered = true;
                string = "!=";
                break;
            }
            case 15: {
                return (Statement)NodeBuilder.newLiteral$default((Object)true, (Type)TypeParser.createFrom((String)"i1", (boolean)true), (String)"true", null, null, (int)24, null);
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return this.handleBinaryOperator(instr, cmpPred, false, unordered);
    }

    private final Statement handleInsertValue(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
        IntPointer indices = LLVM.LLVMGetIndices((LLVMValueRef)instr);
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.lang;
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
        Type baseType = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression valueToSet = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression base = operand;
        Statement copy = (Statement)NodeBuilder.newProblemExpression$default((String)"Default statement for insertvalue", (ProblemNode.ProblemType)ProblemNode.ProblemType.TRANSLATION, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        if (!(operand instanceof ConstructExpression) && (copy = this.declarationOrNot(operand, instr)) instanceof DeclarationStatement) {
            Declaration declaration = ((DeclarationStatement)copy).getSingleDeclaration();
            if (declaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            }
            base = (Expression)NodeBuilder.newDeclaredReferenceExpression$default((String)((DeclarationStatement)copy).getSingleDeclaration().getName(), (Type)((VariableDeclaration)declaration).getType(), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        }
        Expression expr = null;
        for (int idx = 0; idx < numOps; ++idx) {
            FieldDeclaration field;
            RecordDeclaration record;
            int index = indices.get((long)idx);
            if (base instanceof ConstructExpression) {
                if (idx == numOps - 1) {
                    ((ConstructExpression)base).setArgument(index, valueToSet);
                    return this.declarationOrNot(operand, instr);
                }
                Object e = ((ConstructExpression)base).getArguments().get(index);
                Intrinsics.checkNotNullExpressionValue(e, (String)"base.arguments[index]");
                base = (Expression)e;
                continue;
            }
            if (baseType instanceof PointerType) {
                ArraySubscriptionExpression arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)"", null, null, (int)6, null);
                arrayExpr.setArrayExpression(base);
                arrayExpr.setName(String.valueOf(index));
                arrayExpr.setSubscriptExpression(operand);
                expr = (Expression)arrayExpr;
                Intrinsics.checkNotNullExpressionValue((Object)baseType.dereference(), (String)"baseType.dereference()");
                base = expr;
                continue;
            }
            Type type = baseType;
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            Object object = record = objectType != null ? objectType.getRecordDeclaration() : null;
            if (record == null) {
                Handler.log.error("Could not find structure type with name {}, cannot continue", (Object)baseType.getTypeName());
                break;
            }
            Handler.log.debug("Trying to access a field within the record declaration of {}", (Object)record.getName());
            FieldDeclaration fieldDeclaration = field = record.getField("field_" + index);
            Object object2 = fieldDeclaration != null ? fieldDeclaration.getType() : null;
            if (object2 == null) {
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                object2 = (Type)unknownType;
            }
            baseType = object2;
            FieldDeclaration fieldDeclaration2 = field;
            FieldDeclaration fieldDeclaration3 = field;
            expr = (Expression)NodeBuilder.newMemberExpression$default((Expression)base, (Type)(fieldDeclaration2 != null ? fieldDeclaration2.getType() : null), (String)(fieldDeclaration3 != null ? fieldDeclaration3.getName() : null), (String)".", (String)"", null, null, (int)96, null);
            Handler.log.info("{}", (Object)expr);
            base = expr;
        }
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        BinaryOperator assignment = NodeBuilder.newBinaryOperator$default((String)"=", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
        assignment.setLhs(base);
        assignment.setRhs(valueToSet);
        compoundStatement.addStatement(copy);
        compoundStatement.addStatement((Statement)assignment);
        return (Statement)compoundStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.freeze"}, replaces="freeze")
    private final Statement handleFreeze(LLVMValueRef instr) {
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        String instrCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        BinaryOperator condition = NodeBuilder.newBinaryOperator$default((String)"&&", (String)instrCode, null, null, (int)12, null);
        BinaryOperator undefCheck = NodeBuilder.newBinaryOperator$default((String)"!=", (String)instrCode, null, null, (int)12, null);
        undefCheck.setLhs(operand);
        undefCheck.setRhs((Expression)NodeBuilder.newLiteral$default(null, (Type)operand.getType(), (String)instrCode, null, null, (int)24, null));
        condition.setLhs((Expression)undefCheck);
        BinaryOperator poisonCheck = NodeBuilder.newBinaryOperator$default((String)"!=", (String)instrCode, null, null, (int)12, null);
        poisonCheck.setLhs(operand);
        poisonCheck.setRhs((Expression)NodeBuilder.newLiteral$default((Object)"POISON", (Type)operand.getType(), (String)instrCode, null, null, (int)24, null));
        condition.setRhs((Expression)poisonCheck);
        CallExpression callExpression = NodeBuilder.newCallExpression$default((String)"llvm.freeze", (String)"llvm.freeze", (String)instrCode, (boolean)false, null, null, (int)48, null);
        callExpression.addArgument(operand);
        ConditionalExpression conditional = NodeBuilder.newConditionalExpression$default((Expression)((Expression)condition), (Expression)operand, (Expression)((Expression)callExpression), (Type)operand.getType(), null, null, null, (int)112, null);
        return this.declarationOrNot((Expression)conditional, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.fence"}, replaces="fence")
    private final Statement handleFence(LLVMValueRef instr) {
        String instrString = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CallExpression callExpression = NodeBuilder.newCallExpression$default((String)"llvm.fence", (String)"llvm.fence", (String)instrString, (boolean)false, null, null, (int)48, null);
        Literal ordering = NodeBuilder.newLiteral$default((Object)LLVM.LLVMGetOrdering((LLVMValueRef)instr), (Type)TypeParser.createFrom((String)"i32", (boolean)true), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        callExpression.addArgument((Expression)ordering, "ordering");
        String string = instrString;
        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"syncscope", (boolean)false, (int)2, null) : false;
        if (bl) {
            String[] stringArray = new String[]{"\""};
            String syncscope = (String)StringsKt.split$default((CharSequence)instrString, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            callExpression.addArgument((Expression)NodeBuilder.newLiteral$default((Object)syncscope, (Type)TypeParser.createFrom((String)"String", (boolean)true), (String)instrString, null, null, (int)24, null), "syncscope");
        }
        return (Statement)callExpression;
    }

    private final Statement handleAtomiccmpxchg(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
        compoundStatement.setName("atomiccmpxchg");
        Expression ptr = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression cmp = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression value = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 2);
        UnaryOperator ptrDeref = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)instrStr, null, null, (int)48, null);
        ptrDeref.setInput(ptr);
        BinaryOperator cmpExpr = NodeBuilder.newBinaryOperator$default((String)"==", (String)instrStr, null, null, (int)12, null);
        cmpExpr.setLhs((Expression)ptrDeref);
        cmpExpr.setRhs(cmp);
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            Type targetType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr);
            ConstructExpression construct = NodeBuilder.newConstructExpression$default((String)"", null, null, (int)6, null);
            ObjectType objectType = targetType instanceof ObjectType ? (ObjectType)targetType : null;
            construct.setInstantiates((Declaration)(objectType != null ? objectType.getRecordDeclaration() : null));
            construct.addArgument((Expression)ptrDeref);
            construct.addArgument((Expression)cmpExpr);
            Statement decl = this.declarationOrNot((Expression)construct, instr);
            compoundStatement.addStatement(decl);
        }
        BinaryOperator assignment = NodeBuilder.newBinaryOperator$default((String)"=", (String)instrStr, null, null, (int)12, null);
        assignment.setLhs((Expression)ptrDeref);
        assignment.setRhs(value);
        IfStatement ifStatement = NodeBuilder.newIfStatement$default((String)instrStr, null, null, (int)6, null);
        ifStatement.setCondition((Expression)cmpExpr);
        ifStatement.setThenStatement((Statement)assignment);
        compoundStatement.addStatement((Statement)ifStatement);
        return (Statement)compoundStatement;
    }

    private final Statement handleAtomicrmw(LLVMValueRef instr) {
        Statement statement;
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        int operation = LLVM.LLVMGetAtomicRMWBinOp((LLVMValueRef)instr);
        Expression ptr = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression value = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Type ty = value.getType();
        BinaryOperator exchOp = NodeBuilder.newBinaryOperator$default((String)"=", (String)instrStr, null, null, (int)12, null);
        exchOp.setName("atomicrmw");
        UnaryOperator ptrDeref = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)instrStr, null, null, (int)48, null);
        ptrDeref.setInput(ptr);
        exchOp.setLhs((Expression)ptrDeref);
        switch (operation) {
            case 0: {
                exchOp.setRhs(value);
                break;
            }
            case 1: 
            case 11: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"+", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 2: 
            case 12: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"-", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 3: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"&", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 4: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"|", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                UnaryOperator unaryOperator = NodeBuilder.newUnaryOperator$default((String)"~", (boolean)false, (boolean)true, (String)instrStr, null, null, (int)48, null);
                unaryOperator.setInput((Expression)binaryOperator);
                exchOp.setRhs((Expression)unaryOperator);
                break;
            }
            case 5: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"|", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 6: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"^", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 7: 
            case 8: {
                String operatorCode = operation == 8 ? "<" : ">";
                BinaryOperator condition = NodeBuilder.newBinaryOperator$default((String)operatorCode, (String)instrStr, null, null, (int)12, null);
                condition.setLhs((Expression)ptrDeref);
                condition.setRhs(value);
                ConditionalExpression conditional = NodeBuilder.newConditionalExpression$default((Expression)((Expression)condition), (Expression)((Expression)ptrDeref), (Expression)value, (Type)ty, null, null, null, (int)112, null);
                exchOp.setRhs((Expression)conditional);
                break;
            }
            case 9: 
            case 10: {
                String operatorCode = operation == 10 ? "<" : ">";
                BinaryOperator condition = NodeBuilder.newBinaryOperator$default((String)operatorCode, (String)instrStr, null, null, (int)12, null);
                CastExpression castExprLhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                castExprLhs.setCastType(TypeParser.createFrom((String)('u' + ty.getName()), (boolean)true));
                castExprLhs.setExpression((Expression)ptrDeref);
                condition.setLhs((Expression)castExprLhs);
                CastExpression castExprRhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                castExprRhs.setCastType(TypeParser.createFrom((String)('u' + ty.getName()), (boolean)true));
                castExprRhs.setExpression(value);
                condition.setRhs((Expression)castExprRhs);
                ConditionalExpression conditional = NodeBuilder.newConditionalExpression$default((Expression)((Expression)condition), (Expression)((Expression)ptrDeref), (Expression)value, (Type)ty, null, null, null, (int)112, null);
                exchOp.setRhs((Expression)conditional);
                break;
            }
            default: {
                throw new TranslationException("LLVMAtomicRMWBinOp " + operation + " not supported");
            }
        }
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
            Object[] objectArray = new Statement[]{this.declarationOrNot((Expression)ptrDeref, instr), (Statement)exchOp};
            compoundStatement.setStatements(CollectionsKt.listOf((Object[])objectArray));
            statement = (Statement)compoundStatement;
        } else {
            statement = (Statement)exchOp;
        }
        return statement;
    }

    private final Statement handleIndirectbrStatement(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        if (numOps < 2) {
            throw new TranslationException("Indirectbr statement without address and at least one target");
        }
        Expression address = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement$default((String)nodeCode, null, null, (int)6, null);
        switchStatement.selector = address;
        CompoundStatement caseStatements = NodeBuilder.newCompoundStatement$default((String)nodeCode, null, null, (int)6, null);
        for (int idx = 1; idx < numOps; ++idx) {
            long caseBBAddress = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx)).address();
            CaseStatement caseStatement = NodeBuilder.newCaseStatement$default((String)nodeCode, null, null, (int)6, null);
            caseStatement.caseExpression = (Expression)NodeBuilder.newLiteral$default((Object)caseBBAddress, (Type)TypeParser.createFrom((String)"i64", (boolean)true), (String)nodeCode, null, null, (int)24, null);
            caseStatements.addStatement((Statement)caseStatement);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, idx)");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, lLVMValueRef);
            caseStatements.addStatement((Statement)gotoStatement);
        }
        switchStatement.setStatement((Statement)caseStatements);
        return (Statement)switchStatement;
    }

    private final Statement handleBrStatement(LLVMValueRef instr) {
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 3) {
            IfStatement ifStatement = NodeBuilder.newIfStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            Expression condition = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
            ifStatement.setCondition(condition);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 1)");
            ifStatement.setElseStatement((Statement)this.assembleGotoStatement(instr, lLVMValueRef));
            LLVMValueRef lLVMValueRef2 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef2, (String)"LLVMGetOperand(instr, 2)");
            ifStatement.setThenStatement((Statement)this.assembleGotoStatement(instr, lLVMValueRef2));
            return (Statement)ifStatement;
        }
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 1) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
            return (Statement)this.assembleGotoStatement(instr, lLVMValueRef);
        }
        throw new TranslationException("Wrong number of operands in br statement");
    }

    private final Statement handleSwitchStatement(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        if (numOps < 2 || numOps % 2 != 0) {
            throw new TranslationException("Switch statement without operand and default branch");
        }
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement$default((String)nodeCode, null, null, (int)6, null);
        switchStatement.selector = operand;
        CompoundStatement caseStatements = NodeBuilder.newCompoundStatement$default((String)nodeCode, null, null, (int)6, null);
        for (int idx = 2; idx < numOps; ++idx) {
            CaseStatement caseStatement = NodeBuilder.newCaseStatement$default((String)nodeCode, null, null, (int)6, null);
            caseStatement.caseExpression = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
            caseStatements.addStatement((Statement)caseStatement);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)(++idx));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, idx)");
            GotoStatement gotoStatement = this.assembleGotoStatement(instr, lLVMValueRef);
            caseStatements.addStatement((Statement)gotoStatement);
        }
        caseStatements.addStatement((Statement)NodeBuilder.newDefaultStatement$default((String)nodeCode, null, null, (int)6, null));
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 1)");
        GotoStatement defaultGoto = this.assembleGotoStatement(instr, lLVMValueRef);
        caseStatements.addStatement((Statement)defaultGoto);
        switchStatement.setStatement((Statement)caseStatements);
        return (Statement)switchStatement;
    }

    private final Statement handleFunctionCall(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        LLVMValueRef calledFunc = LLVM.LLVMGetCalledValue((LLVMValueRef)instr);
        String calledFuncName = LLVM.LLVMGetValueName((LLVMValueRef)calledFunc).getString();
        int max = LLVM.LLVMGetNumOperands((LLVMValueRef)instr) - 1;
        int idx = 0;
        if (calledFuncName.equals("")) {
            Expression opName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, max);
            calledFuncName = opName.getName();
        }
        GotoStatement gotoCatch = NodeBuilder.newGotoStatement$default((String)instrStr, null, null, (int)6, null);
        GotoStatement tryContinue = NodeBuilder.newGotoStatement$default((String)instrStr, null, null, (int)6, null);
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 5) {
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)(--max));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, max)");
            gotoCatch = this.assembleGotoStatement(instr, lLVMValueRef);
            LLVMValueRef lLVMValueRef2 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)(--max));
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef2, (String)"LLVMGetOperand(instr, max)");
            tryContinue = this.assembleGotoStatement(instr, lLVMValueRef2);
            --max;
            Handler.log.info("Invoke expression: Usually continues at " + tryContinue.getLabelName() + ", exception continues at " + gotoCatch.getLabelName());
        }
        CallExpression callExpr = NodeBuilder.newCallExpression$default((String)calledFuncName, (String)calledFuncName, (String)instrStr, (boolean)false, null, null, (int)48, null);
        while (idx < max) {
            Expression operandName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
            callExpr.addArgument(operandName);
            ++idx;
        }
        LLVMValueRef $this$opCode$iv2 = instr;
        boolean $i$f$getOpCode2 = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv2) == 5) {
            String string = instrStr;
            Intrinsics.checkNotNull((Object)string);
            TryStatement tryStatement = NodeBuilder.newTryStatement$default((String)string, null, null, (int)6, null);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().enterScope((Node)tryStatement);
            CompoundStatement tryBlock = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
            tryBlock.addStatement(this.declarationOrNot((Expression)callExpr, instr));
            tryBlock.addStatement((Statement)tryContinue);
            tryStatement.setTryBlock(tryBlock);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().leaveScope((Node)tryStatement);
            CatchClause catchClause = NodeBuilder.newCatchClause$default((String)instrStr, null, null, (int)6, null);
            String string2 = gotoCatch.getLabelName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gotoCatch.labelName");
            catchClause.setName(string2);
            catchClause.setParameter(NodeBuilder.newVariableDeclaration$default((String)("e_" + gotoCatch.getLabelName()), (Type)((Type)UnknownType.getUnknownType()), (String)instrStr, (boolean)true, null, null, (int)48, null));
            CompoundStatement catchCompoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
            catchCompoundStatement.addStatement((Statement)gotoCatch);
            catchClause.setBody(catchCompoundStatement);
            Object[] objectArray = new CatchClause[]{catchClause};
            tryStatement.setCatchClauses(CollectionsKt.mutableListOf((Object[])objectArray));
            return (Statement)tryStatement;
        }
        return this.declarationOrNot((Expression)callExpr, instr);
    }

    private final Statement handleLandingpad(LLVMValueRef instr) {
        String lhs;
        String string = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        Intrinsics.checkNotNull((Object)string);
        CatchClause catchInstr = NodeBuilder.newCatchClause$default((String)string, null, null, (int)6, null);
        int numClauses = LLVM.LLVMGetNumClauses((LLVMValueRef)instr);
        String catchType = "";
        for (int i = 0; i < numClauses; ++i) {
            LLVMValueRef clause = LLVM.LLVMGetClause((LLVMValueRef)instr, (int)i);
            if (LLVM.LLVMIsAConstantArray((LLVMValueRef)clause) != null) continue;
            catchType = LLVM.LLVMIsNull((LLVMValueRef)clause) == 1 ? catchType + "... | " : catchType + LLVM.LLVMGetValueName((LLVMValueRef)clause).getString() + " | ";
        }
        if (StringsKt.endsWith$default((String)catchType, (String)" | ", (boolean)false, (int)2, null)) {
            String string2 = catchType.substring(0, catchType.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            catchType = string2;
        }
        String exceptionName = !Intrinsics.areEqual((Object)(lhs = (String)((LLVMIRLanguageFrontend)this.lang).getNameOf(instr).getFirst()), (Object)"") ? lhs : "e_" + instr.address();
        VariableDeclaration except = NodeBuilder.newVariableDeclaration$default((String)exceptionName, (Type)TypeParser.createFrom((String)catchType, (boolean)false), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put('%' + exceptionName, (Declaration)except);
        catchInstr.setParameter(except);
        catchInstr.setName(catchType);
        return (Statement)catchInstr;
    }

    private final Statement handleInsertelement(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
        Statement newArrayDecl = this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0), instr);
        compoundStatement.addStatement(newArrayDecl);
        Object e = newArrayDecl.getDeclarations().get(0);
        VariableDeclaration decl = e instanceof VariableDeclaration ? (VariableDeclaration)e : null;
        ArraySubscriptionExpression arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)instrStr, null, null, (int)6, null);
        VariableDeclaration variableDeclaration = decl;
        VariableDeclaration variableDeclaration2 = decl;
        arrayExpr.setArrayExpression((Expression)NodeBuilder.newDeclaredReferenceExpression$default((String)(variableDeclaration != null ? variableDeclaration.getName() : null), (Type)(variableDeclaration2 != null ? variableDeclaration2.getType() : null), (String)instrStr, null, null, (int)24, null));
        arrayExpr.setSubscriptExpression(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 2));
        BinaryOperator binaryExpr = NodeBuilder.newBinaryOperator$default((String)"=", (String)instrStr, null, null, (int)12, null);
        binaryExpr.setLhs((Expression)arrayExpr);
        binaryExpr.setRhs(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        compoundStatement.addStatement((Statement)binaryExpr);
        return (Statement)compoundStatement;
    }

    private final Statement handleExtractelement(LLVMValueRef instr) {
        ArraySubscriptionExpression arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        arrayExpr.setArrayExpression(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        arrayExpr.setSubscriptExpression(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        return this.declarationOrNot((Expression)arrayExpr, instr);
    }

    private final Statement handleShufflevector(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        InitializerListExpression list = NodeBuilder.newInitializerListExpression$default((String)instrStr, null, null, (int)6, null);
        Type elementType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr).dereference();
        List initializers = new ArrayList();
        Expression array1 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        int array1Length = array1 instanceof Literal && ((Literal)array1).getValue() == null ? 0 : LLVM.LLVMGetVectorSize((LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0)));
        Expression array2 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        int array2Length = array2 instanceof Literal && ((Literal)array2).getValue() == null ? 0 : LLVM.LLVMGetVectorSize((LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1)));
        int indices = LLVM.LLVMGetNumMaskElements((LLVMValueRef)instr);
        for (int idx = 0; idx < indices; ++idx) {
            ArraySubscriptionExpression arrayExpr;
            int idxInt = LLVM.LLVMGetMaskValue((LLVMValueRef)instr, (int)idx);
            if (idxInt < array1Length) {
                if (array1 instanceof InitializerListExpression) {
                    ((Collection)initializers).add(((InitializerListExpression)array1).getInitializers().get(idxInt));
                    continue;
                }
                if (array1 instanceof Literal && ((Literal)array1).getValue() == null) {
                    ((Collection)initializers).add(NodeBuilder.newLiteral$default(null, (Type)elementType, (String)instrStr, null, null, (int)24, null));
                    continue;
                }
                arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)instrStr, null, null, (int)6, null);
                arrayExpr.setArrayExpression(array1);
                arrayExpr.setSubscriptExpression((Expression)NodeBuilder.newLiteral$default((Object)idxInt, (Type)TypeParser.createFrom((String)"i32", (boolean)true), (String)instrStr, null, null, (int)24, null));
                ((Collection)initializers).add(arrayExpr);
                continue;
            }
            if (idxInt < array1Length + array2Length) {
                if (array2 instanceof InitializerListExpression) {
                    ((Collection)initializers).add(((InitializerListExpression)array2).getInitializers().get(idxInt - array1Length));
                    continue;
                }
                if (array2 instanceof Literal && ((Literal)array2).getValue() == null) {
                    ((Collection)initializers).add(NodeBuilder.newLiteral$default(null, (Type)elementType, (String)instrStr, null, null, (int)24, null));
                    continue;
                }
                arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)instrStr, null, null, (int)6, null);
                arrayExpr.setArrayExpression(array2);
                arrayExpr.setSubscriptExpression((Expression)NodeBuilder.newLiteral$default((Object)(idxInt - array1Length), (Type)TypeParser.createFrom((String)"i32", (boolean)true), (String)instrStr, null, null, (int)24, null));
                ((Collection)initializers).add(arrayExpr);
                continue;
            }
            ((Collection)initializers).add(NodeBuilder.newLiteral$default(null, (Type)elementType, (String)instrStr, null, null, (int)24, null));
        }
        list.setInitializers(initializers);
        return this.declarationOrNot((Expression)list, instr);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void handlePhi(@NotNull LLVMValueRef instr, @NotNull TranslationUnitDeclaration tu) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
        labelMap = new LinkedHashMap<K, V>();
        numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        i = 0;
        bbsFunction = null;
        flatAST = SubgraphWalker.flattenAST((Node)((Node)tu));
        while (i < numOps) {
            block20: {
                valI = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, i);
                incomingBB = LLVM.LLVMGetIncomingBlock((LLVMValueRef)instr, (int)i);
                if (bbsFunction == null) {
                    bbsFunction = LLVM.LLVMGetBasicBlockParent((LLVMBasicBlockRef)incomingBB);
                } else if (bbsFunction.address() != LLVM.LLVMGetBasicBlockParent((LLVMBasicBlockRef)incomingBB).address()) {
                    Handler.log.error("The basic blocks of the phi instructions are in different functions. Can't handle this!");
                    throw new TranslationException("The basic blocks of the phi instructions are in different functions.");
                }
                Intrinsics.checkNotNullExpressionValue((Object)incomingBB, (String)"incomingBB");
                labelName /* !! */  = this.getBasicBlockName(incomingBB);
                Intrinsics.checkNotNullExpressionValue((Object)flatAST, (String)"flatAST");
                $this$firstOrNull$iv = flatAST;
                $i$f$firstOrNull = false;
                for (Iterator<T> element$iv : $this$firstOrNull$iv) {
                    s = (Node)element$iv /* !! */ ;
                    $i$a$-firstOrNull-StatementHandler$handlePhi$labelI$1 = false;
                    if (!(s instanceof LabelStatement != false && Intrinsics.areEqual((Object)((LabelStatement)s).getLabel(), (Object)labelName /* !! */ ) != false)) continue;
                    v0 /* !! */  = element$iv /* !! */ ;
                    break block20;
                }
                v0 /* !! */  = null;
            }
            labelI = (Node)v0 /* !! */ ;
            ++i;
            if (labelI == null) {
                Handler.log.error("Expecting to find a label with name " + (String)labelName /* !! */  + " for Phi statement.");
            }
            v1 = labelI;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.LabelStatement");
            }
            labelMap.put((LabelStatement)v1, valI);
        }
        if (labelMap.keySet().size() == 1) {
            key = (LabelStatement)CollectionsKt.elementAt((Iterable)labelMap.keySet(), (int)0);
            labelName /* !! */  = key.getSubStatement();
            basicBlock = labelName /* !! */  instanceof CompoundStatement != false ? (CompoundStatement)labelName /* !! */  : null;
            v2 = labelMap.get(key);
            Intrinsics.checkNotNull(v2);
            decl = this.declarationOrNot((Expression)v2, instr);
            v3 /* !! */  = basicBlock;
            v4 = mutableStatements = v3 /* !! */  != null && (v3 /* !! */  = v3 /* !! */ .getStatements()) != null ? CollectionsKt.toMutableList((Collection)((Collection)v3 /* !! */ )) : null;
            if (v4 != null) {
                v4.add(basicBlock.getStatements().size() - 1, decl);
            }
            if (mutableStatements != null) {
                basicBlock.setStatements(mutableStatements);
            }
            return;
        }
        functionName = LLVM.LLVMGetValueName(bbsFunction).getString();
        v5 = tu.getDeclarations();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"tu.declarations");
        $this$filter$iv = v5;
        $i$f$filter = false;
        $this$firstOrNull$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            d = (Declaration)element$iv$iv;
            $i$a$-filter-StatementHandler$handlePhi$functions$1 = false;
            v6 = d instanceof FunctionDeclaration != false ? (FunctionDeclaration)d : null;
            if ((v6 != null ? v6.getName() : null) == null) ** GOTO lbl-1000
            v7 = d instanceof FunctionDeclaration != false ? (FunctionDeclaration)d : null;
            if (StringsKt.equals$default((String)(v7 != null ? v7.getName() : null), (String)functionName, (boolean)false, (int)2, null)) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
            if (!v8) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        functions = (List)destination$iv$iv;
        if (functions.size() != 1) {
            Handler.log.error(functions.size() + " functions match the name of the one where the phi instruction is inserted. Can't handle this case.");
            throw new TranslationException("Wrong number of functions for phi statement.");
        }
        v9 = functions.get(0);
        if (v9 == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration");
        }
        v10 = ((FunctionDeclaration)v9).getBody();
        if (v10 == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
        }
        firstBB = (CompoundStatement)v10;
        $this$name$iv = instr;
        $i$f$getName = false;
        v11 = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"LLVMGetValueName(this).string");
        varName = v11;
        type = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr);
        code = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        declaration = NodeBuilder.newVariableDeclaration$default((String)varName, (Type)type, (String)code, (boolean)false, null, null, (int)48, null);
        declaration.updateType(type);
        ((LLVMIRLanguageFrontend)this.lang).getScopeManager().addDeclaration((Declaration)declaration);
        ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put(LLVMIRLanguageFrontendKt.getSymbolName(instr), (Declaration)declaration);
        declStatement = NodeBuilder.newDeclarationStatement$default((String)code, null, null, (int)6, null);
        declStatement.setSingleDeclaration((Declaration)declaration);
        v12 = firstBB.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"firstBB.statements");
        mutableFunctionStatements = CollectionsKt.toMutableList((Collection)v12);
        mutableFunctionStatements.add(0, declStatement);
        firstBB.setStatements(mutableFunctionStatements);
        for (LabelStatement l : labelMap.keySet()) {
            assignment = NodeBuilder.newBinaryOperator$default((String)"=", (String)code, null, null, (int)12, null);
            v13 = labelMap.get(l);
            Intrinsics.checkNotNull(v13);
            assignment.setRhs((Expression)v13);
            assignment.setLhs((Expression)NodeBuilder.newDeclaredReferenceExpression$default((String)varName, (Type)type, (String)code, null, null, (int)24, null));
            assignment.getLhs().setType(type);
            assignment.getLhs().unregisterTypeListener((HasType.TypeListener)assignment);
            v14 = assignment.getLhs();
            if (v14 == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            }
            assignment.unregisterTypeListener((HasType.TypeListener)((DeclaredReferenceExpression)v14));
            v15 = assignment.getLhs();
            if (v15 == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            }
            ((DeclaredReferenceExpression)v15).setRefersTo((Declaration)declaration);
            var21_31 = l.getSubStatement();
            basicBlock = var21_31 instanceof CompoundStatement != false ? (CompoundStatement)var21_31 : null;
            v16 /* !! */  = basicBlock;
            v17 = mutableStatements = v16 /* !! */  != null && (v16 /* !! */  = v16 /* !! */ .getStatements()) != null ? CollectionsKt.toMutableList((Collection)((Collection)v16 /* !! */ )) : null;
            if (v17 != null) {
                v17.add(basicBlock.getStatements().size() - 1, assignment);
            }
            if (mutableStatements == null) continue;
            basicBlock.setStatements(mutableStatements);
        }
    }

    private final Statement declarationOrNot(Expression rhs, LLVMValueRef valueRef) {
        Statement statement;
        Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.lang).getNameOf(valueRef);
        String lhs = (String)namePair.getFirst();
        String symbolName = (String)namePair.getSecond();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            VariableDeclaration decl = NodeBuilder.newVariableDeclaration$default((String)lhs, (Type)((LLVMIRLanguageFrontend)this.lang).typeOf(valueRef), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(valueRef), (boolean)false, null, null, (int)48, null);
            decl.setInitializer(rhs);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().addDeclaration((Declaration)decl);
            ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put(symbolName, (Declaration)decl);
            DeclarationStatement declStatement = new DeclarationStatement();
            declStatement.setSingleDeclaration((Declaration)decl);
            statement = (Statement)declStatement;
        } else {
            statement = (Statement)rhs;
        }
        return statement;
    }

    private final Statement handleBasicBlock(LLVMBasicBlockRef bb) {
        CompoundStatement compound = NodeBuilder.newCompoundStatement$default((String)"", null, null, (int)6, null);
        LLVMValueRef instr = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)bb);
        while (instr != null) {
            Handler.log.debug("Parsing {}", (Object)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            Statement stmt = (Statement)((LLVMIRLanguageFrontend)this.lang).getStatementHandler().handle(instr);
            compound.addStatement(stmt);
            instr = LLVM.LLVMGetNextInstruction((LLVMValueRef)instr);
        }
        String labelName = this.getBasicBlockName(bb);
        if (!Intrinsics.areEqual((Object)labelName, (Object)"")) {
            LabelStatement labelStatement = NodeBuilder.newLabelStatement$default((String)labelName, null, null, (int)6, null);
            labelStatement.setName(labelName);
            labelStatement.setLabel(labelName);
            labelStatement.setSubStatement((Statement)compound);
            return (Statement)labelStatement;
        }
        return (Statement)compound;
    }

    @FunctionReplacement(addedFunctions={"isunordered"})
    @NotNull
    public final Statement handleBinaryOperator(@NotNull LLVMValueRef instr, @NotNull String op, boolean unsigned, boolean unordered) {
        Statement decl;
        block8: {
            Expression declOp;
            CallExpression unorderedCall;
            Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            Expression op1 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
            Expression op2 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
            Expression binaryOperator = null;
            BinaryOperator binOpUnordered = null;
            if (Intrinsics.areEqual((Object)op, (Object)"uno")) {
                binaryOperator = (Expression)NodeBuilder.newCallExpression$default((String)"isunordered", (String)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, null, (int)48, null);
                ((CallExpression)binaryOperator).addArgument(op1);
                ((CallExpression)binaryOperator).addArgument(op2);
            } else if (Intrinsics.areEqual((Object)op, (Object)"ord")) {
                unorderedCall = NodeBuilder.newCallExpression$default((String)"isunordered", (String)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, null, (int)48, null);
                unorderedCall.addArgument(op1);
                unorderedCall.addArgument(op2);
                binaryOperator = (Expression)NodeBuilder.newUnaryOperator$default((String)"!", (boolean)false, (boolean)true, (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), null, null, (int)48, null);
                ((UnaryOperator)binaryOperator).setInput((Expression)unorderedCall);
            } else {
                binaryOperator = (Expression)NodeBuilder.newBinaryOperator$default((String)op, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
                if (unsigned) {
                    String op1Type = 'u' + op1.getType().getName();
                    CastExpression castExprLhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                    castExprLhs.setCastType(TypeParser.createFrom((String)op1Type, (boolean)true));
                    castExprLhs.setExpression(op1);
                    ((BinaryOperator)binaryOperator).setLhs((Expression)castExprLhs);
                    String op2Type = 'u' + op2.getType().getName();
                    CastExpression castExprRhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                    castExprRhs.setCastType(TypeParser.createFrom((String)op2Type, (boolean)true));
                    castExprRhs.setExpression(op2);
                    ((BinaryOperator)binaryOperator).setRhs((Expression)castExprRhs);
                } else {
                    ((BinaryOperator)binaryOperator).setLhs(op1);
                    ((BinaryOperator)binaryOperator).setRhs(op2);
                }
                if (unordered) {
                    binOpUnordered = NodeBuilder.newBinaryOperator$default((String)"||", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
                    binOpUnordered.setRhs(binaryOperator);
                    unorderedCall = NodeBuilder.newCallExpression$default((String)"isunordered", (String)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, null, (int)48, null);
                    unorderedCall.addArgument(op1);
                    unorderedCall.addArgument(op2);
                    binOpUnordered.setLhs((Expression)unorderedCall);
                }
            }
            Expression expression = declOp = unordered ? (Expression)binOpUnordered : binaryOperator;
            Intrinsics.checkNotNull((Object)expression);
            decl = this.declarationOrNot(expression, instr);
            DeclarationStatement declarationStatement = decl instanceof DeclarationStatement ? (DeclarationStatement)decl : null;
            if (declarationStatement == null) break block8;
            DeclarationStatement it = declarationStatement;
            boolean bl = false;
            Map<String, Declaration> map = ((LLVMIRLanguageFrontend)this.lang).getBindingsCache();
            String string = LLVMIRLanguageFrontendKt.getSymbolName(instr);
            Declaration declaration = ((DeclarationStatement)decl).getSingleDeclaration();
            if (declaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            }
            VariableDeclaration variableDeclaration = (VariableDeclaration)declaration;
            map.put(string, (Declaration)variableDeclaration);
        }
        return decl;
    }

    public static /* synthetic */ Statement handleBinaryOperator$default(StatementHandler statementHandler, LLVMValueRef lLVMValueRef, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return statementHandler.handleBinaryOperator(lLVMValueRef, string, bl, bl2);
    }

    private final GotoStatement assembleGotoStatement(LLVMValueRef instr, LLVMValueRef bbTarget) {
        GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        BiConsumer<Object, Object> assigneeTargetLabel = (arg_0, arg_1) -> StatementHandler.assembleGotoStatement$lambda-6(gotoStatement, arg_0, arg_1);
        LLVMBasicBlockRef lLVMBasicBlockRef = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)bbTarget);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMBasicBlockRef, (String)"LLVMValueAsBasicBlock(bbTarget)");
        LLVMBasicBlockRef bb = lLVMBasicBlockRef;
        String labelName = LLVM.LLVMGetBasicBlockName((LLVMBasicBlockRef)bb).getString();
        gotoStatement.setLabelName(labelName);
        try {
            LabelStatement label = NodeBuilder.newLabelStatement$default((String)labelName, null, null, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)labelName, (String)"labelName");
            label.setName(labelName);
            ((LLVMIRLanguageFrontend)this.lang).registerObjectListener(label, assigneeTargetLabel);
            gotoStatement.getTargetLabel().getLabel();
        }
        catch (Exception e) {
            ((LLVMIRLanguageFrontend)this.lang).registerPredicateListener((arg_0, arg_1) -> StatementHandler.assembleGotoStatement$lambda-7(gotoStatement, arg_0, arg_1), assigneeTargetLabel);
        }
        return gotoStatement;
    }

    private final String getBasicBlockName(LLVMBasicBlockRef bb) {
        String labelName = LLVM.LLVMGetBasicBlockName((LLVMBasicBlockRef)bb).getString();
        CharSequence charSequence = labelName;
        if (charSequence == null || charSequence.length() == 0) {
            String bbStr = LLVM.LLVMPrintValueToString((LLVMValueRef)LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)bb)).getString();
            Intrinsics.checkNotNullExpressionValue((Object)bbStr, (String)"bbStr");
            String[] stringArray = new String[]{"\n"};
            String firstLine = (String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)bbStr)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            if (StringsKt.contains$default((CharSequence)firstLine, (CharSequence)":", (boolean)false, (int)2, null)) {
                String string = firstLine.substring(0, StringsKt.indexOf$default((CharSequence)firstLine, (String)":", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                labelName = string;
            }
        }
        String string = labelName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"labelName");
        return string;
    }

    private static final Statement _init_$lambda-1(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Pointer pointer = it;
        if (pointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bytedeco.llvm.LLVM.LLVMValueRef");
        }
        return this$0.handleInstruction((LLVMValueRef)pointer);
    }

    private static final Statement _init_$lambda-2(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Pointer pointer = it;
        if (pointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bytedeco.llvm.LLVM.LLVMBasicBlockRef");
        }
        return this$0.handleBasicBlock((LLVMBasicBlockRef)pointer);
    }

    private static final void assembleGotoStatement$lambda-6(GotoStatement $goto, Object object, Object to) {
        Intrinsics.checkNotNullParameter((Object)$goto, (String)"$goto");
        Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
        if (to instanceof LabelStatement) {
            $goto.setTargetLabel((LabelStatement)to);
        } else if (!Intrinsics.areEqual((Object)$goto.getTargetLabel(), (Object)to)) {
            Handler.log.error(to + " is not a LabelStatement");
        }
    }

    private static final boolean assembleGotoStatement$lambda-7(GotoStatement $goto, Object object, Object to) {
        Intrinsics.checkNotNullParameter((Object)$goto, (String)"$goto");
        return to instanceof LabelStatement && Intrinsics.areEqual((Object)((LabelStatement)to).getLabel(), (Object)$goto.getLabelName());
    }
}

