/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.llvm;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.annotations.FunctionReplacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import org.bytedeco.llvm.LLVM.LLVMTypeRef;
import org.bytedeco.llvm.LLVM.LLVMValueRef;
import org.bytedeco.llvm.global.LLVM;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J*\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0003J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0003J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0003J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0003J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0003J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0003J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00103\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00105\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bH\u0003\u00a8\u00066"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/llvm/StatementHandler;", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lorg/bytedeco/javacpp/Pointer;", "Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;", "lang", "(Lde/fraunhofer/aisec/cpg/frontends/llvm/LLVMIRLanguageFrontend;)V", "declarationOrNot", "rhs", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "valueRef", "Lorg/bytedeco/llvm/LLVM/LLVMValueRef;", "extractBasicBlockLabel", "Lde/fraunhofer/aisec/cpg/graph/statements/LabelStatement;", "handleAlloca", "instr", "handleAtomiccmpxchg", "handleAtomicrmw", "handleBasicBlock", "Lde/fraunhofer/aisec/cpg/graph/statements/CompoundStatement;", "bb", "Lorg/bytedeco/llvm/LLVM/LLVMBasicBlockRef;", "handleBinaryInstruction", "handleBinaryOperator", "op", "", "unsigned", "", "unordered", "handleBrStatement", "handleCatchpad", "handleCatchret", "handleCatchswitch", "handleCleanuppad", "handleExtractelement", "handleFence", "handleFloatComparison", "handleFreeze", "handleFunctionCall", "handleIndirectbrStatement", "handleInsertValue", "handleInsertelement", "handleInstruction", "handleIntegerComparison", "handleLandingpad", "handleLoad", "handlePhi", "", "tu", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "handleShufflevector", "handleStore", "handleSwitchStatement", "handleVaArg", "cpg-language-llvm"})
public final class StatementHandler
extends Handler<Statement, Pointer, LLVMIRLanguageFrontend> {
    public StatementHandler(@NotNull LLVMIRLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        super(Statement::new, (LanguageFrontend)lang);
        this.map.put(LLVMValueRef.class, arg_0 -> StatementHandler._init_$lambda-0(this, arg_0));
        this.map.put(LLVMBasicBlockRef.class, arg_0 -> StatementHandler._init_$lambda-1(this, arg_0));
    }

    private final Statement handleInstruction(LLVMValueRef instr) {
        if (LLVM.LLVMIsABinaryOperator((LLVMValueRef)instr) != null) {
            return this.handleBinaryInstruction(instr);
        }
        if (LLVM.LLVMIsACastInst((LLVMValueRef)instr) != null) {
            return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleCastInstruction(instr), instr);
        }
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        int opcode = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv);
        switch (opcode) {
            case 1: {
                ReturnStatement ret = NodeBuilder.newReturnStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
                if (numOps != 0) {
                    ret.setReturnValue(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
                }
                return (Statement)ret;
            }
            case 2: {
                return this.handleBrStatement(instr);
            }
            case 3: {
                return this.handleSwitchStatement(instr);
            }
            case 4: {
                return this.handleIndirectbrStatement(instr);
            }
            case 5: 
            case 45: {
                return this.handleFunctionCall(instr);
            }
            case 7: {
                return (Statement)NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            }
            case 67: {
                Handler.log.error("Cannot parse callbr instruction yet");
                break;
            }
            case 66: {
                UnaryOperator fneg = NodeBuilder.newUnaryOperator$default((String)"-", (boolean)false, (boolean)true, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)48, null);
                fneg.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
                return (Statement)fneg;
            }
            case 26: {
                return this.handleAlloca(instr);
            }
            case 27: {
                return this.handleLoad(instr);
            }
            case 28: {
                return this.handleStore(instr);
            }
            case 29: 
            case 53: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleGetElementPtr$cpg_language_llvm(instr), instr);
            }
            case 42: {
                return this.handleIntegerComparison(instr);
            }
            case 43: {
                return this.handleFloatComparison(instr);
            }
            case 44: {
                ((LLVMIRLanguageFrontend)this.lang).getPhiList().add(instr);
                return (Statement)NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            }
            case 46: {
                return this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handleSelect(instr), instr);
            }
            case 47: 
            case 48: {
                Handler.log.info("userop instruction is not a real instruction. Replacing it with empty statement");
                return (Statement)NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            }
            case 49: {
                return this.handleVaArg(instr);
            }
            case 50: {
                return this.handleExtractelement(instr);
            }
            case 51: {
                return this.handleInsertelement(instr);
            }
            case 52: {
                return this.handleShufflevector(instr);
            }
            case 54: {
                return this.handleInsertValue(instr);
            }
            case 68: {
                return this.handleFreeze(instr);
            }
            case 55: {
                return this.handleFence(instr);
            }
            case 56: {
                return this.handleAtomiccmpxchg(instr);
            }
            case 57: {
                return this.handleAtomicrmw(instr);
            }
            case 58: {
                UnaryOperator throwOperation = NodeBuilder.newUnaryOperator$default((String)"throw", (boolean)false, (boolean)true, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)48, null);
                return (Statement)throwOperation;
            }
            case 59: {
                return this.handleLandingpad(instr);
            }
            case 61: {
                return this.handleCatchret(instr);
            }
            case 62: {
                return this.handleCatchret(instr);
            }
            case 63: {
                return this.handleCatchpad(instr);
            }
            case 64: {
                return this.handleCleanuppad(instr);
            }
            case 65: {
                return this.handleCatchswitch(instr);
            }
        }
        Handler.log.error("Not handling instruction opcode {} yet", (Object)opcode);
        return new Statement();
    }

    private final Statement handleCatchret(LLVMValueRef instr) {
        LLVMValueRef unwindDest;
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 62 ? LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1) : (unwindDest = LLVM.LLVMGetUnwindDest((LLVMValueRef)instr) != null ? LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)LLVM.LLVMGetUnwindDest((LLVMValueRef)instr)) : (LLVMValueRef)null);
        if (unwindDest != null) {
            LabelStatement unwindDestination = this.extractBasicBlockLabel(unwindDest);
            GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            gotoStatement.setTargetLabel(unwindDestination);
            gotoStatement.setLabelName(unwindDestination.getName());
            LLVMValueRef $this$opCode$iv2 = instr;
            boolean $i$f$getOpCode2 = false;
            gotoStatement.setName(LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv2) == 62 ? "catchret" : "cleanuppad");
            return (Statement)gotoStatement;
        }
        EmptyStatement emptyStatement = NodeBuilder.newEmptyStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        LLVMValueRef $this$opCode$iv3 = instr;
        boolean $i$f$getOpCode3 = false;
        emptyStatement.setName(LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv3) == 62 ? "catchret" : "cleanuppad");
        return (Statement)emptyStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.catchswitch", "llvm.matchesCatchpad"}, replaces="catchswitch")
    private final Statement handleCatchswitch(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        Expression parent = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)nodeCode, null, null, (int)6, null);
        CallExpression dummyCall = NodeBuilder.newCallExpression$default((String)"llvm.catchswitch", (String)"llvm.catchswitch", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        dummyCall.addArgument(parent, "parent");
        DeclarationStatement tokenGeneration = (DeclarationStatement)this.declarationOrNot((Expression)dummyCall, instr);
        compoundStatement.addStatement((Statement)tokenGeneration);
        IfStatement ifStatement = NodeBuilder.newIfStatement$default((String)nodeCode, null, null, (int)6, null);
        IfStatement currentIfStatement = null;
        int idx = 1;
        while (idx < numOps) {
            if (currentIfStatement == null) {
                currentIfStatement = ifStatement;
            } else {
                IfStatement newIf = NodeBuilder.newIfStatement$default((String)nodeCode, null, null, (int)6, null);
                currentIfStatement.setElseStatement((Statement)newIf);
                currentIfStatement = newIf;
            }
            LLVMValueRef bbTarget = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            LLVMValueRef catchpad = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)LLVM.LLVMValueAsBasicBlock((LLVMValueRef)bbTarget));
            int catchOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)catchpad);
            CallExpression matchesCatchpad = NodeBuilder.newCallExpression$default((String)"llvm.matchesCatchpad", (String)"llvm.matchesCatchpad", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
            LLVMValueRef parentCatchSwitch = LLVM.LLVMGetParentCatchSwitch((LLVMValueRef)catchpad);
            Object object = ((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handle(parentCatchSwitch);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
            }
            Expression catchswitch = (Expression)object;
            matchesCatchpad.addArgument(catchswitch, "parentCatchswitch");
            int n = 0;
            while (n < catchOps) {
                int i = n++;
                LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.lang;
                Intrinsics.checkNotNullExpressionValue((Object)catchpad, (String)"catchpad");
                Expression arg = lLVMIRLanguageFrontend.getOperandValueAtIndex(catchpad, i);
                matchesCatchpad.addArgument(arg, Intrinsics.stringPlus((String)"args_", (Object)i));
            }
            currentIfStatement.setCondition((Expression)matchesCatchpad);
            Intrinsics.checkNotNullExpressionValue((Object)bbTarget, (String)"bbTarget");
            LabelStatement caseLabelStatement = this.extractBasicBlockLabel(bbTarget);
            GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)nodeCode, null, null, (int)6, null);
            gotoStatement.setTargetLabel(caseLabelStatement);
            gotoStatement.setLabelName(caseLabelStatement.getName());
            currentIfStatement.setThenStatement((Statement)gotoStatement);
            int n2 = idx;
            idx = n2 + 1;
        }
        LLVMBasicBlockRef unwindDest = LLVM.LLVMGetUnwindDest((LLVMValueRef)instr);
        if (unwindDest != null) {
            LLVMValueRef catchOps = LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)unwindDest);
            Intrinsics.checkNotNullExpressionValue((Object)catchOps, (String)"LLVMBasicBlockAsValue(unwindDest)");
            LabelStatement unwindDestination = this.extractBasicBlockLabel(catchOps);
            GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)nodeCode, null, null, (int)6, null);
            gotoStatement.setTargetLabel(unwindDestination);
            gotoStatement.setLabelName(unwindDestination.getName());
            if (currentIfStatement == null) {
                currentIfStatement = ifStatement;
            }
            IfStatement ifStatement2 = currentIfStatement;
            Intrinsics.checkNotNull((Object)ifStatement2);
            ifStatement2.setElseStatement((Statement)gotoStatement);
        } else {
            UnaryOperator throwOperation = NodeBuilder.newUnaryOperator$default((String)"throw", (boolean)false, (boolean)true, (String)nodeCode, null, null, (int)48, null);
            IfStatement ifStatement3 = currentIfStatement;
            Intrinsics.checkNotNull((Object)ifStatement3);
            ifStatement3.setElseStatement((Statement)throwOperation);
        }
        compoundStatement.addStatement((Statement)ifStatement);
        return (Statement)compoundStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.cleanuppad"}, replaces="cleanuppad")
    private final Statement handleCleanuppad(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)instr);
        Expression catchswitch = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        CallExpression dummyCall = NodeBuilder.newCallExpression$default((String)"llvm.cleanuppad", (String)"llvm.cleanuppad", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        dummyCall.addArgument(catchswitch, "parentCatchswitch");
        int n = 1;
        while (n < numOps) {
            int i = n++;
            Expression arg = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, i);
            dummyCall.addArgument(arg, Intrinsics.stringPlus((String)"args_", (Object)(i - 1)));
        }
        return this.declarationOrNot((Expression)dummyCall, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.catchpad"}, replaces="catchpad")
    private final Statement handleCatchpad(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumArgOperands((LLVMValueRef)instr);
        LLVMValueRef parentCatchSwitch = LLVM.LLVMGetParentCatchSwitch((LLVMValueRef)instr);
        Object object = ((LLVMIRLanguageFrontend)this.lang).getExpressionHandler().handle(parentCatchSwitch);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression");
        }
        Expression catchswitch = (Expression)object;
        CallExpression dummyCall = NodeBuilder.newCallExpression$default((String)"llvm.catchpad", (String)"llvm.catchpad", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        dummyCall.addArgument(catchswitch, "parentCatchswitch");
        int n = 0;
        while (n < numOps) {
            int i = n++;
            Expression arg = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, i);
            dummyCall.addArgument(arg, Intrinsics.stringPlus((String)"args_", (Object)i));
        }
        return this.declarationOrNot((Expression)dummyCall, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.va_arg"}, replaces="va_arg")
    private final Statement handleVaArg(LLVMValueRef instr) {
        CallExpression callExpr = NodeBuilder.newCallExpression$default((String)"llvm.va_arg", (String)"llvm.va_arg", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        Expression operandName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        callExpr.addArgument(operandName);
        Type expectedType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr);
        Literal typeLiteral = NodeBuilder.newLiteral$default((Object)expectedType, (Type)expectedType, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        callExpr.addArgument((Expression)typeLiteral);
        return this.declarationOrNot((Expression)callExpr, instr);
    }

    private final Statement handleBinaryInstruction(LLVMValueRef instr) {
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode = false;
        switch (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv)) {
            case 8: 
            case 9: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "+", false, false, 8, null);
            }
            case 10: 
            case 11: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "-", false, false, 8, null);
            }
            case 12: 
            case 13: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "*", false, false, 8, null);
            }
            case 14: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", true, false, 8, null);
            }
            case 15: 
            case 16: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "/", false, false, 8, null);
            }
            case 17: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", true, false, 8, null);
            }
            case 18: 
            case 19: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "%", false, false, 8, null);
            }
            case 20: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "<<", false, false, 8, null);
            }
            case 21: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", true, false, 8, null);
            }
            case 22: {
                return StatementHandler.handleBinaryOperator$default(this, instr, ">>", false, false, 8, null);
            }
            case 23: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "&", false, false, 8, null);
            }
            case 24: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "|", false, false, 8, null);
            }
            case 25: {
                return StatementHandler.handleBinaryOperator$default(this, instr, "^", false, false, 8, null);
            }
        }
        return new Statement();
    }

    private final Statement handleAlloca(LLVMValueRef instr) {
        ArrayCreationExpression array = NodeBuilder.newArrayCreationExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        array.setType(((LLVMIRLanguageFrontend)this.lang).typeOf(instr));
        Expression size = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        array.addDimension(size);
        return this.declarationOrNot((Expression)array, instr);
    }

    private final Statement handleStore(LLVMValueRef instr) {
        BinaryOperator binOp = NodeBuilder.newBinaryOperator$default((String)"=", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
        UnaryOperator dereference = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)"", null, null, (int)48, null);
        dereference.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        binOp.setLhs((Expression)dereference);
        binOp.setRhs(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        return (Statement)binOp;
    }

    private final Statement handleLoad(LLVMValueRef instr) {
        UnaryOperator ref = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)"", null, null, (int)48, null);
        ref.setInput(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        return this.declarationOrNot((Expression)ref, instr);
    }

    private final Statement handleIntegerComparison(LLVMValueRef instr) {
        String string;
        boolean unsigned = false;
        switch (LLVM.LLVMGetICmpPredicate((LLVMValueRef)instr)) {
            case 32: {
                string = "==";
                break;
            }
            case 33: {
                string = "!=";
                break;
            }
            case 34: {
                unsigned = true;
                string = ">";
                break;
            }
            case 35: {
                unsigned = true;
                string = ">=";
                break;
            }
            case 36: {
                unsigned = true;
                string = "<";
                break;
            }
            case 37: {
                unsigned = true;
                string = "<=";
                break;
            }
            case 38: {
                string = ">";
                break;
            }
            case 39: {
                string = ">=";
                break;
            }
            case 40: {
                string = "<";
                break;
            }
            case 41: {
                string = "<=";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return StatementHandler.handleBinaryOperator$default(this, instr, cmpPred, unsigned, false, 8, null);
    }

    private final Statement handleFloatComparison(LLVMValueRef instr) {
        String string;
        boolean unordered = false;
        switch (LLVM.LLVMGetFCmpPredicate((LLVMValueRef)instr)) {
            case 0: {
                return (Statement)NodeBuilder.newLiteral$default((Object)false, (Type)TypeParser.createFrom((String)"i1", (boolean)true), (String)"false", null, null, (int)24, null);
            }
            case 1: {
                string = "==";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = ">=";
                break;
            }
            case 4: {
                string = "<";
                break;
            }
            case 5: {
                string = "<=";
                break;
            }
            case 6: {
                string = "!=";
                break;
            }
            case 7: {
                string = "ord";
                break;
            }
            case 8: {
                string = "uno";
                break;
            }
            case 9: {
                unordered = true;
                string = "==";
                break;
            }
            case 10: {
                unordered = true;
                string = ">";
                break;
            }
            case 11: {
                unordered = true;
                string = ">=";
                break;
            }
            case 12: {
                unordered = true;
                string = "<";
                break;
            }
            case 13: {
                unordered = true;
                string = "<=";
                break;
            }
            case 14: {
                unordered = true;
                string = "!=";
                break;
            }
            case 15: {
                return (Statement)NodeBuilder.newLiteral$default((Object)true, (Type)TypeParser.createFrom((String)"i1", (boolean)true), (String)"true", null, null, (int)24, null);
            }
            default: {
                string = "unknown";
            }
        }
        String cmpPred = string;
        return this.handleBinaryOperator(instr, cmpPred, false, unordered);
    }

    private final Statement handleInsertValue(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumIndices((LLVMValueRef)instr);
        IntPointer indices = LLVM.LLVMGetIndices((LLVMValueRef)instr);
        LLVMIRLanguageFrontend lLVMIRLanguageFrontend = (LLVMIRLanguageFrontend)this.lang;
        LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
        Type baseType = lLVMIRLanguageFrontend.typeOf(lLVMValueRef);
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression valueToSet = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression base = operand;
        Statement copy = new Statement();
        if (!(operand instanceof ConstructExpression) && (copy = this.declarationOrNot(operand, instr)) instanceof DeclarationStatement) {
            Declaration declaration = ((DeclarationStatement)copy).getSingleDeclaration();
            if (declaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            }
            base = (Expression)NodeBuilder.newDeclaredReferenceExpression$default((String)((DeclarationStatement)copy).getSingleDeclaration().getName(), (Type)((VariableDeclaration)declaration).getType(), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        }
        Expression expr = null;
        int n = 0;
        while (n < numOps) {
            FieldDeclaration field;
            RecordDeclaration record;
            int idx = n++;
            int index = indices.get((long)idx);
            if (base instanceof ConstructExpression) {
                if (idx == numOps - 1) {
                    ((ConstructExpression)base).setArgument(index, valueToSet);
                    return this.declarationOrNot(operand, instr);
                }
                Object e = ((ConstructExpression)base).getArguments().get(index);
                Intrinsics.checkNotNullExpressionValue(e, (String)"base.arguments[index]");
                base = (Expression)e;
                continue;
            }
            Type type = baseType;
            ObjectType objectType = type instanceof ObjectType ? (ObjectType)type : null;
            Object object = record = objectType == null ? null : objectType.getRecordDeclaration();
            if (record == null) {
                Handler.log.error("Could not find structure type with name {}, cannot continue", (Object)baseType.getTypeName());
                break;
            }
            Handler.log.debug("Trying to access a field within the record declaration of {}", (Object)record.getName());
            FieldDeclaration fieldDeclaration = field = record.getField(Intrinsics.stringPlus((String)"field_", (Object)index));
            Object object2 = fieldDeclaration == null ? null : fieldDeclaration.getType();
            if (object2 == null) {
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                object2 = (Type)unknownType;
            }
            baseType = object2;
            FieldDeclaration fieldDeclaration2 = field;
            FieldDeclaration fieldDeclaration3 = field;
            expr = (Expression)NodeBuilder.newMemberExpression$default((Expression)base, (Type)(fieldDeclaration2 == null ? null : fieldDeclaration2.getType()), (String)(fieldDeclaration3 == null ? null : fieldDeclaration3.getName()), (String)".", (String)"", null, null, (int)96, null);
            Handler.log.info("{}", (Object)expr);
            base = expr;
        }
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        BinaryOperator assignment = NodeBuilder.newBinaryOperator$default((String)"=", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
        assignment.setLhs(base);
        assignment.setRhs(valueToSet);
        compoundStatement.addStatement(copy);
        compoundStatement.addStatement((Statement)assignment);
        return (Statement)compoundStatement;
    }

    @FunctionReplacement(addedFunctions={"llvm.freeze"}, replaces="freeze")
    private final Statement handleFreeze(LLVMValueRef instr) {
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        String instrCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        BinaryOperator condition = NodeBuilder.newBinaryOperator$default((String)"&&", (String)instrCode, null, null, (int)12, null);
        BinaryOperator undefCheck = NodeBuilder.newBinaryOperator$default((String)"!=", (String)instrCode, null, null, (int)12, null);
        undefCheck.setLhs(operand);
        undefCheck.setRhs((Expression)NodeBuilder.newLiteral$default(null, (Type)operand.getType(), (String)instrCode, null, null, (int)24, null));
        condition.setLhs((Expression)undefCheck);
        BinaryOperator poisonCheck = NodeBuilder.newBinaryOperator$default((String)"!=", (String)instrCode, null, null, (int)12, null);
        poisonCheck.setLhs(operand);
        poisonCheck.setRhs((Expression)NodeBuilder.newLiteral$default((Object)"POISON", (Type)operand.getType(), (String)instrCode, null, null, (int)24, null));
        condition.setRhs((Expression)poisonCheck);
        CallExpression callExpression = NodeBuilder.newCallExpression$default((String)"llvm.freeze", (String)"llvm.freeze", (String)instrCode, (boolean)false, null, null, (int)48, null);
        callExpression.addArgument(operand);
        ConditionalExpression conditional = NodeBuilder.newConditionalExpression$default((Expression)((Expression)condition), (Expression)operand, (Expression)((Expression)callExpression), (Type)operand.getType(), null, null, null, (int)112, null);
        return this.declarationOrNot((Expression)conditional, instr);
    }

    @FunctionReplacement(addedFunctions={"llvm.fence"}, replaces="fence")
    private final Statement handleFence(LLVMValueRef instr) {
        String instrString = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CallExpression callExpression = NodeBuilder.newCallExpression$default((String)"llvm.fence", (String)"llvm.fence", (String)instrString, (boolean)false, null, null, (int)48, null);
        Literal ordering = NodeBuilder.newLiteral$default((Object)LLVM.LLVMGetOrdering((LLVMValueRef)instr), (Type)TypeParser.createFrom((String)"i32", (boolean)true), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null);
        callExpression.addArgument((Expression)ordering, "ordering");
        String string = instrString;
        if (string == null ? false : StringsKt.contains$default((CharSequence)string, (CharSequence)"syncscope", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"\""};
            String syncscope = (String)StringsKt.split$default((CharSequence)instrString, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            callExpression.addArgument((Expression)NodeBuilder.newLiteral$default((Object)syncscope, (Type)TypeParser.createFrom((String)"String", (boolean)true), (String)instrString, null, null, (int)24, null), "syncscope");
        }
        return (Statement)callExpression;
    }

    private final Statement handleAtomiccmpxchg(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
        compoundStatement.setName("atomiccmpxchg");
        Expression ptr = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression cmp = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression value = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 2);
        UnaryOperator ptrDeref = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)instrStr, null, null, (int)48, null);
        ptrDeref.setInput(ptr);
        BinaryOperator cmpExpr = NodeBuilder.newBinaryOperator$default((String)"==", (String)instrStr, null, null, (int)12, null);
        cmpExpr.setLhs((Expression)ptrDeref);
        cmpExpr.setRhs(cmp);
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            Type targetType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr);
            ConstructExpression construct = NodeBuilder.newConstructExpression$default((String)"", null, null, (int)6, null);
            ObjectType objectType = targetType instanceof ObjectType ? (ObjectType)targetType : null;
            construct.setInstantiates((Declaration)(objectType == null ? null : objectType.getRecordDeclaration()));
            construct.addArgument((Expression)ptrDeref);
            construct.addArgument((Expression)cmpExpr);
            Statement decl = this.declarationOrNot((Expression)construct, instr);
            compoundStatement.addStatement(decl);
        }
        BinaryOperator assignment = NodeBuilder.newBinaryOperator$default((String)"=", (String)instrStr, null, null, (int)12, null);
        assignment.setLhs((Expression)ptrDeref);
        assignment.setRhs(value);
        IfStatement ifStatement = NodeBuilder.newIfStatement$default((String)instrStr, null, null, (int)6, null);
        ifStatement.setCondition((Expression)cmpExpr);
        ifStatement.setThenStatement((Statement)assignment);
        compoundStatement.addStatement((Statement)ifStatement);
        return (Statement)compoundStatement;
    }

    private final Statement handleAtomicrmw(LLVMValueRef instr) {
        Statement statement;
        String lhs = LLVM.LLVMGetValueName((LLVMValueRef)instr).getString();
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        int operation = LLVM.LLVMGetAtomicRMWBinOp((LLVMValueRef)instr);
        Expression ptr = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression value = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Type ty = value.getType();
        BinaryOperator exchOp = NodeBuilder.newBinaryOperator$default((String)"=", (String)instrStr, null, null, (int)12, null);
        exchOp.setName("atomicrmw");
        UnaryOperator ptrDeref = NodeBuilder.newUnaryOperator$default((String)"*", (boolean)false, (boolean)true, (String)instrStr, null, null, (int)48, null);
        ptrDeref.setInput(ptr);
        exchOp.setLhs((Expression)ptrDeref);
        switch (operation) {
            case 0: {
                exchOp.setRhs(value);
                break;
            }
            case 1: 
            case 11: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"+", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 2: 
            case 12: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"-", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 3: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"&", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 4: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"|", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                UnaryOperator unaryOperator = NodeBuilder.newUnaryOperator$default((String)"~", (boolean)false, (boolean)true, (String)instrStr, null, null, (int)48, null);
                unaryOperator.setInput((Expression)binaryOperator);
                exchOp.setRhs((Expression)unaryOperator);
                break;
            }
            case 5: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"|", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 6: {
                BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator$default((String)"^", (String)instrStr, null, null, (int)12, null);
                binaryOperator.setLhs((Expression)ptrDeref);
                binaryOperator.setRhs(value);
                exchOp.setRhs((Expression)binaryOperator);
                break;
            }
            case 7: 
            case 8: {
                String operatorCode = operation == 8 ? "<" : ">";
                BinaryOperator condition = NodeBuilder.newBinaryOperator$default((String)operatorCode, (String)instrStr, null, null, (int)12, null);
                condition.setLhs((Expression)ptrDeref);
                condition.setRhs(value);
                ConditionalExpression conditional = NodeBuilder.newConditionalExpression$default((Expression)((Expression)condition), (Expression)((Expression)ptrDeref), (Expression)value, (Type)ty, null, null, null, (int)112, null);
                exchOp.setRhs((Expression)conditional);
                break;
            }
            case 9: 
            case 10: {
                String operatorCode = operation == 10 ? "<" : ">";
                BinaryOperator condition = NodeBuilder.newBinaryOperator$default((String)operatorCode, (String)instrStr, null, null, (int)12, null);
                CastExpression castExprLhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                castExprLhs.setCastType(TypeParser.createFrom((String)Intrinsics.stringPlus((String)"u", (Object)ty.getName()), (boolean)true));
                castExprLhs.setExpression((Expression)ptrDeref);
                condition.setLhs((Expression)castExprLhs);
                CastExpression castExprRhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                castExprRhs.setCastType(TypeParser.createFrom((String)Intrinsics.stringPlus((String)"u", (Object)ty.getName()), (boolean)true));
                castExprRhs.setExpression(value);
                condition.setRhs((Expression)castExprRhs);
                ConditionalExpression conditional = NodeBuilder.newConditionalExpression$default((Expression)((Expression)condition), (Expression)((Expression)ptrDeref), (Expression)value, (Type)ty, null, null, null, (int)112, null);
                exchOp.setRhs((Expression)conditional);
                break;
            }
            default: {
                throw new TranslationException("LLVMAtomicRMWBinOp " + operation + " not supported");
            }
        }
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
            Object[] objectArray = new Statement[]{this.declarationOrNot((Expression)ptrDeref, instr), (Statement)exchOp};
            compoundStatement.setStatements(CollectionsKt.listOf((Object[])objectArray));
            statement = (Statement)compoundStatement;
        } else {
            statement = (Statement)exchOp;
        }
        return statement;
    }

    private final Statement handleIndirectbrStatement(LLVMValueRef instr) {
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        if (numOps < 2) {
            throw new TranslationException("Indirectbr statement without address and at least one target");
        }
        Expression address = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement$default((String)nodeCode, null, null, (int)6, null);
        switchStatement.selector = address;
        CompoundStatement caseStatements = NodeBuilder.newCompoundStatement$default((String)nodeCode, null, null, (int)6, null);
        int idx = 1;
        while (idx < numOps) {
            long caseBBAddress = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx)).address();
            CaseStatement caseStatement = NodeBuilder.newCaseStatement$default((String)nodeCode, null, null, (int)6, null);
            caseStatement.caseExpression = (Expression)NodeBuilder.newLiteral$default((Object)caseBBAddress, (Type)TypeParser.createFrom((String)"long", (boolean)true), (String)nodeCode, null, null, (int)24, null);
            caseStatements.addStatement((Statement)caseStatement);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, idx)");
            LabelStatement caseLabelStatement = this.extractBasicBlockLabel(lLVMValueRef);
            GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)nodeCode, null, null, (int)6, null);
            gotoStatement.setTargetLabel(caseLabelStatement);
            gotoStatement.setLabelName(caseLabelStatement.getName());
            caseStatements.addStatement((Statement)gotoStatement);
            int n = idx;
            idx = n + 1;
        }
        switchStatement.setStatement((Statement)caseStatements);
        return (Statement)switchStatement;
    }

    private final Statement handleBrStatement(LLVMValueRef instr) {
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 3) {
            IfStatement ifStatement = NodeBuilder.newIfStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            Expression condition = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
            ifStatement.setCondition(condition);
            GotoStatement elseGoto = NodeBuilder.newGotoStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 1)");
            LabelStatement elseLabel = this.extractBasicBlockLabel(lLVMValueRef);
            elseGoto.setTargetLabel(elseLabel);
            elseGoto.setLabelName(elseLabel.getName());
            ifStatement.setElseStatement((Statement)elseGoto);
            GotoStatement ifGoto = NodeBuilder.newGotoStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            LLVMValueRef lLVMValueRef2 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef2, (String)"LLVMGetOperand(instr, 2)");
            LabelStatement thenLabelStatement = this.extractBasicBlockLabel(lLVMValueRef2);
            ifGoto.setTargetLabel(thenLabelStatement);
            ifGoto.setLabelName(thenLabelStatement.getName());
            ifStatement.setThenStatement((Statement)ifGoto);
            return (Statement)ifStatement;
        }
        if (LLVM.LLVMGetNumOperands((LLVMValueRef)instr) == 1) {
            GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, 0)");
            LabelStatement labelStatement = this.extractBasicBlockLabel(lLVMValueRef);
            gotoStatement.setLabelName(labelStatement.getName());
            gotoStatement.setTargetLabel(labelStatement);
            return (Statement)gotoStatement;
        }
        throw new TranslationException("Wrong number of operands in br statement");
    }

    private final Statement handleSwitchStatement(LLVMValueRef instr) {
        LLVMValueRef caseLabelStatement;
        int numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        String nodeCode = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        if (numOps < 2 || numOps % 2 != 0) {
            throw new TranslationException("Switch statement without operand and default branch");
        }
        Expression operand = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement$default((String)nodeCode, null, null, (int)6, null);
        switchStatement.selector = operand;
        CompoundStatement caseStatements = NodeBuilder.newCompoundStatement$default((String)nodeCode, null, null, (int)6, null);
        int idx = 2;
        while (idx < numOps) {
            CaseStatement caseStatement = NodeBuilder.newCaseStatement$default((String)nodeCode, null, null, (int)6, null);
            caseStatement.caseExpression = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
            caseStatements.addStatement((Statement)caseStatement);
            int n = idx;
            idx = n + 1;
            LLVMValueRef lLVMValueRef = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)idx);
            Intrinsics.checkNotNullExpressionValue((Object)lLVMValueRef, (String)"LLVMGetOperand(instr, idx)");
            caseLabelStatement = this.extractBasicBlockLabel(lLVMValueRef);
            GotoStatement gotoStatement = NodeBuilder.newGotoStatement$default((String)nodeCode, null, null, (int)6, null);
            gotoStatement.setTargetLabel((LabelStatement)caseLabelStatement);
            gotoStatement.setLabelName(caseLabelStatement.getName());
            caseStatements.addStatement((Statement)gotoStatement);
            int n2 = idx;
            idx = n2 + 1;
        }
        caseStatements.addStatement((Statement)NodeBuilder.newDefaultStatement$default((String)nodeCode, null, null, (int)6, null));
        caseLabelStatement = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)caseLabelStatement, (String)"LLVMGetOperand(instr, 1)");
        LabelStatement defaultLabel = this.extractBasicBlockLabel(caseLabelStatement);
        GotoStatement defaultGoto = NodeBuilder.newGotoStatement$default((String)nodeCode, null, null, (int)6, null);
        defaultGoto.setTargetLabel(defaultLabel);
        defaultGoto.setLabelName(defaultLabel.getName());
        caseStatements.addStatement((Statement)defaultGoto);
        switchStatement.setStatement((Statement)caseStatements);
        return (Statement)switchStatement;
    }

    private final Statement handleFunctionCall(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        LLVMValueRef calledFunc = LLVM.LLVMGetCalledValue((LLVMValueRef)instr);
        String calledFuncName = LLVM.LLVMGetValueName((LLVMValueRef)calledFunc).getString();
        int max = LLVM.LLVMGetNumOperands((LLVMValueRef)instr) - 1;
        int idx = 0;
        if (calledFuncName.equals("")) {
            Expression opName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, max);
            calledFuncName = opName.getName();
        }
        LabelStatement catchLabel = new LabelStatement();
        LabelStatement continueLabel = new LabelStatement();
        LLVMValueRef $this$opCode$iv522222 = instr;
        boolean $i$f$getOpCode = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv522222) == 5) {
            int $this$opCode$iv522222 = max;
            max = $this$opCode$iv522222 + -1;
            LLVMValueRef $this$opCode$iv522222 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)max);
            Intrinsics.checkNotNullExpressionValue((Object)$this$opCode$iv522222, (String)"LLVMGetOperand(instr, max)");
            catchLabel = this.extractBasicBlockLabel($this$opCode$iv522222);
            int $this$opCode$iv522222 = max;
            max = $this$opCode$iv522222 + -1;
            LLVMValueRef $this$opCode$iv522222 = LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)max);
            Intrinsics.checkNotNullExpressionValue((Object)$this$opCode$iv522222, (String)"LLVMGetOperand(instr, max)");
            continueLabel = this.extractBasicBlockLabel($this$opCode$iv522222);
            int $this$opCode$iv522222 = max;
            max = $this$opCode$iv522222 + -1;
            Handler.log.info("Invoke expression: Usually continues at " + continueLabel.getName() + ", exception continues at " + catchLabel.getName());
        }
        CallExpression callExpr = NodeBuilder.newCallExpression$default((String)calledFuncName, (String)calledFuncName, (String)instrStr, (boolean)false, null, null, (int)48, null);
        while (idx < max) {
            Expression operandName = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, idx);
            callExpr.addArgument(operandName);
            int n = idx;
            idx = n + 1;
        }
        LLVMValueRef $this$opCode$iv = instr;
        boolean $i$f$getOpCode2 = false;
        if (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)$this$opCode$iv) == 5) {
            String string = instrStr;
            Intrinsics.checkNotNull((Object)string);
            TryStatement tryStatement = NodeBuilder.newTryStatement$default((String)string, null, null, (int)6, null);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().enterScope((Node)tryStatement);
            CompoundStatement tryBlock = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
            tryBlock.addStatement(this.declarationOrNot((Expression)callExpr, instr));
            GotoStatement tryContinue = NodeBuilder.newGotoStatement$default((String)instrStr, null, null, (int)6, null);
            tryContinue.setTargetLabel(continueLabel);
            tryBlock.addStatement((Statement)tryContinue);
            tryStatement.setTryBlock(tryBlock);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().leaveScope((Node)tryStatement);
            CatchClause catchClause = NodeBuilder.newCatchClause$default((String)instrStr, null, null, (int)6, null);
            catchClause.setName(catchLabel.getName());
            GotoStatement gotoCatch = NodeBuilder.newGotoStatement$default((String)instrStr, null, null, (int)6, null);
            gotoCatch.setTargetLabel(catchLabel);
            catchClause.setParameter(NodeBuilder.newVariableDeclaration$default((String)Intrinsics.stringPlus((String)"e_", (Object)catchLabel.getName()), (Type)((Type)UnknownType.getUnknownType()), (String)instrStr, (boolean)true, null, null, (int)48, null));
            CompoundStatement catchCompoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
            catchCompoundStatement.addStatement((Statement)gotoCatch);
            catchClause.setBody(catchCompoundStatement);
            Object[] objectArray = new CatchClause[]{catchClause};
            tryStatement.setCatchClauses(CollectionsKt.mutableListOf((Object[])objectArray));
            return (Statement)tryStatement;
        }
        return this.declarationOrNot((Expression)callExpr, instr);
    }

    private final Statement handleLandingpad(LLVMValueRef instr) {
        String lhs;
        Object object;
        int i;
        String string = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        Intrinsics.checkNotNull((Object)string);
        CatchClause catchInstr = NodeBuilder.newCatchClause$default((String)string, null, null, (int)6, null);
        int numClauses = LLVM.LLVMGetNumClauses((LLVMValueRef)instr);
        String catchType = "";
        int n = 0;
        while (n < numClauses) {
            LLVMValueRef clause;
            if (LLVM.LLVMIsAConstantArray((LLVMValueRef)(clause = LLVM.LLVMGetClause((LLVMValueRef)instr, (int)(i = n++)))) != null) continue;
            if (LLVM.LLVMIsNull((LLVMValueRef)clause) == 1) {
                catchType = Intrinsics.stringPlus((String)catchType, (Object)"... | ");
                continue;
            }
            catchType = catchType + LLVM.LLVMGetValueName((LLVMValueRef)clause).getString() + " | ";
        }
        if (StringsKt.endsWith$default((String)catchType, (String)" | ", (boolean)false, (int)2, null)) {
            String string2 = catchType;
            i = 0;
            int clause = catchType.length() - 3;
            object = string2.substring(i, clause);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            catchType = object;
        }
        String exceptionName = !Intrinsics.areEqual((Object)(lhs = (String)((LLVMIRLanguageFrontend)this.lang).getNameOf(instr).getFirst()), (Object)"") ? lhs : Intrinsics.stringPlus((String)"e_", (Object)instr.address());
        VariableDeclaration except = NodeBuilder.newVariableDeclaration$default((String)exceptionName, (Type)TypeParser.createFrom((String)catchType, (boolean)false), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), (boolean)false, null, null, (int)48, null);
        object = ((LLVMIRLanguageFrontend)this.lang).getBindingsCache();
        String string3 = Intrinsics.stringPlus((String)"%", (Object)exceptionName);
        object.put(string3, except);
        catchInstr.setParameter(except);
        catchInstr.setName(catchType);
        return (Statement)catchInstr;
    }

    private final Statement handleInsertelement(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement$default((String)instrStr, null, null, (int)6, null);
        Statement newArrayDecl = this.declarationOrNot(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0), instr);
        compoundStatement.addStatement(newArrayDecl);
        Object e = newArrayDecl.getDeclarations().get(0);
        VariableDeclaration decl = e instanceof VariableDeclaration ? (VariableDeclaration)e : null;
        ArraySubscriptionExpression arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)instrStr, null, null, (int)6, null);
        VariableDeclaration variableDeclaration = decl;
        VariableDeclaration variableDeclaration2 = decl;
        arrayExpr.setArrayExpression((Expression)NodeBuilder.newDeclaredReferenceExpression$default((String)(variableDeclaration == null ? null : variableDeclaration.getName()), (Type)(variableDeclaration2 == null ? null : variableDeclaration2.getType()), (String)instrStr, null, null, (int)24, null));
        arrayExpr.setSubscriptExpression(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 2));
        BinaryOperator binaryExpr = NodeBuilder.newBinaryOperator$default((String)"=", (String)instrStr, null, null, (int)12, null);
        binaryExpr.setLhs((Expression)arrayExpr);
        binaryExpr.setRhs(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        compoundStatement.addStatement((Statement)binaryExpr);
        return (Statement)compoundStatement;
    }

    private final Statement handleExtractelement(LLVMValueRef instr) {
        ArraySubscriptionExpression arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        arrayExpr.setArrayExpression(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0));
        arrayExpr.setSubscriptExpression(((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1));
        return this.declarationOrNot((Expression)arrayExpr, instr);
    }

    private final Statement handleShufflevector(LLVMValueRef instr) {
        String instrStr = ((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr);
        InitializerListExpression list = NodeBuilder.newInitializerListExpression$default((String)instrStr, null, null, (int)6, null);
        Type elementType = ((LLVMIRLanguageFrontend)this.lang).typeOf(instr).dereference();
        List initializers = new ArrayList();
        Expression array1 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        int array1Length = array1 instanceof Literal && ((Literal)array1).getValue() == null ? 0 : LLVM.LLVMGetVectorSize((LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)0)));
        Expression array2 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        int array2Length = array2 instanceof Literal && ((Literal)array2).getValue() == null ? 0 : LLVM.LLVMGetVectorSize((LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)LLVM.LLVMGetOperand((LLVMValueRef)instr, (int)1)));
        int indices = LLVM.LLVMGetNumMaskElements((LLVMValueRef)instr);
        int n = 0;
        while (n < indices) {
            Collection arrayExpr;
            Object object;
            Collection collection;
            int idx;
            int idxInt;
            if ((idxInt = LLVM.LLVMGetMaskValue((LLVMValueRef)instr, (int)(idx = n++))) < array1Length) {
                if (array1 instanceof InitializerListExpression) {
                    collection = initializers;
                    object = ((InitializerListExpression)array1).getInitializers().get(idxInt);
                    collection.add(object);
                    continue;
                }
                if (array1 instanceof Literal && ((Literal)array1).getValue() == null) {
                    collection = initializers;
                    object = NodeBuilder.newLiteral$default(null, (Type)elementType, (String)instrStr, null, null, (int)24, null);
                    collection.add(object);
                    continue;
                }
                arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)instrStr, null, null, (int)6, null);
                arrayExpr.setArrayExpression(array1);
                arrayExpr.setSubscriptExpression((Expression)NodeBuilder.newLiteral$default((Object)idxInt, (Type)TypeParser.createFrom((String)"i32", (boolean)true), (String)instrStr, null, null, (int)24, null));
                ((Collection)initializers).add(arrayExpr);
                continue;
            }
            if (idxInt < array1Length + array2Length) {
                if (array2 instanceof InitializerListExpression) {
                    arrayExpr = initializers;
                    object = ((InitializerListExpression)array2).getInitializers().get(idxInt - array1Length);
                    arrayExpr.add(object);
                    continue;
                }
                if (array2 instanceof Literal && ((Literal)array2).getValue() == null) {
                    arrayExpr = initializers;
                    object = NodeBuilder.newLiteral$default(null, (Type)elementType, (String)instrStr, null, null, (int)24, null);
                    arrayExpr.add(object);
                    continue;
                }
                arrayExpr = NodeBuilder.newArraySubscriptionExpression$default((String)instrStr, null, null, (int)6, null);
                arrayExpr.setArrayExpression(array2);
                arrayExpr.setSubscriptExpression((Expression)NodeBuilder.newLiteral$default((Object)(idxInt - array1Length), (Type)TypeParser.createFrom((String)"i32", (boolean)true), (String)instrStr, null, null, (int)24, null));
                ((Collection)initializers).add(arrayExpr);
                continue;
            }
            collection = initializers;
            object = NodeBuilder.newLiteral$default(null, (Type)elementType, (String)instrStr, null, null, (int)24, null);
            collection.add(object);
        }
        list.setInitializers(initializers);
        return this.declarationOrNot((Expression)list, instr);
    }

    /*
     * Unable to fully structure code
     */
    public final void handlePhi(@NotNull LLVMValueRef instr, @NotNull TranslationUnitDeclaration tu) {
        Intrinsics.checkNotNullParameter((Object)instr, (String)"instr");
        Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
        labelMap = new LinkedHashMap<K, V>();
        numOps = LLVM.LLVMGetNumOperands((LLVMValueRef)instr);
        i = 0;
        bbsFunction = null;
        while (i < numOps) {
            valI = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, i);
            incomingBB = LLVM.LLVMGetIncomingBlock((LLVMValueRef)instr, (int)i);
            if (bbsFunction == null) {
                bbsFunction = LLVM.LLVMGetBasicBlockParent((LLVMBasicBlockRef)incomingBB);
            } else if (bbsFunction.address() != LLVM.LLVMGetBasicBlockParent((LLVMBasicBlockRef)incomingBB).address()) {
                Handler.log.error("The basic blocks of the phi instructions are in different functions. Can't handle this!");
                throw new TranslationException("The basic blocks of the phi instructions are in different functions.");
            }
            var10_11 = LLVM.LLVMBasicBlockAsValue((LLVMBasicBlockRef)incomingBB);
            Intrinsics.checkNotNullExpressionValue((Object)var10_11, (String)"LLVMBasicBlockAsValue(incomingBB)");
            labelI = this.extractBasicBlockLabel(var10_11);
            var10_10 = i;
            i = var10_10 + 1;
            labelMap.put(labelI, valI);
        }
        if (labelMap.keySet().size() == 1) {
            key = (LabelStatement)CollectionsKt.elementAt((Iterable)labelMap.keySet(), (int)0);
            labelI = key.getSubStatement();
            basicBlock = labelI instanceof CompoundStatement != false ? (CompoundStatement)labelI : null;
            v0 = labelMap.get(key);
            Intrinsics.checkNotNull(v0);
            decl = this.declarationOrNot((Expression)v0, instr);
            v1 = basicBlock;
            if (v1 == null) {
                v2 = null;
            } else {
                v3 = v1.getStatements();
                v2 = v3 == null ? null : CollectionsKt.toMutableList((Collection)v3);
            }
            v4 = mutableStatements = v2;
            if (v4 != null) {
                v4.add(basicBlock.getStatements().size() - 1, decl);
            }
            if (mutableStatements != null) {
                basicBlock.setStatements(mutableStatements);
            }
            return;
        }
        functionName = LLVM.LLVMGetValueName(bbsFunction).getString();
        decl = tu.getDeclarations();
        Intrinsics.checkNotNullExpressionValue((Object)decl, (String)"tu.declarations");
        $this$filter$iv = decl;
        $i$f$filter = false;
        var11_14 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            d = (Declaration)element$iv$iv;
            $i$a$-filter-StatementHandler$handlePhi$functions$1 = false;
            v5 = d instanceof FunctionDeclaration != false ? (FunctionDeclaration)d : null;
            if ((v5 == null ? null : v5.getName()) == null) ** GOTO lbl-1000
            v6 = d instanceof FunctionDeclaration != false ? (FunctionDeclaration)d : null;
            if (StringsKt.equals$default((String)(v6 == null ? null : v6.getName()), (String)functionName, (boolean)false, (int)2, null)) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = false;
            }
            if (!v7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        functions = (List)destination$iv$iv;
        if (functions.size() != 1) {
            Handler.log.error(functions.size() + " functions match the name of the one where the phi instruction is inserted. Can't handle this case.");
            throw new TranslationException("Wrong number of functions for phi statement.");
        }
        v8 = functions.get(0);
        if (v8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration");
        }
        v9 = ((FunctionDeclaration)v8).getBody();
        if (v9 == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
        }
        firstBB = (CompoundStatement)v9;
        declaration = new VariableDeclaration();
        $this$name$iv = instr;
        $i$f$getName = false;
        var13_19 = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
        Intrinsics.checkNotNullExpressionValue((Object)var13_19, (String)"LLVMGetValueName(this).string");
        declaration.setName((String)var13_19);
        ((LLVMIRLanguageFrontend)this.lang).getScopeManager().addDeclaration((Declaration)declaration);
        $this$name$iv = ((LLVMIRLanguageFrontend)this.lang).getBindingsCache();
        $i$f$getName = LLVMIRLanguageFrontendKt.getSymbolName(instr);
        $this$name$iv.put($i$f$getName, declaration);
        declStatement = NodeBuilder.newDeclarationStatement$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
        declStatement.setSingleDeclaration((Declaration)declaration);
        var13_19 = firstBB.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)var13_19, (String)"firstBB.statements");
        mutableFunctionStatements = CollectionsKt.toMutableList((Collection)((Collection)var13_19));
        mutableFunctionStatements.add(0, declStatement);
        firstBB.setStatements(mutableFunctionStatements);
        for (LabelStatement l : labelMap.keySet()) {
            assignment = NodeBuilder.newBinaryOperator$default((String)"=", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
            v10 = labelMap.get(l);
            Intrinsics.checkNotNull(v10);
            assignment.setRhs((Expression)v10);
            $this$name$iv = instr;
            $i$f$getName = false;
            var18_26 = LLVM.LLVMGetValueName((LLVMValueRef)$this$name$iv).getString();
            Intrinsics.checkNotNullExpressionValue((Object)var18_26, (String)"LLVMGetValueName(this).string");
            assignment.setLhs((Expression)NodeBuilder.newDeclaredReferenceExpression$default((String)var18_26, (Type)((LLVMIRLanguageFrontend)this.lang).typeOf(instr), (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)24, null));
            $i$f$getName = l.getSubStatement();
            v11 = basicBlock = $i$f$getName instanceof CompoundStatement != false ? (CompoundStatement)$i$f$getName : null;
            if (v11 == null) {
                v12 = null;
            } else {
                v13 = v11.getStatements();
                v12 = v13 == null ? null : CollectionsKt.toMutableList((Collection)v13);
            }
            v14 = mutableStatements = v12;
            if (v14 != null) {
                v14.add(basicBlock.getStatements().size() - 1, assignment);
            }
            if (mutableStatements == null) continue;
            basicBlock.setStatements(mutableStatements);
        }
    }

    private final Statement declarationOrNot(Expression rhs, LLVMValueRef valueRef) {
        Statement statement;
        Pair<String, String> namePair = ((LLVMIRLanguageFrontend)this.lang).getNameOf(valueRef);
        String lhs = (String)namePair.getFirst();
        String symbolName = (String)namePair.getSecond();
        if (!Intrinsics.areEqual((Object)lhs, (Object)"")) {
            VariableDeclaration decl = new VariableDeclaration();
            decl.setName(lhs);
            decl.setInitializer(rhs);
            ((LLVMIRLanguageFrontend)this.lang).getScopeManager().addDeclaration((Declaration)decl);
            ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put(symbolName, (Declaration)decl);
            DeclarationStatement declStatement = new DeclarationStatement();
            declStatement.setSingleDeclaration((Declaration)decl);
            statement = (Statement)declStatement;
        } else {
            statement = (Statement)rhs;
        }
        return statement;
    }

    private final CompoundStatement handleBasicBlock(LLVMBasicBlockRef bb) {
        CompoundStatement compound = NodeBuilder.newCompoundStatement$default((String)"", null, null, (int)6, null);
        LLVMValueRef instr = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)bb);
        while (instr != null) {
            Handler.log.debug("Parsing {}", (Object)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr));
            Statement stmt = (Statement)((LLVMIRLanguageFrontend)this.lang).getStatementHandler().handle(instr);
            compound.addStatement(stmt);
            instr = LLVM.LLVMGetNextInstruction((LLVMValueRef)instr);
        }
        return compound;
    }

    @FunctionReplacement(addedFunctions={"isunordered"})
    private final Statement handleBinaryOperator(LLVMValueRef instr, String op, boolean unsigned, boolean unordered) {
        Expression declOp;
        CallExpression unorderedCall;
        Expression op1 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 0);
        Expression op2 = ((LLVMIRLanguageFrontend)this.lang).getOperandValueAtIndex(instr, 1);
        Expression binaryOperator = null;
        BinaryOperator binOpUnordered = null;
        if (Intrinsics.areEqual((Object)op, (Object)"uno")) {
            binaryOperator = (Expression)NodeBuilder.newCallExpression$default((String)"isunordered", (String)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, null, (int)48, null);
            ((CallExpression)binaryOperator).addArgument(op1);
            ((CallExpression)binaryOperator).addArgument(op2);
        } else if (Intrinsics.areEqual((Object)op, (Object)"ord")) {
            unorderedCall = NodeBuilder.newCallExpression$default((String)"isunordered", (String)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, null, (int)48, null);
            unorderedCall.addArgument(op1);
            unorderedCall.addArgument(op2);
            binaryOperator = (Expression)NodeBuilder.newUnaryOperator$default((String)"!", (boolean)false, (boolean)true, (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), null, null, (int)48, null);
            ((UnaryOperator)binaryOperator).setInput((Expression)unorderedCall);
        } else {
            binaryOperator = (Expression)NodeBuilder.newBinaryOperator$default((String)op, (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
            if (unsigned) {
                String op1Type = Intrinsics.stringPlus((String)"u", (Object)op1.getType().getTypeName());
                CastExpression castExprLhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                castExprLhs.setCastType(TypeParser.createFrom((String)op1Type, (boolean)true));
                castExprLhs.setExpression(op1);
                ((BinaryOperator)binaryOperator).setLhs((Expression)castExprLhs);
                String op2Type = Intrinsics.stringPlus((String)"u", (Object)op2.getType().getTypeName());
                CastExpression castExprRhs = NodeBuilder.newCastExpression$default((String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)6, null);
                castExprRhs.setCastType(TypeParser.createFrom((String)op2Type, (boolean)true));
                castExprRhs.setExpression(op2);
                ((BinaryOperator)binaryOperator).setRhs((Expression)castExprRhs);
            } else {
                ((BinaryOperator)binaryOperator).setLhs(op1);
                ((BinaryOperator)binaryOperator).setRhs(op2);
            }
            if (unordered) {
                binOpUnordered = NodeBuilder.newBinaryOperator$default((String)"||", (String)((LLVMIRLanguageFrontend)this.lang).getCodeFromRawNode(instr), null, null, (int)12, null);
                binOpUnordered.setRhs(binaryOperator);
                unorderedCall = NodeBuilder.newCallExpression$default((String)"isunordered", (String)"isunordered", (String)LLVM.LLVMPrintValueToString((LLVMValueRef)instr).getString(), (boolean)false, null, null, (int)48, null);
                unorderedCall.addArgument(op1);
                unorderedCall.addArgument(op2);
                binOpUnordered.setLhs((Expression)unorderedCall);
            }
        }
        Expression expression = declOp = unordered ? (Expression)binOpUnordered : binaryOperator;
        Intrinsics.checkNotNull((Object)expression);
        Statement decl = this.declarationOrNot(expression, instr);
        DeclarationStatement declarationStatement = decl instanceof DeclarationStatement ? (DeclarationStatement)decl : null;
        if (declarationStatement != null) {
            DeclarationStatement it = declarationStatement;
            boolean bl = false;
            Declaration declaration = ((DeclarationStatement)decl).getSingleDeclaration();
            if (declaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
            }
            ((LLVMIRLanguageFrontend)this.lang).getBindingsCache().put(LLVMIRLanguageFrontendKt.getSymbolName(instr), (Declaration)((VariableDeclaration)declaration));
        }
        return decl;
    }

    static /* synthetic */ Statement handleBinaryOperator$default(StatementHandler statementHandler, LLVMValueRef lLVMValueRef, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return statementHandler.handleBinaryOperator(lLVMValueRef, string, bl, bl2);
    }

    private final LabelStatement extractBasicBlockLabel(LLVMValueRef valueRef) {
        LLVMBasicBlockRef bb = LLVM.LLVMValueAsBasicBlock((LLVMValueRef)valueRef);
        Ref.ObjectRef labelName = new Ref.ObjectRef();
        labelName.element = LLVM.LLVMGetBasicBlockName((LLVMBasicBlockRef)bb).getString();
        CharSequence charSequence = (CharSequence)labelName.element;
        if (charSequence == null || charSequence.length() == 0) {
            String bbStr = LLVM.LLVMPrintValueToString((LLVMValueRef)valueRef).getString();
            Intrinsics.checkNotNullExpressionValue((Object)bbStr, (String)"bbStr");
            String[] stringArray = new String[]{"\n"};
            String firstLine = (String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)bbStr)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            String string = firstLine.substring(0, StringsKt.indexOf$default((CharSequence)firstLine, (String)":", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            labelName.element = string;
        }
        LabelStatement labelStatement = ((LLVMIRLanguageFrontend)this.lang).getLabelMap().computeIfAbsent((String)labelName.element, arg_0 -> StatementHandler.extractBasicBlockLabel$lambda-4(labelName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)labelStatement, (String)"lang.labelMap.computeIfA\u2026      label\n            }");
        LabelStatement labelStatement2 = labelStatement;
        return labelStatement2;
    }

    private static final Statement _init_$lambda-0(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Pointer pointer = it;
        if (pointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bytedeco.llvm.LLVM.LLVMValueRef");
        }
        return this$0.handleInstruction((LLVMValueRef)pointer);
    }

    private static final Statement _init_$lambda-1(StatementHandler this$0, Pointer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Pointer pointer = it;
        if (pointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bytedeco.llvm.LLVM.LLVMBasicBlockRef");
        }
        return (Statement)this$0.handleBasicBlock((LLVMBasicBlockRef)pointer);
    }

    private static final LabelStatement extractBasicBlockLabel$lambda-4(Ref.ObjectRef $labelName, String it) {
        Intrinsics.checkNotNullParameter((Object)$labelName, (String)"$labelName");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LabelStatement label = NodeBuilder.newLabelStatement$default((String)((String)$labelName.element), null, null, (int)6, null);
        Object object = $labelName.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"labelName");
        label.setName((String)object);
        return label;
    }
}

