/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.passes.ComponentPass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.configuration.DependsOn;
import de.fraunhofer.aisec.cpg.passes.configuration.RequiredFrontend;
import de.fraunhofer.aisec.cpg.processing.IStrategy;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@DependsOn(value=TypeHierarchyResolver.class)
@RequiredFrontend(value=JavaLanguageFrontend.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\bH\u0004J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0004J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\rH\u0004J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0004R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaImportResolver;", "Lde/fraunhofer/aisec/cpg/passes/ComponentPass;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "<init>", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "records", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getRecords", "()Ljava/util/List;", "importables", "", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "getImportables", "()Ljava/util/Map;", "cleanup", "", "accept", "component", "Lde/fraunhofer/aisec/cpg/graph/Component;", "getStaticImports", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/ValueDeclaration;", "recordDeclaration", "getDeclarationsForTypeNames", "targetTypes", "", "getOrCreateMembers", "", "base", "name", "findImportables", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "cpg-language-java"})
@SourceDebugExtension(value={"SMAP\nJavaImportResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaImportResolver.kt\nde/fraunhofer/aisec/cpg/passes/JavaImportResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1485#2:182\n1510#2,3:183\n1513#2,3:193\n1368#2:198\n1454#2,5:199\n774#2:204\n865#2,2:205\n1368#2:207\n1454#2,5:208\n774#2:213\n865#2,2:214\n1611#2,9:216\n1863#2:225\n1864#2:227\n1620#2:228\n774#2:229\n865#2,2:230\n1368#2:232\n1454#2,5:233\n774#2:238\n865#2,2:239\n774#2:241\n865#2,2:242\n1368#2:244\n1454#2,5:245\n774#2:250\n865#2,2:251\n381#3,7:186\n37#4,2:196\n1#5:226\n1#5:253\n*S KotlinDebug\n*F\n+ 1 JavaImportResolver.kt\nde/fraunhofer/aisec/cpg/passes/JavaImportResolver\n*L\n73#1:182\n73#1:183,3\n73#1:193,3\n99#1:198\n99#1:199,5\n99#1:204\n99#1:205,2\n103#1:207\n103#1:208,5\n103#1:213\n103#1:214,2\n111#1:216,9\n111#1:225\n111#1:227\n111#1:228\n115#1:229\n115#1:230,2\n120#1:232\n120#1:233,5\n121#1:238\n121#1:239,2\n123#1:241\n123#1:242,2\n126#1:244\n126#1:245,5\n126#1:250\n126#1:251,2\n73#1:186,7\n96#1:196,2\n111#1:226\n*E\n"})
public class JavaImportResolver
extends ComponentPass {
    @NotNull
    private final List<RecordDeclaration> records;
    @NotNull
    private final Map<String, Declaration> importables;

    public JavaImportResolver(@NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.records = new ArrayList();
        this.importables = new HashMap();
    }

    @NotNull
    protected final List<RecordDeclaration> getRecords() {
        return this.records;
    }

    @NotNull
    protected final Map<String, Declaration> getImportables() {
        return this.importables;
    }

    public void cleanup() {
        this.records.clear();
        this.importables.clear();
    }

    public void accept(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (TranslationUnitDeclaration tu : component.getTranslationUnits()) {
            this.findImportables((Node)tu);
        }
        for (RecordDeclaration recordDecl : this.records) {
            Set<Declaration> imports = this.getDeclarationsForTypeNames(recordDecl.getImportStatements());
            recordDecl.setImports(imports);
            Set<ValueDeclaration> staticImports = this.getStaticImports(recordDecl);
            recordDecl.setStaticImports(staticImports);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<ValueDeclaration> getStaticImports(@NotNull RecordDeclaration recordDeclaration) {
        Object members;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
        Iterable $this$groupBy$iv = recordDeclaration.getStaticImportStatements();
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = StringsKt.endsWith$default((String)it, (String)"*", (boolean)false, (int)2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map partitioned = MapsKt.toMutableMap((Map)destination$iv$iv);
        Set staticImports = new LinkedHashSet();
        Pattern importPattern = Pattern.compile("(?<base>.*)\\.(?<member>.*)");
        List list = (List)partitioned.get(false);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (String specificStaticImport : list) {
            Matcher matcher = importPattern.matcher(specificStaticImport);
            if (!matcher.matches()) continue;
            Declaration base = this.importables.get(matcher.group("base"));
            members = SetsKt.emptySet();
            if (base instanceof RecordDeclaration) {
                RecordDeclaration recordDeclaration2 = (RecordDeclaration)base;
                String string = matcher.group("member");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                members = this.getOrCreateMembers(recordDeclaration2, string);
            }
            staticImports.addAll((Collection)members);
        }
        List list2 = (List)partitioned.get(true);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (String asteriskImport : list2) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable list$iv$iv;
            RecordDeclaration it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Declaration base = this.importables.get(StringsKt.replace$default((String)asteriskImport, (String)".*", (String)"", (boolean)false, (int)4, null));
            if (base instanceof EnumDeclaration) {
                staticImports.addAll(((EnumDeclaration)base).getEntries());
                continue;
            }
            if (!(base instanceof RecordDeclaration)) continue;
            members = new SpreadBuilder(2);
            members.add((Object)base);
            Collection $this$toTypedArray$iv = ((RecordDeclaration)base).getSuperTypeDeclarations();
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            members.addSpread((Object)thisCollection$iv.toArray(new RecordDeclaration[0]));
            List classes = CollectionsKt.listOf((Object[])members.toArray((Object[])new RecordDeclaration[members.size()]));
            members = classes;
            Set set = staticImports;
            boolean $i$f$flatMap = false;
            void $i$f$toTypedArray22 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (RecordDeclaration)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getMethods();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodDeclaration p0 = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                if (!p0.isStatic()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            set.addAll((List)destination$iv$iv2);
            $this$filter$iv = classes;
            set = staticImports;
            $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (RecordDeclaration)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getFields();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FieldDeclaration)element$iv$iv;
                boolean bl = false;
                if (!it.getModifiers().contains("static")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            set.addAll((List)destination$iv$iv2);
        }
        return staticImports;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<Declaration> getDeclarationsForTypeNames(@NotNull List<String> targetTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(targetTypes, (String)"targetTypes");
        Iterable $this$mapNotNull$iv = targetTypes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Declaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.importables.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<ValueDeclaration> getOrCreateMembers(@NotNull RecordDeclaration base, @NotNull String name) {
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        MethodDeclaration it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = base.getMethods();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (MethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it.getName().getLocalName(), (String)name, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set memberMethods = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        $this$filter$iv = base.getSuperTypeDeclarations();
        Set set = memberMethods;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (RecordDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getMethods();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (MethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it.getName().getLocalName(), (String)name, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        set.addAll((List)destination$iv$iv);
        Iterable $this$filter$iv2 = base.getFields();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FieldDeclaration it2 = (FieldDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getName().getLocalName(), (Object)name)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set memberFields = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        $this$filter$iv2 = base.getSuperTypeDeclarations();
        set = memberFields;
        boolean $i$f$flatMap2 = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RecordDeclaration it3 = (RecordDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it3.getFields();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        $i$f$filter2 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FieldDeclaration it4 = (FieldDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it4.getName().getLocalName(), (Object)name)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        set.addAll((List)destination$iv$iv2);
        Set memberEntries = new LinkedHashSet();
        if (base instanceof EnumDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)ExtensionsKt.get$default((Collection)((EnumDeclaration)base).getEntries(), (String)name, null, (int)2, null);
            if (enumConstantDeclaration != null) {
                EnumConstantDeclaration it5 = enumConstantDeclaration;
                boolean bl = false;
                memberEntries.add(it5);
            }
        }
        Set result = new LinkedHashSet();
        result.addAll(memberMethods);
        result.addAll(memberFields);
        result.addAll(memberEntries);
        if (result.isEmpty()) {
            FieldDeclaration targetField = DeclarationBuilderKt.newFieldDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (Type)((Type)UnknownType.Companion.getUnknownType(base.getLanguage())), (List)new ArrayList(), null, (boolean)false, null, (int)32, null);
            targetField.setLanguage(base.getLanguage());
            targetField.setInferred(true);
            MethodDeclaration targetMethod = DeclarationBuilderKt.newMethodDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name, (boolean)true, (RecordDeclaration)base, null, (int)8, null);
            targetMethod.setLanguage(base.getLanguage());
            targetMethod.setInferred(true);
            base.addField(targetField);
            base.addMethod(targetMethod);
            result.add(targetField);
            result.add(targetMethod);
        }
        return result;
    }

    protected final void findImportables(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Strategy strategy = Strategy.INSTANCE;
        node.accept(new IStrategy(strategy){
            final /* synthetic */ Strategy $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Iterator<Node> getIterator(Node p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.AST_FORWARD(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Strategy.class, "AST_FORWARD", "AST_FORWARD(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/util/Iterator;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof IStrategy ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, (IVisitor)new IVisitor<Node>(this){
            final /* synthetic */ JavaImportResolver this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(Node t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof RecordDeclaration) {
                    this.this$0.getRecords().add((RecordDeclaration)t);
                    this.this$0.getImportables().putIfAbsent(t.getName().toString(), (Declaration)t);
                }
            }
        });
    }
}

