/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguage;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeKt;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.SymbolResolver;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaCallResolverHelper;", "", "<init>", "()V", "Companion", "cpg-language-java"})
public final class JavaCallResolverHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaCallResolverHelper$Companion;", "", "<init>", "()V", "handleSuperCall", "", "callee", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "curClass", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "handleSpecificSupertype", "cpg-language-java"})
    @SourceDebugExtension(value={"SMAP\nJavaCallResolverHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCallResolverHelper.kt\nde/fraunhofer/aisec/cpg/passes/JavaCallResolverHelper$Companion\n+ 2 Util.kt\nde/fraunhofer/aisec/cpg/helpers/Util\n*L\n1#1,140:1\n202#2,5:141\n202#2,5:146\n*S KotlinDebug\n*F\n+ 1 JavaCallResolverHelper.kt\nde/fraunhofer/aisec/cpg/passes/JavaCallResolverHelper$Companion\n*L\n76#1:141,5\n127#1:146,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean handleSuperCall(@NotNull MemberExpression callee, @NotNull RecordDeclaration curClass, @NotNull ScopeManager scopeManager) {
            Expression expression;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
            Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
            FunctionDeclaration func = scopeManager.getCurrentFunction();
            if (func instanceof MethodDeclaration) {
                Reference reference = (Reference)callee.getBase();
                if (reference != null) {
                    reference.setRefersTo((Declaration)((MethodDeclaration)func).getReceiver());
                }
            }
            RecordDeclaration target = null;
            if (Intrinsics.areEqual((Object)callee.getBase().getName().toString(), (Object)new JavaLanguage().getSuperClassKeyword())) {
                if (!((Collection)curClass.getSuperClasses()).isEmpty()) {
                    target = TypeKt.getRecordDeclaration((Type)((Type)curClass.getSuperClasses().get(0)).getRoot());
                } else {
                    void arguments$iv;
                    void log$iv;
                    void format$iv;
                    Util util = Util.INSTANCE;
                    Logger logger = SymbolResolver.Companion.getLOGGER();
                    objectArray = "super call without direct superclass! Expected java.lang.Object to be present at least!";
                    expression = new Expression[]{};
                    boolean $i$f$warnWithFileLocation = false;
                    String string = "%s: %s";
                    Object[] objectArray2 = new Object[]{PhysicalLocation.Companion.locationLink(((Node)callee).getLocation()), format$iv};
                    String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    log$iv.warn(string2, (Object[])Arrays.copyOf(arguments$iv, ((void)arguments$iv).length));
                }
            } else {
                target = this.handleSpecificSupertype(callee, curClass);
            }
            if (target != null) {
                Declaration refersTo;
                Type superType = target.toType();
                callee.getBase().setType(superType);
                expression = callee.getBase();
                Reference reference = expression instanceof Reference ? (Reference)expression : null;
                Object object = refersTo = reference != null ? reference.getRefersTo() : null;
                if (refersTo instanceof HasType) {
                    ((HasType)refersTo).setType(superType);
                    objectArray = new Type[]{superType};
                    ((HasType)refersTo).setAssignedTypes(SetsKt.mutableSetOf((Object[])objectArray));
                }
                objectArray = new Type[]{superType};
                callee.getBase().setAssignedTypes(SetsKt.mutableSetOf((Object[])objectArray));
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final RecordDeclaration handleSpecificSupertype(@NotNull MemberExpression callee, @NotNull RecordDeclaration curClass) {
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
            Name name = callee.getBase().getName().getParent();
            if (name == null) {
                return null;
            }
            Name baseName = name;
            Type type = TypeBuilderKt.objectType$default((LanguageProvider)((LanguageProvider)curClass), (CharSequence)((CharSequence)baseName), null, (int)2, null);
            if (curClass.getImplementedInterfaces().contains(type)) {
                return TypeKt.getRecordDeclaration((Type)type);
            }
            RecordDeclaration base = TypeKt.getRecordDeclaration((Type)type);
            if (base != null) {
                void arguments$iv;
                void log$iv;
                void format$iv;
                if (!((Collection)base.getSuperClasses()).isEmpty()) {
                    return TypeKt.getRecordDeclaration((Type)((Type)base.getSuperClasses().get(0)).getRoot());
                }
                Util util = Util.INSTANCE;
                Logger logger = SymbolResolver.Companion.getLOGGER();
                String string = "super call without direct superclass! Expected java.lang.Object to be present at least!";
                Object[] objectArray = new Object[]{};
                boolean $i$f$warnWithFileLocation = false;
                String string2 = "%s: %s";
                Object[] objectArray2 = new Object[]{PhysicalLocation.Companion.locationLink(((Node)callee).getLocation()), format$iv};
                String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                log$iv.warn(string3, (Object[])Arrays.copyOf(arguments$iv, ((void)arguments$iv).length));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

