/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguage;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaCallResolverHelper;", "", "()V", "Companion", "cpg-language-java"})
public final class JavaCallResolverHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tJ2\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\u000f"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaCallResolverHelper$Companion;", "", "()V", "handleSpecificSupertype", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "callee", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "curClass", "recordMap", "", "Lde/fraunhofer/aisec/cpg/graph/Name;", "handleSuperCall", "", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "cpg-language-java"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean handleSuperCall(@NotNull MemberExpression callee, @NotNull RecordDeclaration curClass, @NotNull ScopeManager scopeManager, @NotNull Map<Name, RecordDeclaration> recordMap) {
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
            Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
            Intrinsics.checkNotNullParameter(recordMap, (String)"recordMap");
            FunctionDeclaration func = scopeManager.getCurrentFunction();
            if (func instanceof MethodDeclaration) {
                DeclaredReferenceExpression declaredReferenceExpression = (DeclaredReferenceExpression)callee.getBase();
                if (declaredReferenceExpression != null) {
                    declaredReferenceExpression.setRefersTo((Declaration)((MethodDeclaration)func).getReceiver());
                }
            }
            RecordDeclaration target = null;
            if (Intrinsics.areEqual((Object)callee.getBase().getName().toString(), (Object)new JavaLanguage().getSuperClassKeyword())) {
                if (!((Collection)curClass.getSuperClasses()).isEmpty()) {
                    target = recordMap.get(((Type)curClass.getSuperClasses().get(0)).getRoot().getName());
                } else {
                    Util.warnWithFileLocation((Node)((Node)callee), (Logger)CallResolver.Companion.getLOGGER(), (String)"super call without direct superclass! Expected java.lang.Object to be present at least!", (Object[])new Object[0]);
                }
            } else {
                target = this.handleSpecificSupertype(callee, curClass, recordMap);
            }
            if (target != null) {
                Type superType = target.toType();
                callee.getBase().setType(superType);
                callee.getBase().updatePossibleSubtypes(CollectionsKt.listOf((Object)superType));
                return true;
            }
            return false;
        }

        @Nullable
        public final RecordDeclaration handleSpecificSupertype(@NotNull MemberExpression callee, @NotNull RecordDeclaration curClass, @NotNull Map<Name, RecordDeclaration> recordMap) {
            Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
            Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
            Intrinsics.checkNotNullParameter(recordMap, (String)"recordMap");
            Name name = callee.getBase().getName().getParent();
            if (name == null) {
                return null;
            }
            Name baseName = name;
            if (curClass.getImplementedInterfaces().contains(NodeBuilderKt.parseType$default((LanguageProvider)((LanguageProvider)curClass), (CharSequence)((CharSequence)baseName), (boolean)false, (int)2, null))) {
                return recordMap.get(baseName);
            }
            RecordDeclaration base = recordMap.get(baseName);
            if (base != null) {
                if (!((Collection)base.getSuperClasses()).isEmpty()) {
                    return recordMap.get(((Type)base.getSuperClasses().get(0)).getRoot().getName());
                }
                Util.warnWithFileLocation((Node)((Node)callee), (Logger)CallResolver.Companion.getLOGGER(), (String)"super call without direct superclass! Expected java.lang.Object to be present at least!", (Object[])new Object[0]);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

