/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.FulfilledAndFailedPaths;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.GoEvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0014R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/fraunhofer/aisec/cpg/passes/GoEvaluationOrderGraphPass;", "Lde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "deferredCalls", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "handleDeferUnaryOperator", "", "node", "input", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "handleFunctionDeclaration", "handleRecordDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "handleUnspecificUnaryOperator", "cpg-language-go"})
@SourceDebugExtension(value={"SMAP\nGoEvaluationOrderGraphPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoEvaluationOrderGraphPass.kt\nde/fraunhofer/aisec/cpg/passes/GoEvaluationOrderGraphPass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class GoEvaluationOrderGraphPass
extends EvaluationOrderGraphPass {
    @NotNull
    private Map<FunctionDeclaration, List<UnaryOperator>> deferredCalls;

    public GoEvaluationOrderGraphPass(@NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.deferredCalls = new LinkedHashMap();
    }

    protected void handleUnspecificUnaryOperator(@NotNull UnaryOperator node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression input = node.getInput();
        if (Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"defer") && input instanceof CallExpression) {
            this.handleDeferUnaryOperator(node, (CallExpression)input);
        } else {
            super.handleUnspecificUnaryOperator(node);
        }
    }

    private final void handleDeferUnaryOperator(UnaryOperator node, CallExpression input) {
        FunctionDeclaration function = this.getScopeManager().getCurrentFunction();
        if (function != null) {
            List list2 = this.deferredCalls.computeIfAbsent(function, arg_0 -> GoEvaluationOrderGraphPass.handleDeferUnaryOperator$lambda$0(handleDeferUnaryOperator.calls.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"computeIfAbsent(...)");
            List calls2 = list2;
            ((Collection)calls2).add(node);
            this.pushToEOG((Node)node);
            Expression expression = input.getCallee();
            if (expression != null) {
                Expression it = expression;
                boolean bl = false;
                this.createEOG((Node)it);
            }
            for (Expression arg : input.getArguments()) {
                this.createEOG((Node)arg);
            }
        } else {
            Pass.Companion.getLog().error("Tried to parse a defer statement but could not retrieve current function from scope manager.");
        }
    }

    protected void handleRecordDeclaration(@NotNull RecordDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScope((Node)node);
        this.handleStatementHolder((StatementHolder)node);
        this.getCurrentPredecessors().clear();
        this.getScopeManager().leaveScope((Node)node);
    }

    protected void handleFunctionDeclaration(@NotNull FunctionDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super.handleFunctionDeclaration(node);
        List defers = this.deferredCalls.get(node);
        List list2 = defers;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (UnaryOperator defer : list2) {
            FulfilledAndFailedPaths paths2 = ExtensionsKt.followNextEOGEdgesUntilHit((Node)((Node)defer), (Function1)handleFunctionDeclaration.paths.1.INSTANCE);
            for (List path2 : paths2.getFulfilled()) {
                this.addEOGEdge((Node)CollectionsKt.last((List)path2), (Node)defer.getInput());
            }
        }
    }

    private static final List handleDeferUnaryOperator$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

