/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.golang;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.TypeManager;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.SupportsParallelParsing;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.golang.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.golang.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguage;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend$typeOf$;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontendKt;
import de.fraunhofer.aisec.cpg.frontends.golang.GoStandardLibrary;
import de.fraunhofer.aisec.cpg.frontends.golang.GoUtilsKt;
import de.fraunhofer.aisec.cpg.frontends.golang.SpecificationHandler;
import de.fraunhofer.aisec.cpg.frontends.golang.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.ContextProvider;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.DeclarationSequence;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.types.FunctionType;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.GoEvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.GoExtraPass;
import de.fraunhofer.aisec.cpg.passes.configuration.RegisterExtraPass;
import de.fraunhofer.aisec.cpg.passes.configuration.ReplacePass;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@RegisterExtraPass(value=GoExtraPass.class)
@ReplacePass(old=EvaluationOrderGraphPass.class, lang=GoLanguage.class, with=GoEvaluationOrderGraphPass.class)
@SupportsParallelParsing(supported=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 J2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002JKB\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u0002H\u0016J!\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020&082\u0006\u0010:\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b;J\u0010\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u000205H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u00106\u001a\u00020\u0002H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u00106\u001a\u00020\u0002H\u0016J\u0010\u0010H\u001a\u0002092\u0006\u0010I\u001a\u00020\u0003H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006L"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$Node;", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$Expr;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "commentMap", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$CommentMap;", "currentFile", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$File;", "getCurrentFile", "()Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$File;", "setCurrentFile", "(Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$File;)V", "currentFileSet", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$FileSet;", "currentModule", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Modfile$File;", "declCtx", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$DeclarationContext;", "getDeclCtx", "()Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$DeclarationContext;", "setDeclCtx", "(Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$DeclarationContext;)V", "declarationHandler", "Lde/fraunhofer/aisec/cpg/frontends/golang/DeclarationHandler;", "getDeclarationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/golang/DeclarationHandler;", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/golang/ExpressionHandler;", "getExpressionHandler", "()Lde/fraunhofer/aisec/cpg/frontends/golang/ExpressionHandler;", "setExpressionHandler", "(Lde/fraunhofer/aisec/cpg/frontends/golang/ExpressionHandler;)V", "isDependency", "", "()Z", "setDependency", "(Z)V", "specificationHandler", "Lde/fraunhofer/aisec/cpg/frontends/golang/SpecificationHandler;", "getSpecificationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/golang/SpecificationHandler;", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/golang/StatementHandler;", "getStatementHandler", "()Lde/fraunhofer/aisec/cpg/frontends/golang/StatementHandler;", "setStatementHandler", "(Lde/fraunhofer/aisec/cpg/frontends/golang/StatementHandler;)V", "codeOf", "", "astNode", "fieldTypeOf", "Lkotlin/Pair;", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "paramType", "fieldTypeOf$cpg_language_go", "isBuiltinType", "name", "locationOf", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "setComment", "", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "typeOf", "type", "Companion", "DeclarationContext", "cpg-language-go"})
@SourceDebugExtension(value={"SMAP\nGoLanguageFrontend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Util.kt\nde/fraunhofer/aisec/cpg/helpers/Util\n+ 5 TypeManager.kt\nde/fraunhofer/aisec/cpg/TypeManager\n*L\n1#1,533:1\n288#2,2:534\n1855#2,2:536\n1360#2:539\n1446#2,2:540\n1549#2:542\n1620#2,3:543\n1448#2,3:546\n1549#2:549\n1620#2,3:550\n1549#2:553\n1620#2,3:554\n1549#2:557\n1620#2,3:558\n1549#2:561\n1620#2,3:562\n1549#2:565\n1620#2,3:566\n223#2,2:586\n1#3:538\n159#4,9:569\n197#5,8:578\n206#5,19:588\n*S KotlinDebug\n*F\n+ 1 GoLanguageFrontend.kt\nde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend\n*L\n137#1:534,2\n206#1:536,2\n250#1:539\n250#1:540,2\n257#1:542\n257#1:543,3\n250#1:546,3\n260#1:549\n260#1:550,3\n261#1:553\n261#1:554,3\n275#1:557\n275#1:558,3\n285#1:561\n285#1:562,3\n322#1:565\n322#1:566,3\n352#1:586,2\n342#1:569,9\n352#1:578,8\n352#1:588,19\n*E\n"})
public final class GoLanguageFrontend
extends LanguageFrontend<GoStandardLibrary.Ast.Node, GoStandardLibrary.Ast.Expr> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GoStandardLibrary.Ast.FileSet currentFileSet;
    @Nullable
    private GoStandardLibrary.Modfile.File currentModule;
    @Nullable
    private GoStandardLibrary.Ast.CommentMap commentMap;
    @Nullable
    private GoStandardLibrary.Ast.File currentFile;
    private boolean isDependency;
    @NotNull
    private final DeclarationHandler declarationHandler;
    @NotNull
    private final SpecificationHandler specificationHandler;
    @NotNull
    private StatementHandler statementHandler;
    @NotNull
    private ExpressionHandler expressionHandler;
    @NotNull
    private DeclarationContext declCtx;
    @NotNull
    private static final List<String> goosValues;
    @NotNull
    private static final List<String> goarchValues;

    public GoLanguageFrontend(@NotNull Language<GoLanguageFrontend> language, @NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(language, ctx);
        this.declarationHandler = new DeclarationHandler(this);
        this.specificationHandler = new SpecificationHandler(this);
        this.statementHandler = new StatementHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
        this.declCtx = new DeclarationContext();
    }

    @Nullable
    public final GoStandardLibrary.Ast.File getCurrentFile() {
        return this.currentFile;
    }

    public final void setCurrentFile(@Nullable GoStandardLibrary.Ast.File file) {
        this.currentFile = file;
    }

    public final boolean isDependency() {
        return this.isDependency;
    }

    public final void setDependency(boolean bl) {
        this.isDependency = bl;
    }

    @NotNull
    public final DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    @NotNull
    public final SpecificationHandler getSpecificationHandler() {
        return this.specificationHandler;
    }

    @NotNull
    public final StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    public final void setStatementHandler(@NotNull StatementHandler statementHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)statementHandler), (String)"<set-?>");
        this.statementHandler = statementHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    public final void setExpressionHandler(@NotNull ExpressionHandler expressionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)expressionHandler), (String)"<set-?>");
        this.expressionHandler = expressionHandler;
    }

    @NotNull
    public final DeclarationContext getDeclCtx() {
        return this.declCtx;
    }

    public final void setDeclCtx(@NotNull DeclarationContext declarationContext) {
        Intrinsics.checkNotNullParameter((Object)declarationContext, (String)"<set-?>");
        this.declCtx = declarationContext;
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) throws TranslationException {
        File file2;
        Object v1;
        block12: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!GoUtilsKt.shouldBeBuild(file, this.getCtx().getConfig().getSymbols())) {
                LanguageFrontend.Companion.getLog().debug("Ignoring the contents of {} because of missing build tags or different GOOS/GOARCH.", (Object)file);
                return DeclarationBuilderKt.newTranslationUnitDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)file.getName(), null, (int)2, null);
            }
            Iterable $this$firstOrNull$iv = this.getCtx().getConfig().getIncludePaths();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)((Object)it.toAbsolutePath()).toString(), (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block12;
            }
            v1 = null;
        }
        Path dependency = v1;
        if (dependency != null) {
            this.isDependency = true;
            file2 = dependency.toFile();
        } else {
            file2 = this.getConfig().getTopLevel() != null ? this.getConfig().getTopLevel() : file.getParentFile();
        }
        Intrinsics.checkNotNull((Object)file2);
        File topLevel = file2;
        GoStandardLibrary std = GoStandardLibrary.Companion.getINSTANCE();
        File goModFile = FilesKt.resolve((File)topLevel, (String)"go.mod");
        if (goModFile.exists()) {
            String string = goModFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            this.currentModule = GoStandardLibrary.Modfile.INSTANCE.parse(string, FilesKt.readText$default((File)goModFile, null, (int)1, null));
        }
        GoStandardLibrary.Ast.FileSet fset = std.NewFileSet();
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        GoStandardLibrary.Ast.File f = GoStandardLibrary.Parser.INSTANCE.parseFile(fset, string);
        this.commentMap = std.NewCommentMap(fset, f, f.getComments());
        this.currentFile = f;
        this.currentFileSet = fset;
        TranslationUnitDeclaration tu = DeclarationBuilderKt.newTranslationUnitDeclaration((MetadataProvider)((MetadataProvider)this), (CharSequence)file.getAbsolutePath(), (Object)((Object)f));
        this.getScopeManager().resetToGlobal(tu);
        this.setCurrentTU(tu);
        for (GoStandardLibrary.Ast.ImportSpec spec : f.getImports()) {
            Declaration declaration = (Declaration)this.specificationHandler.handle((GoStandardLibrary.Ast.Node)spec);
            ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)declaration, (boolean)false, (int)2, null);
        }
        NamespaceDeclaration p = DeclarationBuilderKt.newNamespaceDeclaration$default((MetadataProvider)((MetadataProvider)this), (CharSequence)f.getName().getName(), null, (int)2, null);
        this.getScopeManager().enterScope((Node)p);
        try {
            String modulePath;
            File file3 = file.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
            File packagePath = FilesKt.relativeTo((File)file3, (File)topLevel);
            GoStandardLibrary.GoObject goObject = this.currentModule;
            String string2 = goObject != null && (goObject = ((GoStandardLibrary.Modfile.File)goObject).getModule()) != null && (goObject = ((GoStandardLibrary.Modfile.Module)goObject).getMod()) != null ? ((GoStandardLibrary.Module.Version)goObject).getPath() : (modulePath = null);
            if (modulePath != null && !Intrinsics.areEqual((Object)modulePath, (Object)"std")) {
                packagePath = FilesKt.resolve((File)new File(modulePath), (File)packagePath);
            }
            p.setPath(packagePath.getPath());
        }
        catch (IllegalArgumentException ex) {
            LanguageFrontend.Companion.getLog().error("Could not relativize package path to top level. Cannot set package path.", (Throwable)ex);
        }
        for (GoStandardLibrary.Ast.Decl decl2 : f.getDecls()) {
            Declaration declaration = (Declaration)this.declarationHandler.handle((GoStandardLibrary.Ast.Node)decl2);
            if (declaration instanceof DeclarationSequence) {
                Iterable $this$forEach$iv = ((DeclarationSequence)declaration).getDeclarations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Declaration it = (Declaration)element$iv;
                    boolean bl = false;
                    ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)it, (boolean)false, (int)2, null);
                }
                continue;
            }
            ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)declaration, (boolean)false, (int)2, null);
        }
        this.getScopeManager().leaveScope((Node)p);
        ScopeManager.addDeclaration$default((ScopeManager)this.getScopeManager(), (Declaration)((Declaration)p), (boolean)false, (int)2, null);
        return tu;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Type typeOf(@NotNull GoStandardLibrary.Ast.Expr type2) {
        Type type3;
        Type type4;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        GoStandardLibrary.Ast.Expr expr = type2;
        if (expr instanceof GoStandardLibrary.Ast.Ident) {
            GoStandardLibrary.Ast.Node node;
            String string = this.isBuiltinType(((GoStandardLibrary.Ast.Ident)type2).getName()) ? ((GoStandardLibrary.Ast.Ident)type2).getName() : ((node = this.currentFile) != null && (node = ((GoStandardLibrary.Ast.File)node).getName()) != null ? ((GoStandardLibrary.Ast.Ident)node).getName() : null) + "." + ((GoStandardLibrary.Ast.Ident)type2).getName();
            type4 = TypeBuilderKt.objectType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)string, null, (int)2, null);
        } else {
            if (expr instanceof GoStandardLibrary.Ast.SelectorExpr) {
                Name name2;
                GoStandardLibrary.Ast.Expr expr2 = ((GoStandardLibrary.Ast.SelectorExpr)type2).getX();
                Object object = expr2 instanceof GoStandardLibrary.Ast.Ident ? (GoStandardLibrary.Ast.Ident)expr2 : null;
                if (object != null && (object = object.getName()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    name2 = new Name((String)object2, null, null, 6, null);
                } else {
                    name2 = null;
                }
                Name name3 = name2;
                return TypeBuilderKt.objectType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)((CharSequence)new Name(((GoStandardLibrary.Ast.SelectorExpr)type2).getSel().getName(), name3, null, 4, null)), null, (int)2, null);
            }
            if (expr instanceof GoStandardLibrary.Ast.ArrayType) {
                return TypeBuilderKt.array((ContextProvider)((ContextProvider)this), (Type)this.typeOf(((GoStandardLibrary.Ast.ArrayType)type2).getElt()));
            }
            if (expr instanceof GoStandardLibrary.Ast.ChanType) {
                return TypeBuilderKt.objectType((LanguageProvider)((LanguageProvider)this), (CharSequence)"chan", (List)CollectionsKt.listOf((Object)this.typeOf(((GoStandardLibrary.Ast.ChanType)type2).getValue())));
            }
            if (expr instanceof GoStandardLibrary.Ast.FuncType) {
                List list2;
                void $this$mapTo$iv$iv;
                GoStandardLibrary.Ast.Field $this$mapTo$iv$iv2;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Iterable iterable = ((GoStandardLibrary.Ast.FuncType)type2).getParams().getList();
                boolean $i$f$flatMap = false;
                void var7_45 = $this$flatMap$iv;
                Collection collection = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object t : $this$flatMapTo$iv$iv) {
                    List list3;
                    GoStandardLibrary.Ast.Field field = (GoStandardLibrary.Ast.Field)((Object)t);
                    boolean bl = false;
                    if (field.getNames().isEmpty()) {
                        list3 = CollectionsKt.listOf((Object)((Object)field.getType()));
                    } else {
                        Iterable $this$map$iv = field.getNames();
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv2.iterator();
                        while (iterator.hasNext()) {
                            Object item$iv$iv = iterator.next();
                            GoStandardLibrary.Ast.Ident ident = (GoStandardLibrary.Ast.Ident)((Object)item$iv$iv);
                            Collection collection2 = destination$iv$iv;
                            boolean bl2 = false;
                            collection2.add(field.getType());
                        }
                        list3 = (List)destination$iv$iv;
                    }
                    Iterable iterable3 = list3;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable3);
                }
                $this$flatMap$iv = (List)collection;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    GoStandardLibrary.Ast.Expr expr3 = (GoStandardLibrary.Ast.Expr)((Object)t);
                    var24_104 = collection3;
                    boolean bl = false;
                    var24_104.add((Type)this.fieldTypeOf$cpg_language_go(expr3).getFirst());
                }
                List list4 = (List)collection3;
                Object object = ((GoStandardLibrary.Ast.FuncType)type2).getResults();
                if (object != null && (object = object.getList()) != null) {
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map2 = false;
                    Iterable iterable4 = $this$map$iv;
                    Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : iterable4) {
                        void it;
                        $this$mapTo$iv$iv2 = (GoStandardLibrary.Ast.Field)((Object)item$iv$iv);
                        var24_104 = collection4;
                        boolean bl = false;
                        var24_104.add(this.typeOf(it.getType()));
                    }
                    list2 = (List)collection4;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List returnTypes = list2;
                String name4 = GoLanguageFrontendKt.funcTypeName(list4, returnTypes);
                type4 = (Type)new FunctionType(name4, list4, returnTypes, this.getLanguage());
            } else if (expr instanceof GoStandardLibrary.Ast.IndexExpr) {
                Type type5 = this.typeOf(((GoStandardLibrary.Ast.IndexExpr)type2).getX());
                generics = CollectionsKt.listOf((Object)this.typeOf(((GoStandardLibrary.Ast.IndexExpr)type2).getIndex()));
                type4 = TypeBuilderKt.objectType((LanguageProvider)((LanguageProvider)this), (CharSequence)((CharSequence)type5.getName()), (List)generics);
            } else if (expr instanceof GoStandardLibrary.Ast.IndexListExpr) {
                Type type6 = this.typeOf(((GoStandardLibrary.Ast.IndexListExpr)type2).getX());
                Iterable $this$map$iv = ((GoStandardLibrary.Ast.IndexListExpr)type2).getIndices();
                boolean $i$f$map3 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object t : iterable) {
                    void it;
                    GoStandardLibrary.Ast.Expr $i$f$mapTo2 = (GoStandardLibrary.Ast.Expr)((Object)t);
                    var24_104 = destination$iv$iv;
                    boolean bl = false;
                    var24_104.add(this.typeOf((GoStandardLibrary.Ast.Expr)it));
                }
                generics = (List)destination$iv$iv;
                type4 = TypeBuilderKt.objectType((LanguageProvider)((LanguageProvider)this), (CharSequence)((CharSequence)type6.getName()), (List)generics);
            } else if (expr instanceof GoStandardLibrary.Ast.StructType) {
                void $this$mapTo$iv$iv;
                $this$map$iv = ((GoStandardLibrary.Ast.StructType)type2).getFields().getList();
                boolean $i$f$map = false;
                Iterable $i$f$map3 = $this$map$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    GoStandardLibrary.Ast.Field field = (GoStandardLibrary.Ast.Field)((Object)t);
                    var24_104 = collection;
                    boolean bl = false;
                    Object desc = null;
                    desc = "";
                    if ((GoStandardLibrary.Ast.Ident)((Object)CollectionsKt.getOrNull(field.getNames(), (int)0)) != null) {
                        GoStandardLibrary.Ast.Ident it;
                        boolean bl3 = false;
                        desc = "" + desc + it;
                    }
                    desc = desc + " ";
                    desc = "" + desc + ((Type)this.fieldTypeOf$cpg_language_go(field.getType()).getFirst()).getName();
                    var24_104.add(desc);
                }
                List list5 = (List)collection;
                String name5 = CollectionsKt.joinToString$default((Iterable)list5, (CharSequence)"; ", (CharSequence)"struct{", (CharSequence)"}", (int)0, null, null, (int)56, null);
                RecordDeclaration record2 = (RecordDeclaration)this.getScopeManager().withScope((Scope)this.getScopeManager().getGlobalScope(), (Function1)new Function1<Scope, RecordDeclaration>(this, type2, name5){
                    final /* synthetic */ GoLanguageFrontend this$0;
                    final /* synthetic */ GoStandardLibrary.Ast.Expr $type;
                    final /* synthetic */ String $name;
                    {
                        this.this$0 = $receiver;
                        this.$type = $type;
                        this.$name = $name;
                        super(1);
                    }

                    @NotNull
                    public final RecordDeclaration invoke(@Nullable Scope it) {
                        return SpecificationHandler.buildRecordDeclaration$default(this.this$0.getSpecificationHandler(), (GoStandardLibrary.Ast.StructType)this.$type, this.$name, null, 4, null);
                    }
                });
                type4 = record2.toType();
            } else if (expr instanceof GoStandardLibrary.Ast.InterfaceType) {
                if (((GoStandardLibrary.Ast.InterfaceType)type2).getMethods().getList().isEmpty()) {
                    return TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"any");
                }
                $this$map$iv = ((GoStandardLibrary.Ast.InterfaceType)type2).getMethods().getList();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    GoStandardLibrary.Ast.Field field = (GoStandardLibrary.Ast.Field)((Object)t);
                    var24_104 = collection;
                    boolean bl = false;
                    Object desc = null;
                    desc = "";
                    if ((GoStandardLibrary.Ast.Ident)((Object)CollectionsKt.getOrNull(field.getNames(), (int)0)) != null) {
                        GoStandardLibrary.Ast.Ident it;
                        boolean bl4 = false;
                        desc = "" + desc + it;
                    }
                    desc = desc + StringsKt.removePrefix((String)this.typeOf(field.getType()).getName().toString(), (CharSequence)"func");
                    var24_104.add(desc);
                }
                List list6 = (List)collection;
                type4 = TypeBuilderKt.objectType$default((LanguageProvider)((LanguageProvider)this), (CharSequence)CollectionsKt.joinToString$default((Iterable)list6, (CharSequence)"; ", (CharSequence)"interface{", (CharSequence)"}", (int)0, null, null, (int)56, null), null, (int)2, null);
            } else {
                if (expr instanceof GoStandardLibrary.Ast.MapType) {
                    Object[] objectArray = new Type[]{this.typeOf(((GoStandardLibrary.Ast.MapType)type2).getKey()), this.typeOf(((GoStandardLibrary.Ast.MapType)type2).getValue())};
                    return TypeBuilderKt.objectType((LanguageProvider)((LanguageProvider)this), (CharSequence)"map", (List)CollectionsKt.listOf((Object[])objectArray));
                }
                if (expr instanceof GoStandardLibrary.Ast.StarExpr) {
                    type4 = TypeBuilderKt.pointer((ContextProvider)((ContextProvider)this), (Type)this.typeOf(((GoStandardLibrary.Ast.StarExpr)type2).getX()));
                } else {
                    void arguments$iv;
                    void log$iv;
                    void format$iv;
                    Util util = Util.INSTANCE;
                    Logger logger = LanguageFrontend.Companion.getLog();
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"<get-log>(...)");
                    $this$map$iv = logger;
                    String $i$f$map = "Not parsing type of type " + type2.getGoType() + " yet";
                    Object[] $this$mapTo$iv$iv = new Object[]{};
                    boolean bl = false;
                    String $i$f$mapTo = "%s: %s";
                    Object[] $i$f$mapTo3 = new Object[]{PhysicalLocation.Companion.locationLink(((LanguageFrontend)this).locationOf((Object)type2)), format$iv};
                    String string = String.format($i$f$mapTo, Arrays.copyOf($i$f$mapTo3, $i$f$mapTo3.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                    log$iv.warn(string, (Object[])Arrays.copyOf(arguments$iv, ((void)arguments$iv).length));
                    type4 = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
                }
            }
        }
        Type cpgType2 = type4;
        expr = this.getTypeManager();
        Type type7 = this.getTypeManager().resolvePossibleTypedef(cpgType2, this.getScopeManager());
        boolean $i$f$registerType = false;
        if (type7 instanceof ParameterizedType) {
            type3 = type7;
            return type3;
        }
        if (type7.isFirstOrderType()) {
            Object object;
            if (!this_$iv.getFirstOrderTypes().add(type7)) {
                Object element$iv$iv2;
                block44: {
                    Iterable $this$first$iv$iv = this_$iv.getFirstOrderTypes();
                    boolean $i$f$first = false;
                    for (Object element$iv$iv2 : $this$first$iv$iv) {
                        Type it$iv = (Type)element$iv$iv2;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it$iv, (Object)type7) && it$iv instanceof Type)) continue;
                        break block44;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv$iv2;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.Type");
                }
                type3 = (Type)t;
                return type3;
            }
            TypeManager.Companion.getLog().trace("Registering unique first order type {}{}", (Object)type7.getName(), ((object = type7 instanceof ObjectType ? (ObjectType)type7 : null) != null && (object = object.getGenerics()) != null ? !((Collection)object).isEmpty() : false) ? " with generics " + CollectionsKt.joinToString$default((Iterable)((ObjectType)type7).getGenerics(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)typeOf$$inlined$registerType$1.INSTANCE, (int)24, null) : "");
        } else if (type7 instanceof SecondOrderType) {
            if (!this_$iv.getSecondOrderTypes().add(type7)) {
                Object element$iv$iv3;
                block45: {
                    Iterable $this$first$iv$iv = this_$iv.getSecondOrderTypes();
                    boolean $i$f$first = false;
                    for (Object element$iv$iv3 : $this$first$iv$iv) {
                        Type it$iv = (Type)element$iv$iv3;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it$iv, (Object)type7) && it$iv instanceof Type)) continue;
                        break block45;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv$iv3;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.Type");
                }
                type3 = (Type)t;
                return type3;
            }
            TypeManager.Companion.getLog().trace("Registering unique second order type {}", (Object)type7.getName());
        }
        type3 = type7;
        return type3;
    }

    @NotNull
    public final Pair<Type, Boolean> fieldTypeOf$cpg_language_go(@NotNull GoStandardLibrary.Ast.Expr paramType) {
        Type type2;
        Intrinsics.checkNotNullParameter((Object)((Object)paramType), (String)"paramType");
        boolean variadic = false;
        if (paramType instanceof GoStandardLibrary.Ast.Ellipsis) {
            variadic = true;
            type2 = TypeBuilderKt.array((ContextProvider)((ContextProvider)this), (Type)this.typeOf(((GoStandardLibrary.Ast.Ellipsis)paramType).getElt()));
        } else {
            type2 = this.typeOf(paramType);
        }
        Type type3 = type2;
        return new Pair((Object)type3, (Object)variadic);
    }

    private final boolean isBuiltinType(String name2) {
        return this.getLanguage().getPrimitiveTypeNames().contains(name2);
    }

    @Nullable
    public String codeOf(@NotNull GoStandardLibrary.Ast.Node astNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)astNode), (String)"astNode");
        GoStandardLibrary.Ast.FileSet fileSet = this.currentFileSet;
        return fileSet != null ? fileSet.code(astNode) : null;
    }

    @Nullable
    public PhysicalLocation locationOf(@NotNull GoStandardLibrary.Ast.Node astNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)astNode), (String)"astNode");
        GoStandardLibrary.GoObject goObject = this.currentFileSet;
        if (goObject == null || (goObject = ((GoStandardLibrary.Ast.FileSet)goObject).position(astNode.getPos())) == null) {
            return null;
        }
        GoStandardLibrary.GoObject start = goObject;
        GoStandardLibrary.GoObject goObject2 = this.currentFileSet;
        if (goObject2 == null || (goObject2 = ((GoStandardLibrary.Ast.FileSet)goObject2).position(astNode.getEnd())) == null) {
            return null;
        }
        GoStandardLibrary.GoObject end2 = goObject2;
        Object object = this.currentFileSet;
        if (object == null || (object = object.fileName(astNode.getPos())) == null) {
            return null;
        }
        Object it = object;
        boolean bl = false;
        URI url = new URI((String)it);
        return new PhysicalLocation(url, new Region(((GoStandardLibrary.Ast.Position)start).getLine(), ((GoStandardLibrary.Ast.Position)start).getColumn(), ((GoStandardLibrary.Ast.Position)end2).getLine(), ((GoStandardLibrary.Ast.Position)end2).getColumn()));
    }

    public void setComment(@NotNull Node node, @NotNull GoStandardLibrary.Ast.Node astNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)astNode), (String)"astNode");
        if (node.getComment() == null) {
            GoStandardLibrary.Ast.CommentMap commentMap = this.commentMap;
            String comment = commentMap != null ? commentMap.comment(astNode) : null;
            node.setComment(comment);
        }
    }

    static {
        Object[] objectArray = new String[]{"aix", "android", "darwin", "dragonfly", "freebsd", "hurd", "illumos", "ios", "js", "linux", "nacl", "netbsd", "openbsd", "plan9", "solaris", "wasip1", "windows", "zos"};
        goosValues = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"386", "amd64", "arm", "arm64", "loong64", "mips", "mips64", "mips64le", "mipsle", "ppc64", "ppc64le", "riscv64", "s390x"};
        goarchValues = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$Companion;", "", "()V", "goarchValues", "", "", "getGoarchValues", "()Ljava/util/List;", "goosValues", "getGoosValues", "cpg-language-go"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getGoosValues() {
            return goosValues;
        }

        @NotNull
        public final List<String> getGoarchValues() {
            return goarchValues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$DeclarationContext;", "", "()V", "constInitializers", "", "", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$Expr;", "getConstInitializers", "()Ljava/util/Map;", "setConstInitializers", "(Ljava/util/Map;)V", "constType", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "getConstType", "()Lde/fraunhofer/aisec/cpg/graph/types/Type;", "setConstType", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;)V", "currentDecl", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$GenDecl;", "getCurrentDecl", "()Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$GenDecl;", "setCurrentDecl", "(Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$GenDecl;)V", "iotaValue", "getIotaValue", "()I", "setIotaValue", "(I)V", "cpg-language-go"})
    public static final class DeclarationContext {
        private int iotaValue = -1;
        @NotNull
        private Map<Integer, GoStandardLibrary.Ast.Expr> constInitializers = new LinkedHashMap();
        @Nullable
        private Type constType;
        @Nullable
        private GoStandardLibrary.Ast.GenDecl currentDecl;

        public final int getIotaValue() {
            return this.iotaValue;
        }

        public final void setIotaValue(int n) {
            this.iotaValue = n;
        }

        @NotNull
        public final Map<Integer, GoStandardLibrary.Ast.Expr> getConstInitializers() {
            return this.constInitializers;
        }

        public final void setConstInitializers(@NotNull Map<Integer, GoStandardLibrary.Ast.Expr> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.constInitializers = map;
        }

        @Nullable
        public final Type getConstType() {
            return this.constType;
        }

        public final void setConstType(@Nullable Type type2) {
            this.constType = type2;
        }

        @Nullable
        public final GoStandardLibrary.Ast.GenDecl getCurrentDecl() {
            return this.currentDecl;
        }

        public final void setCurrentDecl(@Nullable GoStandardLibrary.Ast.GenDecl genDecl) {
            this.currentDecl = genDecl;
        }
    }
}

