/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.golang;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.golang.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.golang.GoHandler;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.golang.GoStandardLibrary;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.NameKt;
import de.fraunhofer.aisec.cpg.graph.RawNodeTypeProvider;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.NameScope;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.KeyValueExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.LambdaExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewArrayExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.RangeExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.SubscriptExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\u0018\u0000 ?2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001?B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002002\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0003H\u0002\u00a8\u0006@"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/ExpressionHandler;", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoHandler;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$Expr;", "frontend", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend;", "(Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend;)V", "handleBasicLit", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Literal;", "basicLit", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$BasicLit;", "handleBinaryExpr", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "binaryExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$BinaryExpr;", "handleCallExpr", "callExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$CallExpr;", "handleCompositeLit", "compositeLit", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$CompositeLit;", "handleFuncLit", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/LambdaExpression;", "funcLit", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$FuncLit;", "handleIdent", "ident", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$Ident;", "handleIndexExpr", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/SubscriptExpression;", "indexExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$IndexExpr;", "handleKeyValueExpr", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/KeyValueExpression;", "keyValueExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$KeyValueExpr;", "handleMakeExpr", "handleNewExpr", "handleNode", "node", "handleSelectorExpr", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Reference;", "selectorExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$SelectorExpr;", "handleSliceExpr", "sliceExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$SliceExpr;", "handleStarExpr", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "starExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$StarExpr;", "handleTypeAssertExpr", "typeAssertExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$TypeAssertExpr;", "handleUnaryExpr", "unaryExpr", "Lde/fraunhofer/aisec/cpg/frontends/golang/GoStandardLibrary$Ast$UnaryExpr;", "isPackageName", "", "name", "", "unwrap", "expr", "Companion", "cpg-language-go"})
@SourceDebugExtension(value={"SMAP\nExpressionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionHandler.kt\nde/fraunhofer/aisec/cpg/frontends/golang/ExpressionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n1#2:522\n*E\n"})
public final class ExpressionHandler
extends GoHandler<Expression, GoStandardLibrary.Ast.Expr> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> builtins;

    public ExpressionHandler(@NotNull GoLanguageFrontend frontend) {
        Intrinsics.checkNotNullParameter((Object)((Object)frontend), (String)"frontend");
        super(() -> new ProblemExpression(null, null, 3, null), frontend);
    }

    @Override
    @NotNull
    public Expression handleNode(@NotNull GoStandardLibrary.Ast.Expr node) {
        Expression expression;
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        GoStandardLibrary.Ast.Expr expr = node;
        if (expr instanceof GoStandardLibrary.Ast.BasicLit) {
            expression = (Expression)this.handleBasicLit((GoStandardLibrary.Ast.BasicLit)node);
        } else if (expr instanceof GoStandardLibrary.Ast.BinaryExpr) {
            expression = (Expression)this.handleBinaryExpr((GoStandardLibrary.Ast.BinaryExpr)node);
        } else if (expr instanceof GoStandardLibrary.Ast.CompositeLit) {
            expression = this.handleCompositeLit((GoStandardLibrary.Ast.CompositeLit)node);
        } else if (expr instanceof GoStandardLibrary.Ast.FuncLit) {
            expression = (Expression)this.handleFuncLit((GoStandardLibrary.Ast.FuncLit)node);
        } else if (expr instanceof GoStandardLibrary.Ast.Ident) {
            expression = this.handleIdent((GoStandardLibrary.Ast.Ident)node);
        } else if (expr instanceof GoStandardLibrary.Ast.IndexExpr) {
            expression = (Expression)this.handleIndexExpr((GoStandardLibrary.Ast.IndexExpr)node);
        } else if (expr instanceof GoStandardLibrary.Ast.CallExpr) {
            expression = this.handleCallExpr((GoStandardLibrary.Ast.CallExpr)node);
        } else if (expr instanceof GoStandardLibrary.Ast.KeyValueExpr) {
            expression = (Expression)this.handleKeyValueExpr((GoStandardLibrary.Ast.KeyValueExpr)node);
        } else {
            if (expr instanceof GoStandardLibrary.Ast.ParenExpr) {
                return (Expression)this.handle((GoStandardLibrary.Ast.Node)((GoStandardLibrary.Ast.ParenExpr)node).getX());
            }
            if (expr instanceof GoStandardLibrary.Ast.SelectorExpr) {
                expression = (Expression)this.handleSelectorExpr((GoStandardLibrary.Ast.SelectorExpr)node);
            } else if (expr instanceof GoStandardLibrary.Ast.SliceExpr) {
                expression = (Expression)this.handleSliceExpr((GoStandardLibrary.Ast.SliceExpr)node);
            } else if (expr instanceof GoStandardLibrary.Ast.StarExpr) {
                expression = (Expression)this.handleStarExpr((GoStandardLibrary.Ast.StarExpr)node);
            } else if (expr instanceof GoStandardLibrary.Ast.TypeAssertExpr) {
                expression = this.handleTypeAssertExpr((GoStandardLibrary.Ast.TypeAssertExpr)node);
            } else if (expr instanceof GoStandardLibrary.Ast.UnaryExpr) {
                expression = (Expression)this.handleUnaryExpr((GoStandardLibrary.Ast.UnaryExpr)node);
            } else {
                return (Expression)this.handleNotSupported((GoStandardLibrary.Ast.Node)node, node.getGoType());
            }
        }
        return expression;
    }

    private final Literal<?> handleBasicLit(GoStandardLibrary.Ast.BasicLit basicLit) {
        String rawValue = basicLit.getValue();
        Object value2 = null;
        Type type2 = null;
        switch (WhenMappings.$EnumSwitchMapping$0[basicLit.getKind().ordinal()]) {
            case 1: {
                String string = rawValue.substring(RangesKt.coerceAtMost((int)1, (int)(rawValue.length() - 1)), RangesKt.coerceAtLeast((int)(rawValue.length() - 1), (int)0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                value2 = string;
                type2 = TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"string");
                break;
            }
            case 2: {
                rawValue = StringsKt.replace$default((String)rawValue, (String)"_", (String)"", (boolean)false, (int)4, null);
                String string = rawValue.substring(0, RangesKt.coerceAtMost((int)2, (int)rawValue.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String prefix = string;
                String string2 = rawValue.substring(RangesKt.coerceAtMost((int)2, (int)rawValue.length()), rawValue.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String postfix = string2;
                value2 = switch (prefix) {
                    case "0x" -> new BigInteger(postfix, 16);
                    case "0o" -> new BigInteger(postfix, 10);
                    case "0b" -> new BigInteger(postfix, 2);
                    default -> new BigInteger(rawValue, 10);
                };
                value2 = ((BigInteger)value2).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? value2 : (((BigInteger)value2).longValue() > Integer.MAX_VALUE ? (Number)((BigInteger)value2).longValue() : (Number)((BigInteger)value2).intValue());
                type2 = TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"int");
                break;
            }
            case 3: {
                value2 = Double.parseDouble(rawValue);
                type2 = TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"float64");
                break;
            }
            case 4: {
                value2 = StringsKt.firstOrNull((CharSequence)rawValue);
                type2 = TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"rune");
                break;
            }
            default: {
                value2 = rawValue;
                type2 = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
            }
        }
        Literal lit = ExpressionBuilderKt.newLiteral$default((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)value2, null, (Object)((Object)basicLit), (int)2, null);
        lit.setType(type2);
        return lit;
    }

    private final BinaryOperator handleBinaryExpr(GoStandardLibrary.Ast.BinaryExpr binaryExpr) {
        BinaryOperator binOp = ExpressionBuilderKt.newBinaryOperator((MetadataProvider)((MetadataProvider)this), (String)binaryExpr.getOpString(), (Object)((Object)binaryExpr));
        binOp.setLhs((Expression)this.handle((GoStandardLibrary.Ast.Node)binaryExpr.getX()));
        binOp.setRhs((Expression)this.handle((GoStandardLibrary.Ast.Node)binaryExpr.getY()));
        return binOp;
    }

    private final Expression handleIdent(GoStandardLibrary.Ast.Ident ident) {
        CharSequence charSequence;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"nil", (Object)new Pair((Object)TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this)), null)), TuplesKt.to((Object)"true", (Object)new Pair((Object)TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"bool"), (Object)true)), TuplesKt.to((Object)"false", (Object)new Pair((Object)TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"bool"), (Object)false)), TuplesKt.to((Object)"iota", (Object)new Pair((Object)TypeBuilderKt.primitiveType((LanguageProvider)((LanguageProvider)this), (CharSequence)"int"), (Object)((GoLanguageFrontend)this.getFrontend()).getDeclCtx().getIotaValue()))};
        Map builtinLiterals = MapsKt.mapOf((Pair[])pairArray);
        Pair literalPair = (Pair)builtinLiterals.get(ident.getName());
        if (literalPair != null) {
            Type type2 = (Type)literalPair.component1();
            Object value2 = literalPair.component2();
            Literal literal = ExpressionBuilderKt.newLiteral((RawNodeTypeProvider)((RawNodeTypeProvider)this), (Object)value2, (Type)type2, (Object)((Object)ident));
            literal.setName(NameKt.parseName((LanguageProvider)((LanguageProvider)this), (CharSequence)ident.getName()));
            return (Expression)literal;
        }
        CharSequence name2 = ident.getName();
        if (CollectionsKt.contains((Iterable)builtins, (Object)name2)) {
            charSequence = name2;
        } else if (this.isPackageName(name2)) {
            charSequence = name2;
        } else {
            Language language = this.getLanguage();
            if (StringsKt.contains$default((CharSequence)name2, (CharSequence)String.valueOf(language != null ? language.getNamespaceDelimiter() : null), (boolean)false, (int)2, null)) {
                charSequence = name2;
            } else {
                LanguageProvider languageProvider = (LanguageProvider)this;
                Scope scope = this.getScope();
                Object object = scope instanceof NameScope ? (NameScope)scope : null;
                if (object == null || (object = object.getName()) == null || (object = NameKt.fqn((Name)object, (String)ident.getName())) == null) {
                    object = ident.getName();
                }
                charSequence = (CharSequence)NameKt.parseName((LanguageProvider)languageProvider, (CharSequence)((CharSequence)object));
            }
        }
        name2 = charSequence;
        return (Expression)ExpressionBuilderKt.newReference$default((MetadataProvider)((MetadataProvider)this), (CharSequence)name2, null, (Object)((Object)ident), (int)2, null);
    }

    private final SubscriptExpression handleIndexExpr(GoStandardLibrary.Ast.IndexExpr indexExpr) {
        SubscriptExpression ase = ExpressionBuilderKt.newSubscriptExpression((MetadataProvider)((MetadataProvider)this), (Object)((Object)indexExpr));
        ase.setArrayExpression((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)indexExpr.getX()));
        ase.setSubscriptExpression((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)indexExpr.getIndex()));
        return ase;
    }

    private final Expression handleCallExpr(GoStandardLibrary.Ast.CallExpr callExpr) {
        Expression expression;
        GoStandardLibrary.Ast.Expr unwrapped = this.unwrap(callExpr.getFun());
        if (((((unwrapped instanceof GoStandardLibrary.Ast.ArrayType ? true : unwrapped instanceof GoStandardLibrary.Ast.ChanType) ? true : unwrapped instanceof GoStandardLibrary.Ast.FuncType) ? true : unwrapped instanceof GoStandardLibrary.Ast.InterfaceType) ? true : unwrapped instanceof GoStandardLibrary.Ast.StructType) ? true : unwrapped instanceof GoStandardLibrary.Ast.MapType) {
            CastExpression cast = ExpressionBuilderKt.newCastExpression((MetadataProvider)((MetadataProvider)this), (Object)((Object)callExpr));
            cast.setCastType(((GoLanguageFrontend)this.getFrontend()).typeOf(unwrapped));
            if (!((Collection)callExpr.getArgs()).isEmpty()) {
                cast.setExpression((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)callExpr.getArgs().get(0)));
            }
            return (Expression)cast;
        }
        List typeConstraints = new ArrayList();
        GoStandardLibrary.Ast.Expr fun2 = callExpr.getFun();
        if (fun2 instanceof GoStandardLibrary.Ast.IndexExpr) {
            var6_6 = ((GoLanguageFrontend)this.getFrontend()).typeOf(fun2);
            Object object = var6_6 instanceof ObjectType ? (ObjectType)var6_6 : null;
            if (object != null && (object = object.getGenerics()) != null) {
                it = object;
                boolean bl = false;
                CollectionsKt.addAll((Collection)typeConstraints, (Iterable)((Iterable)it));
            }
            expression = (Expression)this.handle((GoStandardLibrary.Ast.Node)((GoStandardLibrary.Ast.IndexExpr)fun2).getX());
        } else if (fun2 instanceof GoStandardLibrary.Ast.IndexListExpr) {
            var6_6 = ((GoLanguageFrontend)this.getFrontend()).typeOf(fun2);
            Object object = var6_6 instanceof ObjectType ? (ObjectType)var6_6 : null;
            if (object != null && (object = object.getGenerics()) != null) {
                it = object;
                boolean bl = false;
                CollectionsKt.addAll((Collection)typeConstraints, (Iterable)((Iterable)it));
            }
            expression = (Expression)this.handle((GoStandardLibrary.Ast.Node)((GoStandardLibrary.Ast.IndexListExpr)fun2).getX());
        } else {
            expression = (Expression)this.handle((GoStandardLibrary.Ast.Node)callExpr.getFun());
        }
        Expression callee = expression;
        String name2 = callee.getName().getLocalName();
        if (Intrinsics.areEqual((Object)name2, (Object)"new")) {
            return this.handleNewExpr(callExpr);
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"make")) {
            return this.handleMakeExpr(callExpr);
        }
        CallExpression call2 = callee instanceof MemberExpression ? (CallExpression)ExpressionBuilderKt.newMemberCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)callee, (boolean)false, (Object)((Object)callExpr), (int)2, null) : ExpressionBuilderKt.newCallExpression$default((MetadataProvider)((MetadataProvider)this), (Expression)callee, (CharSequence)name2, (boolean)false, (Object)((Object)callExpr), (int)4, null);
        call2.setType(TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this)));
        if (!((Collection)typeConstraints).isEmpty()) {
            Handler.getLog().debug("Call {} has type constraints ({}), but we cannot add them to the call expression yet", (Object)call2.getName(), (Object)CollectionsKt.joinToString$default((Iterable)typeConstraints, (CharSequence)", ", null, null, (int)0, null, (Function1)handleCallExpr.1.INSTANCE, (int)30, null));
        }
        for (GoStandardLibrary.Ast.Expr arg : callExpr.getArgs()) {
            call2.plusAssign((Expression)this.handle((GoStandardLibrary.Ast.Node)arg));
        }
        return (Expression)call2;
    }

    private final GoStandardLibrary.Ast.Expr unwrap(GoStandardLibrary.Ast.Expr expr) {
        return expr instanceof GoStandardLibrary.Ast.ParenExpr ? this.unwrap(((GoStandardLibrary.Ast.ParenExpr)expr).getX()) : expr;
    }

    private final KeyValueExpression handleKeyValueExpr(GoStandardLibrary.Ast.KeyValueExpr keyValueExpr) {
        Expression key2 = (Expression)this.handle((GoStandardLibrary.Ast.Node)keyValueExpr.getKey());
        Expression value2 = (Expression)this.handle((GoStandardLibrary.Ast.Node)keyValueExpr.getValue());
        return ExpressionBuilderKt.newKeyValueExpression((MetadataProvider)((MetadataProvider)this), (Expression)key2, (Expression)value2, (Object)((Object)keyValueExpr));
    }

    private final Expression handleNewExpr(GoStandardLibrary.Ast.CallExpr callExpr) {
        if (callExpr.getArgs().isEmpty()) {
            return (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"could not create NewExpression with empty arguments", null, null, (int)6, null);
        }
        NewExpression n = ExpressionBuilderKt.newNewExpression$default((MetadataProvider)((MetadataProvider)this), null, (Object)((Object)callExpr), (int)1, null);
        Type type2 = ((GoLanguageFrontend)this.getFrontend()).typeOf(callExpr.getArgs().get(0));
        n.setType(type2.reference(PointerType.PointerOrigin.POINTER));
        ConstructExpression construct = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), null, (Object)((Object)callExpr), (int)1, null);
        construct.setType(type2);
        n.setInitializer((Expression)construct);
        return (Expression)n;
    }

    private final Expression handleMakeExpr(GoStandardLibrary.Ast.CallExpr callExpr) {
        Expression expression;
        List<GoStandardLibrary.Ast.Expr> args2 = callExpr.getArgs();
        if (args2.isEmpty()) {
            return (Expression)ExpressionBuilderKt.newProblemExpression$default((MetadataProvider)((MetadataProvider)this), (String)"too few arguments for make expression", null, null, (int)6, null);
        }
        if (args2.get(0) instanceof GoStandardLibrary.Ast.ArrayType) {
            NewArrayExpression array = ExpressionBuilderKt.newNewArrayExpression((MetadataProvider)((MetadataProvider)this), (Object)((Object)callExpr));
            if (args2.size() > 1) {
                array.addDimension((Expression)this.handle((GoStandardLibrary.Ast.Node)args2.get(1)));
            }
            expression = (Expression)array;
        } else {
            ConstructExpression construct = ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), null, (Object)((Object)callExpr), (int)1, null);
            for (GoStandardLibrary.Ast.Expr expr : args2.subList(RangesKt.coerceAtMost((int)1, (int)(args2.size() - 1)), args2.size() - 1)) {
                Expression it = (Expression)this.handle((GoStandardLibrary.Ast.Node)expr);
                boolean bl = false;
                construct.plusAssign(it);
            }
            expression = (Expression)construct;
        }
        Expression expression2 = expression;
        expression2.setType(((GoLanguageFrontend)this.getFrontend()).typeOf(callExpr.getArgs().get(0)));
        return expression2;
    }

    private final Reference handleSelectorExpr(GoStandardLibrary.Ast.SelectorExpr selectorExpr) {
        Reference reference;
        boolean isMemberExpression;
        Expression base = (Expression)this.handle((GoStandardLibrary.Ast.Node)selectorExpr.getX());
        boolean bl = isMemberExpression = !this.isPackageName(base.getName().getLocalName());
        if (isMemberExpression) {
            reference = (Reference)ExpressionBuilderKt.newMemberExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)selectorExpr.getSel().getName(), (Expression)base, null, null, (Object)((Object)selectorExpr), (int)12, null);
        } else {
            String fqn = base.getName() + "." + selectorExpr.getSel().getName();
            reference = ExpressionBuilderKt.newReference$default((MetadataProvider)((MetadataProvider)this), (CharSequence)fqn, null, (Object)((Object)selectorExpr), (int)2, null);
        }
        Reference ref = reference;
        return ref;
    }

    private final boolean isPackageName(CharSequence name2) {
        Object object = ((GoLanguageFrontend)this.getFrontend()).getCurrentFile();
        if (object == null || (object = object.getImports()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object packageName;
            GoStandardLibrary.Ast.ImportSpec imp = (GoStandardLibrary.Ast.ImportSpec)((Object)iterator.next());
            Object object2 = imp.getName();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = this.getImportName(imp);
            }
            if (!Intrinsics.areEqual((Object)name2, (Object)(packageName = object2))) continue;
            return true;
        }
        return false;
    }

    private final SubscriptExpression handleSliceExpr(GoStandardLibrary.Ast.SliceExpr sliceExpr) {
        GoStandardLibrary.Ast.Expr it;
        SubscriptExpression ase = ExpressionBuilderKt.newSubscriptExpression((MetadataProvider)((MetadataProvider)this), (Object)((Object)sliceExpr));
        ase.setArrayExpression((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)sliceExpr.getX()));
        RangeExpression range = ExpressionBuilderKt.newRangeExpression$default((MetadataProvider)((MetadataProvider)this), null, null, (Object)((Object)sliceExpr), (int)3, null);
        GoStandardLibrary.Ast.Expr expr = sliceExpr.getLow();
        if (expr != null) {
            it = expr;
            boolean bl = false;
            range.setFloor((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)it));
        }
        GoStandardLibrary.Ast.Expr expr2 = sliceExpr.getHigh();
        if (expr2 != null) {
            it = expr2;
            boolean bl = false;
            range.setCeiling((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)it));
        }
        GoStandardLibrary.Ast.Expr expr3 = sliceExpr.getMax();
        if (expr3 != null) {
            it = expr3;
            boolean bl = false;
            range.setThird((Expression)((GoLanguageFrontend)this.getFrontend()).getExpressionHandler().handle((GoStandardLibrary.Ast.Node)it));
        }
        ase.setSubscriptExpression((Expression)range);
        return ase;
    }

    private final UnaryOperator handleStarExpr(GoStandardLibrary.Ast.StarExpr starExpr) {
        UnaryOperator op = ExpressionBuilderKt.newUnaryOperator((MetadataProvider)((MetadataProvider)this), (String)"*", (boolean)false, (boolean)false, (Object)((Object)starExpr));
        op.setInput((Expression)this.handle((GoStandardLibrary.Ast.Node)starExpr.getX()));
        return op;
    }

    /*
     * WARNING - void declaration
     */
    private final Expression handleTypeAssertExpr(GoStandardLibrary.Ast.TypeAssertExpr typeAssertExpr) {
        Expression expression;
        if (typeAssertExpr.getType() == null) {
            UnaryOperator op = ExpressionBuilderKt.newUnaryOperator((MetadataProvider)((MetadataProvider)this), (String)".(type)", (boolean)true, (boolean)false, (Object)((Object)typeAssertExpr));
            op.setInput((Expression)this.handle((GoStandardLibrary.Ast.Node)typeAssertExpr.getX()));
            expression = (Expression)op;
        } else {
            void var2_3;
            CastExpression cast = ExpressionBuilderKt.newCastExpression((MetadataProvider)((MetadataProvider)this), (Object)((Object)typeAssertExpr));
            cast.setExpression((Expression)this.handle((GoStandardLibrary.Ast.Node)typeAssertExpr.getX()));
            GoStandardLibrary.Ast.Expr expr = typeAssertExpr.getType();
            if (expr != null) {
                GoStandardLibrary.Ast.Expr it = expr;
                boolean bl = false;
                cast.setCastType(((GoLanguageFrontend)this.getFrontend()).typeOf(it));
            }
            expression = (Expression)var2_3;
        }
        return expression;
    }

    private final UnaryOperator handleUnaryExpr(GoStandardLibrary.Ast.UnaryExpr unaryExpr) {
        UnaryOperator op = ExpressionBuilderKt.newUnaryOperator((MetadataProvider)((MetadataProvider)this), (String)unaryExpr.getOpString(), (boolean)false, (boolean)false, (Object)((Object)unaryExpr));
        op.setInput((Expression)this.handle((GoStandardLibrary.Ast.Node)unaryExpr.getX()));
        return op;
    }

    private final Expression handleCompositeLit(GoStandardLibrary.Ast.CompositeLit compositeLit) {
        GoStandardLibrary.Ast.Expr expr;
        block4: {
            block3: {
                expr = compositeLit.getType();
                if (expr == null) break block3;
                GoStandardLibrary.Ast.Expr it = expr;
                boolean bl = false;
                Type type2 = ((GoLanguageFrontend)this.getFrontend()).typeOf(it);
                expr = type2;
                if (type2 != null) break block4;
            }
            expr = TypeBuilderKt.unknownType((MetadataProvider)((MetadataProvider)this));
        }
        GoStandardLibrary.Ast.Expr type3 = expr;
        InitializerListExpression list2 = ExpressionBuilderKt.newInitializerListExpression((MetadataProvider)((MetadataProvider)this), (Type)type3, (Object)((Object)compositeLit));
        list2.setType((Type)type3);
        List expressions = new ArrayList();
        for (GoStandardLibrary.Ast.Expr elem : compositeLit.getElts()) {
            Expression expression = (Expression)this.handle((GoStandardLibrary.Ast.Node)elem);
            ((Collection)expressions).add(expression);
        }
        list2.setInitializers(expressions);
        return (Expression)list2;
    }

    @NotNull
    public final LambdaExpression handleFuncLit(@NotNull GoStandardLibrary.Ast.FuncLit funcLit) {
        Intrinsics.checkNotNullParameter((Object)((Object)funcLit), (String)"funcLit");
        LambdaExpression lambda = ExpressionBuilderKt.newLambdaExpression((MetadataProvider)((MetadataProvider)this), (Object)((Object)funcLit));
        Object ResultNode = ((GoLanguageFrontend)this.getFrontend()).getDeclarationHandler().handle((GoStandardLibrary.Ast.Node)funcLit.toDecl());
        lambda.setFunction(ResultNode instanceof FunctionDeclaration ? (FunctionDeclaration)ResultNode : null);
        return lambda;
    }

    static {
        Object[] objectArray = new String[]{"bool", "uint8", "uint16", "uint32", "uint64", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "string", "int", "uint", "uintptr", "byte", "rune", "any", "comparable", "iota", "nil", "append", "copy", "delete", "len", "cap", "make", "max", "min", "new", "complex", "real", "imag", "clear", "close", "panic", "recover", "print", "println", "error"};
        builtins = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/ExpressionHandler$Companion;", "", "()V", "builtins", "", "", "getBuiltins", "()Ljava/util/List;", "cpg-language-go"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getBuiltins() {
            return builtins;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GoStandardLibrary.Ast.BasicLit.Kind.values().length];
            try {
                nArray[GoStandardLibrary.Ast.BasicLit.Kind.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoStandardLibrary.Ast.BasicLit.Kind.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoStandardLibrary.Ast.BasicLit.Kind.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoStandardLibrary.Ast.BasicLit.Kind.CHAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

