/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.golang;

import de.fraunhofer.aisec.cpg.frontends.golang.BuildConstraintExpression;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0010"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/BuildConstraintBinaryExpression;", "Lde/fraunhofer/aisec/cpg/frontends/golang/BuildConstraintExpression;", "operatorCode", "", "lhs", "rhs", "(Ljava/lang/String;Lde/fraunhofer/aisec/cpg/frontends/golang/BuildConstraintExpression;Lde/fraunhofer/aisec/cpg/frontends/golang/BuildConstraintExpression;)V", "getLhs", "()Lde/fraunhofer/aisec/cpg/frontends/golang/BuildConstraintExpression;", "getOperatorCode", "()Ljava/lang/String;", "getRhs", "evaluate", "", "tags", "", "cpg-language-go"})
public final class BuildConstraintBinaryExpression
implements BuildConstraintExpression {
    @NotNull
    private final String operatorCode;
    @NotNull
    private final BuildConstraintExpression lhs;
    @NotNull
    private final BuildConstraintExpression rhs;

    public BuildConstraintBinaryExpression(@NotNull String operatorCode, @NotNull BuildConstraintExpression lhs2, @NotNull BuildConstraintExpression rhs2) {
        Intrinsics.checkNotNullParameter((Object)operatorCode, (String)"operatorCode");
        Intrinsics.checkNotNullParameter((Object)lhs2, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs2, (String)"rhs");
        this.operatorCode = operatorCode;
        this.lhs = lhs2;
        this.rhs = rhs2;
    }

    @NotNull
    public final String getOperatorCode() {
        return this.operatorCode;
    }

    @NotNull
    public final BuildConstraintExpression getLhs() {
        return this.lhs;
    }

    @NotNull
    public final BuildConstraintExpression getRhs() {
        return this.rhs;
    }

    @Override
    public boolean evaluate(@NotNull Set<String> tags) {
        boolean bl;
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        String string = this.operatorCode;
        if (Intrinsics.areEqual((Object)string, (Object)"&&")) {
            bl = this.lhs.evaluate(tags) && this.rhs.evaluate(tags);
        } else if (Intrinsics.areEqual((Object)string, (Object)"||")) {
            bl = this.lhs.evaluate(tags) || this.rhs.evaluate(tags);
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return bl;
    }
}

