/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.golang;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.SupportsParallelParsing;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SupportsParallelParsing(supported=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u0004\u0018\u00010\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0082 J)\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\u0016\u001a\u0002H\u001b2\u0006\u0010\u001c\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "getCodeFromRawNode", "", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "parseInternal", "s", "path", "topLevel", "setComment", "", "S", "ctx", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Companion", "cpg-language-go"})
public final class GoLanguageFrontend
extends LanguageFrontend {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GoLanguageFrontend(@NotNull Language<GoLanguageFrontend> language, @NotNull TranslationConfiguration config, @NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        super(language, config, scopeManager);
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) throws TranslationException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        Object object = this.getConfig().getTopLevel();
        if (object == null || (object = ((File)object).getAbsolutePath()) == null) {
            object = file.getParent();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"config.topLevel?.absolutePath ?: file.parent");
        return this.parseInternal(string, string2, (String)object);
    }

    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        return null;
    }

    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        return null;
    }

    public <S, T> void setComment(S s, T ctx) {
    }

    private final native TranslationUnitDeclaration parseInternal(String var1, String var2, String var3);

    static {
        try {
            String string = System.getProperty("os.arch");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.arch\")");
            String arch = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"aarch64", (String)"arm64", (boolean)false, (int)4, null), (String)"x86_64", (String)"amd64", (boolean)false, (int)4, null);
            String string2 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.name\")");
            String ext = StringsKt.startsWith$default((String)string2, (String)"Mac", (boolean)false, (int)2, null) ? ".dylib" : ".so";
            InputStream stream = GoLanguageFrontend.class.getResourceAsStream("/libcpgo-" + arch + ext);
            File tmp = File.createTempFile("libcpgo", ext);
            tmp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmp);
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            ByteStreamsKt.copyTo$default((InputStream)stream, (OutputStream)new FileOutputStream(tmp), (int)0, (int)2, null);
            fos.close();
            stream.close();
            LanguageFrontend.Companion.getLog().info("Loading cpgo library from " + tmp.getAbsoluteFile());
            System.load(tmp.getAbsolutePath());
        }
        catch (Exception ex) {
            LanguageFrontend.Companion.getLog().error("Error while loading cpgo library. Go frontend will not work correctly", (Throwable)ex);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$Companion;", "", "()V", "cpg-language-go"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

