/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.golang;

import de.fraunhofer.aisec.cpg.ExperimentalGolang;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalGolang
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u0004\u0018\u00010\r\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0082 J)\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\t2\u0006\u0010\u0014\u001a\u0002H\u00192\u0006\u0010\u001a\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "scopeManager", "Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;)V", "getCodeFromRawNode", "", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "parse", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "file", "Ljava/io/File;", "parseInternal", "s", "path", "topLevel", "setComment", "", "S", "ctx", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Companion", "cpg-language-go"})
public final class GoLanguageFrontend
extends LanguageFrontend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static List<String> GOLANG_EXTENSIONS = CollectionsKt.listOf((Object)".go");

    public GoLanguageFrontend(@NotNull TranslationConfiguration config, @Nullable ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, scopeManager, ".");
    }

    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) throws TranslationException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TypeManager.getInstance().setLanguageFrontend((LanguageFrontend)this);
        String string = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
        String string3 = this.config.getTopLevel().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.topLevel.absolutePath");
        return this.parseInternal(string, string2, string3);
    }

    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        return null;
    }

    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        return null;
    }

    public <S, T> void setComment(S s, T ctx) {
    }

    private final native TranslationUnitDeclaration parseInternal(String var1, String var2, String var3);

    static {
        try {
            String string = System.getProperty("os.arch");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.arch\")");
            String arch = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"aarch64", (String)"arm64", (boolean)false, (int)4, null), (String)"x86_64", (String)"amd64", (boolean)false, (int)4, null);
            String string2 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.name\")");
            String ext = StringsKt.startsWith$default((String)string2, (String)"Mac", (boolean)false, (int)2, null) ? ".dylib" : ".so";
            InputStream stream = GoLanguageFrontend.class.getResourceAsStream("/libcpgo-" + arch + ext);
            File tmp = File.createTempFile("libcpgo", ext);
            tmp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmp);
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            ByteStreamsKt.copyTo$default((InputStream)stream, (OutputStream)new FileOutputStream(tmp), (int)0, (int)2, null);
            fos.close();
            stream.close();
            LanguageFrontend.log.info("Loading cpgo library from " + tmp.getAbsoluteFile());
            System.load(tmp.getAbsolutePath());
        }
        catch (Exception ex) {
            LanguageFrontend.log.error("Error while loading cpgo library. Go frontend will not work correctly", (Throwable)ex);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/golang/GoLanguageFrontend$Companion;", "", "()V", "GOLANG_EXTENSIONS", "", "", "cpg-language-go"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

