/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.cxx.CLanguage;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.ContextProvider;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParameterDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.GlobalScope;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.scopes.ValueDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeKt;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.ComponentPass;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.ReplaceCallCastPass;
import de.fraunhofer.aisec.cpg.passes.ReplaceCallCastPassKt;
import de.fraunhofer.aisec.cpg.passes.SymbolResolver;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg.passes.configuration.DependsOn;
import de.fraunhofer.aisec.cpg.passes.configuration.ExecuteBefore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExecuteBefore.Container(value={@ExecuteBefore(other=EvaluationOrderGraphPass.class), @ExecuteBefore(other=ReplaceCallCastPass.class)})
@DependsOn(value=TypeResolver.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0004J\u001a\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/fraunhofer/aisec/cpg/passes/CXXExtraPass;", "Lde/fraunhofer/aisec/cpg/passes/ComponentPass;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "walker", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "accept", "", "component", "Lde/fraunhofer/aisec/cpg/graph/Component;", "cleanup", "connectDefinitions", "declaration", "Lde/fraunhofer/aisec/cpg/graph/Node;", "convertOperators", "binOp", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "parent", "fixInitializers", "node", "removeBracketOperators", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "cpg-language-cxx"})
@SourceDebugExtension(value={"SMAP\nCXXExtraPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CXXExtraPass.kt\nde/fraunhofer/aisec/cpg/passes/CXXExtraPass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,239:1\n1549#2:240\n1620#2,3:241\n800#2,11:246\n766#2:257\n857#2,2:258\n37#3,2:244\n*S KotlinDebug\n*F\n+ 1 CXXExtraPass.kt\nde/fraunhofer/aisec/cpg/passes/CXXExtraPass\n*L\n173#1:240\n173#1:241,3\n213#1:246,11\n213#1:257\n213#1:258,2\n179#1:244,2\n*E\n"})
public final class CXXExtraPass
extends ComponentPass {
    private SubgraphWalker.ScopedWalker walker;

    public CXXExtraPass(@NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
    }

    public void accept(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.walker = new SubgraphWalker.ScopedWalker(this.getCtx().getScopeManager(), null, 2, null);
        SubgraphWalker.ScopedWalker scopedWalker = this.walker;
        if (scopedWalker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
            scopedWalker = null;
        }
        scopedWalker.registerHandler(this::fixInitializers);
        SubgraphWalker.ScopedWalker scopedWalker2 = this.walker;
        if (scopedWalker2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
            scopedWalker2 = null;
        }
        scopedWalker2.registerHandler((arg_0, arg_1, arg_2) -> CXXExtraPass.accept$lambda$0(this, arg_0, arg_1, arg_2));
        SubgraphWalker.ScopedWalker scopedWalker3 = this.walker;
        if (scopedWalker3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
            scopedWalker3 = null;
        }
        scopedWalker3.registerHandler(this::connectDefinitions);
        for (TranslationUnitDeclaration tu : component.getTranslationUnits()) {
            SubgraphWalker.ScopedWalker scopedWalker4 = this.walker;
            if (scopedWalker4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
                scopedWalker4 = null;
            }
            scopedWalker4.iterate((Node)tu);
        }
    }

    private final void removeBracketOperators(UnaryOperator node, Node parent) {
        if (Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"()") && !this.getTypeManager().typeExists(node.getInput().getName().toString())) {
            ContextProvider contextProvider = (ContextProvider)this;
            SubgraphWalker.ScopedWalker scopedWalker = this.walker;
            if (scopedWalker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
                scopedWalker = null;
            }
            ReplaceCallCastPassKt.replaceArgument((ContextProvider)contextProvider, (SubgraphWalker.ScopedWalker)scopedWalker, (Node)parent, (Expression)((Expression)node), (Expression)node.getInput());
        }
    }

    private final void convertOperators(BinaryOperator binOp, Node parent) {
        CLanguage language;
        Expression fakeUnaryOp = binOp.getLhs();
        Language language2 = fakeUnaryOp.getLanguage();
        CLanguage cLanguage = language = language2 instanceof CLanguage ? (CLanguage)language2 : null;
        if (language != null && fakeUnaryOp instanceof UnaryOperator && Intrinsics.areEqual((Object)((UnaryOperator)fakeUnaryOp).getOperatorCode(), (Object)"()") && this.getTypeManager().typeExists(((UnaryOperator)fakeUnaryOp).getInput().getName().toString())) {
            String opCode;
            CastExpression cast = (CastExpression)NodeBuilderKt.codeAndLocationFrom((Node)((Node)ExpressionBuilderKt.newCastExpression$default((MetadataProvider)((MetadataProvider)this), null, (int)1, null)), (Node)((Node)fakeUnaryOp));
            cast.setLanguage((Language)language);
            cast.setCastType(TypeBuilderKt.objectType$default((LanguageProvider)((LanguageProvider)language), (CharSequence)((CharSequence)((UnaryOperator)fakeUnaryOp).getInput().getName()), null, (int)2, null));
            String string = binOp.getOperatorCode();
            if (string == null) {
                string = opCode = "";
            }
            if (!language.getUnaryOperators().contains(opCode)) {
                Pass.Companion.getLog().error("We tried to convert a binary operator into a unary operator, but the list of operator codes does not allow that. This is suspicious and the translation probably was incorrect");
                return;
            }
            UnaryOperator unaryOp = (UnaryOperator)NodeBuilderKt.codeAndLocationFrom((Node)((Node)ExpressionBuilderKt.newUnaryOperator$default((MetadataProvider)((MetadataProvider)this), (String)opCode, (boolean)false, (boolean)true, null, (int)8, null)), (Node)((Node)binOp.getRhs()));
            unaryOp.setLanguage((Language)language);
            unaryOp.setInput(binOp.getRhs());
            cast.setExpression((Expression)unaryOp);
            ContextProvider contextProvider = (ContextProvider)this;
            SubgraphWalker.ScopedWalker scopedWalker = this.walker;
            if (scopedWalker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
                scopedWalker = null;
            }
            ReplaceCallCastPassKt.replaceArgument((ContextProvider)contextProvider, (SubgraphWalker.ScopedWalker)scopedWalker, (Node)parent, (Expression)((Expression)binOp), (Expression)((Expression)cast));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void fixInitializers(@Nullable Node node) {
        if (node instanceof VariableDeclaration) {
            RecordDeclaration record = TypeKt.getRecordDeclaration((Type)((VariableDeclaration)node).getType().getRoot());
            Name typeString = ((VariableDeclaration)node).getType().getRoot().getName();
            if (record != null) {
                Expression currInitializer = ((VariableDeclaration)node).getInitializer();
                if (currInitializer == null && ((VariableDeclaration)node).isImplicitInitializerAllowed()) {
                    ConstructExpression initializer = (ConstructExpression)NodeBuilderKt.implicit$default((Node)((Node)ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)((CharSequence)typeString), null, (int)2, null)), (String)(typeString + "()"), null, (int)2, null);
                    initializer.setLanguage(((VariableDeclaration)node).getLanguage());
                    initializer.setType(((VariableDeclaration)node).getType());
                    ((VariableDeclaration)node).setInitializer((Expression)initializer);
                    List list = ((VariableDeclaration)node).getTemplateParameters();
                    if (list != null) {
                        List it = list;
                        boolean bl = false;
                        SymbolResolver.Companion.addImplicitTemplateParametersToCall(it, initializer);
                    }
                } else if (!(currInitializer instanceof ConstructExpression) && currInitializer instanceof CallExpression && Intrinsics.areEqual((Object)((CallExpression)currInitializer).getName().getLocalName(), (Object)((VariableDeclaration)node).getType().getRoot().getName().getLocalName())) {
                    void $this$mapTo$iv$iv;
                    List arguments = ((CallExpression)currInitializer).getArguments();
                    Iterable $this$map$iv = arguments;
                    boolean $i$f$map = false;
                    Iterable bl = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        Node node2 = (Node)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(p0.getCode());
                    }
                    String signature = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    ConstructExpression initializer = (ConstructExpression)NodeBuilderKt.implicit$default((Node)((Node)ExpressionBuilderKt.newConstructExpression$default((MetadataProvider)((MetadataProvider)this), (CharSequence)((CharSequence)typeString), null, (int)2, null)), (String)(typeString + "(" + signature + ")"), null, (int)2, null);
                    initializer.setLanguage(((VariableDeclaration)node).getLanguage());
                    initializer.setType(((VariableDeclaration)node).getType());
                    Collection $this$toTypedArray$iv = arguments;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Expression[] expressionArray = thisCollection$iv.toArray(new Expression[0]);
                    initializer.setArguments(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(expressionArray, expressionArray.length)));
                    ((VariableDeclaration)node).setInitializer((Expression)initializer);
                    ((CallExpression)currInitializer).disconnectFromGraph();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void connectDefinitions(Node declaration) {
        if (!(declaration instanceof FunctionDeclaration)) {
            return;
        }
        if (!((FunctionDeclaration)declaration).isDefinition()) {
            return;
        }
        Scope scope = this.getScopeManager().getCurrentScope();
        if (scope instanceof GlobalScope) {
            scope = (Scope)this.getScopeManager().getGlobalScope();
        }
        if (scope instanceof ValueDeclarationScope) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((ValueDeclarationScope)scope).getValueDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FunctionDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FunctionDeclaration it = (FunctionDeclaration)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.getClass() == declaration.getClass() && !it.isDefinition() && Intrinsics.areEqual((Object)it.getName(), (Object)((FunctionDeclaration)declaration).getName()) && Intrinsics.areEqual((Object)it.getSignature(), (Object)((FunctionDeclaration)declaration).getSignature());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidates = (List)destination$iv$iv;
            for (FunctionDeclaration candidate : candidates) {
                candidate.setDefinition((FunctionDeclaration)declaration);
                int n = ((FunctionDeclaration)declaration).getParameters().size();
                for (int i = 0; i < n; ++i) {
                    if (((ParameterDeclaration)candidate.getParameters().get(i)).getDefault() == null) continue;
                    ((ParameterDeclaration)((FunctionDeclaration)declaration).getParameters().get(i)).setDefault(((ParameterDeclaration)candidate.getParameters().get(i)).getDefault());
                }
            }
        }
    }

    public void cleanup() {
    }

    private static final void accept$lambda$0(CXXExtraPass this$0, RecordDeclaration recordDeclaration, Node parent, Node node) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Node node2 = node;
        if (node2 instanceof UnaryOperator) {
            this$0.removeBracketOperators((UnaryOperator)node, parent);
        } else if (node2 instanceof BinaryOperator) {
            this$0.convertOperators((BinaryOperator)node, parent);
        }
    }
}

