/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cxx;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.aisec.cpg.frontends.CastNotPossible;
import de.fraunhofer.aisec.cpg.frontends.CastResult;
import de.fraunhofer.aisec.cpg.frontends.DirectMatch;
import de.fraunhofer.aisec.cpg.frontends.HasElaboratedTypeSpecifier;
import de.fraunhofer.aisec.cpg.frontends.HasFunctionPointers;
import de.fraunhofer.aisec.cpg.frontends.HasGlobalVariables;
import de.fraunhofer.aisec.cpg.frontends.HasQualifier;
import de.fraunhofer.aisec.cpg.frontends.HasShortCircuitOperators;
import de.fraunhofer.aisec.cpg.frontends.HasStructs;
import de.fraunhofer.aisec.cpg.frontends.ImplicitCast;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.cxx.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.declarations.ParameterDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.FloatingPointType;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.IntegerType;
import de.fraunhofer.aisec.cpg.graph.types.NumericType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Transient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u00072\u00020\bB\u0005\u00a2\u0006\u0002\u0010\tJ,\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.H\u0016R\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001f8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017\u00a8\u00060"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/cxx/CLanguage;", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Lde/fraunhofer/aisec/cpg/frontends/cxx/CXXLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/HasStructs;", "Lde/fraunhofer/aisec/cpg/frontends/HasFunctionPointers;", "Lde/fraunhofer/aisec/cpg/frontends/HasQualifier;", "Lde/fraunhofer/aisec/cpg/frontends/HasElaboratedTypeSpecifier;", "Lde/fraunhofer/aisec/cpg/frontends/HasShortCircuitOperators;", "Lde/fraunhofer/aisec/cpg/frontends/HasGlobalVariables;", "()V", "builtInTypes", "", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "getBuiltInTypes", "()Ljava/util/Map;", "compoundAssignmentOperators", "", "getCompoundAssignmentOperators", "()Ljava/util/Set;", "conjunctiveOperators", "", "getConjunctiveOperators", "()Ljava/util/List;", "disjunctiveOperators", "getDisjunctiveOperators", "elaboratedTypeSpecifier", "getElaboratedTypeSpecifier", "fileExtensions", "getFileExtensions", "frontend", "Lkotlin/reflect/KClass;", "getFrontend", "()Lkotlin/reflect/KClass;", "namespaceDelimiter", "getNamespaceDelimiter", "()Ljava/lang/String;", "qualifiers", "getQualifiers", "unaryOperators", "getUnaryOperators", "tryCast", "Lde/fraunhofer/aisec/cpg/frontends/CastResult;", "type", "targetType", "hint", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "targetHint", "cpg-language-cxx"})
public class CLanguage
extends Language<CXXLanguageFrontend>
implements HasStructs,
HasFunctionPointers,
HasQualifier,
HasElaboratedTypeSpecifier,
HasShortCircuitOperators,
HasGlobalVariables {
    @NotNull
    private final List<String> fileExtensions;
    @NotNull
    private final String namespaceDelimiter;
    @Transient
    @NotNull
    private final KClass<? extends CXXLanguageFrontend> frontend;
    @NotNull
    private final List<String> qualifiers;
    @NotNull
    private final List<String> elaboratedTypeSpecifier;
    @NotNull
    private final List<String> conjunctiveOperators;
    @NotNull
    private final List<String> disjunctiveOperators;
    @NotNull
    private final List<String> unaryOperators;
    @NotNull
    private final Set<String> compoundAssignmentOperators;
    @Transient
    @JsonIgnore
    @NotNull
    private final Map<String, Type> builtInTypes;

    public CLanguage() {
        Object[] objectArray = new String[]{"c", "h"};
        this.fileExtensions = CollectionsKt.listOf((Object[])objectArray);
        this.namespaceDelimiter = "::";
        this.frontend = Reflection.getOrCreateKotlinClass(CXXLanguageFrontend.class);
        objectArray = new String[]{"const", "volatile", "restrict", "atomic"};
        this.qualifiers = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"struct", "union", "enum"};
        this.elaboratedTypeSpecifier = CollectionsKt.listOf((Object[])objectArray);
        this.conjunctiveOperators = CollectionsKt.listOf((Object)"&&");
        this.disjunctiveOperators = CollectionsKt.listOf((Object)"||");
        objectArray = new String[]{"--", "++", "-", "+", "*", "&", "~"};
        this.unaryOperators = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"+=", "-=", "*=", "/=", "%=", "<<=", ">>=", "&=", "|=", "^="};
        this.compoundAssignmentOperators = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"char", (Object)new IntegerType((CharSequence)"char", Integer.valueOf(8), (Language)this, NumericType.Modifier.NOT_APPLICABLE)), TuplesKt.to((Object)"signed char", (Object)new IntegerType((CharSequence)"signed char", Integer.valueOf(8), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"unsigned char", (Object)new IntegerType((CharSequence)"unsigned char", Integer.valueOf(8), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"short int", (Object)new IntegerType((CharSequence)"short int", Integer.valueOf(16), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"unsigned short int", (Object)new IntegerType((CharSequence)"unsigned short int", Integer.valueOf(16), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"int", (Object)new IntegerType((CharSequence)"int", Integer.valueOf(32), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"unsigned int", (Object)new IntegerType((CharSequence)"unsigned int", Integer.valueOf(32), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"long int", (Object)new IntegerType((CharSequence)"long int", Integer.valueOf(64), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"unsigned long int", (Object)new IntegerType((CharSequence)"unsigned long int", Integer.valueOf(64), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"long long int", (Object)new IntegerType((CharSequence)"long long int", Integer.valueOf(64), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"unsigned long long int", (Object)new IntegerType((CharSequence)"unsigned long long int", Integer.valueOf(64), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"float", (Object)new FloatingPointType((CharSequence)"float", Integer.valueOf(32), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"double", (Object)new FloatingPointType((CharSequence)"double", Integer.valueOf(64), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"long double", (Object)new FloatingPointType((CharSequence)"long double", Integer.valueOf(128), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"bool", (Object)new IntegerType((CharSequence)"bool", Integer.valueOf(1), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"int8_t", (Object)new IntegerType((CharSequence)"int8_t", Integer.valueOf(8), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"int16_t", (Object)new IntegerType((CharSequence)"int16_t", Integer.valueOf(16), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"int32_t", (Object)new IntegerType((CharSequence)"int32_t", Integer.valueOf(32), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"int64_t", (Object)new IntegerType((CharSequence)"int64_t", Integer.valueOf(64), (Language)this, NumericType.Modifier.SIGNED)), TuplesKt.to((Object)"uint8_t", (Object)new IntegerType((CharSequence)"uint8_t", Integer.valueOf(8), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"uint16_t", (Object)new IntegerType((CharSequence)"uint16_t", Integer.valueOf(16), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"uint32_t", (Object)new IntegerType((CharSequence)"uint32_t", Integer.valueOf(32), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"uint64_t", (Object)new IntegerType((CharSequence)"uint64_t", Integer.valueOf(64), (Language)this, NumericType.Modifier.UNSIGNED)), TuplesKt.to((Object)"__int128", (Object)new IntegerType((CharSequence)"__int128", Integer.valueOf(128), (Language)this, NumericType.Modifier.SIGNED))};
        this.builtInTypes = MapsKt.mapOf((Pair[])objectArray);
    }

    @NotNull
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    @NotNull
    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    @NotNull
    public KClass<? extends CXXLanguageFrontend> getFrontend() {
        return this.frontend;
    }

    @NotNull
    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    @NotNull
    public List<String> getElaboratedTypeSpecifier() {
        return this.elaboratedTypeSpecifier;
    }

    @NotNull
    public List<String> getConjunctiveOperators() {
        return this.conjunctiveOperators;
    }

    @NotNull
    public List<String> getDisjunctiveOperators() {
        return this.disjunctiveOperators;
    }

    @NotNull
    public final List<String> getUnaryOperators() {
        return this.unaryOperators;
    }

    @NotNull
    public Set<String> getCompoundAssignmentOperators() {
        return this.compoundAssignmentOperators;
    }

    @NotNull
    public Map<String, Type> getBuiltInTypes() {
        return this.builtInTypes;
    }

    @NotNull
    public CastResult tryCast(@NotNull Type type, @NotNull Type targetType, @Nullable HasType hint, @Nullable HasType targetHint) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        CastResult match = super.tryCast(type, targetType, hint, targetHint);
        if (!Intrinsics.areEqual((Object)match, (Object)CastNotPossible.INSTANCE)) {
            return match;
        }
        if (type instanceof NumericType && targetType instanceof NumericType) {
            return (CastResult)ImplicitCast.Companion;
        }
        if (Intrinsics.areEqual((Object)type.getRoot(), (Object)targetType.getRoot()) && type instanceof PointerType && targetType instanceof PointerType) {
            return (CastResult)ImplicitCast.Companion;
        }
        if (targetType instanceof ReferenceType && Intrinsics.areEqual((Object)((ReferenceType)targetType).getElementType(), (Object)type) && targetHint instanceof ParameterDeclaration && ((ParameterDeclaration)targetHint).getModifiers().contains("const")) {
            return (CastResult)DirectMatch.INSTANCE;
        }
        return (CastResult)CastNotPossible.INSTANCE;
    }

    @NotNull
    public Set<String> getOperatorCodes() {
        return HasShortCircuitOperators.DefaultImpls.getOperatorCodes((HasShortCircuitOperators)this);
    }
}

