/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.sarif;

import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "", "uri", "Ljava/net/URI;", "region", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "(Ljava/net/URI;Lde/fraunhofer/aisec/cpg/sarif/Region;)V", "artifactLocation", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation$ArtifactLocation;", "getArtifactLocation", "()Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation$ArtifactLocation;", "getRegion", "()Lde/fraunhofer/aisec/cpg/sarif/Region;", "setRegion", "(Lde/fraunhofer/aisec/cpg/sarif/Region;)V", "equals", "", "other", "hashCode", "", "toString", "", "ArtifactLocation", "Companion", "cpg-core"})
public final class PhysicalLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArtifactLocation artifactLocation;
    @NotNull
    private Region region;

    public PhysicalLocation(@NotNull URI uri, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.artifactLocation = new ArtifactLocation(uri);
        this.region = region;
    }

    @NotNull
    public final ArtifactLocation getArtifactLocation() {
        return this.artifactLocation;
    }

    @NotNull
    public final Region getRegion() {
        return this.region;
    }

    public final void setRegion(@NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"<set-?>");
        this.region = region;
    }

    @NotNull
    public String toString() {
        return this.artifactLocation + "(" + this.region + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysicalLocation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.artifactLocation, (Object)((PhysicalLocation)other).artifactLocation) && Intrinsics.areEqual((Object)this.region, (Object)((PhysicalLocation)other).region);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.artifactLocation, this.region};
        return Objects.hash(objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation$ArtifactLocation;", "", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "getUri", "()Ljava/net/URI;", "equals", "", "other", "hashCode", "", "toString", "", "cpg-core"})
    public static final class ArtifactLocation {
        @NotNull
        private final URI uri;

        public ArtifactLocation(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
        }

        @NotNull
        public final URI getUri() {
            return this.uri;
        }

        @NotNull
        public String toString() {
            String string = this.uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = string;
            String string3 = this.uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            String string4 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            return string4;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactLocation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uri, (Object)((ArtifactLocation)other).uri);
        }

        public int hashCode() {
            return Objects.hashCode(this.uri);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation$Companion;", "", "()V", "locationLink", "", "location", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String locationLink(@Nullable PhysicalLocation location) {
            return location != null ? location.getArtifactLocation().getUri().getPath() + ":" + location.getRegion().startLine + ":" + location.getRegion().startColumn : "unknown";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

