/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.order;

import de.fraunhofer.aisec.cpg.ConfigurationException;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.order.PassWithDependencies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KAnnotatedElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bJ\u001c\u0010\r\u001a\u00020\b2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\u001c\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\u0014\u0010\u0013\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0010\u0018\u00010\u000fJ\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f0\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0015J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0015J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0015J\u001c\u0010\u0019\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/fraunhofer/aisec/cpg/passes/order/PassWithDepsContainer;", "", "()V", "isEmpty", "", "()Z", "workingList", "", "Lde/fraunhofer/aisec/cpg/passes/order/PassWithDependencies;", "addMissingDependencies", "", "addToWorkingList", "newElement", "createNewPassWithDependency", "cls", "Lkotlin/reflect/KClass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "dependencyPresent", "dep", "getAndRemoveFirstPass", "getAndRemoveFirstPassWithoutDependencies", "", "getFirstPasses", "getLastPasses", "getWorkingList", "removeDependencyByClass", "size", "", "toString", "", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nPassWithDepsContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PassWithDepsContainer.kt\nde/fraunhofer/aisec/cpg/passes/order/PassWithDepsContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,210:1\n766#2:211\n857#2,2:212\n766#2:214\n857#2,2:215\n1855#2,2:218\n43#3:217\n*S KotlinDebug\n*F\n+ 1 PassWithDepsContainer.kt\nde/fraunhofer/aisec/cpg/passes/order/PassWithDepsContainer\n*L\n77#1:211\n77#1:212,2\n81#1:214\n81#1:215,2\n177#1:218,2\n100#1:217\n*E\n"})
public final class PassWithDepsContainer {
    @NotNull
    private final List<PassWithDependencies> workingList = new ArrayList();

    @NotNull
    public final List<PassWithDependencies> getWorkingList() {
        return this.workingList;
    }

    public final void addToWorkingList(@NotNull PassWithDependencies newElement) {
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        this.workingList.add(newElement);
    }

    public final boolean isEmpty() {
        return this.workingList.isEmpty();
    }

    public final int size() {
        return this.workingList.size();
    }

    private final void removeDependencyByClass(KClass<? extends Pass<?>> cls) {
        for (PassWithDependencies pass : this.workingList) {
            pass.getSoftDependencies().remove(cls);
            pass.getHardDependencies().remove(cls);
        }
    }

    @NotNull
    public String toString() {
        return this.workingList.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PassWithDependencies> getFirstPasses() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.workingList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PassWithDependencies it = (PassWithDependencies)element$iv$iv;
            boolean bl = false;
            if (!it.isFirstPass()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PassWithDependencies> getLastPasses() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.workingList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PassWithDependencies it = (PassWithDependencies)element$iv$iv;
            boolean bl = false;
            if (!it.isLastPass()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean dependencyPresent(KClass<? extends Pass<?>> dep) {
        boolean result = false;
        for (PassWithDependencies currentElement : this.workingList) {
            if (!Intrinsics.areEqual(dep, currentElement.getPass())) continue;
            result = true;
            break;
        }
        return result;
    }

    private final PassWithDependencies createNewPassWithDependency(KClass<? extends Pass<?>> cls) {
        Set softDependencies = new LinkedHashSet();
        Set hardDependencies = new LinkedHashSet();
        KAnnotatedElement $this$findAnnotations$iv = (KAnnotatedElement)cls;
        boolean $i$f$findAnnotations = false;
        List dependencies = KAnnotatedElements.findAnnotations((KAnnotatedElement)$this$findAnnotations$iv, (KClass)Reflection.getOrCreateKotlinClass(DependsOn.class));
        for (DependsOn d : dependencies) {
            if (d.softDependency()) {
                ((Collection)softDependencies).add(Reflection.getOrCreateKotlinClass(d.value()));
                continue;
            }
            ((Collection)hardDependencies).add(Reflection.getOrCreateKotlinClass(d.value()));
        }
        return new PassWithDependencies(cls, softDependencies, hardDependencies);
    }

    public final void addMissingDependencies() {
        ListIterator<PassWithDependencies> it = this.workingList.listIterator();
        while (it.hasNext()) {
            PassWithDependencies current = it.next();
            for (KClass kClass : current.getHardDependencies()) {
                if (this.dependencyPresent(kClass)) continue;
                Pass.Companion.getLog().info("Registering a required hard dependency which was not registered explicitly: {}", (Object)kClass);
                it.add(this.createNewPassWithDependency(kClass));
            }
        }
        List missingPasses = new ArrayList();
        for (PassWithDependencies passWithDependencies : this.workingList) {
            for (KClass<? extends Pass<?>> kClass : passWithDependencies.getHardDependencies()) {
                if (this.dependencyPresent(kClass)) continue;
                missingPasses.add(kClass);
            }
        }
    }

    @NotNull
    public final List<KClass<? extends Pass<?>>> getAndRemoveFirstPassWithoutDependencies() {
        List results = new ArrayList();
        ListIterator<PassWithDependencies> it = this.workingList.listIterator();
        while (it.hasNext()) {
            PassWithDependencies currentElement = it.next();
            if (results.isEmpty() && currentElement.isLastPass() && this.workingList.size() == 1) {
                it.remove();
                return CollectionsKt.listOf(currentElement.getPass());
            }
            if (!currentElement.getDependencies().isEmpty() || currentElement.isLastPass()) continue;
            KClass<? extends Pass<?>> result = currentElement.getPass();
            results.add(result);
            it.remove();
        }
        Iterable $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass it2 = (KClass)element$iv;
            boolean bl = false;
            this.removeDependencyByClass(it2);
        }
        return results;
    }

    @Nullable
    public final KClass<? extends Pass<?>> getAndRemoveFirstPass() {
        KClass<? extends Pass<?>> kClass;
        List<PassWithDependencies> firstPasses = this.getFirstPasses();
        if (firstPasses.size() > 1) {
            String string = "More than one pass requires to be run as first pass: {}";
            Object[] objectArray = new Object[]{firstPasses};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            throw new ConfigurationException(string2);
        }
        if (!((Collection)firstPasses).isEmpty()) {
            PassWithDependencies firstPass = (PassWithDependencies)CollectionsKt.first(firstPasses);
            if (!((Collection)firstPass.getHardDependencies()).isEmpty()) {
                throw new ConfigurationException("The first pass has a hard dependency.");
            }
            this.removeDependencyByClass(firstPass.getPass());
            this.workingList.remove(firstPass);
            kClass = firstPass.getPass();
        } else {
            kClass = null;
        }
        return kClass;
    }
}

