/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.passes.ComponentPass;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.processing.IStrategy;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DependsOn(value=TypeResolver.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0004J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0004J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lde/fraunhofer/aisec/cpg/passes/TypeHierarchyResolver;", "Lde/fraunhofer/aisec/cpg/passes/ComponentPass;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "enums", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/EnumDeclaration;", "getEnums", "()Ljava/util/List;", "recordMap", "", "Lde/fraunhofer/aisec/cpg/graph/Name;", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getRecordMap", "()Ljava/util/Map;", "accept", "", "component", "Lde/fraunhofer/aisec/cpg/graph/Component;", "analyzeOverridingMethods", "declaration", "allMethodsFromSupertypes", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/MethodDeclaration;", "cleanup", "findRecordsAndEnums", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "findSupertypeRecords", "", "recordDeclaration", "getAllMethodsFromSupertypes", "supertypeRecords", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nTypeHierarchyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeHierarchyResolver.kt\nde/fraunhofer/aisec/cpg/passes/TypeHierarchyResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1603#2,9:132\n1855#2:141\n1856#2:143\n1612#2:144\n1549#2:145\n1620#2,3:146\n1549#2:149\n1620#2,3:150\n1603#2,9:153\n1855#2:162\n1856#2:164\n1612#2:165\n766#2:166\n857#2,2:167\n1855#2,2:169\n1#3:142\n1#3:163\n*S KotlinDebug\n*F\n+ 1 TypeHierarchyResolver.kt\nde/fraunhofer/aisec/cpg/passes/TypeHierarchyResolver\n*L\n75#1:132,9\n75#1:141\n75#1:143\n75#1:144\n77#1:145\n77#1:146,3\n101#1:149\n101#1:150,3\n109#1:153,9\n109#1:162\n109#1:164\n109#1:165\n121#1:166\n121#1:167,2\n123#1:169,2\n75#1:142\n109#1:163\n*E\n"})
public class TypeHierarchyResolver
extends ComponentPass {
    @NotNull
    private final Map<Name, RecordDeclaration> recordMap;
    @NotNull
    private final List<EnumDeclaration> enums;

    public TypeHierarchyResolver(@NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.recordMap = new LinkedHashMap();
        this.enums = new ArrayList();
    }

    @NotNull
    protected final Map<Name, RecordDeclaration> getRecordMap() {
        return this.recordMap;
    }

    @NotNull
    protected final List<EnumDeclaration> getEnums() {
        return this.enums;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (TranslationUnitDeclaration tu : component.getTranslationUnits()) {
            this.findRecordsAndEnums(tu);
        }
        for (RecordDeclaration recordDecl : this.recordMap.values()) {
            Set<RecordDeclaration> supertypeRecords = this.findSupertypeRecords(recordDecl);
            List<MethodDeclaration> allMethodsFromSupertypes = this.getAllMethodsFromSupertypes(supertypeRecords);
            this.analyzeOverridingMethods(recordDecl, allMethodsFromSupertypes);
        }
        for (EnumDeclaration enumDecl : this.enums) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = enumDecl.getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<RecordDeclaration> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RecordDeclaration it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Type it = (Type)element$iv$iv;
                boolean bl2 = false;
                ObjectType objectType = it instanceof ObjectType ? (ObjectType)it : null;
                if ((objectType != null ? objectType.getRecordDeclaration() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set directSupertypeRecords = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = directSupertypeRecords;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv = (RecordDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(this.findSupertypeRecords((RecordDeclaration)it));
            }
            Set allSupertypes = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv2)));
            enumDecl.setSuperTypeDeclarations(allSupertypes);
        }
    }

    protected final void findRecordsAndEnums(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Strategy strategy2 = Strategy.INSTANCE;
        node.accept(new IStrategy(strategy2){
            final /* synthetic */ Strategy $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final Iterator<Node> getIterator(@NotNull Node p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.AST_FORWARD(p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Strategy.class, "AST_FORWARD", "AST_FORWARD(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/util/Iterator;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof IStrategy ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }, new IVisitor<Node>(this){
            final /* synthetic */ TypeHierarchyResolver this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(@NotNull Node t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof EnumDeclaration) {
                    this.this$0.getEnums().add((EnumDeclaration)t);
                } else if (t instanceof RecordDeclaration) {
                    this.this$0.getRecordMap().putIfAbsent(t.getName(), (RecordDeclaration)t);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<MethodDeclaration> getAllMethodsFromSupertypes(@NotNull Set<? extends RecordDeclaration> supertypeRecords) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(supertypeRecords, (String)"supertypeRecords");
        Iterable $this$map$iv = supertypeRecords;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RecordDeclaration recordDeclaration = (RecordDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMethods());
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<RecordDeclaration> findSupertypeRecords(@NotNull RecordDeclaration recordDeclaration) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
        Iterable $this$mapNotNull$iv = recordDeclaration.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RecordDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Type it = (Type)element$iv$iv;
            boolean bl2 = false;
            ObjectType objectType = it instanceof ObjectType ? (ObjectType)it : null;
            if ((objectType != null ? objectType.getRecordDeclaration() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set superTypeDeclarations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        recordDeclaration.setSuperTypeDeclarations(superTypeDeclarations);
        return superTypeDeclarations;
    }

    /*
     * WARNING - void declaration
     */
    protected final void analyzeOverridingMethods(@NotNull RecordDeclaration declaration, @NotNull List<? extends MethodDeclaration> allMethodsFromSupertypes) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(allMethodsFromSupertypes, (String)"allMethodsFromSupertypes");
        for (MethodDeclaration methodDeclaration : allMethodsFromSupertypes) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = declaration.getMethods();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodDeclaration it = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                if (!methodDeclaration.isOverrideCandidate(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List overrideCandidates = (List)destination$iv$iv;
            methodDeclaration.addOverriddenBy(overrideCandidates);
            Iterable $this$forEach$iv = overrideCandidates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MethodDeclaration it = (MethodDeclaration)element$iv;
                boolean bl = false;
                it.addOverrides(methodDeclaration);
            }
        }
    }

    @Override
    public void cleanup() {
    }
}

