/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.TypeManager;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.ContextProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.RawNodeTypeProvider;
import de.fraunhofer.aisec.cpg.graph.ScopeProvider;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.PassConfiguration;
import de.fraunhofer.aisec.cpg.passes.order.RequiredFrontend;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 .*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\b\u0012\u0004\u0012\u00020\u00060\u00052\u00020\u0007:\u0001.B\u000f\b\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020%H&J\u0017\u0010&\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0001\u0010\u0001*\u00020'\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\u00020*2\u0014\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-0,R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0001\u0004/012\u00a8\u00063"}, d2={"Lde/fraunhofer/aisec/cpg/passes/Pass;", "T", "Lde/fraunhofer/aisec/cpg/graph/Node;", "Ljava/util/function/Consumer;", "Lde/fraunhofer/aisec/cpg/graph/ContextProvider;", "Lde/fraunhofer/aisec/cpg/graph/RawNodeTypeProvider;", "", "Lde/fraunhofer/aisec/cpg/graph/ScopeProvider;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "getCtx", "()Lde/fraunhofer/aisec/cpg/TranslationContext;", "<set-?>", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "scope", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "getScope", "()Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "getScopeManager", "()Lde/fraunhofer/aisec/cpg/ScopeManager;", "typeManager", "Lde/fraunhofer/aisec/cpg/TypeManager;", "getTypeManager", "()Lde/fraunhofer/aisec/cpg/TypeManager;", "cleanup", "", "passConfig", "Lde/fraunhofer/aisec/cpg/passes/PassConfiguration;", "()Lde/fraunhofer/aisec/cpg/passes/PassConfiguration;", "runsWithCurrentFrontend", "", "usedFrontends", "", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Companion", "Lde/fraunhofer/aisec/cpg/passes/ComponentPass;", "Lde/fraunhofer/aisec/cpg/passes/EOGStarterPass;", "Lde/fraunhofer/aisec/cpg/passes/TranslationResultPass;", "Lde/fraunhofer/aisec/cpg/passes/TranslationUnitPass;", "cpg-core"})
public abstract class Pass<T extends Node>
implements Consumer<T>,
ContextProvider,
RawNodeTypeProvider,
ScopeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationContext ctx;
    @NotNull
    private String name;
    @NotNull
    private final TranslationConfiguration config;
    @NotNull
    private final ScopeManager scopeManager;
    @NotNull
    private final TypeManager typeManager;
    @NotNull
    private static final Logger log;

    private Pass(TranslationContext ctx) {
        this.ctx = ctx;
        this.config = this.ctx.getConfig();
        this.scopeManager = this.ctx.getScopeManager();
        this.typeManager = this.ctx.getTypeManager();
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
    }

    @Override
    @NotNull
    public final TranslationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    protected final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final TranslationConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    @NotNull
    public final TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scopeManager.getCurrentScope();
    }

    public abstract void cleanup();

    public final boolean runsWithCurrentFrontend(@NotNull Collection<? extends LanguageFrontend<?, ?>> usedFrontends) {
        Intrinsics.checkNotNullParameter(usedFrontends, (String)"usedFrontends");
        if (!this.getClass().isAnnotationPresent(RequiredFrontend.class)) {
            return true;
        }
        Class<? extends LanguageFrontend<?, ?>> requiredFrontend = this.getClass().getAnnotation(RequiredFrontend.class).value();
        for (LanguageFrontend<?, ?> used : usedFrontends) {
            if (!Intrinsics.areEqual(used.getClass(), requiredFrontend)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final <T extends PassConfiguration> T passConfig() {
        PassConfiguration passConfiguration = this.config.getPassConfigurations().get(Reflection.getOrCreateKotlinClass(this.getClass()));
        return (T)(passConfiguration instanceof PassConfiguration ? passConfiguration : null);
    }

    public /* synthetic */ Pass(TranslationContext ctx, DefaultConstructorMarker $constructor_marker) {
        this(ctx);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Pass.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/passes/Pass$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

