/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.ComponentPass;
import de.fraunhofer.aisec.cpg.passes.ControlFlowSensitiveDFGPass;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.DynamicInvokeResolver;
import de.fraunhofer.aisec.cpg.passes.Edge;
import de.fraunhofer.aisec.cpg.passes.EdgeType;
import de.fraunhofer.aisec.cpg.passes.Edges;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.SymbolResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.processing.IStrategy;
import de.fraunhofer.aisec.cpg.processing.IVisitable;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.Iterator;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DependsOn.Container(value={@DependsOn(value=EvaluationOrderGraphPass.class), @DependsOn(value=SymbolResolver.class), @DependsOn(value=DFGPass.class), @DependsOn(value=DynamicInvokeResolver.class), @DependsOn(value=ControlFlowSensitiveDFGPass.class)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0004\u00a8\u0006\u000f"}, d2={"Lde/fraunhofer/aisec/cpg/passes/EdgeCachePass;", "Lde/fraunhofer/aisec/cpg/passes/ComponentPass;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "accept", "", "component", "Lde/fraunhofer/aisec/cpg/graph/Component;", "cleanup", "visitAST", "n", "Lde/fraunhofer/aisec/cpg/graph/Node;", "visitDFG", "visitEOG", "cpg-core"})
public final class EdgeCachePass
extends ComponentPass {
    public EdgeCachePass(@NotNull TranslationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
    }

    @Override
    public void accept(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Edges.INSTANCE.clear();
        for (TranslationUnitDeclaration tu : component.getTranslationUnits()) {
            Strategy strategy2 = Strategy.INSTANCE;
            tu.accept(new IStrategy(strategy2){
                final /* synthetic */ Strategy $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                @NotNull
                public final Iterator<Node> getIterator(@NotNull Node p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return this.$tmp0.AST_FORWARD(p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, Strategy.class, "AST_FORWARD", "AST_FORWARD(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/util/Iterator;", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof IStrategy ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            }, new IVisitor<Node>(this){
                final /* synthetic */ EdgeCachePass this$0;
                {
                    this.this$0 = $receiver;
                }

                public void visit(@NotNull Node t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    this.this$0.visitAST(t);
                    this.this$0.visitDFG(t);
                    this.this$0.visitEOG(t);
                    super.visit((IVisitable)t);
                }
            });
        }
    }

    protected final void visitAST(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        for (Node node : SubgraphWalker.getAstChildren(n)) {
            Edge edge = new Edge(n, node, EdgeType.AST);
            Edges.INSTANCE.add(edge);
        }
    }

    protected final void visitDFG(@NotNull Node n) {
        Edge edge;
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        for (Node dfg : n.getPrevDFG()) {
            edge = new Edge(dfg, n, EdgeType.DFG);
            Edges.INSTANCE.add(edge);
        }
        for (Node dfg : n.getNextDFG()) {
            edge = new Edge(n, dfg, EdgeType.DFG);
            Edges.INSTANCE.add(edge);
        }
    }

    protected final void visitEOG(@NotNull Node n) {
        Edge edge;
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        for (Node eog : n.getPrevEOG()) {
            edge = new Edge(eog, n, EdgeType.EOG);
            Edges.INSTANCE.add(edge);
        }
        for (Node eog : n.getNextEOG()) {
            edge = new Edge(n, eog, EdgeType.EOG);
            Edges.INSTANCE.add(edge);
        }
    }

    @Override
    public void cleanup() {
    }
}

