/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers.neo4j;

import de.fraunhofer.aisec.cpg.helpers.neo4j.CpgCompositeConverter;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00132\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u0003\u0018\u00010\fH\u0016J\u001c\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012R&\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/neo4j/LocationConverter;", "Lde/fraunhofer/aisec/cpg/helpers/neo4j/CpgCompositeConverter;", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "()V", "graphSchema", "", "Lkotlin/Pair;", "", "getGraphSchema", "()Ljava/util/List;", "toEntityAttribute", "value", "", "toGraphProperties", "toInt", "", "objectToMap", "", "(Ljava/lang/Object;)Ljava/lang/Integer;", "Companion", "cpg-core"})
public final class LocationConverter
implements CpgCompositeConverter<PhysicalLocation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String START_LINE = "startLine";
    @NotNull
    public static final String END_LINE = "endLine";
    @NotNull
    public static final String START_COLUMN = "startColumn";
    @NotNull
    public static final String END_COLUMN = "endColumn";
    @NotNull
    public static final String ARTIFACT = "artifact";

    @NotNull
    public Map<String, ?> toGraphProperties(@Nullable PhysicalLocation value) {
        Map properties = new HashMap();
        if (value != null) {
            Map map = properties;
            String string = ARTIFACT;
            String string2 = value.getArtifactLocation().getUri().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2;
            map.put(string, string3);
            properties.put(START_LINE, value.getRegion().startLine);
            properties.put(END_LINE, value.getRegion().getEndLine());
            properties.put(START_COLUMN, value.getRegion().startColumn);
            properties.put(END_COLUMN, value.getRegion().getEndColumn());
        }
        return properties;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getGraphSchema() {
        Object[] objectArray = new Pair[]{new Pair((Object)"String", (Object)ARTIFACT), new Pair((Object)"int", (Object)START_LINE), new Pair((Object)"int", (Object)END_LINE), new Pair((Object)"int", (Object)START_COLUMN), new Pair((Object)"int", (Object)END_COLUMN)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public PhysicalLocation toEntityAttribute(@Nullable Map<String, ?> value) {
        PhysicalLocation physicalLocation;
        try {
            Map<String, ?> map = value;
            Integer n = this.toInt(map != null ? map.get(START_LINE) : null);
            if (n == null) {
                return null;
            }
            int startLine = n;
            Map<String, ?> map2 = value;
            Integer n2 = this.toInt(map2 != null ? map2.get(END_LINE) : null);
            if (n2 == null) {
                return null;
            }
            int endLine = n2;
            Map<String, ?> map3 = value;
            Integer n3 = this.toInt(map3 != null ? map3.get(START_COLUMN) : null);
            if (n3 == null) {
                return null;
            }
            int startColumn = n3;
            Map<String, ?> map4 = value;
            Integer n4 = this.toInt(map4 != null ? map4.get(END_COLUMN) : null);
            if (n4 == null) {
                return null;
            }
            int endColumn = n4;
            Map<String, ?> map5 = value;
            Object obj = map5 != null ? map5.get(ARTIFACT) : null;
            String string = obj instanceof String ? (String)obj : null;
            if (string == null) {
                string = "";
            }
            URI uri = URI.create(string);
            Intrinsics.checkNotNull((Object)uri);
            physicalLocation = new PhysicalLocation(uri, new Region(startLine, startColumn, endLine, endColumn));
        }
        catch (NullPointerException e) {
            physicalLocation = null;
        }
        return physicalLocation;
    }

    private final Integer toInt(Object objectToMap) {
        Object object = objectToMap;
        if (object == null || (object = object.toString()) == null) {
            return null;
        }
        long value = Long.parseLong((String)object);
        return Math.toIntExact(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/neo4j/LocationConverter$Companion;", "", "()V", "ARTIFACT", "", "END_COLUMN", "END_LINE", "START_COLUMN", "START_LINE", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

