/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.helpers.IdentitySet;
import de.fraunhofer.aisec.cpg.helpers.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u0004\b\u0002\u0010\u00042\u00020\u0002B)\b\u0016\u0012 \b\u0002\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0013J\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0007J\u001e\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00070\u0011J'\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00028\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\u0010\u001dJ'\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00028\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00070\u00062\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00070\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u000f\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00070\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/Worklist;", "K", "", "N", "V", "globalState", "Ljava/util/IdentityHashMap;", "Lde/fraunhofer/aisec/cpg/helpers/State;", "(Ljava/util/IdentityHashMap;)V", "()V", "alreadySeen", "Lde/fraunhofer/aisec/cpg/helpers/IdentitySet;", "<set-?>", "getGlobalState", "()Ljava/util/IdentityHashMap;", "nodeOrder", "", "Lkotlin/Pair;", "hasAlreadySeen", "", "currentNode", "(Ljava/lang/Object;)Z", "isEmpty", "isNotEmpty", "mop", "pop", "push", "newNode", "state", "(Ljava/lang/Object;Lde/fraunhofer/aisec/cpg/helpers/State;)Z", "update", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nEOGWorklist.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EOGWorklist.kt\nde/fraunhofer/aisec/cpg/helpers/Worklist\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public final class Worklist<K, N, V> {
    @NotNull
    private IdentityHashMap<K, State<N, V>> globalState;
    @NotNull
    private final IdentitySet<K> alreadySeen;
    @NotNull
    private final List<Pair<K, State<N, V>>> nodeOrder;

    public Worklist() {
        this.globalState = new IdentityHashMap();
        this.alreadySeen = new IdentitySet();
        this.nodeOrder = new ArrayList();
    }

    @NotNull
    public final IdentityHashMap<K, State<N, V>> getGlobalState() {
        return this.globalState;
    }

    public Worklist(@NotNull IdentityHashMap<K, State<N, V>> globalState) {
        Intrinsics.checkNotNullParameter(globalState, (String)"globalState");
        this();
        this.globalState = globalState;
    }

    public /* synthetic */ Worklist(IdentityHashMap identityHashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            identityHashMap = new IdentityHashMap();
        }
        this(identityHashMap);
    }

    public final boolean update(@NotNull K newNode, @NotNull State<N, V> state) {
        Intrinsics.checkNotNullParameter(newNode, (String)"newNode");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Pair pair = this.globalState.get(newNode);
        if (pair == null || (pair = pair.lub(state)) == null) {
            pair = new Pair(state, (Object)true);
        }
        Pair pair2 = pair;
        State newGlobalState = (State)pair2.component1();
        boolean update = (Boolean)pair2.component2();
        if (update) {
            ((Map)this.globalState).put(newNode, newGlobalState);
        }
        return update;
    }

    public final boolean push(@NotNull K newNode, @NotNull State<N, V> state) {
        Pair newEntry;
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter(newNode, (String)"newNode");
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Iterable iterable = this.nodeOrder;
            for (Object t : iterable) {
                Pair it = (Pair)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), newNode)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        Pair currentEntry = v0;
        boolean update = false;
        if (currentEntry != null) {
            Iterator iterator = ((State)currentEntry.getSecond()).lub(state);
            State newState = (State)iterator.component1();
            boolean update2 = (Boolean)iterator.component2();
            update = update2;
            if (update) {
                this.nodeOrder.remove(currentEntry);
            }
            v1 = new Pair(currentEntry.getFirst(), (Object)newState);
        } else {
            update = true;
            v1 = newEntry = new Pair(newNode, state);
        }
        if (update) {
            this.nodeOrder.add(newEntry);
        }
        return update;
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.nodeOrder).isEmpty();
    }

    public final boolean isEmpty() {
        return this.nodeOrder.isEmpty();
    }

    @NotNull
    public final Pair<K, State<N, V>> pop() {
        Pair node = (Pair)CollectionsKt.removeFirst(this.nodeOrder);
        this.alreadySeen.add((K)node.getFirst());
        return node;
    }

    public final boolean hasAlreadySeen(@NotNull K currentNode) {
        Intrinsics.checkNotNullParameter(currentNode, (String)"currentNode");
        return this.alreadySeen.contains(currentNode);
    }

    @Nullable
    public final State<N, V> mop() {
        Set<K> set = this.globalState.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Object firstKey = CollectionsKt.firstOrNull((Iterable)set);
        State<N, V> state = this.globalState.get(firstKey);
        Iterator iterator = ((Map)this.globalState).entrySet().iterator();
        while (iterator.hasNext()) {
            State v = (State)iterator.next().getValue();
            State<N, V> state2 = state;
            if (state2 == null) continue;
            Intrinsics.checkNotNull((Object)v);
            state2.lub(v);
        }
        return state;
    }
}

