/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.helpers.IdentitySet;
import de.fraunhofer.aisec.cpg.helpers.TriConsumer;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "fieldCache", "Ljava/util/HashMap;", "", "", "Ljava/lang/reflect/Field;", "flattenAST", "Lde/fraunhofer/aisec/cpg/graph/Node;", "n", "flattenASTInternal", "", "identitySet", "", "getAllFields", "", "classType", "Ljava/lang/Class;", "getAstChildren", "node", "getEOGPathEdges", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$Border;", "Border", "IterativeGraphWalker", "ScopedWalker", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nSubgraphWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n800#2,11:463\n800#2,11:474\n766#2:485\n857#2,2:486\n766#2:488\n857#2:489\n1747#2,3:490\n858#2:493\n766#2:494\n857#2:495\n1747#2,3:496\n858#2:499\n*S KotlinDebug\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker\n*L\n165#1:463,11\n172#1:474,11\n231#1:485\n231#1:486,2\n237#1:488\n237#1:489\n237#1:490,3\n237#1:493\n241#1:494\n241#1:495\n241#1:496,3\n241#1:499\n*E\n"})
public final class SubgraphWalker {
    @NotNull
    public static final SubgraphWalker INSTANCE = new SubgraphWalker();
    private static final Logger LOGGER = LoggerFactory.getLogger(SubgraphWalker.class);
    @NotNull
    private static final HashMap<String, List<Field>> fieldCache = new HashMap();

    private SubgraphWalker() {
    }

    private final Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            String cacheKey = classType.getName();
            if (fieldCache.containsKey(cacheKey)) {
                List<Field> list2 = fieldCache.get(cacheKey);
                return list2 == null ? (Collection)new ArrayList() : (Collection)list2;
            }
            ArrayList<Field> fields2 = new ArrayList<Field>();
            Class<?> clazz = classType.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            fields2.addAll(this.getAllFields(clazz));
            Field[] fieldArray = classType.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Field[] fieldArray2 = fieldArray;
            fields2.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(fieldArray2, fieldArray2.length)));
            Map map = fieldCache;
            Intrinsics.checkNotNull((Object)cacheKey);
            map.put(cacheKey, fields2);
            return fields2;
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Node> getAstChildren(@Nullable Node node) {
        ArrayList children2 = new ArrayList();
        if (node == null) {
            return children2;
        }
        Class<?> classType = node.getClass();
        for (Field field : INSTANCE.getAllFields(classType)) {
            if (field.getAnnotation(AST.class) == null) continue;
            try {
                Collection destination$iv$iv;
                Object object;
                List $i$a$-synchronized-SubgraphWalker$getAstChildren$obj$22;
                List obj;
                Object object2 = field;
                synchronized (object2) {
                    boolean $i$a$-synchronized-SubgraphWalker$getAstChildren$obj$22 = false;
                    field.trySetAccessible();
                    obj = field.get(node);
                    field.setAccessible(false);
                    $i$a$-synchronized-SubgraphWalker$getAstChildren$obj$22 = obj;
                }
                List list2 = $i$a$-synchronized-SubgraphWalker$getAstChildren$obj$22;
                if (list2 == null) continue;
                List obj2 = list2;
                boolean outgoing = true;
                if (field.getAnnotation(Relationship.class) != null) {
                    boolean bl = outgoing = field.getAnnotation(Relationship.class).direction() == Relationship.Direction.OUTGOING;
                }
                if (PropertyEdge.Companion.checkForPropertyEdge(field, (Object)obj2) && obj2 instanceof Collection) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    object2 = obj2;
                    object = PropertyEdge.Companion;
                    boolean $i$f$filterIsInstance = false;
                    obj = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PropertyEdge)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    obj2 = ((PropertyEdge.Companion)object).unwrap((List)destination$iv$iv, outgoing);
                }
                if ((object2 = obj2) instanceof Node) {
                    children2.add(obj2);
                    continue;
                }
                if (object2 instanceof Collection) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    Iterable $i$f$filterIsInstance = obj2;
                    object = children2;
                    boolean $i$f$filterIsInstance2 = false;
                    destination$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Node)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    ((ArrayList)object).addAll((List)destination$iv$iv2);
                    continue;
                }
                throw new AnnotationFormatError("Found @field:SubGraph(\"AST\") on field of type " + obj2.getClass() + " but can only used with node graph classes or collections of graph nodes");
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Error while retrieving AST children: {}", (Object)ex.getMessage());
            }
        }
        return children2;
    }

    @NotNull
    public final List<Node> flattenAST(@Nullable Node n) {
        if (n == null) {
            return new ArrayList();
        }
        IdentitySet identitySet = new IdentitySet();
        this.flattenASTInternal(identitySet, n);
        return identitySet.toSortedList();
    }

    private final void flattenASTInternal(Set<Node> identitySet, Node n) {
        if (!identitySet.add(n)) {
            return;
        }
        for (Node child : SubgraphWalker.getAstChildren(n)) {
            this.flattenASTInternal(identitySet, child);
        }
    }

    @NotNull
    public final Border getEOGPathEdges(@Nullable Node n) {
        boolean $i$f$any;
        Iterable $this$any$iv;
        Node node;
        Iterable $this$filterTo$iv$iv;
        Border border = new Border();
        List<Node> flattedASTTree = this.flattenAST(n);
        Iterable $this$filter$iv = flattedASTTree;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            node = (Node)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)node.getPrevEOG()).isEmpty() || !((Collection)node.getNextEOG()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List eogNodes = (List)destination$iv$iv;
        $this$filter$iv = eogNodes;
        Border border2 = border;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                node = (Node)element$iv$iv;
                boolean bl3 = false;
                $this$any$iv = node.getPrevEOG();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Node prev = (Node)element$iv;
                        boolean bl4 = false;
                        if (!(!eogNodes.contains(prev))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        border2.setEntries(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        $this$filter$iv = eogNodes;
        border2 = border;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block10: {
                node = (Node)element$iv$iv;
                boolean bl5 = false;
                $this$any$iv = node.getNextEOG();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Node next = (Node)element$iv;
                        boolean bl6 = false;
                        if (!(!eogNodes.contains(next))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        border2.setExits(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        return border;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$Border;", "", "()V", "entries", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getEntries", "()Ljava/util/List;", "setEntries", "(Ljava/util/List;)V", "exits", "getExits", "setExits", "cpg-core"})
    public static final class Border {
        @NotNull
        private List<Node> entries = new ArrayList();
        @NotNull
        private List<Node> exits = new ArrayList();

        @NotNull
        public final List<Node> getEntries() {
            return this.entries;
        }

        public final void setEntries(@NotNull List<Node> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.entries = list2;
        }

        @NotNull
        public final List<Node> getExits() {
            return this.exits;
        }

        public final void setExits(@NotNull List<Node> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.exits = list2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0005J\u0014\u0010\u001f\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0014\u0010!\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u001c\u0010\"\u001a\u00020\u001b2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000eJ\u0016\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005R.\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0019\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker;", "", "()V", "<set-?>", "Ljava/util/Deque;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "backlog", "getBacklog", "()Ljava/util/Deque;", "onNodeExit", "", "Ljava/util/function/Consumer;", "onNodeVisit", "onNodeVisit2", "Ljava/util/function/BiConsumer;", "replacements", "", "strategy", "Lkotlin/Function1;", "", "getStrategy", "()Lkotlin/jvm/functions/Function1;", "setStrategy", "(Lkotlin/jvm/functions/Function1;)V", "todo", "Lkotlin/Pair;", "clearCallbacks", "", "getTodo", "iterate", "root", "registerOnNodeExit", "callback", "registerOnNodeVisit", "registerOnNodeVisit2", "registerReplacement", "from", "to", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nSubgraphWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n1855#2,2:463\n1549#2:465\n1620#2,3:466\n*S KotlinDebug\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker\n*L\n335#1:463,2\n370#1:465\n370#1:466,3\n*E\n"})
    public static final class IterativeGraphWalker {
        @Nullable
        private Deque<Pair<Node, Node>> todo;
        @Nullable
        private Deque<Node> backlog;
        @NotNull
        private Function1<? super Node, ? extends Iterator<? extends Node>> strategy = (Function1)new Function1<Node, Iterator<? extends Node>>((Object)Strategy.INSTANCE){

            @NotNull
            public final Iterator<Node> invoke(@NotNull Node p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Strategy)this.receiver).AST_FORWARD(p0);
            }
        };
        @NotNull
        private final List<Consumer<Node>> onNodeVisit = new ArrayList();
        @NotNull
        private final List<BiConsumer<Node, Node>> onNodeVisit2 = new ArrayList();
        @NotNull
        private final Map<Node, Node> replacements = new LinkedHashMap();
        @NotNull
        private final List<Consumer<Node>> onNodeExit = new ArrayList();

        @Nullable
        public final Deque<Node> getBacklog() {
            return this.backlog;
        }

        @NotNull
        public final Function1<Node, Iterator<Node>> getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(@NotNull Function1<? super Node, ? extends Iterator<? extends Node>> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.strategy = function1;
        }

        public final void iterate(@NotNull Node root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.todo = new ArrayDeque();
            this.backlog = new ArrayDeque();
            Set seen = new LinkedHashSet();
            Deque<Pair<Node, Node>> deque = this.todo;
            if (deque != null) {
                deque.push((Pair<Node, Node>)new Pair((Object)root, null));
            }
            while (true) {
                Deque<Pair<Node, Node>> deque2 = this.todo;
                Intrinsics.checkNotNull(deque2, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                if (!(!((Collection)((ArrayDeque)deque2)).isEmpty())) break;
                Deque<Pair<Node, Node>> deque3 = this.todo;
                Intrinsics.checkNotNull(deque3, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                Pair pair = (Pair)((ArrayDeque)deque3).pop();
                Ref.ObjectRef current = new Ref.ObjectRef();
                current.element = pair.component1();
                Ref.ObjectRef parent = new Ref.ObjectRef();
                parent.element = pair.component2();
                Deque<Node> deque4 = this.backlog;
                Intrinsics.checkNotNull(deque4, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                if (!((Collection)((ArrayDeque)deque4)).isEmpty()) {
                    Deque<Node> deque5 = this.backlog;
                    Intrinsics.checkNotNull(deque5, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                    if (Intrinsics.areEqual(((ArrayDeque)deque5).peek(), (Object)current.element)) {
                        Deque<Node> deque6 = this.backlog;
                        Intrinsics.checkNotNull(deque6, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                        Node exiting = (Node)((ArrayDeque)deque6).pop();
                        this.onNodeExit.forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$0(exiting, arg_0));
                        continue;
                    }
                }
                this.onNodeVisit.forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$1(current, arg_0));
                this.onNodeVisit2.forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$2(current, parent, arg_0));
                Node toReplace = this.replacements.get(current.element);
                if (toReplace != null) {
                    current.element = toReplace;
                    this.replacements.remove(toReplace);
                }
                List unseenChildren2 = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)((Iterator)this.strategy.invoke(current.element))), (Function1)((Function1)new Function1<Node, Boolean>((Set<Node>)seen){
                    final /* synthetic */ Set<Node> $seen;
                    {
                        this.$seen = $seen;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Node it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !this.$seen.contains(it);
                    }
                })));
                Deque<Pair<Node, Node>> deque7 = this.todo;
                Intrinsics.checkNotNull(deque7, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                ((ArrayDeque)deque7).push(new Pair(current.element, parent.element));
                seen.addAll(unseenChildren2);
                Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)unseenChildren2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Node child = (Node)element$iv;
                    boolean bl = false;
                    Deque<Pair<Node, Node>> deque8 = this.todo;
                    Intrinsics.checkNotNull(deque8, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                    ((ArrayDeque)deque8).push(new Pair((Object)child, current.element));
                }
                Deque<Node> deque9 = this.backlog;
                Intrinsics.checkNotNull(deque9, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                ((ArrayDeque)deque9).push(current.element);
            }
        }

        public final void registerReplacement(@NotNull Node from2, @NotNull Node to2) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to2, (String)"to");
            this.replacements.put(from2, to2);
        }

        public final void registerOnNodeVisit(@NotNull Consumer<Node> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onNodeVisit.add(callback);
        }

        public final void registerOnNodeVisit2(@NotNull BiConsumer<Node, Node> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onNodeVisit2.add(callback);
        }

        public final void registerOnNodeExit(@NotNull Consumer<Node> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onNodeExit.add(callback);
        }

        public final void clearCallbacks() {
            this.onNodeVisit.clear();
            this.onNodeExit.clear();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Deque<Node> getTodo() {
            List list2;
            Deque<Pair<Node, Node>> deque = this.todo;
            if (deque != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = deque;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Node)it.getFirst());
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            Collection collection = list2;
            return new ArrayDeque(collection);
        }

        private static final void iterate$lambda$0(Node $exiting, Consumer c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.accept($exiting);
        }

        private static final void iterate$lambda$1(Ref.ObjectRef $current, Consumer c) {
            Intrinsics.checkNotNullParameter((Object)$current, (String)"$current");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.accept($current.element);
        }

        private static final void iterate$lambda$2(Ref.ObjectRef $current, Ref.ObjectRef $parent, BiConsumer c) {
            Intrinsics.checkNotNullParameter((Object)$current, (String)"$current");
            Intrinsics.checkNotNullParameter((Object)$parent, (String)"$parent");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.accept($current.element, $parent.element);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\t2\u001e\u0010\u001a\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eH\u0002J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\tJ&\u0010\u001d\u001a\u00020\u00172\u001e\u0010\u001a\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eJ\u001e\u0010\u001d\u001a\u00020\u00172\u0016\u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001eJ\u0016\u0010\u001d\u001a\u00020\u00172\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001fJ\u0016\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tR,\u0010\f\u001a \u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "", "lang", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "(Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;)V", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "strategy", "Lkotlin/Function1;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "", "(Lde/fraunhofer/aisec/cpg/ScopeManager;Lkotlin/jvm/functions/Function1;)V", "handlers", "", "Lde/fraunhofer/aisec/cpg/helpers/TriConsumer;", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getStrategy", "()Lkotlin/jvm/functions/Function1;", "setStrategy", "(Lkotlin/jvm/functions/Function1;)V", "walker", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker;", "clearCallbacks", "", "handleNode", "current", "handler", "iterate", "root", "registerHandler", "Ljava/util/function/BiConsumer;", "Ljava/util/function/Consumer;", "registerReplacement", "from", "to", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nSubgraphWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n1855#2,2:463\n*S KotlinDebug\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker\n*L\n440#1:463,2\n*E\n"})
    public static final class ScopedWalker {
        public Function1<? super Node, ? extends Iterator<? extends Node>> strategy;
        @Nullable
        private IterativeGraphWalker walker;
        @NotNull
        private final ScopeManager scopeManager;
        @NotNull
        private final List<TriConsumer<RecordDeclaration, Node, Node>> handlers;

        @NotNull
        public final Function1<Node, Iterator<Node>> getStrategy() {
            Function1<? super Node, ? extends Iterator<? extends Node>> function1 = this.strategy;
            if (function1 != null) {
                return function1;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"strategy");
            return null;
        }

        public final void setStrategy(@NotNull Function1<? super Node, ? extends Iterator<? extends Node>> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.strategy = function1;
        }

        public ScopedWalker(@NotNull LanguageFrontend<?, ?> lang) {
            Intrinsics.checkNotNullParameter(lang, (String)"lang");
            this.handlers = new ArrayList();
            this.scopeManager = lang.getScopeManager();
        }

        public ScopedWalker(@NotNull ScopeManager scopeManager, @NotNull Function1<? super Node, ? extends Iterator<? extends Node>> strategy2) {
            Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
            Intrinsics.checkNotNullParameter(strategy2, (String)"strategy");
            this.handlers = new ArrayList();
            this.scopeManager = scopeManager;
            this.setStrategy(strategy2);
        }

        public /* synthetic */ ScopedWalker(ScopeManager scopeManager, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<Node, Iterator<? extends Node>>((Object)Strategy.INSTANCE){

                    @NotNull
                    public final Iterator<Node> invoke(@NotNull Node p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((Strategy)this.receiver).AST_FORWARD(p0);
                    }
                };
            }
            this(scopeManager, (Function1<? super Node, ? extends Iterator<? extends Node>>)function1);
        }

        public final void clearCallbacks() {
            this.handlers.clear();
        }

        public final void registerHandler(@NotNull TriConsumer<RecordDeclaration, Node, Node> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.handlers.add(handler);
        }

        public final void registerHandler(@NotNull BiConsumer<Node, RecordDeclaration> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.handlers.add((arg_0, arg_1, arg_2) -> ScopedWalker.registerHandler$lambda$0(handler, arg_0, arg_1, arg_2));
        }

        public final void registerHandler(@NotNull Consumer<Node> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.handlers.add((arg_0, arg_1, arg_2) -> ScopedWalker.registerHandler$lambda$1(handler, arg_0, arg_1, arg_2));
        }

        public final void registerReplacement(@NotNull Node from2, @NotNull Node to2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to2, (String)"to");
                IterativeGraphWalker iterativeGraphWalker = this.walker;
                if (iterativeGraphWalker == null) break block0;
                iterativeGraphWalker.registerReplacement(from2, to2);
            }
        }

        public final void iterate(@NotNull Node root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            IterativeGraphWalker walker = new IterativeGraphWalker();
            walker.setStrategy(this.getStrategy());
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TriConsumer h = (TriConsumer)element$iv;
                boolean bl = false;
                walker.registerOnNodeVisit(arg_0 -> ScopedWalker.iterate$lambda$3$lambda$2(this, h, arg_0));
            }
            this.walker = walker;
            walker.iterate(root);
        }

        private final void handleNode(Node current, TriConsumer<RecordDeclaration, Node, Node> handler) {
            Object object;
            if (!Intrinsics.areEqual((Object)this.scopeManager.getCurrentScope(), (Object)current.getScope())) {
                this.scopeManager.jumpTo$cpg_core(current.getScope());
            }
            Node parent = (object = this.walker) != null && (object = ((IterativeGraphWalker)object).getBacklog()) != null ? (Node)object.peek() : null;
            handler.accept(this.scopeManager.getCurrentRecord(), parent, current);
        }

        private static final void registerHandler$lambda$0(BiConsumer $handler, RecordDeclaration currClass, Node node, Node currNode) {
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            $handler.accept(currNode, currClass);
        }

        private static final void registerHandler$lambda$1(Consumer $handler, RecordDeclaration recordDeclaration, Node node, Node currNode) {
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            $handler.accept(currNode);
        }

        private static final void iterate$lambda$3$lambda$2(ScopedWalker this$0, TriConsumer $h, Node n) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$h, (String)"$h");
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            this$0.handleNode(n, $h);
        }
    }
}

