/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.helpers.LatticeElement;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022*\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0003j\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0004`\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J4\u0010\b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\u001c\u0010\f\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J%\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00028\u00002\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/State;", "K", "V", "Ljava/util/HashMap;", "Lde/fraunhofer/aisec/cpg/helpers/LatticeElement;", "Lkotlin/collections/HashMap;", "()V", "duplicate", "lub", "Lkotlin/Pair;", "", "other", "needsUpdate", "push", "newNode", "newLatticeElement", "(Ljava/lang/Object;Lde/fraunhofer/aisec/cpg/helpers/LatticeElement;)Z", "cpg-core"})
public class State<K, V>
extends HashMap<K, LatticeElement<V>> {
    @NotNull
    public Pair<State<K, V>, Boolean> lub(@NotNull State<K, V> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean update = false;
        for (Map.Entry entry : ((Map)other).entrySet()) {
            LatticeElement newLattice;
            Object node = entry.getKey();
            update = this.push(node, newLattice = (LatticeElement)entry.getValue()) || update;
        }
        return new Pair((Object)this, (Object)update);
    }

    public boolean needsUpdate(@NotNull State<K, V> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean update = false;
        for (Map.Entry entry : ((Map)other).entrySet()) {
            Object node = entry.getKey();
            LatticeElement newLattice = (LatticeElement)entry.getValue();
            LatticeElement current = (LatticeElement)this.get(node);
            update = update || current == null || newLattice.compareTo(current) > 0;
        }
        return update;
    }

    @NotNull
    public State<K, V> duplicate() {
        State<K, V> clone = new State<K, V>();
        for (Map.Entry entry : ((Map)this).entrySet()) {
            Object key = entry.getKey();
            LatticeElement value = (LatticeElement)entry.getValue();
            ((Map)clone).put(key, value.duplicate());
        }
        return clone;
    }

    public boolean push(K newNode, @Nullable LatticeElement<V> newLatticeElement) {
        if (newLatticeElement == null) {
            return false;
        }
        LatticeElement current = (LatticeElement)this.get(newNode);
        if (current != null && current.compareTo(newLatticeElement) >= 0) {
            return false;
        }
        if (current != null) {
            ((Map)this).put(newNode, newLatticeElement.lub(current));
        } else {
            ((Map)this).put(newNode, newLatticeElement);
        }
        return true;
    }
}

