/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001a\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\t"}, d2={"getCodeOfSubregion", "", "code", "nodeRegion", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "subRegion", "getNewLineType", "multilineCode", "region", "cpg-core"})
public final class RegionUtilsKt {
    @NotNull
    public static final String getNewLineType(@NotNull String multilineCode, @Nullable Region region) {
        Intrinsics.checkNotNullParameter((Object)multilineCode, (String)"multilineCode");
        String code = null;
        code = multilineCode;
        Region region2 = region;
        if (region2 != null) {
            Region it = region2;
            boolean bl = false;
            if (it.startLine != it.getEndLine()) {
                String string = code.substring(0, code.length() - it.getEndColumn() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                code = string;
            }
        }
        String[] stringArray = new String[]{"\n\r", "\r\n", "\n"};
        List nls = CollectionsKt.listOf((Object[])stringArray);
        for (String nl : nls) {
            if (!StringsKt.endsWith$default((String)code, (String)nl, (boolean)false, (int)2, null)) continue;
            return nl;
        }
        LanguageFrontend.Companion.getLog().debug("Could not determine newline type. Assuming \\n.");
        return "\n";
    }

    public static /* synthetic */ String getNewLineType$default(String string, Region region, int n, Object object) {
        if ((n & 2) != 0) {
            region = null;
        }
        return RegionUtilsKt.getNewLineType(string, region);
    }

    @NotNull
    public static final String getCodeOfSubregion(@NotNull String code, @NotNull Region nodeRegion, @NotNull Region subRegion) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)nodeRegion, (String)"nodeRegion");
        Intrinsics.checkNotNullParameter((Object)subRegion, (String)"subRegion");
        String nlType = RegionUtilsKt.getNewLineType(code, nodeRegion);
        int start = subRegion.startLine == nodeRegion.startLine ? subRegion.startColumn - nodeRegion.startColumn : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.startLine - nodeRegion.startLine)) + subRegion.startColumn;
        int end = subRegion.getEndLine() == nodeRegion.startLine ? subRegion.getEndColumn() - nodeRegion.startColumn : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getEndLine() - nodeRegion.startLine)) + subRegion.getEndColumn();
        String string = code.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }
}

