/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/CommonPath;", "", "()V", "commonPath", "Ljava/io/File;", "paths", "", "getNearestDirectory", "file", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nCommonPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonPath.kt\nde/fraunhofer/aisec/cpg/helpers/CommonPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,70:1\n1549#2:71\n1620#2,2:72\n731#2,9:74\n1622#2:85\n1045#2:86\n1726#2,3:87\n37#3,2:83\n*S KotlinDebug\n*F\n+ 1 CommonPath.kt\nde/fraunhofer/aisec/cpg/helpers/CommonPath\n*L\n40#1:71\n40#1:72,2\n43#1:74,9\n40#1:85\n46#1:86\n50#1:87,3\n44#1:83,2\n*E\n"})
public final class CommonPath {
    @NotNull
    public static final CommonPath INSTANCE = new CommonPath();

    private CommonPath() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File commonPath(@NotNull Collection<? extends File> paths) {
        File result;
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.isEmpty()) {
            return null;
        }
        StringBuilder longestPrefix = new StringBuilder();
        Iterable iterable = paths;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$toTypedArray$iv;
            List list2;
            Collection $this$dropLastWhile$iv;
            void file;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            Object object = string;
            String string2 = Pattern.quote(File.separator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quote(...)");
            String string3 = string2;
            string3 = new Regex(string3);
            int n = 0;
            object = string3.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            collection.add(thisCollection$iv.toArray(new String[0]));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List splitPaths = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String[] it = (String[])a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.length);
                it = (String[])b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.length));
            }
        });
        String[] shortest = (String[])splitPaths.get(0);
        int n = shortest.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String part;
            block9: {
                part = shortest[i];
                Iterable $this$all$iv = splitPaths;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String[] it = (String[])element$iv;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it[i], (Object)part)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (!bl) break;
            longestPrefix.append(part).append(File.separator);
        }
        return (result = new File(longestPrefix.toString())).exists() ? this.getNearestDirectory(result) : null;
    }

    private final File getNearestDirectory(File file) {
        File file2;
        if (file.isDirectory()) {
            file2 = file;
        } else {
            File file3 = file.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
            file2 = this.getNearestDirectory(file3);
        }
        return file2;
    }
}

