/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolderKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fR\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/BenchmarkResults;", "", "entries", "", "(Ljava/util/List;)V", "getEntries", "()Ljava/util/List;", "json", "", "getJson", "()Ljava/lang/String;", "print", "", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nMeasurementHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasurementHolder.kt\nde/fraunhofer/aisec/cpg/helpers/BenchmarkResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1179#2,2:240\n1253#2,4:242\n*S KotlinDebug\n*F\n+ 1 MeasurementHolder.kt\nde/fraunhofer/aisec/cpg/helpers/BenchmarkResults\n*L\n46#1:240,2\n46#1:242,4\n*E\n"})
public final class BenchmarkResults {
    @NotNull
    private final List<List<Object>> entries;

    public BenchmarkResults(@NotNull List<? extends List<? extends Object>> entries2) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.entries = entries2;
    }

    @NotNull
    public final List<List<Object>> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getJson() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
        mapper.configure(SerializationFeature.FAIL_ON_SELF_REFERENCES, false);
        Iterable iterable = this.entries;
        ObjectMapper objectMapper = mapper;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.get(0), it.get(1));
            map.put(pair.getFirst(), pair.getSecond());
        }
        String string = objectMapper.writeValueAsString((Object)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    public final void print() {
        System.out.println((Object)("# Benchmark run " + UUID.randomUUID()));
        Object[] objectArray = new String[]{"Metric", "Value"};
        MeasurementHolderKt.printMarkdown(this.entries, CollectionsKt.listOf((Object[])objectArray));
    }
}

