/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B1\b\u0007\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/Benchmark;", "Lde/fraunhofer/aisec/cpg/helpers/MeasurementHolder;", "c", "Ljava/lang/Class;", "message", "", "debug", "", "holder", "Lde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;", "(Ljava/lang/Class;Ljava/lang/String;ZLde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;)V", "start", "Ljava/time/Instant;", "addMeasurement", "", "measurementKey", "measurementValue", "stop", "", "Companion", "cpg-core"})
public class Benchmark
extends MeasurementHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant start;
    @NotNull
    private static final Logger log;

    @JvmOverloads
    public Benchmark(@NotNull Class<?> c, @NotNull String message, boolean debug, @Nullable StatisticsHolder holder) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(c, message, debug, holder);
        this.getMeasurements().put(this.getCaller() + ": " + message, "No value available yet.");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.start = instant;
    }

    public /* synthetic */ Benchmark(Class clazz, String string, boolean bl, StatisticsHolder statisticsHolder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            statisticsHolder = null;
        }
        this(clazz, string, bl, statisticsHolder);
    }

    public final void stop() {
        MeasurementHolder.addMeasurement$default(this, null, null, 3, null);
    }

    @Override
    @Nullable
    public Object addMeasurement(@Nullable String measurementKey, @Nullable String measurementValue) {
        long duration;
        block0: {
            duration = Duration.between(this.start, Instant.now()).toMillis();
            this.getMeasurements().put(this.getCaller() + ": " + this.getMessage(), duration + " ms");
            this.logDebugMsg(this.getCaller() + ": " + this.getMessage() + " done in " + duration + " ms");
            StatisticsHolder statisticsHolder = this.getHolder();
            if (statisticsHolder == null) break block0;
            statisticsHolder.addBenchmark(this);
        }
        return duration;
    }

    @JvmOverloads
    public Benchmark(@NotNull Class<?> c, @NotNull String message, boolean debug) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(c, message, debug, null, 8, null);
    }

    @JvmOverloads
    public Benchmark(@NotNull Class<?> c, @NotNull String message) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(c, message, false, null, 12, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MeasurementHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/Benchmark$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

