/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\b\u001a\u00020\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lde/fraunhofer/aisec/cpg/graph/types/ReferenceType;", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "Lde/fraunhofer/aisec/cpg/graph/types/SecondOrderType;", "()V", "reference", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;)V", "type", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;Lde/fraunhofer/aisec/cpg/graph/types/Type;)V", "elementType", "getElementType", "()Lde/fraunhofer/aisec/cpg/graph/types/Type;", "setElementType", "dereference", "equals", "", "other", "", "hashCode", "", "isSimilar", "t", "pointer", "Lde/fraunhofer/aisec/cpg/graph/types/PointerType$PointerOrigin;", "toString", "", "cpg-core"})
public final class ReferenceType
extends Type
implements SecondOrderType {
    @NotNull
    private Type elementType;

    @Override
    @NotNull
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"<set-?>");
        this.elementType = type;
    }

    public ReferenceType() {
        this.elementType = TypeBuilderKt.unknownType(this);
    }

    public ReferenceType(@NotNull Type reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.elementType = TypeBuilderKt.unknownType(this);
        this.setLanguage(reference.getLanguage());
        this.setName(reference.getName().append("&"));
        this.setElementType(reference);
    }

    public ReferenceType(@NotNull Type type, @NotNull Type reference) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        super(type);
        this.elementType = TypeBuilderKt.unknownType(this);
        this.setLanguage(reference.getLanguage());
        this.setName(reference.getName().append("&"));
        this.setElementType(reference);
    }

    @Override
    @NotNull
    public Type reference(@Nullable PointerType.PointerOrigin pointer) {
        return new PointerType(this, pointer);
    }

    @Override
    @NotNull
    public Type dereference() {
        return this.getElementType().dereference();
    }

    @Override
    public boolean isSimilar(@Nullable Type t) {
        return t instanceof ReferenceType && Intrinsics.areEqual((Object)((ReferenceType)t).getElementType(), (Object)this) && super.isSimilar(t);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReferenceType)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.getElementType(), (Object)((ReferenceType)other).getElementType());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.getElementType()};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("elementType", (Object)this.getElementType()).append("name", (Object)this.getName()).append("typeOrigin", (Object)this.getTypeOrigin()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

