/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0018\u001a\u00020\u0001H\u0016J\u0013\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u0012\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\u001f\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001e\u0010\u0004\u001a\u00020\u00018\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lde/fraunhofer/aisec/cpg/graph/types/PointerType;", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "Lde/fraunhofer/aisec/cpg/graph/types/SecondOrderType;", "()V", "elementType", "pointerOrigin", "Lde/fraunhofer/aisec/cpg/graph/types/PointerType$PointerOrigin;", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;Lde/fraunhofer/aisec/cpg/graph/types/PointerType$PointerOrigin;)V", "type", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;Lde/fraunhofer/aisec/cpg/graph/types/Type;Lde/fraunhofer/aisec/cpg/graph/types/PointerType$PointerOrigin;)V", "getElementType", "()Lde/fraunhofer/aisec/cpg/graph/types/Type;", "setElementType", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;)V", "isArray", "", "()Z", "<set-?>", "getPointerOrigin", "()Lde/fraunhofer/aisec/cpg/graph/types/PointerType$PointerOrigin;", "referenceDepth", "", "getReferenceDepth", "()I", "dereference", "equals", "other", "", "hashCode", "isSimilar", "t", "reference", "pointer", "refreshNames", "", "PointerOrigin", "cpg-core"})
public final class PointerType
extends Type
implements SecondOrderType {
    @Relationship(value="ELEMENT_TYPE")
    public Type elementType;
    @Nullable
    private PointerOrigin pointerOrigin;

    @Override
    @NotNull
    public Type getElementType() {
        Type type = this.elementType;
        if (type != null) {
            return type;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"elementType");
        return null;
    }

    @Override
    public void setElementType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"<set-?>");
        this.elementType = type;
    }

    @Nullable
    public final PointerOrigin getPointerOrigin() {
        return this.pointerOrigin;
    }

    public PointerType() {
    }

    public PointerType(@NotNull Type elementType, @Nullable PointerOrigin pointerOrigin) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        this.setLanguage(elementType.getLanguage());
        this.setName(pointerOrigin == PointerOrigin.ARRAY ? elementType.getName().append("[]") : elementType.getName().append("*"));
        this.pointerOrigin = pointerOrigin;
        this.setElementType(elementType);
    }

    public PointerType(@Nullable Type type, @NotNull Type elementType, @Nullable PointerOrigin pointerOrigin) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(type);
        this.setLanguage(elementType.getLanguage());
        this.setName(pointerOrigin == PointerOrigin.ARRAY ? elementType.getName().append("[]") : elementType.getName().append("*"));
        this.pointerOrigin = pointerOrigin;
        this.setElementType(elementType);
    }

    @Override
    @NotNull
    public PointerType reference(@Nullable PointerOrigin pointer) {
        PointerOrigin origin = pointer;
        if (origin == null) {
            origin = PointerOrigin.ARRAY;
        }
        return new PointerType(this, origin);
    }

    @Override
    @NotNull
    public Type dereference() {
        return this.getElementType();
    }

    @Override
    public void refreshNames() {
        if (this.getElementType() instanceof PointerType) {
            this.getElementType().refreshNames();
        }
        Object localName = this.getElementType().getName().getLocalName();
        localName = (String)localName + (this.pointerOrigin == PointerOrigin.ARRAY ? "[]" : "*");
        Name fullTypeName = new Name((String)localName, this.getElementType().getName().getParent(), this.getElementType().getName().getDelimiter());
        this.setName(fullTypeName);
    }

    public final boolean isArray() {
        return this.pointerOrigin == PointerOrigin.ARRAY;
    }

    @Override
    public boolean isSimilar(@Nullable Type t) {
        if (!(t instanceof PointerType)) {
            return false;
        }
        return this.getReferenceDepth() == ((PointerType)t).getReferenceDepth() && this.getElementType().isSimilar(((PointerType)t).getRoot()) && super.isSimilar(t);
    }

    @Override
    public int getReferenceDepth() {
        int depth = 1;
        Type containedType = this.getElementType();
        while (containedType instanceof PointerType) {
            ++depth;
            containedType = ((PointerType)containedType).getElementType();
        }
        return depth;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PointerType)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.getElementType(), (Object)((PointerType)other).getElementType()) && this.pointerOrigin == ((PointerType)other).pointerOrigin;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.getElementType(), this.pointerOrigin};
        return Objects.hash(objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lde/fraunhofer/aisec/cpg/graph/types/PointerType$PointerOrigin;", "", "(Ljava/lang/String;I)V", "POINTER", "ARRAY", "cpg-core"})
    public static final class PointerOrigin
    extends Enum<PointerOrigin> {
        public static final /* enum */ PointerOrigin POINTER = new PointerOrigin();
        public static final /* enum */ PointerOrigin ARRAY = new PointerOrigin();
        private static final /* synthetic */ PointerOrigin[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PointerOrigin[] values() {
            return (PointerOrigin[])$VALUES.clone();
        }

        public static PointerOrigin valueOf(String value) {
            return Enum.valueOf(PointerOrigin.class, value);
        }

        @NotNull
        public static EnumEntries<PointerOrigin> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pointerOriginArray = new PointerOrigin[]{PointerOrigin.POINTER, PointerOrigin.ARRAY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

