/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 -2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\u001e\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0019H\u0002J\u0013\u0010\"\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "Lde/fraunhofer/aisec/cpg/graph/types/HasType$TypeObserver;", "()V", "value", "input", "getInput", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "setInput", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "isPostfix", "", "()Z", "setPostfix", "(Z)V", "isPrefix", "setPrefix", "", "operatorCode", "getOperatorCode", "()Ljava/lang/String;", "setOperatorCode", "(Ljava/lang/String;)V", "addArgument", "", "expression", "assignedTypeChanged", "assignedTypes", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "src", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "changeExpressionAccess", "equals", "other", "", "hashCode", "", "replaceArgument", "old", "new", "toString", "typeChanged", "newType", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nUnaryOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnaryOperator.kt\nde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1549#2:151\n1620#2,3:152\n*S KotlinDebug\n*F\n+ 1 UnaryOperator.kt\nde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator\n*L\n105#1:151\n105#1:152,3\n*E\n"})
public final class UnaryOperator
extends Expression
implements ArgumentHolder,
HasType.TypeObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @AST
    @NotNull
    private Expression input = new ProblemExpression("could not parse input", null, 2, null);
    @Nullable
    private String operatorCode;
    private boolean isPostfix;
    private boolean isPrefix;
    @NotNull
    public static final String OPERATOR_POSTFIX_INCREMENT = "++";
    @NotNull
    public static final String OPERATOR_POSTFIX_DECREMENT = "--";

    @NotNull
    public final Expression getInput() {
        return this.input;
    }

    public final void setInput(@NotNull Expression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.input.unregisterTypeObserver(this);
        this.input = value;
        this.input.registerTypeObserver(this);
        this.changeExpressionAccess();
    }

    @Nullable
    public final String getOperatorCode() {
        return this.operatorCode;
    }

    public final void setOperatorCode(@Nullable String value) {
        this.operatorCode = value;
        this.changeExpressionAccess();
    }

    public final boolean isPostfix() {
        return this.isPostfix;
    }

    public final void setPostfix(boolean bl) {
        this.isPostfix = bl;
    }

    public final boolean isPrefix() {
        return this.isPrefix;
    }

    public final void setPrefix(boolean bl) {
        this.isPrefix = bl;
    }

    private final void changeExpressionAccess() {
        AccessValues access = AccessValues.READ;
        if (Intrinsics.areEqual((Object)this.operatorCode, (Object)OPERATOR_POSTFIX_INCREMENT) || Intrinsics.areEqual((Object)this.operatorCode, (Object)OPERATOR_POSTFIX_DECREMENT)) {
            access = AccessValues.READWRITE;
        }
        if (this.input instanceof Reference) {
            Expression expression = this.input;
            Reference reference = expression instanceof Reference ? (Reference)expression : null;
            if (reference != null) {
                reference.setAccess(access);
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("operatorCode", (Object)this.operatorCode).append("postfix", this.isPostfix).append("prefix", this.isPrefix).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void typeChanged(@NotNull Type newType, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!Intrinsics.areEqual((Object)src, (Object)this.input)) {
            return;
        }
        String string = this.operatorCode;
        Type type = Intrinsics.areEqual((Object)string, (Object)"*") ? newType.dereference() : (Intrinsics.areEqual((Object)string, (Object)"&") ? TypeBuilderKt.pointer(this, newType) : newType);
        this.setType(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void assignedTypeChanged(@NotNull Set<? extends Type> assignedTypes, @NotNull HasType src) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(assignedTypes, (String)"assignedTypes");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!Intrinsics.areEqual((Object)src, (Object)this.input)) {
            return;
        }
        Iterable iterable = assignedTypes;
        UnaryOperator unaryOperator = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.operatorCode;
            collection.add(Intrinsics.areEqual((Object)string, (Object)"*") ? it.dereference() : (Intrinsics.areEqual((Object)string, (Object)"&") ? TypeBuilderKt.pointer(this, (Type)it) : it));
        }
        unaryOperator.addAssignedTypes(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.setInput(expression);
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual((Object)this.input, (Object)old)) {
            this.setInput(expression);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnaryOperator)) {
            return false;
        }
        return super.equals(other) && this.isPostfix == ((UnaryOperator)other).isPostfix && this.isPrefix == ((UnaryOperator)other).isPrefix && Intrinsics.areEqual((Object)this.input, (Object)((UnaryOperator)other).input) && Intrinsics.areEqual((Object)this.operatorCode, (Object)((UnaryOperator)other).operatorCode);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator$Companion;", "", "()V", "OPERATOR_POSTFIX_DECREMENT", "", "OPERATOR_POSTFIX_INCREMENT", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

